/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.sandbox;

import com.sun.star.lib.sandbox.Cachable;
import com.sun.star.lib.sandbox.WeakEntry;
import com.sun.star.lib.sandbox.WeakRef;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;

public class WeakTable
extends Observable {
    private static final boolean DEBUG = false;
    static WeakTable weakTable = new WeakTable();
    public Hashtable hash = new Hashtable();

    private static final void DEBUG(String string) {
    }

    private synchronized void pput(Object object, Cachable cachable) {
        WeakTable.DEBUG("put:" + object + " " + cachable);
        Hashtable hashtable = this.hash;
        synchronized (hashtable) {
            Object object2 = cachable.getHardObject();
            Class<?> clazz = cachable.getClass();
            WeakRef weakRef = new WeakRef(object, object2);
            cachable.setWeakRef(weakRef);
            this.hash.put(object, new WeakEntry(clazz, weakRef));
        }
        this.setChanged();
        this.notifyObservers();
    }

    private synchronized Cachable pget(Object object) {
        WeakTable.DEBUG("get:" + object);
        String string = null;
        Cachable cachable = null;
        Hashtable hashtable = this.hash;
        synchronized (hashtable) {
            WeakEntry weakEntry = (WeakEntry)this.hash.get(object);
            if (weakEntry != null) {
                try {
                    cachable = (Cachable)weakEntry.weakClass.newInstance();
                    cachable.setWeakRef(weakEntry.weakRef);
                }
                catch (IllegalAccessException illegalAccessException) {
                    string = "#### WeakTable.get:" + illegalAccessException;
                }
                catch (InstantiationException instantiationException) {
                    string = "#### WeakTable.get:" + instantiationException;
                }
            }
        }
        if (string != null) {
            System.err.println(string);
        }
        return cachable;
    }

    private synchronized void premove(Object object) {
        this.hash.remove(object);
        this.setChanged();
        this.notifyObservers();
    }

    private synchronized void pclear() {
        this.hash.clear();
        this.setChanged();
        this.notifyObservers();
    }

    public void addObserver(Observer observer) {
        super.addObserver(observer);
        observer.update(this, null);
    }

    public static void put(Object object, Cachable cachable) {
        weakTable.pput(object, cachable);
    }

    public static Cachable get(Object object) {
        return weakTable.pget(object);
    }

    public static void remove(Object object) {
        weakTable.premove(object);
    }

    public static void AddObserver(Observer observer) {
        weakTable.addObserver(observer);
    }

    public static void DeleteObserver(Observer observer) {
        weakTable.deleteObserver(observer);
    }

    static void clear() {
        weakTable.pclear();
    }

    static Enumeration elements() {
        return WeakTable.weakTable.hash.elements();
    }
}

