/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.db;

import com.sun.xmlsearch.db.BlockStack;
import com.sun.xmlsearch.db.VectorBtree;

public final class VectorBtreeIterator {
    private VectorBtree _btree;
    private int _VECLEN;
    private byte[] _vector;
    private byte[] _highPrefix;
    private byte[] _buffer;
    private int _next;
    private int _prefLen;
    private int _commLen;
    private BlockStack _stack = new BlockStack();

    public VectorBtreeIterator(VectorBtree vectorBtree, byte[] byArray) {
        this._btree = vectorBtree;
        this._VECLEN = vectorBtree.getVectorLength();
        this._vector = byArray;
        this._highPrefix = new byte[this._VECLEN];
        this._buffer = new byte[vectorBtree.getIteratorBufferLength()];
    }

    public byte[] first(byte[] byArray, int n) throws Exception {
        return this.init(byArray, byArray, n) ? this.next() : null;
    }

    public byte[] next() throws Exception {
        if ((this._buffer[this._next] & 0xFF) >= this._commLen) {
            System.arraycopy(this._buffer, this._next + 1, this._vector, this._buffer[this._next] & 0xFF, this._VECLEN - (this._buffer[this._next] & 0xFF));
            this._next += this._VECLEN + 1 - (this._buffer[this._next] & 0xFF);
            return this._vector;
        }
        if (this._stack.size() > 0) {
            this._btree.FindVectors2(this._vector, this._highPrefix, this._commLen, this._prefLen, this._buffer, this._stack);
            this._next = 0;
            return this.next();
        }
        return null;
    }

    private boolean init(byte[] byArray, byte[] byArray2, int n) throws Exception {
        this._commLen = 0;
        while (this._commLen < n) {
            if (byArray[this._commLen] != byArray2[this._commLen]) break;
            ++this._commLen;
        }
        this._prefLen = n;
        if (this._btree.FindVectors1(byArray, byArray2, this._commLen, this._prefLen, this._buffer, this._stack)) {
            System.arraycopy(byArray2, 0, this._highPrefix, 0, this._VECLEN);
            System.arraycopy(byArray, 0, this._vector, 0, this._VECLEN);
            this._next = 0;
            return true;
        }
        return false;
    }
}

