/*************************************************************************
 *
 *  $RCSfile: inetnntp.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 11:05:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef _INETNNTP_HXX
#define _INETNNTP_HXX "$Revision: 1.2 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _INET_CLIENT_HXX
#include <inet/client.hxx>
#endif

class DateTime;
class List;

/*=======================================================================
 *
 * INetCoreNNTPConnection Interface.
 *
 * References:
 *   RFC  977 - Network News Transfer Protocol (Proposed Standard).
 *   RFC 1920 - Internet Official Protocol Standards (STD 1).
 *
 *=====================================================================*/
#define INETCORENNTP_DEF_PORT 119

enum INetCoreNNTPConnectionReply
{
	// Implementation defined Reply (-x)
	INETCORENNTP_REPLY_TRANSFER_OVERVIEW        =  -7,
	INETCORENNTP_REPLY_TRANSFER_WAIT            =  -6,
	INETCORENNTP_REPLY_CONNECT_ERROR            =  -5,
	INETCORENNTP_REPLY_CONNECT_WAIT             =  -4,
	INETCORENNTP_REPLY_RESOLVER_ERROR           =  -3,
	INETCORENNTP_REPLY_RESOLVER_WAIT            =  -2,
	INETCORENNTP_REPLY_NETWORK_ERROR            =  -1,

	// Informative Message Reply (1xx)
	INETCORENNTP_REPLY_HELP_MESSAGE             = 100,
	INETCORENNTP_REPLY_DEBUG_OUTPUT             = 199,

	// Positive Completion Reply (2xx)
	INETCORENNTP_REPLY_SERVICE_READY_POSTING    = 200,
	INETCORENNTP_REPLY_SERVICE_READY            = 201,
	INETCORENNTP_REPLY_SLAVE_STATUS             = 202,
    INETCORENNTP_REPLY_SERVICE_CLOSING          = 205,
	INETCORENNTP_REPLY_GROUP_SELECTED           = 211,
	INETCORENNTP_REPLY_GROUPS_LIST_OK           = 215,
	INETCORENNTP_REPLY_ARTICLE_OK               = 220,
	INETCORENNTP_REPLY_ARTICLE_HEAD_OK          = 221,
	INETCORENNTP_REPLY_ARTICLE_BODY_OK          = 222,
	INETCORENNTP_REPLY_ARTICLE_SEPARATE         = 223,
	INETCORENNTP_REPLY_OVERVIEW_OK              = 224,
	INETCORENNTP_REPLY_NEWARTICLE_LIST_OK       = 230,
	INETCORENNTP_REPLY_NEWGROUPS_LIST_OK        = 231,
	INETCORENNTP_REPLY_ARTICLE_TRANSFERRED_OK   = 235,
	INETCORENNTP_REPLY_ARTICLE_POSTED_OK        = 240,
	INETCORENNTP_REPLY_AUTHINFO_ACCEPTED        = 281,

	// Positive Intermediate Reply (3xx)
	INETCORENNTP_REPLY_START_ARTICLE_TRANSFER   = 335,
	INETCORENNTP_REPLY_START_ARTICLE_POSTING    = 340,
	INETCORENNTP_REPLY_MORE_AUTHINFO_REQUIRED   = 381,

	// Transient Negative Completion Reply (4xx)
	INETCORENNTP_REPLY_SERVICE_DISCONTINUED     = 400,
	INETCORENNTP_REPLY_NO_SUCH_GROUP            = 411,
	INETCORENNTP_REPLY_NO_GROUP_SELECTED        = 412,
	INETCORENNTP_REPLY_NO_ARTICLE_SELECTED      = 420,
	INETCORENNTP_REPLY_NO_NEXT_ARTICLE          = 421,
	INETCORENNTP_REPLY_NO_PREV_ARTICLE          = 422,
	INETCORENNTP_REPLY_NO_SUCH_ARTICLE_NUMBER   = 423,
	INETCORENNTP_REPLY_NO_SUCH_ARTICLE          = 430,
	INETCORENNTP_REPLY_ARTICLE_NOT_WANTED       = 435,
	INETCORENNTP_REPLY_TRANSFER_FAILED_TRYAGAIN = 436,
	INETCORENNTP_REPLY_ARTICLE_REJECTED         = 437,
	INETCORENNTP_REPLY_POSTING_NOT_ALLOWED      = 440,
	INETCORENNTP_REPLY_POSTING_FAILED           = 441,
	INETCORENNTP_REPLY_AUTHINFO_REQUIRED        = 480,
	INETCORENNTP_REPLY_AUTHINFO_REJECTED        = 482,

	// Permanent Negative Completion Reply (5xx)
	INETCORENNTP_REPLY_COMMAND_UNKNOWN          = 500,
	INETCORENNTP_REPLY_COMMAND_SYNTAX_ERROR     = 501,
	INETCORENNTP_REPLY_PERMISSION_DENIED        = 502,
	INETCORENNTP_REPLY_SERVER_PROGRAM_FAULT     = 503
};

#define INETCORENNTP_GROUP_FLAG_POSTALLOWED 0x01
#define INETCORENNTP_GROUP_FLAG_MODERATED   0x02

class  INetCoreMessageIStream;
class  INetCoreMessageOStream;

struct INetCoreNNTPGroupListEntry
{
	rtl::OUString m_aGroupName;
	sal_uInt32    m_nArticleCount;
	sal_uInt32    m_nFirstArticleNumber;
	sal_uInt32    m_nLastArticleNumber;
	sal_uInt32    m_nFlags;

	INetCoreNNTPGroupListEntry (void)
		: m_nArticleCount       (0),
		  m_nFirstArticleNumber (0),
		  m_nLastArticleNumber  (0),
		  m_nFlags              (0)
	{}
};

struct INetCoreNNTPOverviewEntry
{
	sal_uInt32   m_nArticleNumber;
	rtl::OString m_aOverviewHeader;

	INetCoreNNTPOverviewEntry (
		sal_uInt32      nArticleNumber = 0,
		const sal_Char *pHeader = NULL,
		sal_Int32       nHeaderLen = 0)
		: m_nArticleNumber  (nArticleNumber),
		  m_aOverviewHeader (pHeader, nHeaderLen)
	{}
};

typedef rtl::OUString INetCoreNNTPNewNewsListEntry;

#ifdef _USE_NAMESPACE
namespace inet {
#endif

class  INetCoreNNTPConnection;
struct INetCoreNNTPCmdContext;
struct INetCoreNNTPConnectionContext;

typedef sal_Bool INetCoreNNTPCallback (
	INetCoreNNTPConnection *pConnection,
	sal_Int32               nReplyCode,
	const sal_Char         *pReplyText,
	void                   *pData);

typedef sal_Bool INetCoreNNTPOverviewCallback (
	INetCoreNNTPConnection    *pConnection,
	sal_Int32                  nReplyCode,       // _TRANSFER_OVERVIEW
	INetCoreNNTPOverviewEntry *pOverviewEntry,
	void                      *pData);

class INetCoreNNTPConnection :
	public NAMESPACE_INET(INetClientConnection_Impl)
{
public:
	INetCoreNNTPConnection (void);

	sal_Bool Open (
		const rtl::OUString &rHost, sal_uInt16 nPort,
		INetCoreNNTPCallback *pfnCallback, void *pData);
	sal_Bool IsOpen (void);

	sal_Bool Close (
		INetCoreNNTPCallback *pfnCallback, void *pData);
	void Destroy (void);

	sal_Bool SetModeReader (
		INetCoreNNTPCallback *pfnCallback, void *pData);

	sal_Bool AuthinfoUser (
		const rtl::OUString &rUsername,
		INetCoreNNTPCallback *pfnCallback, void *pData);
	sal_Bool AuthinfoPass (
		const rtl::OUString &rPassword,
		INetCoreNNTPCallback *pfnCallback, void *pData);

	sal_Bool GetGroupList (
		List& rGroupList,
		INetCoreNNTPCallback *pfnCallback, void *pData);

	sal_Bool GetNewGroupsList (
		const DateTime& rSinceDateTime,
		List& rNewGroupsList,
		INetCoreNNTPCallback *pfnCallback, void *pData);

	sal_Bool GetNewNewsList (
		const rtl::OUString &rGroups,
		const DateTime& rSinceDateTime,
		List& rNewNewsList,
		INetCoreNNTPCallback *pfnCallback, void *pData);

	sal_Bool SelectGroup (
		const rtl::OUString &rGroupName,
		INetCoreNNTPCallback *pfnCallback, void *pData);

	sal_Bool GetArticleHeaderOverviewFormat (
		List& rOverviewHeaderList,
		INetCoreNNTPCallback *pfnCallback, void *pData);
	sal_Bool GetArticleHeaderOverview (
		sal_uInt32 nFirstArticleNumber,
		sal_uInt32 nLastArticleNumber,
		INetCoreNNTPCallback *pfnCallback, void *pData);

	sal_Bool GetArticleHeader (
		sal_uInt32 nArticleNumber,
		INetCoreMessageOStream& rMessageStream,
		INetCoreNNTPCallback *pfnCallback, void *pData);
	sal_Bool GetArticleHeader (
		const rtl::OUString &rMessageID,
		INetCoreMessageOStream& rMessageStream,
		INetCoreNNTPCallback *pfnCallback, void *pData);

	sal_Bool RetrieveArticle (
		sal_uInt32 nArticleNumber,
		INetCoreMessageOStream& rMessageStream,
		INetCoreNNTPCallback *pfnCallback, void *pData);
	sal_Bool RetrieveArticle (
		const rtl::OUString &rMessageID,
		INetCoreMessageOStream& rMessageStream,
		INetCoreNNTPCallback *pfnCallback, void *pData);

	sal_Bool IsPostingAllowed (void);
	sal_Bool PostArticle (
		INetCoreMessageIStream& rMessageStream,
		INetCoreNNTPCallback *pfnCallback, void *pData);

	sal_uInt32 GetTransferCount (void);
	sal_Bool SetTransferCallback (
		INetCoreNNTPCallback *pfnCallback, void *pData);
	sal_Bool SetTerminateCallback (
		INetCoreNNTPCallback *pfnCallback, void *pData);

protected:
    virtual ~INetCoreNNTPConnection (void);

private:
	INetCoreNNTPConnectionContext *m_pConCtx;

	virtual sal_Bool handleResolverEvent (
		sal_Int32 nStatus, INetCoreDNSHostEntry *pHostEntry);

	virtual sal_Bool handleSocketEvent (
		const NAMESPACE_VOS(ORef)<INetSocket> &rxSocket, sal_Int32 nEvent);

	sal_Bool StartCommand (INetCoreNNTPCmdContext *pCtx);
};

#ifdef _USE_NAMESPACE
}
#endif

#endif /* !_INETNNTP_HXX */

