/*************************************************************************
 *
 *  $RCSfile: prnmon.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: pb $ $Date: 2001/08/20 13:33:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFX_PRNMON_HXX
#define _SFX_PRNMON_HXX

#ifndef _BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
#include <sfx2/printer.hxx>
#include <sfx2/progress.hxx>

class SfxViewShell;
class SfxProgress;
struct SfxPrintProgress_Impl;

// ------------------------------------------------------------------------

#define PAGE_MAX    9999        //max. Anzahl der Seiten die gedruckt werden

//--------------------------------------------------------------------

class SfxPrintProgress: public SfxProgress
{
	SfxPrintProgress_Impl*  pImp;

private:
#if 0 // _SOLAR__PRIVATE
	DECL_LINK( PrintErrorNotify, void * );
	DECL_LINK( EndPrintNotify, void * );
#endif
public:
							SfxPrintProgress( SfxViewShell* pViewSh,
											  FASTBOOL bShow = TRUE );
	virtual                 ~SfxPrintProgress();

	virtual void            SetText( const String &rText );
			BOOL            SetStateText( ULONG nVal, const String &rVal, ULONG nNewRange = 0 );
	virtual BOOL            SetState( ULONG nVal, ULONG nNewRange = 0 );

	void                    RestoreOnEndPrint( SfxPrinter *pOldPrinter );
	void                    RestoreOnEndPrint( SfxPrinter *pOldPrinter,
											   BOOL bOldEnablePrintFile );
	void                    DeleteOnEndPrint();
};

// ------------------------------------------------------------------------

struct SfxPrintOptDlg_Impl;
class SfxPrintOptionsDialog : public ModalDialog
{
private:
	OKButton                aOkBtn;
	CancelButton            aCancelBtn;
#if SUPD > 640
	HelpButton				aHelpBtn;
#endif
	SfxPrintOptDlg_Impl*	pDlgImpl;
	SfxViewShell*           pViewSh;
	SfxItemSet*             pOptions;
	SfxTabPage*             pPage;

public:
							SfxPrintOptionsDialog( Window *pParent,
												   SfxViewShell *pViewShell,
												   const SfxItemSet *rOptions );
	virtual                 ~SfxPrintOptionsDialog();

	BOOL                    Construct();
	virtual short           Execute();
	virtual long			Notify( NotifyEvent& rNEvt );

	SfxTabPage*             GetTabPage() const { return pPage; }
	const SfxItemSet&       GetOptions() const { return *pOptions; }
	void					DisableHelp();
};

#endif
