/*************************************************************************
 *
 *  $RCSfile: textview.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: mt $ $Date: 2001/11/06 12:25:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _TEXTVIEW_HXX
#define _TEXTVIEW_HXX

class TextEngine;
class OutputDevice;
class Window;
class Cursor;
class KeyEvent;
class MouseEvent;
class CommandEvent;
class TextSelFunctionSet;
class SelectionEngine;
class VirtualDevice;
struct TextDDInfo;

#ifndef _GEN_HXX //autogen
#include <tools/gen.hxx>
#endif
#include <svtools/textdata.hxx>

#ifndef _VCL_DNDHELP_HXX
#include <vcl/dndhelp.hxx>
#endif

namespace com {
namespace sun {
namespace star {
namespace datatransfer {
namespace clipboard {
	class XClipboard;
}}}}}

class TextView : public vcl::unohelper::DragAndDropClient
{
	friend class 		TextEngine;
	friend class 		TextUndo;
	friend class 		TextUndoManager;
	friend class		TextSelFunctionSet;
	friend class		ExtTextView;

private:
	TextEngine*			mpTextEngine;

	Window*				mpWindow;
	TextSelection		maSelection;
	Point				maStartDocPos;
	TextPaM				maMBDownPaM;

	Cursor*				mpCursor;

	TextDDInfo*			mpDDInfo;

	VirtualDevice*		mpVirtDev;

	SelectionEngine*	mpSelEngine;
	TextSelFunctionSet*	mpSelFuncSet;

    ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDragSourceListener > mxDnDListener;

	USHORT				mnTravelXPos;

	BOOL				mbAutoScroll			: 1;
	BOOL				mbInsertMode			: 1;
	BOOL				mbReadOnly				: 1;
	BOOL				mbPaintSelection		: 1;
	BOOL				mbAutoIndent			: 1;
	BOOL				mbHighlightSelection	: 1;
	BOOL				mbCursorEnabled			: 1;
	BOOL				mbClickedInSelection    : 1;

						TextView( const TextView& ) 		{;}
	TextView&			operator=( const TextView& ) 		{ return *this; }

protected:
	void				ShowSelection();
	void				HideSelection();
	void				ShowSelection( const TextSelection& rSel );

	TextSelection		ImpMoveCursor( const KeyEvent& rKeyEvent );
	TextPaM				ImpDelete( BOOL bForward, BYTE nMode );
	void				ImpSetSelection( const TextSelection& rNewSel, BOOL bUI );
	BOOL 				IsInSelection( const TextPaM& rPaM );

	void				ImpPaint( OutputDevice* pOut, const Point& rStartPos, Rectangle const* pPaintArea, TextSelection const* pPaintRange = 0, TextSelection const* pSelection = 0 );
	void				ImpPaint( const Rectangle& rRect, BOOL bUseVirtDev );
	void				ImpShowCursor( BOOL bGotoCursor, BOOL bForceVisCursor, BOOL bEndKey );
	void				ImpHighlight( const TextSelection& rSel );

	void				ImpHideDDCursor();
	void				ImpShowDDCursor();

	BOOL				ImplCheckTextLen( const String& rNewText );

	VirtualDevice* 		GetVirtualDevice();

    // DragAndDropClient
    virtual void        dragGestureRecognized( const ::com::sun::star::datatransfer::dnd::DragGestureEvent& dge ) throw (::com::sun::star::uno::RuntimeException);
    virtual void        dragDropEnd( const ::com::sun::star::datatransfer::dnd::DragSourceDropEvent& dsde ) throw (::com::sun::star::uno::RuntimeException);
    virtual void        drop( const ::com::sun::star::datatransfer::dnd::DropTargetDropEvent& dtde ) throw (::com::sun::star::uno::RuntimeException);
    virtual void        dragEnter( const ::com::sun::star::datatransfer::dnd::DropTargetDragEnterEvent& dtdee ) throw (::com::sun::star::uno::RuntimeException);
    virtual void        dragExit( const ::com::sun::star::datatransfer::dnd::DropTargetEvent& dte ) throw (::com::sun::star::uno::RuntimeException);
    virtual void        dragOver( const ::com::sun::star::datatransfer::dnd::DropTargetDragEvent& dtde ) throw (::com::sun::star::uno::RuntimeException);

public:
						TextView( TextEngine* pEng, Window* pWindow );
						~TextView();

	TextEngine*			GetTextEngine() const { return mpTextEngine; }
	Window*				GetWindow() const { return mpWindow; }

	void				Invalidate();
	void				Scroll( long nHorzScroll, long nVertScroll );

	void				ShowCursor( BOOL bGotoCursor = TRUE, BOOL bForceVisCursor = TRUE );
	void				HideCursor();

	void				EnableCursor( BOOL bEnable )	{ mbCursorEnabled = bEnable; }
	BOOL				IsCursorEnabled() const			{ return mbCursorEnabled; }

	const TextSelection&	GetSelection() const;
	void				SetSelection( const TextSelection& rNewSel );
	void				SetSelection( const TextSelection& rNewSel, BOOL bGotoCursor );
	BOOL				HasSelection() const { return maSelection.HasRange(); }

	String				GetSelected();
	void				DeleteSelected();

	void				InsertText( const String& rNew, BOOL bSelect = FALSE );

	BOOL				KeyInput( const KeyEvent& rKeyEvent );
	void				Paint( const Rectangle& rRect );
	void				MouseButtonUp( const MouseEvent& rMouseEvent );
	void				MouseButtonDown( const MouseEvent& rMouseEvent );
	void				MouseMove( const MouseEvent& rMouseEvent );
	void				Command( const CommandEvent& rCEvt );

	void				Cut();
	void				Copy();
	void				Paste();

    void                Copy( ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::clipboard::XClipboard >& rxClipboard );
    void                Paste( ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::clipboard::XClipboard >& rxClipboard );

	void				Undo();
	void				Redo();

	BOOL				Read( SvStream& rInput );
	BOOL				Write( SvStream& rOutput );

	void				SetStartDocPos( const Point& rPos ) { maStartDocPos = rPos; }
	const Point&		GetStartDocPos() const 	{ return maStartDocPos; }

	inline Point		GetDocPos( const Point& rWindowPos ) const;
	inline Point		GetWindowPos( const Point& rDocPos ) const;

	void				SetInsertMode( BOOL bInsert );
	BOOL				IsInsertMode() const { return mbInsertMode; }

	void				SetAutoIndentMode( BOOL bAutoIndent )	{ mbAutoIndent = bAutoIndent; }
	BOOL 				IsAutoIndentMode() const 				{ return mbAutoIndent; }

	void				SetReadOnly( BOOL bReadOnly );
	BOOL				IsReadOnly() const 		{ return mbReadOnly; }

	void				SetAutoScroll( BOOL bAutoScroll )	{ mbAutoScroll = bAutoScroll; }
	BOOL				IsAutoScroll() const 				{ return mbAutoScroll; }

	BOOL 				SetCursorAtPoint( const Point& rPointPixel );
	BOOL 				IsSelectionAtPoint( const Point& rPointPixel );

	void				SetPaintSelection( BOOL bPaint);
	BOOL				IsPaintSelection() const { return mbPaintSelection; }

	void				SetHighlightSelection( BOOL bSelectByHighlight );
	BOOL				IsHighlightSelection() const { return mbHighlightSelection; }

	void 				EraseVirtualDevice();

	// aus dem protected Teil hierher verschoben
	// Fr 'SvtXECTextCursor' (TL). Mu ggf nochmal anders gelst werden.
	TextPaM				PageUp( const TextPaM& rPaM );
	TextPaM				PageDown( const TextPaM& rPaM );
	TextPaM				CursorUp( const TextPaM& rPaM );
	TextPaM				CursorDown( const TextPaM& rPaM );
	TextPaM				CursorLeft( const TextPaM& rPaM, BOOL bWordMode = FALSE );
	TextPaM				CursorRight( const TextPaM& rPaM, BOOL bWordMode = FALSE );
	TextPaM				CursorStartOfLine( const TextPaM& rPaM );
	TextPaM				CursorEndOfLine( const TextPaM& rPaM );
	TextPaM				CursorStartOfParagraph( const TextPaM& rPaM );
	TextPaM				CursorEndOfParagraph( const TextPaM& rPaM );
	TextPaM				CursorStartOfDoc();
	TextPaM				CursorEndOfDoc();

};

inline Point TextView::GetDocPos( const Point& rWindowPos ) const
{
	// Fensterposition => Dokumentposition

	Point aPoint( rWindowPos );

	aPoint.Y() += maStartDocPos.Y();
	aPoint.X() += maStartDocPos.X();

	return aPoint;
}

inline Point TextView::GetWindowPos( const Point& rDocPos ) const
{
	// Dokumentposition => Fensterposition

	Point aPoint( rDocPos );

	aPoint.Y() -= maStartDocPos.Y();
	aPoint.X() -= maStartDocPos.X();

	return aPoint;
}

#endif // _TEXTVIEW_HXX
