/*************************************************************************
 *
 *  $RCSfile: frmsel.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dr $ $Date: 2001/05/17 12:26:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_FRMSEL_HXX
#define _SVX_FRMSEL_HXX

// include ---------------------------------------------------------------

#ifndef _LINK_HXX //autogen
#include <tools/link.hxx>
#endif
#ifndef _WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif
#ifndef _COLOR_HXX //autogen
#include <vcl/color.hxx>
#endif
#ifndef _SV_BITMAP_HXX
#include <vcl/bitmap.hxx>
#endif
#ifndef SVX_LINKLINE_HXX
#include <svx/linelink.hxx>
#endif

// -----------------------------------------------------------------------

	/*-----------------------------------------------------------*\

		Diese Klasse stellt das von Word bekannte Bedienelement
		fuer die Rahmeneinstellung zur Verfuegung.
		Dem Ctor kann dabei uebergeben werden, ob der Rahmen
		einer Tabelle oder eines Absatzes eingestellt werden soll.

	\*-----------------------------------------------------------*/

// enum ------------------------------------------------------------------

enum SvxFrameSelectorType
{
	SVX_FRMSELTYPE_TABLE = 0,
	SVX_FRMSELTYPE_PARAGRAPH
};
enum SvxFrameSelectorLine
{
	SVX_FRMSELLINE_NONE = 0,
	SVX_FRMSELLINE_LEFT,
	SVX_FRMSELLINE_RIGHT,
	SVX_FRMSELLINE_TOP,
	SVX_FRMSELLINE_BOTTOM,
	SVX_FRMSELLINE_HOR,
	SVX_FRMSELLINE_VER
};
enum SvxFrameLineState
{
	SVX_FRMLINESTATE_SHOW = 0,
	SVX_FRMLINESTATE_HIDE,
	SVX_FRMLINESTATE_DONT_CARE
};
enum SvxFrameShadow
{
    SVX_FRMSHADOW_NONE = 0,
    SVX_FRMSHADOW_BOT_RIGHT,
    SVX_FRMSHADOW_TOP_RIGHT,
    SVX_FRMSHADOW_BOT_LEFT,
    SVX_FRMSHADOW_TOP_LEFT
};
enum SvxSelArrowType
{
	SVX_SELARROWTYPE_LEFT = 0,
	SVX_SELARROWTYPE_RIGHT,
	SVX_SELARROWTYPE_UP,
	SVX_SELARROWTYPE_DOWN
};

// class SvxFrameLine -----------------------------------------------------

class SvxFrameLine
{
						SvxFrameLine();
public:
	SvxLineStruct		GetStyle() const { return theCoreStyle; }
	void				SetStyle( const SvxLineStruct& aStyle );
	Color				GetColor() const { return aColor; }
	void				SetColor( const Color& rColor )  { aColor = rColor; }
	SvxFrameLineState	GetState() const { return theState; }
	void				SetState( SvxFrameLineState eState );

private:
	friend class SvxFrameSelector;

	static struct SvxLineStruct NO_LINE;		// darstellbare Linien-Styles:
	static struct SvxLineStruct THIN_LINE;
	static struct SvxLineStruct THICK_LINE;
	static struct SvxLineStruct THIN_DOUBLE_LINE;
	static struct SvxLineStruct THICK_DOUBLE_LINE;

	Point				aStartPos;		// Stuetzpunkte
	Point				aMidPos;
	Point				aEndPos;
	Color				aColor;			// Farbe
	SvxLineStruct		theStyle;		// interner Style
	SvxLineStruct		theCoreStyle;	// Core Style
	SvxFrameLineState	theState;	 	// sichtbar? Tristate?
	BOOL				bIsSelected;	// selektiert?
};

// class SvxFrameSelector ------------------------------------------------

class SvxFrameSelector : public Window
{
public:
						SvxFrameSelector( Window* pParent,
										  SvxFrameSelectorType eType,
										  BOOL bDontCare );

	SvxFrameLine&		GetTop() 	{ return theTopLine; }
	SvxFrameLine&		GetBottom()	{ return theBottomLine; }
	SvxFrameLine&		GetLeft() 	{ return theLeftLine; }
	SvxFrameLine&		GetRight() 	{ return theRightLine; }
	SvxFrameLine&		GetHor() 	{ return theHorLine; }
	SvxFrameLine&		GetVer() 	{ return theVerLine; }

	void 				ShowLines();
	void				HideLines();
	void				SelectLine( SvxFrameSelectorLine eNewLine,
									BOOL bSet = TRUE );

    SvxFrameShadow      GetShadowPos() const;
    void                SetShadowPos( SvxFrameShadow eShadowPos );
//    void                ShowShadow();
    Color               GetShadowColor() const;
    void                SetShadowColor( const Color& aColor );

	void				SetCurLineColor( const Color& aColor );
	void				SetCurLineStyle( const SvxLineStruct& aStyle );

	void				SetSelectLink(const Link& rLnk) {aSelectLink = rLnk;}

	BOOL				IsDirty() const { return bIsClicked; }
	BOOL				IsAnyLineSet() const;

protected:
	virtual void 		Paint( const Rectangle& rRect );
	virtual void    	MouseButtonDown( const MouseEvent& rMEvt );
	virtual void    	MouseButtonUp( const MouseEvent& rMEvt );

private:
	const SvxFrameSelectorType	eSel; // Selektor-Typ (Tabelle oder Absatz)

	Color				theCurLineCol;	// aktuelle Linienfarbe
	SvxLineStruct		theCurLineStyle;// aktueller LineStyle
    SvxFrameShadow      eShadow;        // Schattenposition
    Color               theShadowCol;   // aktuelle Schattenfarbe
	Bitmap				theBmp;			// Hintergrund-Bitmap
	Rectangle			aRectFrame;		// der Rahmen (Mitte der Linien)
	Rectangle			theBoundingRect;// alle Linien umschliessender Rahmen
	SvxFrameLine		theLeftLine;	// seine Linien
	SvxFrameLine		theRightLine;
	SvxFrameLine		theTopLine;
	SvxFrameLine		theBottomLine;
	SvxFrameLine		theHorLine;
	SvxFrameLine		theVerLine;
	Link				aSelectLink;
	Rectangle			aSpotLeft;		// Click-HotSpots auf der Bitmap
	Rectangle			aSpotRight;
	Rectangle			aSpotTop;
	Rectangle			aSpotBottom;
	Rectangle			aSpotHor;
	Rectangle			aSpotVer;
	BOOL				bIsDontCare;
	BOOL				bIsClicked;

#ifdef _SVX_FRMSEL_CXX
	void				InitBitmap_Impl( const Size& rSize );
	void				DrawSelArrow_Impl( OutputDevice& rDev,
										   Point aPos,
										   Color aCol,
										   SvxSelArrowType eType );
	void				DrawContents_Impl( OutputDevice& rVirDev );
	void				DrawFrameLine_Impl( OutputDevice& rVirDev,
											Point from,
											Point to,
											BOOL bHor,
											SvxLineStruct& dline,
											SvxLineStruct& lt,
											SvxLineStruct& lLine,
											SvxLineStruct& lb,
											SvxLineStruct& rt,
											SvxLineStruct& rLine,
											SvxLineStruct& rb );
	void				LineClicked_Impl( SvxFrameLine& aLine,
										  BOOL bShiftPressed,
										  BOOL bDoubleClick );
#endif
};

#endif

