/*************************************************************************
 *
 *  $RCSfile: numinf.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: er $ $Date: 2001/05/13 03:27:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_NUMINF_HXX
#define _SVX_NUMINF_HXX

// include ---------------------------------------------------------------

#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif
#ifndef _SVX_NUMFMTSH_HXX //autogen
#include <svx/numfmtsh.hxx>
#endif

// class SvxNumberInfoItem -----------------------------------------------

#ifdef ITEMID_NUMBERINFO

/*
[Beschreibung]
Dieses Item dient als Transport-Medium fuer einen Number-Formatter.
*/

class SvxNumberInfoItem : public SfxPoolItem
{
public:
	TYPEINFO();

	SvxNumberInfoItem( const USHORT nId = ITEMID_NUMBERINFO );
	SvxNumberInfoItem( SvNumberFormatter* pNumFormatter,
					   const USHORT nId = ITEMID_NUMBERINFO );
	SvxNumberInfoItem( SvNumberFormatter* pNumFormatter, const String& rVal,
					   const USHORT nId = ITEMID_NUMBERINFO );
	SvxNumberInfoItem( SvNumberFormatter* pNumFormatter, const double& rVal,
					   const USHORT nId = ITEMID_NUMBERINFO );
	// if both double and String are supplied, String is used for text formats
	SvxNumberInfoItem( SvNumberFormatter* pNumFormatter, const double& rVal,
					   const String& rValueStr, const USHORT nId );
	SvxNumberInfoItem( const SvxNumberInfoItem& );
	~SvxNumberInfoItem();

	virtual int              operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem*     Clone( SfxItemPool *pPool = 0 ) const;
	virtual SfxPoolItem*     Create( SvStream& rStream, USHORT nVer ) const;
	virtual SvStream&		 Store( SvStream& , USHORT nItemVersion ) const;

	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
                                    String &rText, const IntlWrapper * = 0 ) const;

	SvNumberFormatter*		GetNumberFormatter() const { return pFormatter; }
	void					SetNumberFormatter( SvNumberFormatter* pNumFrmt );
	const String&			GetValueString() const { return aStringVal; }
	void					SetStringValue( const String& rNewVal );
	double					GetValueDouble() const 	{ return nDoubleVal; }
	void					SetDoubleValue( const double& rNewVal );

	const ULONG*			GetDelArray() const { return pDelFormatArr; }
	void					SetDelFormatArray( const ULONG* pData,
											   const ULONG  nCount );

	SvxNumberValueType		GetValueType() const { return eValueType; }
	ULONG					GetDelCount() const  { return nDelCount; }

private:
	SvNumberFormatter*	pFormatter;
	SvxNumberValueType	eValueType;
	String				aStringVal;
	double				nDoubleVal;

	ULONG*				pDelFormatArr;
	ULONG				nDelCount;
};

#endif

#endif

