/*************************************************************************
 *
 *  $RCSfile: iiclient.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: gh $ $Date: 2001/01/05 15:20:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _IICLIENT_HXX
#define _IICLIENT_HXX

#ifndef _STCPCON_HXX
#include <tools/stcpcon.hxx>
#endif

#include <tools/sasyncfn.hxx>

class SvMemoryStream;
class InfoDataPack;
class GenericInformation;
class TcpConBase;

const ULONG nSvMemoryInitSize = 32 * 1024;
const ULONG nSvMemoryReSize   = 32 * 1024;

/************************************************************************/
class InformationClient
/************************************************************************/
{
private:
  enum SendMode { request, request_list, request_whole_list, infosend, infosend_new, command, good_handshake, bad_handshake, user };

	Link aConnectionClosedHdl;

protected:
InformationClient(
		   const ByteString &rRequest,
		   BOOL bRequestList,
		   BOOL bRequestWholeList );

public:
virtual ~InformationClient();

  enum Error_Code { none, /*no_connect,*/ server_shutdown, no_info };

  BOOL CnctIsValid();	 // Flag, ob die Verbindung schon besteht

  void SetRequest( const ByteString &rRequest,
		   BOOL bListRequest = FALSE,
		   BOOL bWholeList = FALSE )
  { sRequest = rRequest; /*bListReq = bListRequest; bWholeListReq = bWholeList;*/ eSendMode = (bListRequest?(bWholeList?request_whole_list:request_list):request); }

  /* setzt ein Kommando , abschicken mit SendData() */
  void SetCommand( const ByteString &rCommand,
		   const ByteString &rOptions = ByteString() )
  { sRequest = rCommand; sRequestOptions = rOptions; eSendMode = command; }
  void SetInfo( const ByteString &rKey,
		const ByteString &rValue,
		BOOL bNewPath )
  { sRequest = rKey; sRequestOptions = rValue; /*bCreateNewPath = bNewPath;*/ eSendMode = (bNewPath?infosend_new:infosend); }

  void SetData( InfoDataPack *pData );
  long int SendData(); // schickt den Request ab

  //const String &GetAnswer() const { return sAnswer; } // spaeter mit file/memorystream realisieren
  //  const SvStream &GetAnswer() const { return *pMemStream; }
  //const char *GetAnswer() const { return aMemStream.GetData(); }

  /* gibt die angeforderte Generic Information zurueck
   * Bei einfacher Anfrage enthaelt GetInfo() nur ein Key-Value Paar
   * Bei Listenanfrage enthaelt GetInfo() ein Key-Value Paar UND 1 Liste
   *   GetSubList() mit weiteren Key-Value Paaren
   */
  GenericInformation *GetInfo( BOOL bAquireOwnership = FALSE )
	{
		if ( bAquireOwnership )
		{
			GenericInformation *pTemp = pGenInfo;
			pGenInfo = NULL;
			return pTemp;
		}
		else
			return pGenInfo;
	}

  /* InfoIsValid() unterscheidet zwischen:
   * TRUE -> information gefunden aber eventuell leer
   * FALSE -> information nicht gefunden beim Server
   */
  BOOL InfoIsValid() const { return bValid; }
  BOOL CommandAcknowledged() const { return bValid; }
  BOOL CommandAknowledge() const { DBG_ERROR("Command misspelled: deprecated! Use CommandAcknowledged") return bValid; }
  Error_Code GetError() const { return eErrorCode; }

  /* Methode mit blockierender Abfrage der Information
   * ->erspart die Links
   * wenn pRequest vom Konstruktor oder SetRequest() ==0 ist passiert NICHTS !!!
   * wenn schon eine Nachricht abgeschickt wurde wird nur noch auf den Empfang gewartet
   * bei ungueltiger Information !InfoIsValid() wird NULL zurueck gegeben. */
  virtual const GenericInformation *Send_n_Wait()=0;
  /* wie "Send_n_Wait", nur wird auf ein Aknowlege gewartet
   * und das Ergebniss der Anfrage zurueckgegeben. */
  virtual BOOL Command_n_Wait()=0;

  // send a message, if you got the answer
  void SetGotInfoHdl ( Link &rLink ) { aGotInfoHdl = rLink; }

  /* Setzt einen Notfy mechanismus bein Iserver ab.
   * der Server benachrichtigt dabei dieses Object,
   * wenn Aenderungen an einer Datei vorgenommen wurden.
   * Der Notifymechanismus wird automatisch abgebaut, beim
   * Abbau dieses Objects.
   */
  virtual BOOL Notify_Me( const ByteString &rFileName )=0; // Datei, fuer welche die Aenderung benachrichtigt wird.
  virtual BOOL Denotify_Me( const ByteString &rFileName )=0;
  /* Reciever of the Nofify.
   * Hier wird der Empfaenger der Iserverbenachrichtigung angelinkt */
  virtual void SetNotifyHdl ( Link &rLink )=0;
  /* wenn die Benachrichtigung kam,
   * kann hier die Nachricht abgeholt werden.
   * !!!!!!! IsValid() und andere Flags haben keine Bedeutung */
  virtual const ByteString GetNotifyFile() const=0;

  void SetConnectionClosedHdl( const Link &rLink ) { aConnectionClosedHdl = rLink; }

// Da frher TcpCon Basisklasse war mssen aus Kompatibilittsgrnden
// diese Methoden des TcpCon zur verfgung gestellt werden

	void StartCommunication() { pTcpCon->StartCommunication(); }
	ClientContext *GetClientContext() { return pTcpCon->GetClientContext(); }

	long int SendData( DataPack* pDPack ) { return pTcpCon->SendData( pDPack ); }

	ByteString&	GetAddress() { return pTcpCon->GetAddress(); }
	ByteString& GetTcpNr() { return pTcpCon->GetTcpNr(); }

	BOOL	IsServer() { return pTcpCon->IsServer(); }
	BOOL	ClientHasCon() { return pTcpCon->ClientHasCon(); }

	void 	SetStatusHdl( const Link &rLink ) { pTcpCon->SetStatusHdl( rLink ); }

	AsyncFuncsBase *GetAsyncFuncs() { return pAsyncFuncs; }

	void SetApplication( const ByteString& aApp ) { pTcpCon->SetApplication( aApp ); }

protected:

	void LateInit();

	AsyncFuncsBase *pAsyncFuncs;

  virtual DECL_LINK( PacketRecieved, DataPack* );
  virtual DECL_LINK( ConnectionOpened, ClientContext* );
  virtual DECL_LINK( ConnectionClosed, ClientContext* );
  void SendHandShake( BOOL bSuccess = TRUE );

  TcpConBase *pTcpCon;

  InfoDataPack *pInfoPack;

  Link   aGotInfoHdl;
  ByteString sRequest, sRequestOptions;
  GenericInformation *pGenInfo;
  SvMemoryStream *pWholeListStream;
  int    nRetries;
  BOOL   bSend, bRecieved, bValid, bConnectionBad; // memory for send & recieved Datagramms
  UINT16 nLastPaket; // hier steht das zuletzt angekommene Paket
  Error_Code eErrorCode;
  SendMode   eSendMode;

};

#endif
