/*************************************************************************
 *
 *  $RCSfile: bmpacc.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: cp $ $Date: 2001/06/28 13:08:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_BMPACC_HXX
#define _SV_BMPACC_HXX

#ifndef _SV_SV_H
#include <vcl/sv.h>
#endif
#ifndef _SV_SALBTYPE_HXX
#include <vcl/salbtype.hxx>
#endif
#ifndef _SV_BITMAP_HXX
#include <vcl/bitmap.hxx>
#endif

#if 0 // _SOLAR__PRIVATE

// --------------------
// - Access defines -
// --------------------

#define DECL_FORMAT_GETPIXEL( Format ) \
static BitmapColor GetPixelFor##Format( Scanline pScanline, long nX, const ColorMask& rMask );

#define DECL_FORMAT_SETPIXEL( Format ) \
static void SetPixelFor##Format( Scanline pScanline, long nX, const BitmapColor& rBitmapColor, const ColorMask& rMask );

#define DECL_FORMAT( Format )   \
DECL_FORMAT_GETPIXEL( Format )  \
DECL_FORMAT_SETPIXEL( Format )

#define IMPL_FORMAT_GETPIXEL( Format ) \
BitmapColor BitmapReadAccess::GetPixelFor##Format( Scanline pScanline, long nX, const ColorMask& rMask )

#define IMPL_FORMAT_SETPIXEL( Format ) \
void BitmapReadAccess::SetPixelFor##Format( Scanline pScanline, long nX, const BitmapColor& rBitmapColor, const ColorMask& rMask )

#define CASE_FORMAT( Format )           \
case( BMP_FORMAT##Format ):            \
{                                       \
    mFncGetPixel = GetPixelFor##Format;\
    mFncSetPixel = SetPixelFor##Format;\
}                                       \
break;

#endif // __PRIVATE

// --------------------
// - Access functions -
// --------------------

typedef BitmapColor (*FncGetPixel)( Scanline pScanline, long nX, const ColorMask& rMask );
typedef void (*FncSetPixel)( Scanline pScanline, long nX, const BitmapColor& rBitmapColor, const ColorMask& rMask );

// --------------------
// - BitmapReadAccess -
// --------------------

class BitmapReadAccess
{
private:

                                BitmapReadAccess();
                                BitmapReadAccess( const BitmapReadAccess& );
    inline BitmapReadAccess&    operator=( const BitmapReadAccess& );

protected:
    Bitmap                      maBitmap;
    BitmapBuffer*               mpBuffer;
    Scanline*                   mpScanBuf;
    ColorMask                   maColorMask;
    FncGetPixel                 mFncGetPixel;
    FncSetPixel                 mFncSetPixel;
    BOOL                        mbModify;

#if 0 // _SOLAR__PRIVATE

    void                        ImplCreate( Bitmap& rBitmap );
    void                        ImplDestroy();
    BOOL                        ImplSetAccessPointers( ULONG nFormat );

public:

	void						ImplZeroInitUnusedBits();

                                DECL_FORMAT( _1BIT_MSB_PAL )
                                DECL_FORMAT( _1BIT_LSB_PAL )
                                DECL_FORMAT( _4BIT_MSN_PAL )
                                DECL_FORMAT( _4BIT_LSN_PAL )
                                DECL_FORMAT( _8BIT_PAL )
                                DECL_FORMAT( _8BIT_TC_MASK )
                                DECL_FORMAT( _16BIT_TC_MSB_MASK )
                                DECL_FORMAT( _16BIT_TC_LSB_MASK )
                                DECL_FORMAT( _24BIT_TC_BGR )
                                DECL_FORMAT( _24BIT_TC_RGB )
                                DECL_FORMAT( _24BIT_TC_MASK )
                                DECL_FORMAT( _32BIT_TC_ABGR )
                                DECL_FORMAT( _32BIT_TC_ARGB )
                                DECL_FORMAT( _32BIT_TC_BGRA )
                                DECL_FORMAT( _32BIT_TC_RGBA )
                                DECL_FORMAT( _32BIT_TC_MASK )
#endif // __PRIVATE

protected:
                                BitmapReadAccess( Bitmap& rBitmap, BOOL bModify );

    void                        Flush();
    void                        ReAccess( BOOL bModify );

public:
                                BitmapReadAccess( Bitmap& rBitmap );
    virtual                     ~BitmapReadAccess();

    inline BOOL                 operator!() const;

    inline long                 Width() const;
    inline long                 Height() const;
    inline Point                TopLeft() const;
    inline Point                BottomRight() const;

    inline BOOL                 IsTopDown() const;
    inline BOOL                 IsBottomUp() const;

    inline ULONG                GetScanlineFormat() const;
    inline ULONG                GetScanlineSize() const;

    inline USHORT               GetBitCount() const;
    inline BitmapColor          GetBestMatchingColor( const BitmapColor& rBitmapColor );

    inline Scanline             GetBuffer() const;
    inline Scanline             GetScanline( long nY ) const;

    inline BOOL                 HasPalette() const;
    inline const BitmapPalette& GetPalette() const;
    inline USHORT               GetPaletteEntryCount() const;
    inline const BitmapColor&   GetPaletteColor( USHORT nColor ) const;
    inline const BitmapColor&   GetBestPaletteColor( const BitmapColor& rBitmapColor ) const;
    USHORT                      GetBestPaletteIndex( const BitmapColor& rBitmapColor ) const;

    inline BOOL                 HasColorMask() const;
    inline ColorMask&           GetColorMask() const;

    inline BitmapColor          GetPixel( long nY, long nX ) const;
	inline BitmapColor			GetColor( long nY, long nX ) const;
	inline BYTE					GetLuminance( long nY, long nX ) const;
};

// ---------------------
// - BitmapWriteAccess -
// ---------------------

class BitmapWriteAccess : public BitmapReadAccess
{
private:
    BitmapColor                 maLineColor;
    BitmapColor                 maFillColor;

protected:
#if 0 // _SOLAR__PRIVATE
    void                        ImplInitDraw();
#endif // __PRIVATE

public:
    inline                      BitmapWriteAccess( Bitmap& rBitmap );
    virtual                     ~BitmapWriteAccess();

    void                        CopyScanline( long nY, const BitmapReadAccess& rReadAcc );
    void                        CopyScanline( long nY, const Scanline aSrcScanline, 
											  ULONG nSrcScanlineFormat, ULONG nSrcScanlineSize );

    void                        CopyBuffer( const BitmapReadAccess& rReadAcc );

    inline void                 SetPalette( const BitmapPalette& rPalette );
    inline void                 SetPaletteEntryCount( USHORT nCount );
    inline void                 SetPaletteColor( USHORT nColor, const BitmapColor& rBitmapColor );

    inline void                 SetPixel( long nY, long nX, const BitmapColor& rBitmapColor );

    inline void                 SetLineColor( const BitmapColor& rColor );
    inline const BitmapColor&   GetLineColor() const;

    inline void                 SetFillColor( const BitmapColor& rColor );
    inline const BitmapColor&   GetFillColor() const;

	void						Erase( const Color& rColor );

    void                        DrawLine( const Point& rStart, const Point& rEnd );
    void                        DrawRect( const Rectangle& rRect );
    void                        FillRect( const Rectangle& rRect );
	void                        DrawPolygon( const Polygon& rPoly );
	void                        DrawPolyPolygon( const PolyPolygon& rPolyPoly );
};

// -----------
// - Inlines -
// -----------

inline BitmapReadAccess& BitmapReadAccess::operator=( const BitmapReadAccess& )
{
    return *this;
}

// ------------------------------------------------------------------

inline BOOL BitmapReadAccess::operator!() const
{
    return( mpBuffer == NULL );
}

// ------------------------------------------------------------------

inline long BitmapReadAccess::Width() const
{
    return( mpBuffer ? mpBuffer->mnWidth : 0L );
}

// ------------------------------------------------------------------

inline long BitmapReadAccess::Height() const
{
    return( mpBuffer ? mpBuffer->mnHeight : 0L );
}

// ------------------------------------------------------------------

inline Point BitmapReadAccess::TopLeft() const
{
    return Point();
}

// ------------------------------------------------------------------

inline Point BitmapReadAccess::BottomRight() const
{
    return Point( Width() - 1L, Height() - 1L );
}

// ------------------------------------------------------------------

inline BOOL BitmapReadAccess::IsTopDown() const
{
    BMP_ASSERT( mpBuffer, "Access is not valid!" );
    return( mpBuffer ? ( BMP_SCANLINE_ADJUSTMENT( mpBuffer->mnFormat ) == BMP_FORMAT_TOP_DOWN ) : FALSE );
}

// ------------------------------------------------------------------

inline BOOL BitmapReadAccess::IsBottomUp() const
{
    return !IsTopDown();
}

// ------------------------------------------------------------------

inline ULONG BitmapReadAccess::GetScanlineFormat() const
{
    BMP_ASSERT( mpBuffer, "Access is not valid!" );
    return( mpBuffer ? BMP_SCANLINE_FORMAT( mpBuffer->mnFormat ) : 0UL );
}

// ------------------------------------------------------------------

inline ULONG BitmapReadAccess::GetScanlineSize() const
{
    BMP_ASSERT( mpBuffer, "Access is not valid!" );
    return( mpBuffer ? mpBuffer->mnScanlineSize : 0UL );
}

// ------------------------------------------------------------------

inline USHORT  BitmapReadAccess::GetBitCount() const
{
    BMP_ASSERT( mpBuffer, "Access is not valid!" );
    return( mpBuffer ? mpBuffer->mnBitCount : 0 );
}

// ------------------------------------------------------------------

inline BitmapColor BitmapReadAccess::GetBestMatchingColor( const BitmapColor& rBitmapColor )
{
    if( HasPalette() )
        return BitmapColor( (BYTE) GetBestPaletteIndex( rBitmapColor ) );
    else
        return rBitmapColor;
}

// ------------------------------------------------------------------

inline Scanline BitmapReadAccess::GetBuffer() const
{
    BMP_ASSERT( mpBuffer, "Access is not valid!" );
    return( mpBuffer ? mpBuffer->mpBits : NULL );
}

// ------------------------------------------------------------------

inline Scanline BitmapReadAccess::GetScanline( long nY ) const
{
    BMP_ASSERT( mpBuffer, "Access is not valid!" );
    BMP_ASSERT( nY < mpBuffer->mnHeight, "y-coordinate out of range!" );
    return( mpBuffer ? mpScanBuf[ nY ] : NULL );
}

// ------------------------------------------------------------------

inline BOOL BitmapReadAccess::HasPalette() const
{
    BMP_ASSERT( mpBuffer, "Access is not valid!" );
    return( mpBuffer && !!mpBuffer->maPalette );
}

// ------------------------------------------------------------------

inline const BitmapPalette& BitmapReadAccess::GetPalette() const
{
    BMP_ASSERT( mpBuffer, "Access is not valid!" );
    return mpBuffer->maPalette;
}

// ------------------------------------------------------------------

inline USHORT BitmapReadAccess::GetPaletteEntryCount() const
{
    BMP_ASSERT( HasPalette(), "Bitmap has no palette!" );
    return( HasPalette() ? mpBuffer->maPalette.GetEntryCount() : 0 );
}

// ------------------------------------------------------------------

inline const BitmapColor& BitmapReadAccess::GetPaletteColor( USHORT nColor ) const
{
    BMP_ASSERT( mpBuffer, "Access is not valid!" );
    BMP_ASSERT( HasPalette(), "Bitmap has no palette!" );
    return mpBuffer->maPalette[ nColor ];
}

// ------------------------------------------------------------------

inline const BitmapColor& BitmapReadAccess::GetBestPaletteColor( const BitmapColor& rBitmapColor ) const
{
    return GetPaletteColor( GetBestPaletteIndex( rBitmapColor ) );
}

// ------------------------------------------------------------------

inline BOOL BitmapReadAccess::HasColorMask() const
{
    BMP_ASSERT( mpBuffer, "Access is not valid!" );
    const ULONG nFormat = BMP_SCANLINE_FORMAT( mpBuffer->mnFormat );

    return( nFormat == BMP_FORMAT_8BIT_TC_MASK  ||
            nFormat == BMP_FORMAT_16BIT_TC_MSB_MASK ||
            nFormat == BMP_FORMAT_16BIT_TC_LSB_MASK ||
            nFormat == BMP_FORMAT_24BIT_TC_MASK ||
            nFormat == BMP_FORMAT_32BIT_TC_MASK );
}

// ------------------------------------------------------------------

inline ColorMask& BitmapReadAccess::GetColorMask() const
{
    BMP_ASSERT( mpBuffer, "Access is not valid!" );
    return mpBuffer->maColorMask;
}

// ------------------------------------------------------------------

inline BitmapColor BitmapReadAccess::GetPixel( long nY, long nX ) const
{
    BMP_ASSERT( mpBuffer, "Access is not valid!" );
    BMP_ASSERT( nX < mpBuffer->mnWidth, "x-coordinate out of range!" );
    BMP_ASSERT( nY < mpBuffer->mnHeight, "y-coordinate out of range!" );
    return mFncGetPixel( mpScanBuf[ nY ], nX, maColorMask );
}

// ------------------------------------------------------------------

inline BitmapColor BitmapReadAccess::GetColor( long nY, long nX ) const
{
	if( !!mpBuffer->maPalette )
	{
	    BMP_ASSERT( mpBuffer, "Access is not valid!" );
		return mpBuffer->maPalette[ GetPixel( nY, nX ).GetIndex() ];
	}
	else
		return GetPixel( nY, nX );
}

// ------------------------------------------------------------------

inline BYTE BitmapReadAccess::GetLuminance( long nY, long nX ) const
{
	return GetColor( nY, nX ).GetLuminance();
}

// ------------------------------------------------------------------

inline BitmapWriteAccess::BitmapWriteAccess( Bitmap& rBitmap ) :
            BitmapReadAccess( rBitmap, TRUE ),
            maLineColor     ( 0, 0, 0 ),
            maFillColor     ( 255, 255, 255 )
{
}

// ------------------------------------------------------------------

inline void BitmapWriteAccess::SetPalette( const BitmapPalette& rPalette )
{
    BMP_ASSERT( mpBuffer, "Access is not valid!" );
    BMP_ASSERT( HasPalette(), "Bitmap has no palette!" );
    mpBuffer->maPalette = rPalette;
}

// ------------------------------------------------------------------

inline void BitmapWriteAccess::SetPaletteEntryCount( USHORT nCount )
{
    BMP_ASSERT( mpBuffer, "Access is not valid!" );
    BMP_ASSERT( HasPalette(), "Bitmap has no palette!" );
    mpBuffer->maPalette.SetEntryCount( nCount );
}

// ------------------------------------------------------------------

inline void BitmapWriteAccess::SetPaletteColor( USHORT nColor, const BitmapColor& rBitmapColor )
{
    BMP_ASSERT( mpBuffer, "Access is not valid!" );
    BMP_ASSERT( HasPalette(), "Bitmap has no palette!" );
    mpBuffer->maPalette[ nColor ] = rBitmapColor;
}

// ------------------------------------------------------------------

inline void BitmapWriteAccess::SetLineColor( const BitmapColor& rColor )
{
    BMP_ASSERT( !rColor.IsIndex(), "Drawing with index into palette is not allowed!" );

    if( rColor != maLineColor )
    {
        if( HasPalette() )
            maLineColor = (BYTE) GetBestPaletteIndex( rColor );
        else
            maLineColor = rColor;
    }
}

// ------------------------------------------------------------------

inline const BitmapColor& BitmapWriteAccess::GetLineColor() const
{
    return maLineColor;
}

// ------------------------------------------------------------------

inline void BitmapWriteAccess::SetFillColor( const BitmapColor& rColor )
{
    BMP_ASSERT( !rColor.IsIndex(), "Drawing with index into palette is not allowed!" );

    if( rColor != maFillColor )
    {
        if( HasPalette() )
            maFillColor = (BYTE) GetBestPaletteIndex( rColor );
        else
            maFillColor = rColor;
    }
}

// ------------------------------------------------------------------

inline const BitmapColor& BitmapWriteAccess::GetFillColor() const
{
    return maFillColor;
}

// ------------------------------------------------------------------

inline void BitmapWriteAccess::SetPixel( long nY, long nX, const BitmapColor& rBitmapColor )
{
    BMP_ASSERT( mpBuffer, "Access is not valid!" );
    BMP_ASSERT( nX < mpBuffer->mnWidth, "x-coordinate out of range!" );
    BMP_ASSERT( nY < mpBuffer->mnHeight, "y-coordinate out of range!" );
    mFncSetPixel( mpScanBuf[ nY ], nX, rBitmapColor, maColorMask );
}

#endif // _SV_BMPACC_HXX
