/*
 * Decompiled with CFR 0.152.
 */
package stardiv.starjar;

import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringBufferInputStream;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import stardiv.starjar.BASE64Encoder;
import stardiv.starjar.FileListElement;
import stardiv.starjar.FilterElement;
import stardiv.starjar.FilterSyntaxException;

public class StarJar {
    protected static Hashtable m_jarFiles = new Hashtable();

    protected static ZipFile getJarFile(File file) throws ZipException, IOException {
        ZipFile zipFile = null;
        if (m_jarFiles.containsKey(file.getName())) {
            zipFile = (ZipFile)m_jarFiles.get(file.getName());
        } else {
            zipFile = new ZipFile(file);
            m_jarFiles.put(file.getName(), zipFile);
        }
        return zipFile;
    }

    protected static ZipFile getJarFile(String string) throws ZipException, IOException {
        return StarJar.getJarFile(new File(string));
    }

    public void importFilter(Vector vector, InputStreamReader inputStreamReader) throws FilterSyntaxException {
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        try {
            String string;
            while ((string = lineNumberReader.readLine()) != null) {
                String string2;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.countTokens() <= 0 || !(string2 = stringTokenizer.nextToken()).equals("+") && !string2.equals("-")) continue;
                if (stringTokenizer.countTokens() % 2 != 0) {
                    throw new FilterSyntaxException("Zeile " + lineNumberReader.getLineNumber() + ": zu wenig Parameter");
                }
                vector.addElement(new FilterElement(string2.equals("+"), stringTokenizer.nextToken(), stringTokenizer.nextToken()));
            }
            lineNumberReader.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Fehler beim Parsen der Filter " + inputStreamReader);
            iOException.printStackTrace();
            return;
        }
    }

    public void filterFileList(Vector vector, Vector vector2) {
        Enumeration enumeration = vector.elements();
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        while (enumeration.hasMoreElements()) {
            FileListElement fileListElement = (FileListElement)enumeration.nextElement();
            Enumeration enumeration2 = vector2.elements();
            Pattern pattern = null;
            Pattern pattern2 = null;
            while (enumeration2.hasMoreElements()) {
                FilterElement filterElement = (FilterElement)enumeration2.nextElement();
                try {
                    pattern = perl5Compiler.compile(filterElement.getPathPattern());
                    pattern2 = perl5Compiler.compile(filterElement.getFilenamePattern());
                }
                catch (MalformedPatternException malformedPatternException) {
                    System.out.println("Fehler im Pattern\n" + malformedPatternException);
                }
                String string = null;
                String string2 = null;
                if (fileListElement.isInJarFile()) {
                    String string3 = fileListElement.getFilename();
                    string2 = string3.lastIndexOf("/") != -1 ? string3.substring(string3.lastIndexOf("/") + 1) : (string3.lastIndexOf("\\") != -1 ? string3.substring(string3.lastIndexOf("\\") + 1) : string3);
                    string = string3.substring(0, string3.lastIndexOf(string2));
                } else {
                    string = fileListElement.getPath();
                    string2 = fileListElement.getFilename();
                }
                if (!perl5Matcher.matches(string, pattern) || !perl5Matcher.matches(string2, pattern2)) continue;
                fileListElement.setInclude(filterElement.isInclude());
            }
        }
    }

    public void parseDirectoryTree(Vector vector, File file) throws IOException {
        if (!file.isDirectory()) {
            if (file.isFile() && file.getName().endsWith(".jar")) {
                this.parseJarFile(vector, file);
                return;
            }
            if (file.getPath().lastIndexOf(File.separator) != -1) {
                String string = file.getPath().substring(0, file.getPath().lastIndexOf(File.separator));
                if (string.startsWith(".")) {
                    string = string.substring(1);
                }
                if (string.startsWith("\\")) {
                    string = string.substring(1);
                }
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                vector.addElement(new FileListElement(string, file.getName(), file.length(), true, null, null, null, false));
                return;
            }
            vector.addElement(new FileListElement("", file.getName(), file.length(), true, null, null, null, false));
            return;
        }
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (file2.isDirectory()) {
                this.parseDirectoryTree(vector, file2);
            } else if (stringArray[n].endsWith(".jar")) {
                this.parseJarFile(vector, file2);
            } else if (file2.getPath().lastIndexOf(File.separator) != -1) {
                String string = file2.getPath().substring(0, file2.getPath().lastIndexOf(File.separator));
                if (string.startsWith(".")) {
                    string = string.substring(1);
                }
                if (string.startsWith("\\")) {
                    string = string.substring(1);
                }
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                vector.addElement(new FileListElement(string, file2.getName(), file2.length(), true, null, null, null, false));
            } else {
                vector.addElement(new FileListElement("", file2.getName(), file2.length(), true, null, null, null, false));
            }
            ++n;
        }
    }

    public void parseJarFile(Vector vector, File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                vector.addElement(new FileListElement(file.getPath().substring(0, file.getPath().lastIndexOf(File.separator)), zipEntry.getName(), zipEntry.getSize(), true, file.getName(), zipFile, zipEntry, true));
            }
            return;
        }
        catch (ZipException zipException) {
            System.out.println("Fehler beim Parsen der JarDatei " + file);
            zipException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Fehler beim Parsen der JarDatei " + file);
            iOException.printStackTrace();
            return;
        }
    }

    public void addEntry(ZipEntry zipEntry, InputStream inputStream, ZipOutputStream zipOutputStream) {
        try {
            byte[] byArray = new byte[1024];
            zipOutputStream.putNextEntry(zipEntry);
            if (zipEntry.getMethod() == -1) {
                int n;
                while ((n = inputStream.read(byArray)) >= 0) {
                    zipOutputStream.write(byArray, 0, n);
                }
            } else {
                int n;
                int n2 = (int)zipEntry.getSize();
                while (n2 > 0 && (n = inputStream.read(byArray, 0, Math.min(1024, n2))) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                    n2 -= n;
                }
            }
            ((FilterOutputStream)zipOutputStream).flush();
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Fehler beim Schreiben der Ausgabedatei " + zipOutputStream + "\nEntry " + zipEntry);
            iOException.printStackTrace();
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void zipFiles(Vector var1_1, String var2_2, String var3_3) {
        var5_4 = new StringBuffer("Manifest-Version: 1.0\n\n");
        var7_5 = null;
        var8_6 = null;
        var10_7 = var1_1.elements();
        var11_8 = new Hashtable<String, String>();
        try {
            var12_9 = new FileInputStream(var3_3);
            var13_12 = new BufferedReader(new InputStreamReader((InputStream)var12_9));
            while ((var14_15 = var13_12.readLine()) != null) {
                if (!var14_15.startsWith("Name: ", 0)) continue;
                var15_17 = new String("");
                var16_18 = var13_12.readLine();
                var17_21 = 0;
                while (var16_18 != null && !var16_18.trim().equals("")) {
                    if (var17_21++ > 0) {
                        var15_17 = String.valueOf(var15_17) + "\n";
                    }
                    var15_17 = String.valueOf(var15_17) + var16_18;
                    var16_18 = var13_12.readLine();
                }
                if (var15_17.equals("")) continue;
                var11_8.put(var14_15.substring(6), (String)var15_17);
            }
        }
        catch (Exception var12_10) {
            System.out.println("No valid manifest file: " + var12_10);
        }
        try {
            var8_6 = new BufferedOutputStream(new CheckedOutputStream(new FileOutputStream(var2_2), new Adler32()));
            var9_22 = new ZipOutputStream(var8_6);
            if (true) ** GOTO lbl85
        }
        catch (IOException var12_11) {
            System.out.println("Fehler beim Oeffnen der Ausgabedatei " + var2_2);
            var12_11.printStackTrace();
            return;
        }
        do {
            if (!(var6_23 = (FileListElement)var10_7.nextElement()).isInclude()) continue;
            var12_9 = null;
            try {
                if (!var6_23.isInJarFile()) {
                    var12_9 = !var6_23.getPath().equals(".") ? (var6_23.getPath().indexOf(58) != -1 ? new ZipEntry((String.valueOf(var6_23.getPath().substring(var6_23.getPath().indexOf(File.separator) + 1)) + File.separator + var6_23.getFilename()).replace('\\', '/')) : new ZipEntry((String.valueOf(var6_23.getPath()) + File.separator + var6_23.getFilename()).replace('\\', '/'))) : new ZipEntry(var6_23.getFilename().replace('\\', '/'));
                    var12_9.setSize(var6_23.getSize());
                    var12_9.setCrc(new CRC32().getValue());
                    System.out.println("Adding " + var6_23.getPath() + File.separator + var6_23.getFilename());
                    var7_5 = new BufferedInputStream(new FileInputStream(String.valueOf(var6_23.getPath()) + File.separator + var6_23.getFilename()));
                } else {
                    System.out.println("Adding from JAR (" + var6_23.getPath() + File.separator + var6_23.getJarFilename() + ") " + var6_23.getFilename());
                    var12_9 = var6_23.getZipFileEntry();
                    var7_5 = new BufferedInputStream(var6_23.getZipFile().getInputStream(var6_23.getZipFileEntry()));
                }
                if (var11_8.containsKey(var12_9.getName())) {
                    var5_4.append(new String("Name: " + var12_9.getName() + "\n"));
                    var13_12 = (String)var11_8.get(var12_9.getName());
                    if (var13_12 != null) {
                        var5_4.append(String.valueOf(var13_12) + "\n");
                    }
                    try {
                        var14_15 = null;
                        var14_15 = var6_23.isInJarFile() == false ? new FileInputStream(String.valueOf(var6_23.getPath()) + File.separator + var6_23.getFilename()) : new BufferedInputStream(var6_23.getZipFile().getInputStream(var6_23.getZipFileEntry()));
                        var15_17 = new byte[(int)var6_23.getSize()];
                        var16_20 = 0;
                        while (var14_15.available() > 0) {
                            var16_20 += var14_15.read((byte[])var15_17, var16_20, var14_15.available());
                        }
                        var5_4.append(new String("Digest-Algorithms: SHA MD5\n"));
                        var5_4.append(String.valueOf(StarJar.base64Hash("SHA", (byte[])var15_17)) + "\n");
                        var5_4.append(String.valueOf(StarJar.base64Hash("MD5", (byte[])var15_17)) + "\n");
                        var5_4.append("\n");
                    }
                    catch (Exception var14_16) {
                        System.out.println("Exception while creating digest-key: " + var14_16);
                    }
                }
                this.addEntry((ZipEntry)var12_9, var7_5, var9_22);
            }
            catch (FileNotFoundException var13_13) {
                System.out.println("Datei " + var6_23.getPath() + var6_23.getFilename() + " nicht gefunden.");
                var13_13.printStackTrace();
                return;
            }
            catch (IOException var13_14) {
                if (var6_23.isInJarFile()) {
                    System.out.println("Fehler beim Einlesen des Archivs '" + var6_23.getPath() + File.separator + var6_23.getJarFilename() + "'.");
                }
                var13_14.printStackTrace();
            }
lbl85:
            // 4 sources

        } while (var10_7.hasMoreElements());
        var12_9 = new ZipEntry("META-INF/MANIFEST.MF");
        var4_24 = new StringBufferInputStream(var5_4.toString().replace('\\', '/'));
        var12_9.setSize(var4_24.available());
        var12_9.setCrc(new CRC32().getValue());
        this.addEntry((ZipEntry)var12_9, var4_24, var9_22);
        try {
            var9_22.close();
            return;
        }
        catch (IOException v0) {
            System.out.println("Fehler beim Schliessen der Ausgabedatei " + var2_2);
            System.out.println("Fehlerhaftes Archiv wird geloescht...");
            try {
                var8_6.close();
            }
            catch (IOException v1) {}
            var13_12 = new File(var2_2);
            var13_12.delete();
            return;
        }
    }

    public static String base64Hash(String string, byte[] byArray) {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            return new String(String.valueOf(string) + "-Digest: " + bASE64Encoder.encode(messageDigest.digest(byArray)));
        }
        catch (Exception exception) {
            System.out.println("Exception in base64Hash: " + exception);
            return null;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 5) {
            System.out.println("Usage : java stardiv.starjar.StarJar <jarfile> <manifestfile>|- <filterfile> <fileseparator> <files...>");
            System.out.println("        Achtung, auch 'Space' muss als FileSeparator angegeben werden!");
            return;
        }
        StarJar starJar = new StarJar();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        try {
            Object object;
            if (stringArray[3].equals(" ")) {
                int n = 3;
                while (n < stringArray.length) {
                    starJar.parseDirectoryTree(vector2, new File(stringArray[n]));
                    ++n;
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[4], stringArray[3]);
                while (stringTokenizer.hasMoreTokens()) {
                    starJar.parseDirectoryTree(vector2, new File(stringTokenizer.nextToken()));
                }
            }
            int n = 0;
            while (n < vector2.size()) {
                object = (FileListElement)vector2.elementAt(n++);
                while (vector2.indexOf(object) != vector2.lastIndexOf(object)) {
                    vector2.removeElementAt(vector2.lastIndexOf(object));
                }
            }
            try {
                object = new FileReader(stringArray[2]);
                starJar.importFilter(vector, (InputStreamReader)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Fehler beim Einlesen der Filterdatei :\n" + fileNotFoundException);
            }
            catch (FilterSyntaxException filterSyntaxException) {
                System.out.println("Fehler beim Parsen der Filterdatei :\n" + filterSyntaxException);
            }
            starJar.filterFileList(vector2, vector);
            starJar.zipFiles(vector2, stringArray[0], stringArray[1]);
            return;
        }
        catch (Exception exception) {
            System.out.println("Fehler :\n" + exception);
            return;
        }
    }
}

