/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.ImageIcon;

class DisabledIcon
extends ImageIcon {
    static final long serialVersionUID = 5126672233442706110L;
    private Image borderImage;
    protected boolean borderPainted = true;

    public DisabledIcon(Image image) {
        super(image);
        this.borderImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), new Filter()));
    }

    public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.borderPainted) {
            graphics.drawImage(this.borderImage, n + 1, n2 + 1, null);
        }
        super.paintIcon(component, graphics, n, n2);
    }

    public void setBorderPainted(boolean bl) {
        this.borderPainted = bl;
    }

    class Filter
    extends RGBImageFilter {
        Filter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            return n3 & 0xFF000000 | 0xFF0000 | 0xFF00 | 0xFF;
        }
    }
}

