/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.tree.TreePath;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;

public class BeanTreeView
extends TreeView {
    static final long serialVersionUID = 3841322840231536380L;

    void initializeTree() {
        super.initializeTree();
    }

    protected NodeTreeModel createModel() {
        return new NodeTreeModel();
    }

    protected boolean selectionAccept(Node[] nodeArray) {
        return true;
    }

    protected void showSelection(TreePath[] treePathArray) {
        this.tree.getSelectionModel().setSelectionPaths(treePathArray);
        if (treePathArray.length == 1) {
            this.showPathWithoutExpansion(treePathArray[0]);
        }
    }

    protected void selectionChanged(Node[] nodeArray, ExplorerManager explorerManager) throws PropertyVetoException {
        if (nodeArray.length > 0) {
            Node node = nodeArray[0].getParentNode();
            int n = 1;
            while (n < nodeArray.length) {
                if (node != nodeArray[n].getParentNode()) {
                    explorerManager.setSelectedNodes(nodeArray);
                    return;
                }
                ++n;
            }
            if (explorerManager.getRootContext().getParentNode() == node) {
                explorerManager.setExploredContextAndSelection(null, nodeArray);
            } else {
                explorerManager.setExploredContextAndSelection(node, nodeArray);
            }
        } else {
            explorerManager.setSelectedNodes(nodeArray);
        }
    }

    protected void showPath(TreePath treePath) {
        this.tree.expandPath(treePath);
        this.showPathWithoutExpansion(treePath);
    }

    private void showPathWithoutExpansion(TreePath treePath) {
        Rectangle rectangle = this.tree.getPathBounds(treePath);
        if (rectangle != null) {
            Rectangle rectangle2 = this.tree.getVisibleRect();
            if (rectangle2 != null) {
                rectangle.width = rectangle2.width;
                rectangle.x = rectangle2.x;
            } else {
                rectangle.width += rectangle.x;
                rectangle.x = 0;
            }
            this.tree.scrollRectToVisible(rectangle);
        }
    }

    public void setEnabled(boolean bl) {
        this.tree.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.tree.isEnabled();
    }
}

