/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.tool.javadep;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;

public class GetClasses {
    private static final boolean DEBUG = false;
    static char separator = (char)59;
    static String outputFileName = null;
    static boolean verbose;
    static Vector depLists;
    protected static Vector filters;
    String className;
    File classFile;
    protected Vector dependencies = new Vector();
    static char fileSeparator;
    static String lineSeparator;

    private static final void DEBUG(String string) {
    }

    private static void doOptions(Tokenizer tokenizer) throws IOException, InvalidMagicException, FileNotFoundException {
        while (tokenizer.hasMoreTokens()) {
            String string;
            String string2 = tokenizer.getToken();
            if (string2.toLowerCase().equals("-i")) {
                string = tokenizer.getToken();
                int n = string.indexOf(separator);
                while (n > -1) {
                    GetClasses.addToFilterList(string.substring(0, n));
                    string = string.substring(n + 1);
                    n = string.indexOf(separator);
                }
                GetClasses.addToFilterList(string);
                continue;
            }
            if (string2.toLowerCase().equals("-s")) {
                separator = tokenizer.getToken().charAt(0);
                GetClasses.DEBUG("separator:" + separator);
                continue;
            }
            if (string2.toLowerCase().equals("-o")) {
                outputFileName = tokenizer.getToken();
                continue;
            }
            if (string2.toLowerCase().equals("-v")) {
                verbose = true;
                continue;
            }
            if (string2.startsWith("@")) {
                GetClasses.doOptions(new TStreamTokenizer(new FileInputStream(new File(string2.substring(1)))));
                continue;
            }
            string = string2;
            if (verbose) {
                System.err.println("Processing:" + string);
            } else {
                System.err.print(".");
            }
            GetClasses getClasses = new GetClasses(string);
            getClasses.process();
            depLists.addElement(getClasses);
        }
        if (!verbose) {
            System.err.println();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            try {
                GetClasses.doOptions(new StringArrayTokenizer(stringArray));
                if (verbose) {
                    System.err.println("#### GetClasses writing:" + outputFileName);
                }
                PrintStream printStream = outputFileName != null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(outputFileName)))) : System.out;
                int n = 0;
                while (n < depLists.size()) {
                    ((GetClasses)depLists.elementAt(n)).list(printStream);
                    ++n;
                }
                printStream.close();
                return;
            }
            catch (InvalidMagicException invalidMagicException) {
                System.err.println(String.valueOf(lineSeparator) + "JavaDep - abort:" + invalidMagicException);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(String.valueOf(lineSeparator) + "JavaDep - abort:" + fileNotFoundException);
                return;
            }
            catch (IOException iOException) {
                System.err.println(String.valueOf(lineSeparator) + "JavaDep - abort:" + iOException);
                return;
            }
        }
        System.err.println("DepList: -o <outputFile> | [-i <path<separator>path>]* | -s <separator> | [classFile]*");
    }

    protected static void addToFilterList(String string) throws IOException {
        if (string.charAt(string.length() - 1) != '/') {
            string = String.valueOf(string) + "/";
        }
        GetClasses.DEBUG("DepList.addToFilterList:" + string);
        filters.addElement(string);
    }

    GetClasses(String string) {
        this.className = string;
        this.classFile = new File(string);
    }

    String getPackagePrefix(String string) {
        String string2 = string;
        int n = string.lastIndexOf(fileSeparator);
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    boolean isEmpty() {
        return this.dependencies.size() == 0;
    }

    protected void addDepedencee(String string) throws IOException {
        if (filters.size() != 0) {
            int n = 0;
            while (n < filters.size()) {
                String string2 = (String)filters.elementAt(n);
                File file = new File(String.valueOf(string2) + string);
                if (!this.getPackagePrefix(file.getCanonicalPath()).equals(this.getPackagePrefix(this.classFile.getCanonicalPath())) && file.exists()) {
                    GetClasses.DEBUG("DepList.addDepedencee - adding:" + file);
                    this.dependencies.addElement(String.valueOf(string2) + string);
                }
                ++n;
            }
            return;
        }
        File file = new File(string);
        if (file.exists()) {
            GetClasses.DEBUG("DepList.addDepedencee - adding:" + file);
            this.dependencies.addElement(string);
        }
    }

    static String replaceChar(String string, char c, String string2) {
        String string3 = "";
        int n = string.indexOf(c);
        while (n > -1) {
            string3 = String.valueOf(string3) + string.substring(0, n) + string2;
            string = string.substring(n + 1);
            n = string.indexOf(c);
        }
        string3 = String.valueOf(string3) + string;
        return string3;
    }

    protected void list(PrintStream printStream) {
        printStream.print(String.valueOf(GetClasses.replaceChar(this.className, fileSeparator, "$/")) + ":");
        int n = 0;
        while (n < this.dependencies.size()) {
            printStream.print("  \\" + lineSeparator + "\t" + GetClasses.replaceChar((String)this.dependencies.elementAt(n), fileSeparator, "$/"));
            ++n;
        }
        printStream.print(String.valueOf(lineSeparator) + lineSeparator);
    }

    protected void process() throws IOException, InvalidMagicException {
        String string;
        int n;
        FileInputStream fileInputStream = new FileInputStream(this.classFile);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(fileInputStream));
        int n2 = dataInputStream.readInt();
        if (n2 != -889275714) {
            throw new InvalidMagicException("Invalid magic number in " + this.className);
        }
        dataInputStream.readShort();
        dataInputStream.readShort();
        int n3 = dataInputStream.readShort();
        Vector<Integer> vector = new Vector<Integer>();
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        int n4 = 1;
        while (n4 < n3) {
            n = dataInputStream.readByte();
            switch (n) {
                case 7: {
                    short s = dataInputStream.readShort();
                    vector.addElement(new Integer(s));
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    dataInputStream.skipBytes(4);
                    break;
                }
                case 8: {
                    dataInputStream.skipBytes(2);
                    break;
                }
                case 3: 
                case 4: {
                    dataInputStream.skipBytes(4);
                    break;
                }
                case 5: 
                case 6: {
                    dataInputStream.skipBytes(8);
                    ++n4;
                    break;
                }
                case 12: {
                    dataInputStream.skipBytes(4);
                    break;
                }
                case 1: {
                    string = dataInputStream.readUTF();
                    hashtable.put(new Integer(n4), string);
                    break;
                }
                default: {
                    GetClasses.DEBUG("WARNING: Unknown constant tag (" + n + "@" + n4 + " of " + n3 + ") in " + this.className);
                }
            }
            ++n4;
        }
        dataInputStream.close();
        n = 0;
        while (n < vector.size()) {
            block17: {
                block16: {
                    Integer n5 = (Integer)vector.elementAt(n);
                    string = (String)hashtable.get(n5);
                    if (!string.startsWith("[")) break block16;
                    while (string.startsWith("[")) {
                        string = string.substring(1);
                    }
                    if (!string.startsWith("L")) break block17;
                    string = string.substring(1, string.length() - 1);
                }
                string = String.valueOf(string) + ".class";
                this.addDepedencee(string);
            }
            ++n;
        }
    }

    static {
        depLists = new Vector();
        filters = new Vector();
        fileSeparator = System.getProperty("file.separator").charAt(0);
        lineSeparator = System.getProperty("line.separator");
    }

    static class InvalidMagicException
    extends Exception {
        InvalidMagicException(String string) {
            super(string);
        }
    }

    interface Tokenizer {
        public String getToken() throws IOException;

        public boolean hasMoreTokens() throws IOException;
    }

    static class StringArrayTokenizer
    implements Tokenizer {
        String[] args;
        int index;

        StringArrayTokenizer(String[] stringArray) {
            this.args = stringArray;
        }

        public String getToken() {
            return this.args[this.index++];
        }

        public boolean hasMoreTokens() {
            return this.index < this.args.length;
        }
    }

    static class TStreamTokenizer
    implements Tokenizer {
        StringBuffer token;
        InputStream inputStream;
        int ch = 32;

        TStreamTokenizer(InputStream inputStream) throws IOException {
            this.inputStream = inputStream;
            this.eatSpace();
        }

        void eatSpace() throws IOException {
            while (this.ch != -1 && (Character.isWhitespace((char)this.ch) || (char)this.ch == '\"')) {
                this.ch = this.inputStream.read();
            }
        }

        public String getToken() throws IOException {
            this.token = new StringBuffer();
            while (this.ch != -1 && !Character.isWhitespace((char)this.ch)) {
                this.token.append((char)this.ch);
                this.ch = this.inputStream.read();
                if (this.ch == -1 || (char)this.ch != '\"') continue;
                this.ch = this.inputStream.read();
            }
            this.eatSpace();
            return this.token.toString();
        }

        public boolean hasMoreTokens() {
            return this.ch != -1;
        }
    }
}

