/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.tool.starjar;

import com.sun.star.tool.starjar.BASE64Encoder;
import com.sun.star.tool.starjar.DoubleException;
import com.sun.star.tool.starjar.FileList;
import com.sun.star.tool.starjar.FileListElement;
import com.sun.star.tool.starjar.FilterElement;
import com.sun.star.tool.starjar.FilterSyntaxException;
import com.sun.star.tool.starjar.regex.MalformedPatternException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringBufferInputStream;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class StarJar {
    protected static Hashtable m_jarFiles = new Hashtable();
    protected String m_classPrefix;

    protected static ZipFile getJarFile(File file) throws ZipException, IOException {
        ZipFile zipFile = null;
        if (m_jarFiles.containsKey(file.getName())) {
            zipFile = (ZipFile)m_jarFiles.get(file.getName());
        } else {
            zipFile = new ZipFile(file);
            m_jarFiles.put(file.getName(), zipFile);
        }
        return zipFile;
    }

    protected static ZipFile getJarFile(String string) throws ZipException, IOException {
        return StarJar.getJarFile(new File(string));
    }

    public void importFilter(Vector vector, InputStreamReader inputStreamReader) throws FilterSyntaxException, IOException, MalformedPatternException {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        while ((string = lineNumberReader.readLine()) != null) {
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() <= 0 || !(string2 = stringTokenizer.nextToken()).equals("+") && !string2.equals("-")) continue;
            if (stringTokenizer.countTokens() % 2 != 0) {
                throw new FilterSyntaxException("Zeile " + lineNumberReader.getLineNumber() + ": zu wenig Parameter");
            }
            vector.addElement(new FilterElement(string2.equals("+"), stringTokenizer.nextToken(), stringTokenizer.nextToken()));
        }
        lineNumberReader.close();
    }

    public void parseDirectoryTree(FileList fileList, File file, boolean bl) throws IOException, DoubleException {
        if (!file.exists()) {
            System.err.println("File: " + file.getPath() + File.separator + file.getName() + " does not exist, ignored!!!");
            return;
        }
        if (file.isFile() && (file.getName().endsWith(".jar") || file.getName().endsWith(".JAR")) && bl) {
            this.parseJarFile(fileList, file);
            return;
        }
        if (file.isFile()) {
            if (file.getPath().lastIndexOf(File.separator) != -1) {
                String string = file.getPath().substring(0, file.getPath().lastIndexOf(File.separator));
                fileList.put(new FileListElement(this.m_classPrefix, string, file.getName(), file.length(), true, null, null, null, false), false);
                return;
            }
            fileList.put(new FileListElement(this.m_classPrefix, "", file.getName(), file.length(), true, null, null, null, false), false);
            return;
        }
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                this.parseDirectoryTree(fileList, file2, false);
                ++n;
            }
        }
    }

    public void parseJarFile(FileList fileList, File file) throws ZipException, IOException, DoubleException {
        System.err.println("parsingJar:" + file);
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName().replace('/', File.separator.charAt(0));
            String string2 = "";
            String string3 = string;
            int n = string.lastIndexOf(File.separator);
            if (n > -1) {
                string2 = string.substring(n + 1);
                string3 = string.substring(0, n);
            }
            fileList.put(new FileListElement(string3, string2, zipEntry.getSize(), true, String.valueOf(file.getPath()) + File.separator + file.getName(), zipFile, zipEntry, true), true);
        }
    }

    public void addEntry(ZipEntry zipEntry, InputStream inputStream, ZipOutputStream zipOutputStream) throws IOException {
        byte[] byArray = new byte[1024];
        zipOutputStream.putNextEntry(zipEntry);
        if (zipEntry.getMethod() == -1) {
            int n;
            while ((n = inputStream.read(byArray)) >= 0) {
                zipOutputStream.write(byArray, 0, n);
            }
        } else {
            int n;
            int n2 = (int)zipEntry.getSize();
            while (n2 > 0 && (n = inputStream.read(byArray, 0, Math.min(1024, n2))) != -1) {
                zipOutputStream.write(byArray, 0, n);
                n2 -= n;
            }
        }
        ((FilterOutputStream)zipOutputStream).flush();
        inputStream.close();
    }

    public void zipFiles(Enumeration enumeration, String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<String> vector = new Vector<String>();
        Vector<FileListElement> vector2 = new Vector<FileListElement>();
        try {
            FileListElement fileListElement;
            Object object;
            int n;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            try {
                object5 = new FileInputStream(string2);
                object4 = new BufferedReader(new InputStreamReader((InputStream)object5));
                while ((object3 = ((BufferedReader)object4).readLine()) != null) {
                    object2 = new String("");
                    n = 0;
                    ((String)object3).trim();
                    if (((String)object3).startsWith("Name: ", 0)) {
                        object = ((BufferedReader)object4).readLine();
                        while (object != null && !((String)object).trim().equals("")) {
                            if (n++ > 0) {
                                object2 = String.valueOf(object2) + "\n";
                            }
                            object2 = String.valueOf(object2) + (String)object;
                            object = ((BufferedReader)object4).readLine();
                        }
                        if (((String)object2).equals("")) continue;
                        hashtable.put(((String)object3).substring(6), (String)object2);
                        continue;
                    }
                    if (((String)object3).equals("")) continue;
                    object = ((BufferedReader)object4).readLine();
                    while (object != null && !((String)object).trim().equals("")) {
                        if (n++ > 0) {
                            object2 = String.valueOf(object2) + "\n";
                        }
                        object2 = String.valueOf(object2) + (String)object;
                        object = ((BufferedReader)object4).readLine();
                    }
                    if (((String)object3).startsWith("Manifest-Version:") && ((String)object3).indexOf("!MANIFEST_VERSION!") > 0) {
                        object3 = new String("Manifest-Version: 1.0");
                    }
                    if (!((String)object2).equals("")) {
                        object3 = ((String)object3).concat("\n" + (String)object2);
                    }
                    if (vector.size() == 0 && !((String)object3).startsWith("Manifest-Version:")) {
                        vector.addElement("Manifest-Version: 1.0");
                    }
                    vector.addElement((String)object3);
                }
            }
            catch (Exception exception) {
                System.out.println("No valid manifest file: " + exception);
            }
            if (vector.size() == 0) {
                vector.addElement("Manifest-Version: 1.0\n");
            }
            object5 = vector.elements();
            while (object5.hasMoreElements()) {
                stringBuffer.append((String)object5.nextElement());
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n");
            bufferedOutputStream = new BufferedOutputStream(new CheckedOutputStream(new FileOutputStream(string), new Adler32()));
            zipOutputStream = new ZipOutputStream(bufferedOutputStream);
            while (enumeration.hasMoreElements()) {
                fileListElement = (FileListElement)enumeration.nextElement();
                if (!fileListElement.isInclude()) continue;
                object4 = !fileListElement.isInJarFile() ? (!fileListElement.getPath().equals(".") ? (fileListElement.getPath().indexOf(58) != -1 ? (String.valueOf(fileListElement.getPath().substring(fileListElement.getPath().indexOf(File.separator) + 1)) + File.separator + fileListElement.getFilename()).replace('\\', '/') : (!fileListElement.getPath().equals("") ? (String.valueOf(fileListElement.getPath()) + File.separator + fileListElement.getFilename()).replace('\\', '/') : fileListElement.getFilename().replace('\\', '/'))) : fileListElement.getFilename().replace('\\', '/')) : fileListElement.getZipFileEntry().getName();
                if (hashtable.containsKey(object4)) {
                    stringBuffer.append(new String("Name: " + (String)object4 + "\n"));
                    object3 = (String)hashtable.get(object4);
                    if (object3 != null) {
                        stringBuffer.append(String.valueOf(object3) + "\n");
                    }
                    try {
                        object = null;
                        object = !fileListElement.isInJarFile() ? new FileInputStream(String.valueOf(fileListElement.getRealPath()) + File.separator + fileListElement.getFilename()) : new BufferedInputStream(fileListElement.getZipFile().getInputStream(fileListElement.getZipFileEntry()));
                        object2 = new byte[(int)fileListElement.getSize()];
                        n = 0;
                        while (((InputStream)object).available() > 0) {
                            n += ((InputStream)object).read((byte[])object2, n, ((InputStream)object).available());
                        }
                        stringBuffer.append(new String("Digest-Algorithms: SHA MD5\n"));
                        stringBuffer.append(String.valueOf(StarJar.base64Hash("SHA", (byte[])object2)) + "\n");
                        stringBuffer.append(String.valueOf(StarJar.base64Hash("MD5", (byte[])object2)) + "\n");
                        stringBuffer.append("\n");
                    }
                    catch (Exception exception) {
                        System.out.println("Exception while creating digest-key: " + exception);
                    }
                }
                vector2.addElement(fileListElement);
            }
            object4 = new ZipEntry("META-INF/MANIFEST.MF");
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(stringBuffer.toString().replace('\\', '/'));
            ((ZipEntry)object4).setSize(stringBufferInputStream.available());
            ((ZipEntry)object4).setCrc(new CRC32().getValue());
            this.addEntry((ZipEntry)object4, stringBufferInputStream, zipOutputStream);
            object3 = vector2.elements();
            while (object3.hasMoreElements()) {
                fileListElement = (FileListElement)object3.nextElement();
                if (!fileListElement.isInclude()) continue;
                object = null;
                try {
                    if (!fileListElement.isInJarFile()) {
                        object = !fileListElement.getPath().equals(".") ? (fileListElement.getPath().indexOf(58) != -1 ? new ZipEntry((String.valueOf(fileListElement.getPath().substring(fileListElement.getPath().indexOf(File.separator) + 1)) + File.separator + fileListElement.getFilename()).replace('\\', '/')) : (!fileListElement.getPath().equals("") ? new ZipEntry((String.valueOf(fileListElement.getPath()) + File.separator + fileListElement.getFilename()).replace('\\', '/')) : new ZipEntry(fileListElement.getFilename().replace('\\', '/')))) : new ZipEntry(fileListElement.getFilename().replace('\\', '/'));
                        ((ZipEntry)object).setSize(fileListElement.getSize());
                        ((ZipEntry)object).setCrc(new CRC32().getValue());
                        object2 = "";
                        if (!fileListElement.getRealPath().equals("")) {
                            object2 = String.valueOf(fileListElement.getRealPath()) + File.separator;
                        }
                        object2 = String.valueOf(object2) + fileListElement.getFilename();
                        System.out.println("Adding " + (String)object2 + " as " + ((ZipEntry)object).getName());
                        bufferedInputStream = new BufferedInputStream(new FileInputStream((String)object2));
                    } else {
                        System.out.println("Adding from JAR (" + fileListElement.getJarFilename() + ") " + fileListElement.getFilename());
                        object = new ZipEntry(fileListElement.getZipFileEntry().getName());
                        ((ZipEntry)object).setSize(fileListElement.getSize());
                        ((ZipEntry)object).setCrc(new CRC32().getValue());
                        bufferedInputStream = new BufferedInputStream(fileListElement.getZipFile().getInputStream(fileListElement.getZipFileEntry()));
                    }
                    this.addEntry((ZipEntry)object, bufferedInputStream, zipOutputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("Datei " + fileListElement.getPath() + fileListElement.getFilename() + " nicht gefunden.");
                    fileNotFoundException.printStackTrace();
                    Object var14_22 = null;
                    if (zipOutputStream != null) {
                        zipOutputStream.close();
                    }
                    return;
                }
            }
        }
        finally {
            Object var14_23 = null;
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
        System.out.println("Ok ! -> " + string);
    }

    public static String base64Hash(String string, byte[] byArray) {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            return new String(String.valueOf(string) + "-Digest: " + bASE64Encoder.encode(messageDigest.digest(byArray)));
        }
        catch (Exception exception) {
            System.out.println("Exception in base64Hash: " + exception);
            return null;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 5) {
            System.out.println("Usage : java stardiv.starjar.StarJar <jarfile> <manifestfile>|- <filterfile> <fileseparator> <files...>");
            System.out.println("        Achtung, auch 'Space' muss als FileSeparator angegeben werden!");
            return;
        }
        StarJar starJar = new StarJar();
        Vector vector = new Vector();
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(stringArray[2]);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("error reading filter file:\n" + fileNotFoundException);
            System.exit(1);
        }
        try {
            starJar.importFilter(vector, fileReader);
            FileList fileList = new FileList(vector);
            if (stringArray[3].equals(" ")) {
                int n = 4;
                while (n < stringArray.length) {
                    starJar.parseDirectoryTree(fileList, new File(stringArray[n]), true);
                    ++n;
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[4], stringArray[3]);
                while (stringTokenizer.hasMoreTokens()) {
                    String string;
                    starJar.m_classPrefix = string = stringTokenizer.nextToken();
                    starJar.parseDirectoryTree(fileList, new File(string), true);
                }
            }
            starJar.zipFiles(fileList.elements(), stringArray[0], stringArray[1]);
            return;
        }
        catch (Exception exception) {
            System.err.println("Exception occurred: " + exception);
            System.err.print("deleting archive:" + stringArray[0] + " ...");
            File file = new File(stringArray[0]);
            file.delete();
            System.err.println();
            System.exit(-1);
            return;
        }
    }
}

