/*
 * Decompiled with CFR 0.152.
 */
package stardiv.starjar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringBufferInputStream;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import stardiv.starjar.BASE64Encoder;
import stardiv.starjar.FileListElement;
import stardiv.starjar.FilterElement;
import stardiv.starjar.FilterSyntaxException;
import stardiv.starjar.regex.MalformedPatternException;
import stardiv.starjar.regex.Pattern;
import stardiv.starjar.regex.Perl5Compiler;
import stardiv.starjar.regex.Perl5Matcher;

public class StarJar {
    protected static Hashtable m_jarFiles = new Hashtable();

    protected static ZipFile getJarFile(File file) throws ZipException, IOException {
        ZipFile zipFile = null;
        if (m_jarFiles.containsKey(file.getName())) {
            zipFile = (ZipFile)m_jarFiles.get(file.getName());
        } else {
            zipFile = new ZipFile(file);
            m_jarFiles.put(file.getName(), zipFile);
        }
        return zipFile;
    }

    protected static ZipFile getJarFile(String string) throws ZipException, IOException {
        return StarJar.getJarFile(new File(string));
    }

    public void importFilter(Vector vector, InputStreamReader inputStreamReader) throws FilterSyntaxException, IOException {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        while ((string = lineNumberReader.readLine()) != null) {
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() <= 0 || !(string2 = stringTokenizer.nextToken()).equals("+") && !string2.equals("-")) continue;
            if (stringTokenizer.countTokens() % 2 != 0) {
                throw new FilterSyntaxException("Zeile " + lineNumberReader.getLineNumber() + ": zu wenig Parameter");
            }
            vector.addElement(new FilterElement(string2.equals("+"), stringTokenizer.nextToken(), stringTokenizer.nextToken()));
        }
        lineNumberReader.close();
    }

    public void filterFileList(Enumeration enumeration, Vector vector) {
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        while (enumeration.hasMoreElements()) {
            FileListElement fileListElement = (FileListElement)enumeration.nextElement();
            Enumeration enumeration2 = vector.elements();
            Pattern pattern = null;
            Pattern pattern2 = null;
            while (enumeration2.hasMoreElements()) {
                FilterElement filterElement = (FilterElement)enumeration2.nextElement();
                try {
                    pattern = perl5Compiler.compile(filterElement.getPathPattern());
                    pattern2 = perl5Compiler.compile(filterElement.getFilenamePattern());
                }
                catch (MalformedPatternException malformedPatternException) {
                    System.out.println("Fehler im Pattern\n" + malformedPatternException);
                }
                String string = null;
                String string2 = null;
                if (fileListElement.isInJarFile()) {
                    String string3 = fileListElement.getFilename();
                    string2 = string3.lastIndexOf("/") != -1 ? string3.substring(string3.lastIndexOf("/") + 1) : (string3.lastIndexOf("\\") != -1 ? string3.substring(string3.lastIndexOf("\\") + 1) : string3);
                    string = string3.substring(0, string3.lastIndexOf(string2));
                } else {
                    string = fileListElement.getPath();
                    string2 = fileListElement.getFilename();
                }
                if (!perl5Matcher.matches(string, pattern) || !perl5Matcher.matches(string2, pattern2)) continue;
                fileListElement.setInclude(filterElement.isInclude());
            }
        }
    }

    public void parseDirectoryTree(Vector vector, File file) throws IOException {
        if (!file.isDirectory()) {
            if (file.isFile() && file.getName().endsWith(".jar") || file.getName().endsWith(".JAR")) {
                this.parseJarFile(vector, file);
                return;
            }
            if (file.isFile()) {
                if (file.getPath().lastIndexOf(File.separator) != -1) {
                    String string = file.getPath().substring(0, file.getPath().lastIndexOf(File.separator));
                    if (string.startsWith(".")) {
                        string = string.substring(1);
                    }
                    if (string.startsWith("\\")) {
                        string = string.substring(1);
                    }
                    if (string.startsWith("/")) {
                        string = string.substring(1);
                    }
                    vector.addElement(new FileListElement(string, file.getName(), file.length(), true, null, null, null, false));
                    return;
                }
                vector.addElement(new FileListElement("", file.getName(), file.length(), true, null, null, null, false));
            }
            return;
        }
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (file2.isDirectory()) {
                this.parseDirectoryTree(vector, file2);
            } else if (!stringArray[n].endsWith(".jar") && !stringArray[n].endsWith(".JAR")) {
                if (file2.getPath().lastIndexOf(File.separator) != -1) {
                    String string = file2.getPath().substring(0, file2.getPath().lastIndexOf(File.separator));
                    if (string.startsWith(".")) {
                        string = string.substring(1);
                    }
                    if (string.startsWith("\\")) {
                        string = string.substring(1);
                    }
                    if (string.startsWith("/")) {
                        string = string.substring(1);
                    }
                    vector.addElement(new FileListElement(string, file2.getName(), file2.length(), true, null, null, null, false));
                } else {
                    vector.addElement(new FileListElement("", file2.getName(), file2.length(), true, null, null, null, false));
                }
            }
            ++n;
        }
    }

    public void parseJarFile(Vector vector, File file) throws ZipException, IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            vector.addElement(new FileListElement(file.getPath().substring(0, file.getPath().lastIndexOf(File.separator)), zipEntry.getName(), zipEntry.getSize(), true, file.getName(), zipFile, zipEntry, true));
        }
    }

    public void addEntry(ZipEntry zipEntry, InputStream inputStream, ZipOutputStream zipOutputStream) throws IOException {
        byte[] byArray = new byte[1024];
        zipOutputStream.putNextEntry(zipEntry);
        if (zipEntry.getMethod() == -1) {
            int n;
            while ((n = inputStream.read(byArray)) >= 0) {
                zipOutputStream.write(byArray, 0, n);
            }
        } else {
            int n;
            int n2 = (int)zipEntry.getSize();
            while (n2 > 0 && (n = inputStream.read(byArray, 0, Math.min(1024, n2))) != -1) {
                zipOutputStream.write(byArray, 0, n);
                n2 -= n;
            }
        }
        ((FilterOutputStream)zipOutputStream).flush();
        inputStream.close();
    }

    public void zipFiles(Enumeration enumeration, String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("Manifest-Version: 1.0\n\n");
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            try {
                object4 = new FileInputStream(string2);
                object3 = new BufferedReader(new InputStreamReader((InputStream)object4));
                while ((object2 = ((BufferedReader)object3).readLine()) != null) {
                    if (!((String)object2).startsWith("Name: ", 0)) continue;
                    object = new String("");
                    String string3 = ((BufferedReader)object3).readLine();
                    int n = 0;
                    while (string3 != null && !string3.trim().equals("")) {
                        if (n++ > 0) {
                            object = String.valueOf(object) + "\n";
                        }
                        object = String.valueOf(object) + string3;
                        string3 = ((BufferedReader)object3).readLine();
                    }
                    if (((String)object).equals("")) continue;
                    hashtable.put(((String)object2).substring(6), (String)object);
                }
            }
            catch (Exception exception) {
                System.out.println("No valid manifest file: " + exception);
            }
            bufferedOutputStream = new BufferedOutputStream(new CheckedOutputStream(new FileOutputStream(string), new Adler32()));
            zipOutputStream = new ZipOutputStream(bufferedOutputStream);
            while (enumeration.hasMoreElements()) {
                FileListElement fileListElement = (FileListElement)enumeration.nextElement();
                if (!fileListElement.isInclude()) continue;
                object4 = null;
                try {
                    if (!fileListElement.isInJarFile()) {
                        object4 = !fileListElement.getPath().equals(".") ? (fileListElement.getPath().indexOf(58) != -1 ? new ZipEntry((String.valueOf(fileListElement.getPath().substring(fileListElement.getPath().indexOf(File.separator) + 1)) + File.separator + fileListElement.getFilename()).replace('\\', '/')) : new ZipEntry((String.valueOf(fileListElement.getPath()) + File.separator + fileListElement.getFilename()).replace('\\', '/'))) : new ZipEntry(fileListElement.getFilename().replace('\\', '/'));
                        ((ZipEntry)object4).setSize(fileListElement.getSize());
                        ((ZipEntry)object4).setCrc(new CRC32().getValue());
                        object3 = "";
                        if (!fileListElement.getPath().equals("")) {
                            object3 = String.valueOf(fileListElement.getPath()) + File.separator;
                        }
                        object3 = String.valueOf(object3) + fileListElement.getFilename();
                        System.out.println("Adding " + (String)object3);
                        bufferedInputStream = new BufferedInputStream(new FileInputStream((String)object3));
                    } else {
                        System.out.println("Adding from JAR (" + fileListElement.getPath() + File.separator + fileListElement.getJarFilename() + ") " + fileListElement.getFilename());
                        object4 = fileListElement.getZipFileEntry();
                        bufferedInputStream = new BufferedInputStream(fileListElement.getZipFile().getInputStream(fileListElement.getZipFileEntry()));
                    }
                    if (hashtable.containsKey(((ZipEntry)object4).getName())) {
                        stringBuffer.append(new String("Name: " + ((ZipEntry)object4).getName() + "\n"));
                        object3 = (String)hashtable.get(((ZipEntry)object4).getName());
                        if (object3 != null) {
                            stringBuffer.append(String.valueOf(object3) + "\n");
                        }
                        try {
                            object2 = null;
                            object2 = !fileListElement.isInJarFile() ? new FileInputStream(String.valueOf(fileListElement.getPath()) + File.separator + fileListElement.getFilename()) : new BufferedInputStream(fileListElement.getZipFile().getInputStream(fileListElement.getZipFileEntry()));
                            object = new byte[(int)fileListElement.getSize()];
                            int n = 0;
                            while (((InputStream)object2).available() > 0) {
                                n += ((InputStream)object2).read((byte[])object, n, ((InputStream)object2).available());
                            }
                            stringBuffer.append(new String("Digest-Algorithms: SHA MD5\n"));
                            stringBuffer.append(String.valueOf(StarJar.base64Hash("SHA", (byte[])object)) + "\n");
                            stringBuffer.append(String.valueOf(StarJar.base64Hash("MD5", (byte[])object)) + "\n");
                            stringBuffer.append("\n");
                        }
                        catch (Exception exception) {
                            System.out.println("Exception while creating digest-key: " + exception);
                        }
                    }
                    this.addEntry((ZipEntry)object4, bufferedInputStream, zipOutputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("Datei " + fileListElement.getPath() + fileListElement.getFilename() + " nicht gefunden.");
                    fileNotFoundException.printStackTrace();
                    Object var12_21 = null;
                    if (zipOutputStream != null) {
                        zipOutputStream.close();
                    }
                    return;
                }
            }
            object4 = new ZipEntry("META-INF/MANIFEST.MF");
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(stringBuffer.toString().replace('\\', '/'));
            ((ZipEntry)object4).setSize(stringBufferInputStream.available());
            ((ZipEntry)object4).setCrc(new CRC32().getValue());
            this.addEntry((ZipEntry)object4, stringBufferInputStream, zipOutputStream);
        }
        finally {
            Object var12_22 = null;
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
        System.out.println("Ok ! -> " + string);
    }

    public static String base64Hash(String string, byte[] byArray) {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            return new String(String.valueOf(string) + "-Digest: " + bASE64Encoder.encode(messageDigest.digest(byArray)));
        }
        catch (Exception exception) {
            System.out.println("Exception in base64Hash: " + exception);
            return null;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 5) {
            System.out.println("Usage : java stardiv.starjar.StarJar <jarfile> <manifestfile>|- <filterfile> <fileseparator> <files...>");
            System.out.println("        Achtung, auch 'Space' muss als FileSeparator angegeben werden!");
            return;
        }
        StarJar starJar = new StarJar();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(stringArray[2]);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Fehler beim Einlesen der Filterdatei :\n" + fileNotFoundException);
            System.exit(1);
        }
        try {
            if (stringArray[3].equals(" ")) {
                int n = 4;
                while (n < stringArray.length) {
                    starJar.parseDirectoryTree(vector2, new File(stringArray[n]));
                    ++n;
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[4], stringArray[3]);
                while (stringTokenizer.hasMoreTokens()) {
                    starJar.parseDirectoryTree(vector2, new File(stringTokenizer.nextToken()));
                }
            }
            try {
                starJar.importFilter(vector, fileReader);
            }
            catch (FilterSyntaxException filterSyntaxException) {
                System.out.println("Fehler beim Parsen der Filterdatei :\n" + filterSyntaxException);
            }
            starJar.filterFileList(vector2.elements(), vector);
            starJar.zipFiles(vector2.elements(), stringArray[0], stringArray[1]);
            return;
        }
        catch (Exception exception) {
            System.err.println("Exception occurred: " + exception);
            System.err.print("Fehlerhaftes Archiv wird geloescht:" + stringArray[0] + " ...");
            File file = new File(stringArray[0]);
            file.delete();
            System.err.println();
            System.exit(-1);
            return;
        }
    }
}

