// Pspell implementation header file.
// Applications that just use the pspell library should not include 
// these files as they are subject to change.
// Pspell Modules MUST include some of the implementation files and
// spell checkers MAY include some of these files.
// If ANY of the implementation files are included you also link with
// libaspell-impl to protect you from changes in these files.

// Copyright 2000 by Kevin Atkinson under the terms of the LGPL

#include "manager.h"
#include "error_impl.hh"

typedef void * PspellManagerLtHandle;

class PspellManagerImplBase : public PspellManager
{
private:
  PspellManagerLtHandle lt_handle_;
  PspellManagerImplBase(const PspellManagerImplBase &);
  PspellManagerImplBase & operator= (const PspellManagerImplBase &);
protected:
  PspellCanHaveErrorImpl error_;
  PspellManagerImplBase(PspellManagerLtHandle h) : lt_handle_(h) {}
public:
  int          error_number() const {return error_.error_number();}
  const char * error_message() const {return error_.error_message();}
  const PspellErrorExtraInfo * error_extra_info() const
  {
    return error_.error_extra_info();
  }

  PspellManagerLtHandle lt_handle() const {return lt_handle_;}
  virtual ~PspellManagerImplBase() {}
};

PspellCanHaveError * find_word_list(PspellConfig * c);



