*** orig/stlport/stl_alloc.c	Sat Aug 26 17:52:07 2000
--- modified/stlport/stl_alloc.c	Sat Aug 26 17:59:29 2000
***************
*** 4,54 ****
--- 4,58 ----
   * Silicon Graphics Computer Systems, Inc.
   *
   * Copyright (c) 1997
   * Moscow Center for SPARC Technology
   *
   * Copyright (c) 1999 
   * Boris Fomitchev
   *
   * This material is provided "as is", with absolutely no warranty expressed
   * or implied. Any use is at your own risk.
   *
   * Permission to use or copy this software for any purpose is hereby granted 
   * without fee, provided the above notices are retained on all copies.
   * Permission to modify the code and to distribute modified code is granted,
   * provided the above notices are retained, and a notice that the code was
   * modified is included with the above copyright notice.
   *
   */
  #ifndef __STL_ALLOC_C
  #define __STL_ALLOC_C
  
  // Specialised debug form of malloc which does not provide "false"
  // memory leaks when run with debug CRT libraries.
  #if defined(__STL_MSVC) && __STL_MSVC>=1020 && defined(_DEBUG)
  #  include <crtdbg.h>
+ #if !defined(SUPD) || SUPD <= 562
  #  define   __STL_CHUNK_MALLOC(s)         _malloc_dbg(s, _CRT_BLOCK, __FILE__, __LINE__)
+ #else
+ #  define   __STL_CHUNK_MALLOC(s)         ::malloc(s)
+ #endif
  #else	// !_DEBUG
  # ifdef __STL_NODE_ALLOC_USE_MALLOC
  #  define   __STL_CHUNK_MALLOC(s)         ::malloc(s)
  # else
  #  define   __STL_CHUNK_MALLOC(s)         __stl_new(s)
  # endif
  #endif	// !_DEBUG
  
  __STL_BEGIN_NAMESPACE
  
  template <int __inst>
  void * __malloc_alloc<__inst>::_S_oom_malloc(size_t __n)
  {
    __oom_handler_type __my_malloc_handler;
    void * __result;
  
    for (;;) {
      __my_malloc_handler = __oom_handler;
      if (0 == __my_malloc_handler) { __THROW_BAD_ALLOC; }
      (*__my_malloc_handler)();
      __result = malloc(__n);
      if (__result) return(__result);
    }
  #if defined(__STL_NEED_UNREACHABLE_RETURN)
    return 0;
***************
*** 287,326 ****
  template <bool __threads, int __inst>
  char *__node_alloc<__threads, __inst>::_S_end_free = 0;
  
  template <bool __threads, int __inst>
  size_t __node_alloc<__threads, __inst>::_S_heap_size = 0;
  
  
  # else /* ( __STL_STATIC_TEMPLATE_DATA > 0 ) */
  
  __DECLARE_INSTANCE(__oom_handler_type, __malloc_alloc<0>::__oom_handler, =0);
  
  __DECLARE_INSTANCE(char *, __single_client_alloc::_S_start_free,=0);
  __DECLARE_INSTANCE(char *, __single_client_alloc::_S_end_free,=0);
  __DECLARE_INSTANCE(size_t, __single_client_alloc::_S_heap_size,=0);
  __DECLARE_INSTANCE(_Node_alloc_obj * __STL_VOLATILE,
                     __single_client_alloc::_S_free_list[_NFREELISTS],
                     ={0});
  __DECLARE_INSTANCE(char *, __multithreaded_alloc::_S_start_free,=0);
  __DECLARE_INSTANCE(char *, __multithreaded_alloc::_S_end_free,=0);
  __DECLARE_INSTANCE(size_t, __multithreaded_alloc::_S_heap_size,=0);
  __DECLARE_INSTANCE(_Node_alloc_obj * __STL_VOLATILE,
                     __multithreaded_alloc::_S_free_list[_NFREELISTS],
                     ={0});
  #   ifdef __STL_THREADS
  __DECLARE_INSTANCE(_STL_mutex_base,
!                    __single_client_alloc::_S_node_allocator_lock,
                     __STL_MUTEX_INITIALIZER);
  __DECLARE_INSTANCE(_STL_mutex_base,
!                    __multithreaded_alloc::_S_node_allocator_lock,
                     __STL_MUTEX_INITIALIZER);
  #   endif
  #  endif /* __STL_STATIC_TEMPLATE_DATA */
  
  __STL_END_NAMESPACE
  
  #endif /*  __STL_ALLOC_C */
  
  // Local Variables:
  // mode:C++
  // End:
--- 291,330 ----
  template <bool __threads, int __inst>
  char *__node_alloc<__threads, __inst>::_S_end_free = 0;
  
  template <bool __threads, int __inst>
  size_t __node_alloc<__threads, __inst>::_S_heap_size = 0;
  
  
  # else /* ( __STL_STATIC_TEMPLATE_DATA > 0 ) */
  
  __DECLARE_INSTANCE(__oom_handler_type, __malloc_alloc<0>::__oom_handler, =0);
  
  __DECLARE_INSTANCE(char *, __single_client_alloc::_S_start_free,=0);
  __DECLARE_INSTANCE(char *, __single_client_alloc::_S_end_free,=0);
  __DECLARE_INSTANCE(size_t, __single_client_alloc::_S_heap_size,=0);
  __DECLARE_INSTANCE(_Node_alloc_obj * __STL_VOLATILE,
                     __single_client_alloc::_S_free_list[_NFREELISTS],
                     ={0});
  __DECLARE_INSTANCE(char *, __multithreaded_alloc::_S_start_free,=0);
  __DECLARE_INSTANCE(char *, __multithreaded_alloc::_S_end_free,=0);
  __DECLARE_INSTANCE(size_t, __multithreaded_alloc::_S_heap_size,=0);
  __DECLARE_INSTANCE(_Node_alloc_obj * __STL_VOLATILE,
                     __multithreaded_alloc::_S_free_list[_NFREELISTS],
                     ={0});
  #   ifdef __STL_THREADS
  __DECLARE_INSTANCE(_STL_mutex_base,
!                    (_Node_Alloc_Lock<true, 0>::_S_lock),
                     __STL_MUTEX_INITIALIZER);
  __DECLARE_INSTANCE(_STL_mutex_base,
!                    (_Node_Alloc_Lock<false, 0>::_S_lock),
                     __STL_MUTEX_INITIALIZER);
  #   endif
  #  endif /* __STL_STATIC_TEMPLATE_DATA */
  
  __STL_END_NAMESPACE
  
  #endif /*  __STL_ALLOC_C */
  
  // Local Variables:
  // mode:C++
  // End:
