*** orig/stlport/stl_hashtable.h	Sat Aug 26 17:52:08 2000
--- modified/stlport/stl_hashtable.h	Sat Aug 26 17:59:29 2000
***************
*** 201,266 ****
  value_type(const _Ht_iterator<_Val, _Traits,_Key,_HF,_ExK,_EqK,_All>&)
  {
    return (_Val*) 0;
  }
  
  template <class _Val, class _Traits, class _Key, class _HF, class _ExK, class _EqK, class _All>
  inline forward_iterator_tag
  iterator_category(const _Ht_iterator<_Val, _Traits,_Key,_HF,_ExK,_EqK,_All>&)
  {
    return forward_iterator_tag();
  }
  
  template <class _Val, class _Traits, class _Key, class _HF, class _ExK, class _EqK, 
            class _All>
  inline ptrdiff_t*
  distance_type(const _Ht_iterator<_Val,_Traits,_Key,_HF,_ExK,_EqK,_All>&)
  {
    return (ptrdiff_t*) 0;
  }
  
  #endif /* __STL_CLASS_PARTIAL_SPECIALIZATION */
  
  // Note: assumes long is at least 32 bits.
  # define __stl_num_primes  28
  
! # if ( __STL_STATIC_TEMPLATE_DATA > 0 ) /* && ! defined (__GNUC__) */
! #  define __stl_prime_list _Stl_prime<const unsigned long>::_M_list
!    template <class _Tp>
!    struct _Stl_prime {
!    public:
!        static _Tp _M_list[__stl_num_primes];
!    };
! #  else
! #  if ( __STL_WEAK_ATTRIBUTE > 0 )
!       extern const unsigned long __stl_prime_list[__stl_num_primes] __attribute__((weak));
! #  else
!       // give up
!       static const unsigned long __stl_prime_list[__stl_num_primes];
! #  endif /* __STL_WEAK_ATTRIBUTE */
! #endif /* __STL_STATIC_TEMPLATE_DATA */
! 
  
  // Hashtables handle allocators a bit differently than other containers
  //  do.  If we're using standard-conforming allocators, then a hashtable
  //  unconditionally has a member variable to hold its allocator, even if
  //  it so happens that all instances of the allocator type are identical.
  // This is because, for hashtables, this extra storage is negligible.  
  //  Additionally, a base class wouldn't serve any other purposes; it 
  //  wouldn't, for example, simplify the exception-handling code.
  template <class _Val, class _Key, class _HF,
            class _ExK, class _EqK, class _All>
  # if defined ( __STL_DEBUG )
  class hashtable : public __owned_list {
  # else
  class hashtable {
  # endif
    typedef hashtable<_Val, _Key, _HF, _ExK, _EqK, _All> _Self;
  public:
    typedef _Key key_type;
    typedef _Val value_type;
    typedef _HF hasher;
    typedef _EqK key_equal;
  
    typedef size_t            size_type;
    typedef ptrdiff_t         difference_type;
    typedef value_type*       pointer;
--- 201,256 ----
  value_type(const _Ht_iterator<_Val, _Traits,_Key,_HF,_ExK,_EqK,_All>&)
  {
    return (_Val*) 0;
  }
  
  template <class _Val, class _Traits, class _Key, class _HF, class _ExK, class _EqK, class _All>
  inline forward_iterator_tag
  iterator_category(const _Ht_iterator<_Val, _Traits,_Key,_HF,_ExK,_EqK,_All>&)
  {
    return forward_iterator_tag();
  }
  
  template <class _Val, class _Traits, class _Key, class _HF, class _ExK, class _EqK, 
            class _All>
  inline ptrdiff_t*
  distance_type(const _Ht_iterator<_Val,_Traits,_Key,_HF,_ExK,_EqK,_All>&)
  {
    return (ptrdiff_t*) 0;
  }
  
  #endif /* __STL_CLASS_PARTIAL_SPECIALIZATION */
  
  // Note: assumes long is at least 32 bits.
  # define __stl_num_primes  28
  
! # define __stl_prime_list _Stl_prime<const unsigned long>::_M_list
! template <class _Tp>
! struct _Stl_prime {
! public:
! 	static _Tp _M_list[__stl_num_primes];
! };
  
  // Hashtables handle allocators a bit differently than other containers
  //  do.  If we're using standard-conforming allocators, then a hashtable
  //  unconditionally has a member variable to hold its allocator, even if
  //  it so happens that all instances of the allocator type are identical.
  // This is because, for hashtables, this extra storage is negligible.  
  //  Additionally, a base class wouldn't serve any other purposes; it 
  //  wouldn't, for example, simplify the exception-handling code.
  template <class _Val, class _Key, class _HF,
            class _ExK, class _EqK, class _All>
  # if defined ( __STL_DEBUG )
  class hashtable : public __owned_list {
  # else
  class hashtable {
  # endif
    typedef hashtable<_Val, _Key, _HF, _ExK, _EqK, _All> _Self;
  public:
    typedef _Key key_type;
    typedef _Val value_type;
    typedef _HF hasher;
    typedef _EqK key_equal;
  
    typedef size_t            size_type;
    typedef ptrdiff_t         difference_type;
    typedef value_type*       pointer;
***************
*** 636,674 ****
  template <class _Val, class _Key, class _HF, class _ExK, class _EqK, class _All>
  inline bool operator==(const hashtable<_Val,_Key,_HF,_ExK,_EqK,_All>& __ht1,
                         const hashtable<_Val,_Key,_HF,_ExK,_EqK,_All>& __ht2)
  {
    return hashtable<_Val,_Key,_HF,_ExK,_EqK,_All>::_M_equal( __ht1, __ht2 );
  }
  
  #ifdef __STL_USE_SEPARATE_RELOPS_NAMESPACE
  
  template <class _Val, class _Key, class _HF, class _Ex, class _Eq, class _All>
  inline bool operator!=(const hashtable<_Val,_Key,_HF,_Ex,_Eq,_All>& __ht1,
                         const hashtable<_Val,_Key,_HF,_Ex,_Eq,_All>& __ht2) {
    return !(__ht1 == __ht2);
  }
  
  template <class _Val, class _Key, class _HF, class _ExK, class _EqK, 
            class _All>
  inline void swap(hashtable<_Val, _Key, _HF, _ExK, _EqK, _All>& __ht1,
                   hashtable<_Val, _Key, _HF, _ExK, _EqK, _All>& __ht2) {
    __ht1.swap(__ht2);
  }
  
  #endif /* __STL_USE_SEPARATE_RELOPS_NAMESPACE */
  
  __STL_END_NAMESPACE
- 
- # undef __stl_prime_list
  
  # if !defined (__STL_LINK_TIME_INSTANTIATION)
  #  include <stl_hashtable.c>
  # endif
  
  #endif /* __SGI_STL_INTERNAL_HASHTABLE_H */
  
  // Local Variables:
  // mode:C++
  // End:
  
  
--- 626,662 ----
