*** orig/stlport/stl_iterator.h	Sat Aug 26 17:52:08 2000
--- modified/stlport/stl_iterator.h	Sat Aug 26 17:59:29 2000
***************
*** 273,323 ****
    return !(__x < __y);
  }
  
  #endif /* __STL_USE_SEPARATE_RELOPS_NAMESPACE */
  
  template <class _Iterator>
  inline typename reverse_iterator<_Iterator>::difference_type
  operator-(const reverse_iterator<_Iterator>& __x, 
            const reverse_iterator<_Iterator>& __y) {
    return __y.base() - __x.base();
  }
  
  template <class _Iterator>
  inline reverse_iterator<_Iterator> 
  operator+(typename reverse_iterator<_Iterator>::difference_type __n,
            const reverse_iterator<_Iterator>& __x) {
    return reverse_iterator<_Iterator>(__x.base() - __n);
  }
  
  #else /* __STL_CLASS_PARTIAL_SPECIALIZATION */
  
  // This is the old version of reverse_iterator, as found in the original
  //  HP STL.  It does not use partial specialization.
  
  template <class _RandomAccessIterator, 
! # if defined (__MSL__) && (__MSL__ >= 0x2405)
  	__DFL_TMPL_PARAM(_Tp,iterator_traits<_RandomAccessIterator>::value_type),
  # else
  	class _Tp,
  #endif
   __DFL_TMPL_PARAM(_Reference,_Tp&),
  # if defined (__STL_MSVC50_COMPATIBILITY)
          __DFL_TMPL_PARAM(_Pointer, _Tp*),
  # endif
          __DFL_TYPE_PARAM(_Distance,ptrdiff_t)> 
  class reverse_iterator {
    typedef reverse_iterator<_RandomAccessIterator, _Tp, Reference__, _Distance>
            _Self;
  protected:
    _RandomAccessIterator __current;
  public:
    typedef random_access_iterator_tag iterator_category;
    typedef _Tp                        value_type;
    typedef _Distance                  difference_type;
  # if defined (__STL_MSVC50_COMPATIBILITY)
    typedef _Pointer                   pointer;
  # else
    typedef _Tp*                       pointer;
  # endif
    typedef _Reference                 reference;
  
--- 273,323 ----
    return !(__x < __y);
  }
  
  #endif /* __STL_USE_SEPARATE_RELOPS_NAMESPACE */
  
  template <class _Iterator>
  inline typename reverse_iterator<_Iterator>::difference_type
  operator-(const reverse_iterator<_Iterator>& __x, 
            const reverse_iterator<_Iterator>& __y) {
    return __y.base() - __x.base();
  }
  
  template <class _Iterator>
  inline reverse_iterator<_Iterator> 
  operator+(typename reverse_iterator<_Iterator>::difference_type __n,
            const reverse_iterator<_Iterator>& __x) {
    return reverse_iterator<_Iterator>(__x.base() - __n);
  }
  
  #else /* __STL_CLASS_PARTIAL_SPECIALIZATION */
  
  // This is the old version of reverse_iterator, as found in the original
  //  HP STL.  It does not use partial specialization.
  
  template <class _RandomAccessIterator, 
! # if defined (__MSL__) && __MSL_CPP__ >= 0x2405 && __MSL_CPP__ <= 0x5012
  	__DFL_TMPL_PARAM(_Tp,iterator_traits<_RandomAccessIterator>::value_type),
  # else
  	class _Tp,
  #endif
   __DFL_TMPL_PARAM(_Reference,_Tp&),
  # if defined (__STL_MSVC50_COMPATIBILITY)
          __DFL_TMPL_PARAM(_Pointer, _Tp*),
  # endif
          __DFL_TYPE_PARAM(_Distance,ptrdiff_t)> 
  class reverse_iterator {
    typedef reverse_iterator<_RandomAccessIterator, _Tp, Reference__, _Distance>
            _Self;
  protected:
    _RandomAccessIterator __current;
  public:
    typedef random_access_iterator_tag iterator_category;
    typedef _Tp                        value_type;
    typedef _Distance                  difference_type;
  # if defined (__STL_MSVC50_COMPATIBILITY)
    typedef _Pointer                   pointer;
  # else
    typedef _Tp*                       pointer;
  # endif
    typedef _Reference                 reference;
  
