/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM ../../../../mozilla/intl/uconv/idl/nsICharsetConverterManager2.idl
 */

#ifndef __gen_nsICharsetConverterManager2_h__
#define __gen_nsICharsetConverterManager2_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsISupportsArray_h__
#include "nsISupportsArray.h"
#endif

#ifndef __gen_nsIAtom_h__
#include "nsIAtom.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
#include "nsIUnicodeDecoder.h"
#include "nsIUnicodeEncoder.h"
#include "nsString.h"

/* starting interface:    nsICharsetConverterManager2 */
#define NS_ICHARSETCONVERTERMANAGER2_IID_STR "8bafe891-e4cc-11d3-9d0d-0050040007b2"

#define NS_ICHARSETCONVERTERMANAGER2_IID \
  {0x8bafe891, 0xe4cc, 0x11d3, \
    { 0x9d, 0x0d, 0x00, 0x50, 0x04, 0x00, 0x07, 0xb2 }}

/**
 * Replacement interface for nsICharsetConverterManager.
 *
 * Here Charsets are indentified by nsIAtom's. I know, we could have our own 
 * interface for charsets (something like nsICharacterSet). But for now, I 
 * will attempt to use Atom's. That is because it requires minimal work, all 
 * the support stuff is already there. The drawback is that we might have some
 * performance loss from going to the Atom engine. Another possible problem is
 * people creating directly the Atom instead of going through GetCharsetAtom()
 * If these problems will hurt us, we'll switch to nsICharacterSet. The 
 * implementation of this interface is ment to be quite flexible.
 *
 * I provide here some nonscriptable "friendly methods". They accept nsString 
 * as params and assign the result to them, freeing the received memory result.
 * These methods are prone to optimisation, in order to elliminate any 
 * allocation when it is not strictly necessary.
 *
 * @created         21/Feb/2000
 * @author  Catalin Rotaru [CATA]
 */
class NS_NO_VTABLE nsICharsetConverterManager2 : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ICHARSETCONVERTERMANAGER2_IID)

  /**
   * Get the Unicode decoder for the given charset.
   */
  /* [noscript] nsDecoderPtr GetUnicodeDecoder ([const] in nsIAtom charset); */
  NS_IMETHOD GetUnicodeDecoder(const nsIAtom *charset, nsIUnicodeDecoder * *_retval) = 0;

  /**
   * Get the Unicode encoder for the given charset.
   */
  /* [noscript] nsEncoderPtr GetUnicodeEncoder ([const] in nsIAtom charset); */
  NS_IMETHOD GetUnicodeEncoder(const nsIAtom *charset, nsIUnicodeEncoder * *_retval) = 0;

  /**
   * Get the complete list of available decoders.
   */
  /* nsISupportsArray GetDecoderList (); */
  NS_IMETHOD GetDecoderList(nsISupportsArray **_retval) = 0;

  /**
   * Get the complete list of available encoders.
   */
  /* nsISupportsArray GetEncoderList (); */
  NS_IMETHOD GetEncoderList(nsISupportsArray **_retval) = 0;

  /**
   * Get the complete list of available charset detectors.
   */
  /* nsISupportsArray GetCharsetDetectorList (); */
  NS_IMETHOD GetCharsetDetectorList(nsISupportsArray **_retval) = 0;

  /**
   * Get the Atom representing the a given character set. PLEASE USE THIS 
   * METHOD!!! Do not create Atoms directly by going to NS_NewAtom(), because 
   * here we also do alias resolution...
   *
   * Just to let you know, this method will first attempt to resolve this 
   * charset as an alias. If that failed, the original string will be used.
   * Then an atom is created and returned.
   */
  /* nsIAtom GetCharsetAtom ([const] in wstring charset); */
  NS_IMETHOD GetCharsetAtom(const PRUnichar *charset, nsIAtom **_retval) = 0;

  /**
   * Friendlier version.
   */
  /* nsIAtom GetCharsetAtom2 ([const] in string charset); */
  NS_IMETHOD GetCharsetAtom2(const char *charset, nsIAtom **_retval) = 0;

  /**
   * Get the human-readable name for the given charset.
   */
  /* wstring GetCharsetTitle ([const] in nsIAtom charset); */
  NS_IMETHOD GetCharsetTitle(const nsIAtom *charset, PRUnichar **_retval) = 0;

  /**
   * Friendlier but non scriptable version.
   */
  /* [noscript] void GetCharsetTitle2 ([const] in nsIAtom charset, in nsStringPtr str); */
  NS_IMETHOD GetCharsetTitle2(const nsIAtom *charset, nsString * str) = 0;

  /**
   * Get some data about the given charset.
   */
  /* wstring GetCharsetData ([const] in nsIAtom charset, [const] in wstring prop); */
  NS_IMETHOD GetCharsetData(const nsIAtom *charset, const PRUnichar *prop, PRUnichar **_retval) = 0;

  /**
   * Friendlier but non scriptable version.
   */
  /* [noscript] void GetCharsetData2 ([const] in nsIAtom charset, [const] in wstring prop, in nsStringPtr str); */
  NS_IMETHOD GetCharsetData2(const nsIAtom *charset, const PRUnichar *prop, nsString * str) = 0;

  /**
   * Get the language group for the given charset.
   */
  /* nsIAtom GetCharsetLangGroup ([const] in nsIAtom charset); */
  NS_IMETHOD GetCharsetLangGroup(const nsIAtom *charset, nsIAtom **_retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICHARSETCONVERTERMANAGER2 \
  NS_IMETHOD GetUnicodeDecoder(const nsIAtom *charset, nsIUnicodeDecoder * *_retval); \
  NS_IMETHOD GetUnicodeEncoder(const nsIAtom *charset, nsIUnicodeEncoder * *_retval); \
  NS_IMETHOD GetDecoderList(nsISupportsArray **_retval); \
  NS_IMETHOD GetEncoderList(nsISupportsArray **_retval); \
  NS_IMETHOD GetCharsetDetectorList(nsISupportsArray **_retval); \
  NS_IMETHOD GetCharsetAtom(const PRUnichar *charset, nsIAtom **_retval); \
  NS_IMETHOD GetCharsetAtom2(const char *charset, nsIAtom **_retval); \
  NS_IMETHOD GetCharsetTitle(const nsIAtom *charset, PRUnichar **_retval); \
  NS_IMETHOD GetCharsetTitle2(const nsIAtom *charset, nsString * str); \
  NS_IMETHOD GetCharsetData(const nsIAtom *charset, const PRUnichar *prop, PRUnichar **_retval); \
  NS_IMETHOD GetCharsetData2(const nsIAtom *charset, const PRUnichar *prop, nsString * str); \
  NS_IMETHOD GetCharsetLangGroup(const nsIAtom *charset, nsIAtom **_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICHARSETCONVERTERMANAGER2(_to) \
  NS_IMETHOD GetUnicodeDecoder(const nsIAtom *charset, nsIUnicodeDecoder * *_retval) { return _to GetUnicodeDecoder(charset, _retval); } \
  NS_IMETHOD GetUnicodeEncoder(const nsIAtom *charset, nsIUnicodeEncoder * *_retval) { return _to GetUnicodeEncoder(charset, _retval); } \
  NS_IMETHOD GetDecoderList(nsISupportsArray **_retval) { return _to GetDecoderList(_retval); } \
  NS_IMETHOD GetEncoderList(nsISupportsArray **_retval) { return _to GetEncoderList(_retval); } \
  NS_IMETHOD GetCharsetDetectorList(nsISupportsArray **_retval) { return _to GetCharsetDetectorList(_retval); } \
  NS_IMETHOD GetCharsetAtom(const PRUnichar *charset, nsIAtom **_retval) { return _to GetCharsetAtom(charset, _retval); } \
  NS_IMETHOD GetCharsetAtom2(const char *charset, nsIAtom **_retval) { return _to GetCharsetAtom2(charset, _retval); } \
  NS_IMETHOD GetCharsetTitle(const nsIAtom *charset, PRUnichar **_retval) { return _to GetCharsetTitle(charset, _retval); } \
  NS_IMETHOD GetCharsetTitle2(const nsIAtom *charset, nsString * str) { return _to GetCharsetTitle2(charset, str); } \
  NS_IMETHOD GetCharsetData(const nsIAtom *charset, const PRUnichar *prop, PRUnichar **_retval) { return _to GetCharsetData(charset, prop, _retval); } \
  NS_IMETHOD GetCharsetData2(const nsIAtom *charset, const PRUnichar *prop, nsString * str) { return _to GetCharsetData2(charset, prop, str); } \
  NS_IMETHOD GetCharsetLangGroup(const nsIAtom *charset, nsIAtom **_retval) { return _to GetCharsetLangGroup(charset, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICHARSETCONVERTERMANAGER2(_to) \
  NS_IMETHOD GetUnicodeDecoder(const nsIAtom *charset, nsIUnicodeDecoder * *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUnicodeDecoder(charset, _retval); } \
  NS_IMETHOD GetUnicodeEncoder(const nsIAtom *charset, nsIUnicodeEncoder * *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUnicodeEncoder(charset, _retval); } \
  NS_IMETHOD GetDecoderList(nsISupportsArray **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDecoderList(_retval); } \
  NS_IMETHOD GetEncoderList(nsISupportsArray **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEncoderList(_retval); } \
  NS_IMETHOD GetCharsetDetectorList(nsISupportsArray **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCharsetDetectorList(_retval); } \
  NS_IMETHOD GetCharsetAtom(const PRUnichar *charset, nsIAtom **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCharsetAtom(charset, _retval); } \
  NS_IMETHOD GetCharsetAtom2(const char *charset, nsIAtom **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCharsetAtom2(charset, _retval); } \
  NS_IMETHOD GetCharsetTitle(const nsIAtom *charset, PRUnichar **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCharsetTitle(charset, _retval); } \
  NS_IMETHOD GetCharsetTitle2(const nsIAtom *charset, nsString * str) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCharsetTitle2(charset, str); } \
  NS_IMETHOD GetCharsetData(const nsIAtom *charset, const PRUnichar *prop, PRUnichar **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCharsetData(charset, prop, _retval); } \
  NS_IMETHOD GetCharsetData2(const nsIAtom *charset, const PRUnichar *prop, nsString * str) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCharsetData2(charset, prop, str); } \
  NS_IMETHOD GetCharsetLangGroup(const nsIAtom *charset, nsIAtom **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCharsetLangGroup(charset, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsCharsetConverterManager2 : public nsICharsetConverterManager2
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSICHARSETCONVERTERMANAGER2

  nsCharsetConverterManager2();
  virtual ~nsCharsetConverterManager2();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsCharsetConverterManager2, nsICharsetConverterManager2)

nsCharsetConverterManager2::nsCharsetConverterManager2()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsCharsetConverterManager2::~nsCharsetConverterManager2()
{
  /* destructor code */
}

/* [noscript] nsDecoderPtr GetUnicodeDecoder ([const] in nsIAtom charset); */
NS_IMETHODIMP nsCharsetConverterManager2::GetUnicodeDecoder(const nsIAtom *charset, nsIUnicodeDecoder * *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] nsEncoderPtr GetUnicodeEncoder ([const] in nsIAtom charset); */
NS_IMETHODIMP nsCharsetConverterManager2::GetUnicodeEncoder(const nsIAtom *charset, nsIUnicodeEncoder * *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISupportsArray GetDecoderList (); */
NS_IMETHODIMP nsCharsetConverterManager2::GetDecoderList(nsISupportsArray **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISupportsArray GetEncoderList (); */
NS_IMETHODIMP nsCharsetConverterManager2::GetEncoderList(nsISupportsArray **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISupportsArray GetCharsetDetectorList (); */
NS_IMETHODIMP nsCharsetConverterManager2::GetCharsetDetectorList(nsISupportsArray **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAtom GetCharsetAtom ([const] in wstring charset); */
NS_IMETHODIMP nsCharsetConverterManager2::GetCharsetAtom(const PRUnichar *charset, nsIAtom **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAtom GetCharsetAtom2 ([const] in string charset); */
NS_IMETHODIMP nsCharsetConverterManager2::GetCharsetAtom2(const char *charset, nsIAtom **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring GetCharsetTitle ([const] in nsIAtom charset); */
NS_IMETHODIMP nsCharsetConverterManager2::GetCharsetTitle(const nsIAtom *charset, PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void GetCharsetTitle2 ([const] in nsIAtom charset, in nsStringPtr str); */
NS_IMETHODIMP nsCharsetConverterManager2::GetCharsetTitle2(const nsIAtom *charset, nsString * str)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring GetCharsetData ([const] in nsIAtom charset, [const] in wstring prop); */
NS_IMETHODIMP nsCharsetConverterManager2::GetCharsetData(const nsIAtom *charset, const PRUnichar *prop, PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void GetCharsetData2 ([const] in nsIAtom charset, [const] in wstring prop, in nsStringPtr str); */
NS_IMETHODIMP nsCharsetConverterManager2::GetCharsetData2(const nsIAtom *charset, const PRUnichar *prop, nsString * str)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIAtom GetCharsetLangGroup ([const] in nsIAtom charset); */
NS_IMETHODIMP nsCharsetConverterManager2::GetCharsetLangGroup(const nsIAtom *charset, nsIAtom **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsICharsetConverterManager2_h__ */
