*** orig/dmake/dag.c	Sat Sep  9 18:36:52 2000
--- modified/dmake/dag.c	Sat Sep  9 18:36:52 2000
***************
*** 1,26 ****
! /* RCS  $Id: dag.c,v 1.1.1.1 1997/07/15 16:02:25 dvadura Exp $
  --
  -- SYNOPSIS
  --      Routines to construct the internal dag.
  -- 
  -- DESCRIPTION
  --	This file contains all the routines that are responsible for
  --	defining and manipulating all objects used by the make facility.
  -- 
  -- AUTHOR
  --      Dennis Vadura, dvadura@dmake.wticorp.com
  --
  -- WWW
  --      http://dmake.wticorp.com/
  --
  -- COPYRIGHT
  --      Copyright (c) 1996,1997 by WTI Corp.  All rights reserved.
  -- 
  --      This program is NOT free software; you can redistribute it and/or
  --      modify it under the terms of the Software License Agreement Provided
  --      in the file <distribution-root>/readme/license.txt.
  --
  -- LOG
  --      Use cvs log to obtain detailed change logs.
  */
  
--- 1,26 ----
! /* RCS  $Id: dag.c,v 1.2 1998/09/04 14:12:46 hjs Exp $
  --
  -- SYNOPSIS
  --      Routines to construct the internal dag.
  -- 
  -- DESCRIPTION
  --	This file contains all the routines that are responsible for
  --	defining and manipulating all objects used by the make facility.
  -- 
  -- AUTHOR
  --      Dennis Vadura, dvadura@dmake.wticorp.com
  --
  -- WWW
  --      http://dmake.wticorp.com/
  --
  -- COPYRIGHT
  --      Copyright (c) 1996,1997 by WTI Corp.  All rights reserved.
  -- 
  --      This program is NOT free software; you can redistribute it and/or
  --      modify it under the terms of the Software License Agreement Provided
  --      in the file <distribution-root>/readme/license.txt.
  --
  -- LOG
  --      Use cvs log to obtain detailed change logs.
  */
  
***************
*** 239,289 ****
     register HASHPTR   hp;
     register char      *p, *q;
  
     DB_ENTER( "Def_macro" );
     DB_PRINT( "mac", ("Defining macro %s = %s, %x", name, value, flags) );
  
     /* check to see if name is in the table, if so then just overwrite
        the previous definition.  Otherwise allocate a new node, and
        stuff it in the hash table, at the front of any linked list */
  
     if( Readenv ) flags |= M_LITERAL|M_EXPANDED;
  
     hp = Get_name( name, Macs, TRUE );
  
     if ((flags & M_PUSH) && hp->ht_name != NIL(char)) {
        HASHPTR thp=hp;
        TALLOC(hp,1,HASH);
        hp->ht_name  = DmStrDup(thp->ht_name);
        hp->ht_hash  = thp->ht_hash;
        Push_macro(hp);
        flags |= hp->ht_flag;
     }
     flags &= ~M_PUSH;
  
     if( (hp->ht_flag & M_PRECIOUS) && !(flags & M_FORCE) ) {
!       Warning( "Macro `%s' cannot be redefined", name );
        DB_RETURN( hp );
     }
  
     /* Make sure we don't export macros whose names contain legal macro
      * assignment operators, since we can't do proper quoting in the
      * environment. */
     if( *DmStrPbrk(name, "*+:=") != '\0' ) flags |= M_NOEXPORT;
  
     if( hp->ht_value != NIL(char) ) FREE( hp->ht_value );
  
     if( (hp->ht_flag & M_USED) && !((flags | hp->ht_flag) & M_MULTI) )
        Warning( "Macro `%s' redefined after use", name );
  
     if( (value != NIL(char)) && (*value) ) {
        /* strip out any \<nl> combinations where \ is the current CONTINUATION
         * char */
  
        for( p = value; (p = strchr(p, CONTINUATION_CHAR)) != NIL(char); )
           if( p[1] == '\n' )
  	    strcpy( p, p+2 );
  	 else
  	    p++;
  
        if( !(flags & M_LITERAL) ) {
  	 p = DmStrDup( DmStrSpn(value," \t")); /* strip white space before */
--- 239,290 ----
     register HASHPTR   hp;
     register char      *p, *q;
  
     DB_ENTER( "Def_macro" );
     DB_PRINT( "mac", ("Defining macro %s = %s, %x", name, value, flags) );
  
     /* check to see if name is in the table, if so then just overwrite
        the previous definition.  Otherwise allocate a new node, and
        stuff it in the hash table, at the front of any linked list */
  
     if( Readenv ) flags |= M_LITERAL|M_EXPANDED;
  
     hp = Get_name( name, Macs, TRUE );
  
     if ((flags & M_PUSH) && hp->ht_name != NIL(char)) {
        HASHPTR thp=hp;
        TALLOC(hp,1,HASH);
        hp->ht_name  = DmStrDup(thp->ht_name);
        hp->ht_hash  = thp->ht_hash;
        Push_macro(hp);
        flags |= hp->ht_flag;
     }
     flags &= ~M_PUSH;
  
     if( (hp->ht_flag & M_PRECIOUS) && !(flags & M_FORCE) ) {
!       if  (Verbose & V_WARNALL)
! 	     Warning( "Macro `%s' cannot be redefined", name );
        DB_RETURN( hp );
     }
  
     /* Make sure we don't export macros whose names contain legal macro
      * assignment operators, since we can't do proper quoting in the
      * environment. */
     if( *DmStrPbrk(name, "*+:=") != '\0' ) flags |= M_NOEXPORT;
  
     if( hp->ht_value != NIL(char) ) FREE( hp->ht_value );
  
     if( (hp->ht_flag & M_USED) && !((flags | hp->ht_flag) & M_MULTI) )
        Warning( "Macro `%s' redefined after use", name );
  
     if( (value != NIL(char)) && (*value) ) {
        /* strip out any \<nl> combinations where \ is the current CONTINUATION
         * char */
  
        for( p = value; (p = strchr(p, CONTINUATION_CHAR)) != NIL(char); )
           if( p[1] == '\n' )
  	    strcpy( p, p+2 );
  	 else
  	    p++;
  
        if( !(flags & M_LITERAL) ) {
  	 p = DmStrDup( DmStrSpn(value," \t")); /* strip white space before */
