*** orig/dmake/dbug/malloc/free.c	Sat Sep  9 18:36:36 2000
--- modified/dmake/dbug/malloc/free.c	Sat Sep  9 18:36:36 2000
***************
*** 9,59 ****
  
  /*
   * Function:	free()
   *
   * Purpose:	to deallocate malloced data
   *
   * Arguments:	ptr	- pointer to data area to deallocate
   *
   * Returns:	nothing of any value
   *
   * Narrative:
   *		verify pointer is within malloc region
   *		get mlist pointer from passed address
   *		verify magic number
   *		verify inuse flag
   *		verify pointer connections with surrounding segments
   *		turn off inuse flag
   *		verify no data overrun into non-malloced area at end of segment
   *		IF possible join segment with next segment
   *		IF possible join segment with previous segment
   *		Clear all data in segment (to make sure it isn't reused)
   *
   */
  #ifndef lint
  static
! char rcs_hdr[] = "$Id: free.c,v 1.1.1.1 1997/07/15 16:02:26 dvadura Exp $";
  #endif
  
  void
  free(cptr)
  	char	* cptr;
  {
  	char			* func = "free";
  	int			  i;
  	extern int		  malloc_checking;
  	extern struct mlist	* malloc_end;
  	extern int		  malloc_errno;
  	extern char		* malloc_data_end;
  	extern char		* malloc_data_start;
  	void			  malloc_join();
  	void			  malloc_memset();
  	struct mlist		* oldptr;
  	struct mlist		* ptr;
  
  	/*
  	 * IF malloc chain checking is on, go do it.
  	 */
  	if( malloc_checking )
  	{
  		(void) malloc_chain_check(1);
  	}
--- 9,59 ----
  
  /*
   * Function:	free()
   *
   * Purpose:	to deallocate malloced data
   *
   * Arguments:	ptr	- pointer to data area to deallocate
   *
   * Returns:	nothing of any value
   *
   * Narrative:
   *		verify pointer is within malloc region
   *		get mlist pointer from passed address
   *		verify magic number
   *		verify inuse flag
   *		verify pointer connections with surrounding segments
   *		turn off inuse flag
   *		verify no data overrun into non-malloced area at end of segment
   *		IF possible join segment with next segment
   *		IF possible join segment with previous segment
   *		Clear all data in segment (to make sure it isn't reused)
   *
   */
  #ifndef lint
  static
! char rcs_hdr[] = "$Id: free.c,v 1.1.1.1 1997/09/22 14:51:11 hjs Exp $";
  #endif
  
  void
  free(cptr)
  	char	* cptr;
  {
  	char			* func = "free";
  	int			  i;
  	extern int		  malloc_checking;
  	extern struct mlist	* malloc_end;
  	extern int		  malloc_errno;
  	extern char		* malloc_data_end;
  	extern char		* malloc_data_start;
  	void			  malloc_join();
  	void			  malloc_memset();
  	struct mlist		* oldptr;
  	struct mlist		* ptr;
  
  	/*
  	 * IF malloc chain checking is on, go do it.
  	 */
  	if( malloc_checking )
  	{
  		(void) malloc_chain_check(1);
  	}
***************
*** 128,177 ****
--- 128,180 ----
  	 * we will save a pointer to the previous block and test to verify
  	 * if it is joined (it's next ptr will no longer point to ptr).
   	 */
  	malloc_join(ptr,ptr->next,0,0);
  	
  	oldptr = ptr->prev;
  
  	malloc_join(ptr->prev, ptr,0,0);
  
  	if( oldptr->next != ptr )
  	{
  		DEBUG0(10,"Oldptr was changed");
  		ptr = oldptr;
  	}
  	
  	/*
  	 * fill this block with '\02's to ensure that nobody is using a 
  	 * pointer to already freed data...
  	 */
  	malloc_memset(ptr->data,M_FREE_FILL,(int)ptr->s.size);
  
  }
  
  /*
   * $Log: free.c,v $
+  * Revision 1.1.1.1  1997/09/22 14:51:11  hjs
+  * dmake 4.1 orginal sourcen
+  *
   * Revision 1.1.1.1  1997/07/15 16:02:26  dvadura
   * dmake gold 4.1.00 initial import
   *
   * Revision 1.1.1.1  1996/10/27 07:30:14  dvadura
   * Dmake 4.1 Initial Import
   *
   * Revision 1.1.1.1  1996/10/24 05:33:14  dvadura
   * Initial import for final release of dmake 4.1
   *
   * Revision 1.1  1994/10/06  17:43:10  dvadura
   * dmake Release Version 4.0, Initial revision
   *
   * Revision 1.1  1994/10/06  03:45:19  dvadura
   * dmake Release Version 4.0, Initial revision
   *
   * Revision 1.1  1992/01/24  03:29:02  dvadura
   * dmake Version 3.8, Initial revision
   *
   * Revision 1.9  90/08/29  21:22:48  cpcahil
   * miscellaneous lint fixes
   * 
   * Revision 1.8  90/05/11  00:13:08  cpcahil
   * added copyright statment
   * 
   * Revision 1.7  90/02/25  11:00:18  cpcahil
