*** orig/dmake/expand.c	Sat Sep  9 18:36:52 2000
--- modified/dmake/expand.c	Sat Sep  9 18:36:52 2000
***************
*** 1,26 ****
! /* RCS  $Id: expand.c,v 1.1.1.1 1997/07/15 16:02:25 dvadura Exp $
  --
  -- SYNOPSIS
  --      Macro expansion code.
  -- 
  -- DESCRIPTION
  --
  --	This routine handles all the necessary junk that deals with macro
  --	expansion.  It understands the following syntax.  If a macro is
  --	not defined it expands to NULL, and {} are synonyms for ().
  --
  --		$$      - expands to $
  --		{{      - expands to {
  --	        }}      - expands to }
  --		$A      - expands to whatever the macro A is defined as
  --		$(AA)   - expands to whatever the macro AA is defined as
  --		$($(A)) - represents macro indirection
  --		<+...+> - get mapped to $(mktmp ...)
  --	
  --        following macro is recognized
  --        
  --                string1{ token_list }string2
  --                
  --        and expands to string1 prepended to each element of token_list and
  --        string2 appended to each of the resulting tokens from the first
  --        operation.  If string2 is of the form above then the result is
--- 1,26 ----
! /* RCS  $Id: expand.c,v 1.2 1997/10/27 07:35:03 dv Exp $
  --
  -- SYNOPSIS
  --      Macro expansion code.
  -- 
  -- DESCRIPTION
  --
  --	This routine handles all the necessary junk that deals with macro
  --	expansion.  It understands the following syntax.  If a macro is
  --	not defined it expands to NULL, and {} are synonyms for ().
  --
  --		$$      - expands to $
  --		{{      - expands to {
  --	        }}      - expands to }
  --		$A      - expands to whatever the macro A is defined as
  --		$(AA)   - expands to whatever the macro AA is defined as
  --		$($(A)) - represents macro indirection
  --		<+...+> - get mapped to $(mktmp ...)
  --	
  --        following macro is recognized
  --        
  --                string1{ token_list }string2
  --                
  --        and expands to string1 prepended to each element of token_list and
  --        string2 appended to each of the resulting tokens from the first
  --        operation.  If string2 is of the form above then the result is
***************
*** 93,143 ****
--- 93,148 ----
  PUBLIC char *
  Expand( src )/*
  ===============
        This is the driver routine for the expansion, it identifies non-white
        space tokens and gets the ScanToken routine to figure out if they should
        be treated in a special way. */
  
  char *src;                    /* pointer to source string  */
  {
     char  *tmp;		      /* pointer to temporary str  */
     char  *res;                /* pointer to result string  */
     char  *start;              /* pointer to start of token */
     
     DB_ENTER( "Expand" );
     DB_PRINT( "exp", ("Expanding [%s]", src) );
  
     res = DmStrDup( "" );
     if( src == NIL(char) ) DB_RETURN( res );
  
     while( *src ) {
        char *ks, *ke;
  
        /* Here we find the next non white space token in the string
         * and find it's end, with respect to non-significant white space. */
        
+ #ifndef _MPW
        start = DmStrSpn( src, " \t\n" );
+ #else
+       start = DmStrSpn( src, " \t\r\n" );
+ #endif
+ 
        res   = DmStrJoin( res, src, start-src, TRUE );
        if( !(*start) ) break;
  
        /* START <+...+> KLUDGE */
        if(   (ks=DmStrStr(start,"<+")) != NIL(char)
           && (ke=DmStrStr(ks,"+>")) != NIL(char) ){
  	 char *t1, *t2;
  
  	 res = DmStrJoin( res, t2=Expand(t1=DmSubStr(start,ks)), -1, TRUE);
  	 FREE(t1); FREE(t2);
  
  	 t1 = DmSubStr(ks+2, ke+1); t1[ke-ks-2] = ')';
  	 t2 = DmStrJoin( "$(mktmp ", t1, -1,FALSE);
  	 FREE(t1);
  	 res = DmStrJoin( res, t2=Expand(t2), -1, TRUE);
  	 FREE(t2);
  	 src = ke+2;
        }
        /* END <+...+> KLUDGE */
        else {
  	 res   = DmStrJoin( res, tmp = ScanToken(start,&src,TRUE), -1, TRUE );
  	 FREE( tmp );
        }
     }
     
