*** orig/dmake/make.c	Sat Sep  9 18:36:53 2000
--- modified/dmake/make.c	Sat Sep  9 18:36:53 2000
***************
*** 1,63 ****
! /* RCS  $Id: make.c,v 1.1.1.1 1997/07/15 16:02:25 dvadura Exp $
  --
  -- SYNOPSIS
  --      Perform the update of all outdated targets.
  -- 
  -- DESCRIPTION
  --	This is where we traverse the make graph looking for targets that
  --	are out of date, and we try to infer how to make them if we can.
  --	The usual make macros are understood, as well as some new ones:
  --
  --		$$	- expands to $
  --		$@      - full target name
  --		$*      - target name with no suffix, same as $(@:db)
  --			  or, the value of % in % meta rule recipes
  --		$?      - list of out of date prerequisites
  --		$<      - all prerequisites associated with rules line
  --		$&	- all prerequisites associated with target
  --		$>      - library name for target (if any)
  --		$^	- out of date prerequisites taken from value of $<
  -- 
  -- AUTHOR
  --      Dennis Vadura, dvadura@dmake.wticorp.com
  --
  -- WWW
  --      http://dmake.wticorp.com/
  --
  -- COPYRIGHT
  --      Copyright (c) 1996,1997 by WTI Corp.  All rights reserved.
  -- 
  --      This program is NOT free software; you can redistribute it and/or
  --      modify it under the terms of the Software License Agreement Provided
  --      in the file <distribution-root>/readme/license.txt.
  --
  -- LOG
  --      Use cvs log to obtain detailed change logs.
  */
  
  #include "extern.h"
  
  typedef struct cell {
     char            *datum;
     struct  cell    *next;
     size_t           len;
  } LISTCELL, *LISTCELLPTR;
  
  typedef struct {
     LISTCELLPTR  first;
     LISTCELLPTR  last;
     size_t       len;
  } LISTSTRING, *LISTSTRINGPTR;
  
  
  static	void	_drop_mac ANSI((HASHPTR));
  static	void	_set_recipe ANSI((char*, int));
  static	void	_set_tmd ANSI(());
  static	void	_append_file ANSI((STRINGPTR, FILE*, char*, int));
  static  LINKPTR _dup_prq ANSI((LINKPTR));
  static  LINKPTR _expand_dynamic_prq ANSI(( LINKPTR, LINKPTR, char * ));
  static  char*   _prefix ANSI((char *, char *));
  static  char*   _pool_lookup ANSI((char *));
  
  #define RP_GPPROLOG       0
  #define RP_RECIPE         1
--- 1,64 ----
! /* RCS  $Id: make.c,v 1.5 2000/02/15 12:32:22 mh Exp $
  --
  -- SYNOPSIS
  --      Perform the update of all outdated targets.
  -- 
  -- DESCRIPTION
  --	This is where we traverse the make graph looking for targets that
  --	are out of date, and we try to infer how to make them if we can.
  --	The usual make macros are understood, as well as some new ones:
  --
  --		$$	- expands to $
  --		$@      - full target name
  --		$*      - target name with no suffix, same as $(@:db)
  --			  or, the value of % in % meta rule recipes
  --		$?      - list of out of date prerequisites
  --		$<      - all prerequisites associated with rules line
  --		$&	- all prerequisites associated with target
  --		$>      - library name for target (if any)
  --		$^	- out of date prerequisites taken from value of $<
  -- 
  -- AUTHOR
  --      Dennis Vadura, dvadura@dmake.wticorp.com
  --
  -- WWW
  --      http://dmake.wticorp.com/
  --
  -- COPYRIGHT
  --      Copyright (c) 1996,1997 by WTI Corp.  All rights reserved.
  -- 
  --      This program is NOT free software; you can redistribute it and/or
  --      modify it under the terms of the Software License Agreement Provided
  --      in the file <distribution-root>/readme/license.txt.
  --
  -- LOG
  --      Use cvs log to obtain detailed change logs.
  */
  
  #include "extern.h"
+ #include "sysintf.h"
  
  typedef struct cell {
     char            *datum;
     struct  cell    *next;
     size_t           len;
  } LISTCELL, *LISTCELLPTR;
  
  typedef struct {
     LISTCELLPTR  first;
     LISTCELLPTR  last;
     size_t       len;
  } LISTSTRING, *LISTSTRINGPTR;
  
  
  static	void	_drop_mac ANSI((HASHPTR));
  static	void	_set_recipe ANSI((char*, int));
  static	void	_set_tmd ANSI(());
  static	void	_append_file ANSI((STRINGPTR, FILE*, char*, int));
  static  LINKPTR _dup_prq ANSI((LINKPTR));
  static  LINKPTR _expand_dynamic_prq ANSI(( LINKPTR, LINKPTR, char * ));
  static  char*   _prefix ANSI((char *, char *));
  static  char*   _pool_lookup ANSI((char *));
  
  #define RP_GPPROLOG       0
  #define RP_RECIPE         1
***************
*** 1059,1143 ****
        /* We force execution of the recipe if we are tracing and the .EXECUTE
         * attribute was given or if the it is not a group recipe and the
         * recipe line contains the string $(MAKE). */
        if( Trace
         && ((l_attr & A_EXECUTE)||(!group && DmStrStr(rp->st_string,"$(MAKE)")))
        ) {
  	 Wait_for_completion |= Trace;
  	 do_it = TRUE;
        }
  
        if( group )
           Append_line( cmnd, TRUE, tmpfile, cp->CE_NAME, trace, 0 );
        else {
  	 if( *DmStrSpn(cmnd, " \t") != '\0' )
  	    Print_cmnd(cmnd, !(do_it && (l_attr & A_SILENT)), 0);
  	 else
  	    do_it = FALSE;
  
  	 rval=Do_cmnd(cmnd,FALSE,do_it,cp,(l_attr&A_IGNORE)!=0, shell,
  		      rp->st_next == NIL(STRING) );
        }
     }
  
     /* If it is a group then output the EPILOG if required and possibly
      * execute the command */
!    if( group && !(cp->ce_attr & A_ERROR) ) {
        if( attr & A_EPILOG )	/* emit epilog */
  	 _append_file( _recipes[RP_GPEPILOG], tmpfile, cp->CE_NAME, trace );
  
        if( trace ) fputs("]\n", stdout);
  
        do_it = !Trace;
!       if( do_it ) Close_temp( cp, tmpfile );
        rval = Do_cmnd(groupfile, TRUE, do_it, cp, (attr & A_IGNORE)!=0,
  		     TRUE, TRUE);
     }
  
     Wait_for_completion = FALSE;
     _recipes[ RP_RECIPE ] = orp;
     cp->ce_attr &= ~A_ERROR;
     DB_RETURN( rval );
  }
  
  
  PUBLIC void
  Print_cmnd( cmnd, echo, map )/*
  ================================
     This routine is called to print out the command to stdout.  If echo is
     false the printing to stdout is supressed, but the new lines in the command
     are still deleted. */
  char *cmnd;
  int  echo;
  int  map;
  {
     register char *p;
     register char *n;
     char tmp[3];
  
     DB_ENTER( "Print_cmnd" );
! 
     if( echo ) {
        printf( "%s\n", cmnd  );
        fflush(stdout);
     }
  
     tmp[0] = ESCAPE_CHAR;
     tmp[1] = CONTINUATION_CHAR;
     tmp[2] = '\0';
  
     for( p=cmnd; *(n = DmStrPbrk(p,tmp)) != '\0'; )
        if(*n == CONTINUATION_CHAR && n[1] == '\n') {
  	 DB_PRINT( "make", ("fixing [%s]", p) );
  	 strcpy( n, n+2 );
  	 p = n;
        }
        else {
           if( *n == ESCAPE_CHAR && map ) Map_esc( n );
  	 p = n+1;
        }
  
     DB_VOID_RETURN;
  }
  
  
  
--- 1060,1151 ----
        /* We force execution of the recipe if we are tracing and the .EXECUTE
         * attribute was given or if the it is not a group recipe and the
         * recipe line contains the string $(MAKE). */
        if( Trace
         && ((l_attr & A_EXECUTE)||(!group && DmStrStr(rp->st_string,"$(MAKE)")))
        ) {
  	 Wait_for_completion |= Trace;
  	 do_it = TRUE;
        }
  
        if( group )
           Append_line( cmnd, TRUE, tmpfile, cp->CE_NAME, trace, 0 );
        else {
  	 if( *DmStrSpn(cmnd, " \t") != '\0' )
  	    Print_cmnd(cmnd, !(do_it && (l_attr & A_SILENT)), 0);
  	 else
  	    do_it = FALSE;
  
  	 rval=Do_cmnd(cmnd,FALSE,do_it,cp,(l_attr&A_IGNORE)!=0, shell,
  		      rp->st_next == NIL(STRING) );
        }
     }
  
     /* If it is a group then output the EPILOG if required and possibly
      * execute the command */
!    if( group && !(cp->ce_attr & A_ERROR) ) { 
        if( attr & A_EPILOG )	/* emit epilog */
  	 _append_file( _recipes[RP_GPEPILOG], tmpfile, cp->CE_NAME, trace );
  
        if( trace ) fputs("]\n", stdout);
  
        do_it = !Trace;
!       if( do_it )
! 	{
! 		Close_temp( cp, tmpfile );
! #if defined(UNIX)
! 
!  		chmod(groupfile,0700);
! #endif
! 	} 			
        rval = Do_cmnd(groupfile, TRUE, do_it, cp, (attr & A_IGNORE)!=0,
  		     TRUE, TRUE);
     }
  
     Wait_for_completion = FALSE;
     _recipes[ RP_RECIPE ] = orp;
     cp->ce_attr &= ~A_ERROR;
     DB_RETURN( rval );
  }
  
  
  PUBLIC void
  Print_cmnd( cmnd, echo, map )/*
  ================================
     This routine is called to print out the command to stdout.  If echo is
     false the printing to stdout is supressed, but the new lines in the command
     are still deleted. */
  char *cmnd;
  int  echo;
  int  map;
  {
     register char *p;
     register char *n;
     char tmp[3];
  
     DB_ENTER( "Print_cmnd" );
!    
     if( echo ) {
        printf( "%s\n", cmnd  );
        fflush(stdout);
     }
  
     tmp[0] = ESCAPE_CHAR;
     tmp[1] = CONTINUATION_CHAR;
     tmp[2] = '\0';
  
     for( p=cmnd; *(n = DmStrPbrk(p,tmp)) != '\0'; )
        if(*n == CONTINUATION_CHAR && n[1] == '\n') {
  	 DB_PRINT( "make", ("fixing [%s]", p) );
  	 strcpy( n, n+2 );
  	 p = n;
        }
        else {
           if( *n == ESCAPE_CHAR && map ) Map_esc( n );
  	 p = n+1;
        }
  
     DB_VOID_RETURN;
  }
  
  
  
