*** orig/dmake/unix/runargv.c	Sat Sep  9 18:36:50 2000
--- modified/dmake/unix/runargv.c	Sat Sep  9 18:36:50 2000
***************
*** 1,26 ****
! /* RCS  $Id: runargv.c,v 1.1.1.1 1997/07/15 16:02:34 dvadura Exp $
  --
  -- SYNOPSIS
  --      Invoke a sub process.
  -- 
  -- DESCRIPTION
  -- 	Use the standard methods of executing a sub process.
  --
  -- AUTHOR
  --      Dennis Vadura, dvadura@dmake.wticorp.com
  --
  -- WWW
  --      http://dmake.wticorp.com/
  --
  -- COPYRIGHT
  --      Copyright (c) 1996,1997 by WTI Corp.  All rights reserved.
  -- 
  --      This program is NOT free software; you can redistribute it and/or
  --      modify it under the terms of the Software License Agreement Provided
  --      in the file <distribution-root>/readme/license.txt.
  --
  -- LOG
  --      Use cvs log to obtain detailed change logs.
  */
  
  #include <signal.h>
--- 1,26 ----
! /* RCS  $Id: runargv.c,v 1.4 2000/07/24 16:09:09 ross.nicholson Exp $
  --
  -- SYNOPSIS
  --      Invoke a sub process.
  -- 
  -- DESCRIPTION
  -- 	Use the standard methods of executing a sub process.
  --
  -- AUTHOR
  --      Dennis Vadura, dvadura@dmake.wticorp.com
  --
  -- WWW
  --      http://dmake.wticorp.com/
  --
  -- COPYRIGHT
  --      Copyright (c) 1996,1997 by WTI Corp.  All rights reserved.
  -- 
  --      This program is NOT free software; you can redistribute it and/or
  --      modify it under the terms of the Software License Agreement Provided
  --      in the file <distribution-root>/readme/license.txt.
  --
  -- LOG
  --      Use cvs log to obtain detailed change logs.
  */
  
  #include <signal.h>
***************
*** 46,96 ****
--- 46,106 ----
     RCPPTR  	pr_recipe_end;
     char        *pr_dir;
  } PR;
  
  static PR  *_procs    = NIL(PR);
  static int  _proc_cnt = 0;
  static int  _abort_flg= FALSE;
  static int  _use_i    = -1;
  static int  _do_upd   = 0;
  
  static  void	_add_child ANSI((int, CELLPTR, int, int));
  static  void	_attach_cmd ANSI((char *, int, int, CELLPTR, int, int));
  static  void    _finished_child ANSI((int, int));
  static  int     _running ANSI((CELLPTR));
  
  PUBLIC int
  runargv(target, ignore, group, last, shell, cmd)
  CELLPTR target;
  int     ignore;
  int	group;
  int	last;
  int     shell;
  char	*cmd;
  {
     extern  int  errno;
+ #ifndef __APPLE__
+ #ifdef arm32
+    extern  const char * const sys_errlist[];
+ #else
+ #ifdef linux
+    extern  const char * const sys_errlist[];
+ #else
     extern  char *sys_errlist[];
+ #endif
+ #endif
+ #endif
     int          pid;
     char         **argv;
  
     if( _running(target) /*&& Max_proc != 1*/ ) {
        /* The command will be executed when the previous recipe
         * line completes. */
        _attach_cmd( cmd, group, ignore, target, last, shell );
        return(1);
     }
  
     while( _proc_cnt == Max_proc )
        if( Wait_for_child(FALSE, -1) == -1 )  Fatal( "Lost a child %d", errno );
  
     argv = Pack_argv( group, shell, cmd );
  
     switch( pid=fork() ){
        int   wid;
        int   status;
  
     case -1: /* fork failed */
        Error("%s: %s", argv[0], sys_errlist[errno]);
        Handle_result(-1, ignore, _abort_flg, target);
        return(-1);
  
     case 0:  /* child */
