/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM ../../../../mozilla/netwerk/base/public/nsIFileStreams.idl
 */

#ifndef __gen_nsIFileStreams_h__
#define __gen_nsIFileStreams_h__


#ifndef __gen_nsIInputStream_h__
#include "nsIInputStream.h"
#endif

#ifndef __gen_nsIOutputStream_h__
#include "nsIOutputStream.h"
#endif

#ifndef __gen_nsISeekableStream_h__
#include "nsISeekableStream.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIFile; /* forward declaration */


/* starting interface:    nsIFileInputStream */
#define NS_IFILEINPUTSTREAM_IID_STR "e3d56a20-c7ec-11d3-8cda-0060b0fc14a3"

#define NS_IFILEINPUTSTREAM_IID \
  {0xe3d56a20, 0xc7ec, 0x11d3, \
    { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 }}

/**
 * An input stream that allows you to read from a file.
 */
class NS_NO_VTABLE nsIFileInputStream : public nsIInputStream {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IFILEINPUTSTREAM_IID)

  /**
     * @param file          file to read from (must QI to nsILocalFile)
     * @param ioFlags       file open flags listed in prio.h
     * @param perm          file mode bits listed in prio.h
     * @param behaviorFlags flags specifying various behaviors of the class
     *        (see enumerations in the class)
     */
  /* void init (in nsIFile file, in long ioFlags, in long perm, in long behaviorFlags); */
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm, PRInt32 behaviorFlags) = 0;

  /**
     * If this is set, the file will be deleted by the time the stream is
     * closed.  It may be removed before the stream is closed if it is possible
     * to delete it and still read from it.
     *
     * If OPEN_ON_READ is defined, and the file was recreated after the first
     * delete, the file will be deleted again when it is closed again.
     */
  enum { DELETE_ON_CLOSE = 2 };

  /**
     * If this is set, the file will close automatically when the end of the
     * file is reached.
     */
  enum { CLOSE_ON_EOF = 4 };

  /**
     * If this is set, the file will be reopened whenever Seek(0) occurs.  If
     * the file is already open and the seek occurs, it will happen naturally.
     * (The file will only be reopened if it is closed for some reason.)
     */
  enum { REOPEN_ON_REWIND = 8 };

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIFILEINPUTSTREAM \
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm, PRInt32 behaviorFlags); \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIFILEINPUTSTREAM(_to) \
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm, PRInt32 behaviorFlags) { return _to Init(file, ioFlags, perm, behaviorFlags); } \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIFILEINPUTSTREAM(_to) \
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm, PRInt32 behaviorFlags) { return !_to ? NS_ERROR_NULL_POINTER : _to->Init(file, ioFlags, perm, behaviorFlags); } \

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsFileInputStream : public nsIFileInputStream
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIFILEINPUTSTREAM

  nsFileInputStream();
  virtual ~nsFileInputStream();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsFileInputStream, nsIFileInputStream)

nsFileInputStream::nsFileInputStream()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsFileInputStream::~nsFileInputStream()
{
  /* destructor code */
}

/* void init (in nsIFile file, in long ioFlags, in long perm, in long behaviorFlags); */
NS_IMETHODIMP nsFileInputStream::Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm, PRInt32 behaviorFlags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIFileOutputStream */
#define NS_IFILEOUTPUTSTREAM_IID_STR "e6f68040-c7ec-11d3-8cda-0060b0fc14a3"

#define NS_IFILEOUTPUTSTREAM_IID \
  {0xe6f68040, 0xc7ec, 0x11d3, \
    { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 }}

/**
 * An output stream that lets you stream to a file.
 */
class NS_NO_VTABLE nsIFileOutputStream : public nsIOutputStream {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IFILEOUTPUTSTREAM_IID)

  /**
     * @param file          - file to write to (must QI to nsILocalFile)
     * @param ioFlags       - file open flags listed in prio.h
     * @param perm          - file mode bits listed in prio.h
     * @param behaviorFlags flags specifying various behaviors of the class
     *        (currently none supported)
     */
  /* void init (in nsIFile file, in long ioFlags, in long perm, in long behaviorFlags); */
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm, PRInt32 behaviorFlags) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIFILEOUTPUTSTREAM \
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm, PRInt32 behaviorFlags); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIFILEOUTPUTSTREAM(_to) \
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm, PRInt32 behaviorFlags) { return _to Init(file, ioFlags, perm, behaviorFlags); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIFILEOUTPUTSTREAM(_to) \
  NS_IMETHOD Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm, PRInt32 behaviorFlags) { return !_to ? NS_ERROR_NULL_POINTER : _to->Init(file, ioFlags, perm, behaviorFlags); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsFileOutputStream : public nsIFileOutputStream
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIFILEOUTPUTSTREAM

  nsFileOutputStream();
  virtual ~nsFileOutputStream();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsFileOutputStream, nsIFileOutputStream)

nsFileOutputStream::nsFileOutputStream()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsFileOutputStream::~nsFileOutputStream()
{
  /* destructor code */
}

/* void init (in nsIFile file, in long ioFlags, in long perm, in long behaviorFlags); */
NS_IMETHODIMP nsFileOutputStream::Init(nsIFile *file, PRInt32 ioFlags, PRInt32 perm, PRInt32 behaviorFlags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIBufferedInputStream */
#define NS_IBUFFEREDINPUTSTREAM_IID_STR "616f5b48-da09-11d3-8cda-0060b0fc14a3"

#define NS_IBUFFEREDINPUTSTREAM_IID \
  {0x616f5b48, 0xda09, 0x11d3, \
    { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 }}

/**
 * An input stream that reads ahead and keeps a buffer coming from another input
 * stream so that fewer accesses to the underlying stream are necessary.
 */
class NS_NO_VTABLE nsIBufferedInputStream : public nsIInputStream {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IBUFFEREDINPUTSTREAM_IID)

  /**
     * @param fillFromStream - add buffering to this stream
     * @param bufferSize     - specifies the maximum buffer size
     */
  /* void init (in nsIInputStream fillFromStream, in unsigned long bufferSize); */
  NS_IMETHOD Init(nsIInputStream *fillFromStream, PRUint32 bufferSize) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIBUFFEREDINPUTSTREAM \
  NS_IMETHOD Init(nsIInputStream *fillFromStream, PRUint32 bufferSize); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIBUFFEREDINPUTSTREAM(_to) \
  NS_IMETHOD Init(nsIInputStream *fillFromStream, PRUint32 bufferSize) { return _to Init(fillFromStream, bufferSize); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIBUFFEREDINPUTSTREAM(_to) \
  NS_IMETHOD Init(nsIInputStream *fillFromStream, PRUint32 bufferSize) { return !_to ? NS_ERROR_NULL_POINTER : _to->Init(fillFromStream, bufferSize); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsBufferedInputStream : public nsIBufferedInputStream
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIBUFFEREDINPUTSTREAM

  nsBufferedInputStream();
  virtual ~nsBufferedInputStream();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsBufferedInputStream, nsIBufferedInputStream)

nsBufferedInputStream::nsBufferedInputStream()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsBufferedInputStream::~nsBufferedInputStream()
{
  /* destructor code */
}

/* void init (in nsIInputStream fillFromStream, in unsigned long bufferSize); */
NS_IMETHODIMP nsBufferedInputStream::Init(nsIInputStream *fillFromStream, PRUint32 bufferSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIBufferedOutputStream */
#define NS_IBUFFEREDOUTPUTSTREAM_IID_STR "6476378a-da09-11d3-8cda-0060b0fc14a3"

#define NS_IBUFFEREDOUTPUTSTREAM_IID \
  {0x6476378a, 0xda09, 0x11d3, \
    { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 }}

/**
 * An output stream that stores up data to write out to another output stream
 * and does the entire write only when the buffer is full, so that fewer writes
 * to the underlying output stream are necessary.
 */
class NS_NO_VTABLE nsIBufferedOutputStream : public nsIOutputStream {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IBUFFEREDOUTPUTSTREAM_IID)

  /**
     * @param sinkToStream - add buffering to this stream
     * @param bufferSize   - specifies the maximum buffer size
     */
  /* void init (in nsIOutputStream sinkToStream, in unsigned long bufferSize); */
  NS_IMETHOD Init(nsIOutputStream *sinkToStream, PRUint32 bufferSize) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIBUFFEREDOUTPUTSTREAM \
  NS_IMETHOD Init(nsIOutputStream *sinkToStream, PRUint32 bufferSize); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIBUFFEREDOUTPUTSTREAM(_to) \
  NS_IMETHOD Init(nsIOutputStream *sinkToStream, PRUint32 bufferSize) { return _to Init(sinkToStream, bufferSize); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIBUFFEREDOUTPUTSTREAM(_to) \
  NS_IMETHOD Init(nsIOutputStream *sinkToStream, PRUint32 bufferSize) { return !_to ? NS_ERROR_NULL_POINTER : _to->Init(sinkToStream, bufferSize); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsBufferedOutputStream : public nsIBufferedOutputStream
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIBUFFEREDOUTPUTSTREAM

  nsBufferedOutputStream();
  virtual ~nsBufferedOutputStream();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsBufferedOutputStream, nsIBufferedOutputStream)

nsBufferedOutputStream::nsBufferedOutputStream()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsBufferedOutputStream::~nsBufferedOutputStream()
{
  /* destructor code */
}

/* void init (in nsIOutputStream sinkToStream, in unsigned long bufferSize); */
NS_IMETHODIMP nsBufferedOutputStream::Init(nsIOutputStream *sinkToStream, PRUint32 bufferSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

////////////////////////////////////////////////////////////////////////////////
#define NS_LOCALFILEINPUTSTREAM_CLASSNAME "Local File Input Stream"
#define NS_LOCALFILEINPUTSTREAM_CONTRACTID "@mozilla.org/network/file-input-stream;1"
#define NS_LOCALFILEINPUTSTREAM_CID                  \
{ /* be9a53ae-c7e9-11d3-8cda-0060b0fc14a3 */         \
    0xbe9a53ae,                                      \
    0xc7e9,                                          \
    0x11d3,                                          \
    {0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3} \
}
#define NS_LOCALFILEOUTPUTSTREAM_CLASSNAME "Local File Output Stream"
#define NS_LOCALFILEOUTPUTSTREAM_CONTRACTID "@mozilla.org/network/file-output-stream;1"
#define NS_LOCALFILEOUTPUTSTREAM_CID                 \
{ /* c272fee0-c7e9-11d3-8cda-0060b0fc14a3 */         \
    0xc272fee0,                                      \
    0xc7e9,                                          \
    0x11d3,                                          \
    {0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3} \
}
////////////////////////////////////////////////////////////////////////////////
#define NS_BUFFEREDINPUTSTREAM_CLASSNAME "Buffered Input Stream"
#define NS_BUFFEREDINPUTSTREAM_CONTRACTID "@mozilla.org/network/buffered-input-stream;1"
#define NS_BUFFEREDINPUTSTREAM_CID                   \
{ /* 9226888e-da08-11d3-8cda-0060b0fc14a3 */         \
    0x9226888e,                                      \
    0xda08,                                          \
    0x11d3,                                          \
    {0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3} \
}
#define NS_BUFFEREDOUTPUTSTREAM_CLASSNAME "Buffered Output Stream"
#define NS_BUFFEREDOUTPUTSTREAM_CONTRACTID "@mozilla.org/network/buffered-output-stream;1"
#define NS_BUFFEREDOUTPUTSTREAM_CID                  \
{ /* 9868b4ce-da08-11d3-8cda-0060b0fc14a3 */         \
    0x9868b4ce,                                      \
    0xda08,                                          \
    0x11d3,                                          \
    {0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3} \
}
////////////////////////////////////////////////////////////////////////////////
// move to nsNetUtil.h later...
#include "nsCOMPtr.h"
#include "nsIComponentManager.h"
#include "nsIFileChannel.h"
#include "nsIInputStream.h"
#include "nsIOutputStream.h"
#include "prio.h"       // for read/write flags, permissions, etc.
// This will QI the file argument to an nsILocalFile in the Init method.
inline nsresult
NS_NewLocalFileChannel(nsIFileChannel** aResult,
                       nsIFile* aFile,
                       PRInt32 aIOFlags = -1,
                       PRInt32 aPerm = -1)
{
    nsresult rv;
    nsCOMPtr<nsIFileChannel> channel;
    static NS_DEFINE_CID(kLocalFileChannelCID, NS_LOCALFILECHANNEL_CID);
    rv = nsComponentManager::CreateInstance(kLocalFileChannelCID,
                                            nsnull, 
                                            NS_GET_IID(nsIFileChannel),
                                            getter_AddRefs(channel));
    if (NS_FAILED(rv)) return rv;
    rv = channel->Init(aFile, aIOFlags, aPerm);
    if (NS_FAILED(rv)) return rv;
    *aResult = channel;
    NS_ADDREF(*aResult);
    return NS_OK;
}
// This will QI the file argument to an nsILocalFile in the Init method.
inline nsresult
NS_NewLocalFileInputStream(nsIInputStream** aResult,
                           nsIFile* aFile,
                           PRInt32 aIOFlags = -1,
                           PRInt32 aPerm = -1,
                           PRInt32 aBehaviorFlags = 0)
{
    nsresult rv;
    nsCOMPtr<nsIFileInputStream> in;
    static NS_DEFINE_CID(kLocalFileInputStreamCID, NS_LOCALFILEINPUTSTREAM_CID);
    rv = nsComponentManager::CreateInstance(kLocalFileInputStreamCID,
                                            nsnull, 
                                            NS_GET_IID(nsIFileInputStream),
                                            getter_AddRefs(in));
    if (NS_FAILED(rv)) return rv;
    rv = in->Init(aFile, aIOFlags, aPerm, aBehaviorFlags);
    if (NS_FAILED(rv)) return rv;
    *aResult = in;
    NS_ADDREF(*aResult);
    return NS_OK;
}
// This will QI the file argument to an nsILocalFile in the Init method.
inline nsresult
NS_NewLocalFileOutputStream(nsIOutputStream** aResult,
                            nsIFile* aFile,
                            PRInt32 aIOFlags = -1,
                            PRInt32 aPerm = -1,
                            PRInt32 aBehaviorFlags = 0)
{
    nsresult rv;
    nsCOMPtr<nsIFileOutputStream> out;
    static NS_DEFINE_CID(kLocalFileOutputStreamCID, NS_LOCALFILEOUTPUTSTREAM_CID);
    rv = nsComponentManager::CreateInstance(kLocalFileOutputStreamCID,
                                            nsnull, 
                                            NS_GET_IID(nsIFileOutputStream),
                                            getter_AddRefs(out));
    if (NS_FAILED(rv)) return rv;
    rv = out->Init(aFile, aIOFlags, aPerm, aBehaviorFlags);
    if (NS_FAILED(rv)) return rv;
    *aResult = out;
    NS_ADDREF(*aResult);
    return NS_OK;
}
////////////////////////////////////////////////////////////////////////////////
inline nsresult
NS_NewBufferedInputStream(nsIInputStream** aResult,
                          nsIInputStream* aStr,
                          PRUint32 aBufferSize)
{
    nsresult rv;
    nsCOMPtr<nsIBufferedInputStream> in;
    static NS_DEFINE_CID(kBufferedInputStreamCID, NS_BUFFEREDINPUTSTREAM_CID);
    rv = nsComponentManager::CreateInstance(kBufferedInputStreamCID,
                                            nsnull, 
                                            NS_GET_IID(nsIBufferedInputStream),
                                            getter_AddRefs(in));
    if (NS_FAILED(rv)) return rv;
    rv = in->Init(aStr, aBufferSize);
    if (NS_FAILED(rv)) return rv;
    *aResult = in;
    NS_ADDREF(*aResult);
    return NS_OK;
}
inline nsresult
NS_NewBufferedOutputStream(nsIOutputStream** aResult,
                           nsIOutputStream* aStr,
                           PRUint32 aBufferSize)
{
    nsresult rv;
    nsCOMPtr<nsIBufferedOutputStream> out;
    static NS_DEFINE_CID(kBufferedOutputStreamCID, NS_BUFFEREDOUTPUTSTREAM_CID);
    rv = nsComponentManager::CreateInstance(kBufferedOutputStreamCID,
                                            nsnull, 
                                            NS_GET_IID(nsIBufferedOutputStream),
                                            getter_AddRefs(out));
    if (NS_FAILED(rv)) return rv;
    rv = out->Init(aStr, aBufferSize);
    if (NS_FAILED(rv)) return rv;
    *aResult = out;
    NS_ADDREF(*aResult);
    return NS_OK;
}

#endif /* __gen_nsIFileStreams_h__ */
