// __________ Imports __________

// base classes
import com.sun.star.uno.UnoRuntime;
import com.sun.star.lang.*;

// property access
import com.sun.star.beans.*;

// name access
import com.sun.star.container.*;

// application specific classes
import com.sun.star.drawing.*;

// presentation specific classes
import com.sun.star.presentation.*;

// Point, Size, ..
import com.sun.star.awt.*;

// __________ Implementation __________

/** presentation demo
    @author Sven Jacobi
 */

// This demo will demonstrate how to create a CustomShow

// The first parameter describes the connection that is to use. If there is no parameter
// "uno:socket,host=localhost,port=8100;urp;StarOffice.ServiceManager" is used.


public class CustomShowDemo
{
    public static void main( String args[] )
    {
		XComponent xDrawDoc = null;
		try
		{
			String sConnection;
			if ( args.length >= 1 )
				sConnection = args[ 1 ];
			else
				sConnection = "uno:socket,host=localhost,port=8100;urp;StarOffice.ServiceManager";
			XMultiServiceFactory xServiceFactory =
				Helper.connect( sConnection );

			// suppress Presentation Autopilot when opening the document
			// properties are the same as described for com.sun.star.document.MediaDescriptor
			PropertyValue[] pPropValues = new PropertyValue[ 1 ];
			pPropValues[ 0 ] = new PropertyValue();
			pPropValues[ 0 ].Name = "Silent";
			pPropValues[ 0 ].Value = new Boolean( true );

			xDrawDoc = Helper.createDocument( xServiceFactory,
				"private:factory/simpress", "_blank", 0, pPropValues );

			XDrawPagesSupplier xDrawPagesSupplier =
				(XDrawPagesSupplier)UnoRuntime.queryInterface(
					XDrawPagesSupplier.class, xDrawDoc );
			XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
						
			// take care that this document has ten pages
		    while ( xDrawPages.getCount() < 10 )
				xDrawPages.insertNewByIndex( 0 );

			// assign a name to each page
			String aNameArray[] = { "Introduction", "page one", "page two", "page three", "page four",
									"page five", "page six", "page seven", "page eight", "page nine" };
			int i;
			for ( i = 0; i < 10; i++ )
			{
				XNamed xPageName = (XNamed)UnoRuntime.queryInterface(
					XNamed.class, xDrawPages.getByIndex( i ) );
				xPageName.setName( aNameArray[ i ] );
			}

			/* create two custom shows, one will play slide 6 to 10 and is named "ShortVersion"
			   the other one will play slide 2 til 10 and is named "LongVersion" */
			XCustomPresentationSupplier xCustPresSupplier = (XCustomPresentationSupplier)
				UnoRuntime.queryInterface( XCustomPresentationSupplier.class, xDrawDoc );

			/* the following container is a container for further container
			   which concludes the list of pages that are to play within a custom show */
			XNameContainer xNameContainer = xCustPresSupplier.getCustomPresentations();
			XSingleServiceFactory xFactory = (XSingleServiceFactory)
				UnoRuntime.queryInterface( XSingleServiceFactory.class, xNameContainer );

			Object			xObj;
			XIndexContainer xContainer;

			/* instanciate an IndexContainer that will take
			   a list of draw pages for the first custom show */
			xObj = xFactory.createInstance();
		    xContainer = (XIndexContainer)UnoRuntime.queryInterface( XIndexContainer.class, xObj );
			for ( i = 5; i < 10; i++ )
				xContainer.insertByIndex( xContainer.getCount(), xDrawPages.getByIndex( i ) );
			xNameContainer.insertByName( "ShortVersion", xContainer );

			/* instanciate an IndexContainer that will take
			   a list of draw page for the second custom show */
			xObj = xFactory.createInstance();
		    xContainer = (XIndexContainer)UnoRuntime.queryInterface( XIndexContainer.class, xObj );
			for ( i = 1; i < 10; i++ )
				xContainer.insertByIndex( xContainer.getCount(), xDrawPages.getByIndex( i ) );
			xNameContainer.insertByName( "LongVersion", xContainer );

			/* which custom show is to use
			   can been set in the presentation settings */

			XPresentationSupplier xPresSupplier = (XPresentationSupplier)
				UnoRuntime.queryInterface( XPresentationSupplier.class, xDrawDoc );
			XPresentation xPresentation = xPresSupplier.getPresentation();
			XPropertySet xPresPropSet = (XPropertySet)
				UnoRuntime.queryInterface( XPropertySet.class, xPresentation );
			xPresPropSet.setPropertyValue( "CustomShow", "ShortVersion" );
		}
		catch( Exception ex )
		{
            System.out.println( ex );
		}
		System.exit( 0 );
    }
}
