// __________ Imports __________

// base classes
import com.sun.star.uno.UnoRuntime;
import com.sun.star.lang.*;

// property access
import com.sun.star.beans.*;

// name access
import com.sun.star.container.*;

// application specific classes
import com.sun.star.drawing.*;

// XModel, XController
import com.sun.star.frame.*;

// XViewDataSupplier
import com.sun.star.document.*;


// __________ Implementation __________

/** text demo
    @author Sven Jacobi
 */

public class DrawViewDemo
{
    public static void main( String args[] )
    {
		if ( args.length < 1 )
		{
			System.out.println( "usage: DrawViewDemo SourceURL [ connection ]" );
		}
		else
		{
			XComponent xComponent = null;
			try
			{
				String sConnection;
				if ( args.length >= 2 )
					sConnection = args[ 1 ];
				else
					sConnection = "uno:socket,host=localhost,port=8100;urp;StarOffice.ServiceManager";
				XMultiServiceFactory xServiceFactory =
					Helper.connect( sConnection );

				// suppress Presentation Autopilot when opening the document
				// properties are the same as described for com.sun.star.document.MediaDescriptor
				PropertyValue[] pPropValues = new PropertyValue[ 1 ];
				pPropValues[ 0 ] = new PropertyValue();
				pPropValues[ 0 ].Name = "Silent";
				pPropValues[ 0 ].Value = new Boolean( true );
              
				java.io.File sourceFile = new java.io.File(args[0]);
				StringBuffer sUrl = new StringBuffer("file:///");
				sUrl.append(sourceFile.getCanonicalPath().replace('\\', '/'));
                
				xComponent = Helper.createDocument( xServiceFactory,
					sUrl.toString(), "_blank", 0, pPropValues );
				XModel xModel =
					(XModel)UnoRuntime.queryInterface(
						XModel.class, xComponent );


				// print all available properties of first view
				XViewDataSupplier xViewDataSupplier =
					(XViewDataSupplier)UnoRuntime.queryInterface(
						XViewDataSupplier.class, xModel );
				XIndexAccess xIndexAccess = xViewDataSupplier.getViewData();
				if ( xIndexAccess.getCount() != 0 )
				{
                  PropertyValue[] aPropSeq = (PropertyValue[])xIndexAccess.getByIndex( 0 );
					for( int i = 0; i < aPropSeq.length; i++ )
					{
						System.out.println( aPropSeq[ i ].Name + " = " + aPropSeq[ i ].Value );
					}
				}

				
				// print all properties that are supported by the controller
				// and change into masterpage mode
				XController xController = xModel.getCurrentController();
				XPropertySet xPropSet =
					(XPropertySet)UnoRuntime.queryInterface(
						XPropertySet.class, xController );
				XPropertySetInfo xPropSetInfo = xPropSet.getPropertySetInfo();
				Property[] aPropSeq = xPropSetInfo.getProperties();
				for( int i = 0; i < aPropSeq.length; i++ )
				{
					System.out.println( aPropSeq[ i ].Name );
				}
				xPropSet.setPropertyValue( "IsMasterPageMode", new Boolean( true ) );

			}
			catch( Exception ex )
			{
				System.out.println( ex );
			}
		}
		System.exit( 0 );
    }
}
