
import java.util.List;
import java.util.ArrayList;

import com.sun.star.frame.XDispatch;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyState;
import com.sun.star.util.URL;

/**
 * This class reprecents an office slot command.
 */
public class OfficeCommand
{
	private short	mSlot;
	private List	mProps	= new ArrayList();

	/**
	 * Constructor.
	 *
	 * @param slot The office slot identifier.
	 * @param args The arguments of the office slot command.
	 */
	public OfficeCommand(short slot, PropertyValue args[])
	{
		mSlot	= slot;
		for (int idx = 0; idx < args.length; idx += 1) {
			mProps.add(args[idx]);
		}
	}

	/**
	 * Constructor.
	 *
	 * @param slot The office slot identifier.
	 */
	public OfficeCommand(short slot)
	{
		mSlot	= slot;
	}

	/**
	 * Appends an office slot command parameter.
	 *
	 * @param name The parameter name.
	 * @param value The parameter value.
	 */
	public synchronized void appendParameter(String name, Object value)
	{
		mProps.add(new PropertyValue(name, 0, value, 
			PropertyState.DIRECT_VALUE));
	}

	/**
	 * Executes the command on the specified office instance.
	 *
	 * @param office The office instance which is the target of the command. 
	 */
	public synchronized void execute(BasicOfficeBean office)
	{
		synchronized(office) {	// avoid conflicts with connect/disconnect...
			// ... do the job
			URL[]	url	= new URL[1];
			url[0]	= new URL("slot:" + Short.toString(mSlot),
				"",			// string Main
				"",			// string Protocol
				"",			// string User
				"",			// string Password
				"",			// string Server
				(short)0,	// short Port
				"",			// string Path
				"",			// string Name
				"",			// string Arguments
				"");		// string Mark
			office.mURLTransformer.parseSmart(url, "slot");
			// workaround bug in dispatch
			url[0].Complete	= url[0].Main;
			XDispatch	dispatcher	= office.mDispatcher.queryDispatch(
				url[0], "", 0);
			dispatcher.dispatch(url[0], (PropertyValue[])mProps.toArray(
				new PropertyValue[mProps.size()]));
		}
		// Good things come to those who wait...
		notifyAll();
	}
}
