/*************************************************************************
 *
 *  $RCSfile: Office.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: dschulten $ $Date: 2002/10/25 12:38:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.FileOutputStream;
import java.io.FileInputStream;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFrameActionListener;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.view.XSelectionSupplier;
import com.sun.star.beans.PropertyValue;
import com.sun.star.util.XModifiable;
import com.sun.star.uno.UnoRuntime;

/**
 * This class represents a primitive office bean.
 */
public class Office
	extends BasicOfficeBean
{
	public final static int	DEFAULT_WIDTH	= 600;
	public final static int	DEFAULT_HEIGHT	= 300;

	public final static short	SID_TOGGLEPREVIEW	= 5325;
	public final static short	SID_TOGGLEMENUBAR	= 6661;
	public final static short	SID_TOGGLEOBJECTBAR	= 5905;
	public final static short	SID_TOGGLETOOLBAR	= 5909;

	private boolean	mReadOnly			= false;
	private boolean	mPreviewVisible		= false;
	private boolean	mMenuBarVisible		= true;
	private boolean	mObjectBarVisible	= true;
	private boolean	mToolBarVisible		= true;

	private transient PropertyChangeListener	mPropertyChangeListener;

	/**
	 * Retrives the service factory.
	 *
	 * @return The service factory.
	 */
	public XMultiServiceFactory getServiceFactory()
	{
		return mServiceFactory;
	}

	/**
	 * Retrives the document frame.
	 *
	 * @return The document frame.
	 */
	public XFrame getFrame()
	{
		return mFrame;
	}

	/**
	 * Retrives the XModifiable interface of the document frame.
	 *
	 * @return The XModifiable interface of the document frame.
	 */
	public XModifiable getXModifiable()
	{
		return mModifiable;
	}

	/**
	 * Retrives the XSelectionSupplier interface of the document frame 
	 * controller.
	 *
	 * @return The XSelectionSupplier interface of the document frame 
	 * controller.
	 */
	public XSelectionSupplier getSelectionSupplier()
	{
		XSelectionSupplier	selection;
		selection	= (XSelectionSupplier)UnoRuntime.queryInterface(
			XSelectionSupplier.class, mFrame.getController());
		return selection;
	}

	/**
	 * Retrives the document prefered size.
	 *
	 * @return The document prefered size.
	 */
	public Dimension getPreferredSize()
	{
		return new Dimension(DEFAULT_WIDTH, DEFAULT_HEIGHT);
	}

	/**
	 * Retrives the read only property of the document.
	 *
	 * @return <code>true</code> if the document is read only.
	 */
	public boolean isReadOnly()
	{
		return mReadOnly;
	}

	/**
	 * Sets the read only property of the document.
	 *
	 * @param readonly if <code>true</code> the document becomes 
	 *	a read only document.
	 */
	public void setReadOnly(boolean readonly)
	{
		firePropertyChange("ReadOnly", new Boolean(mReadOnly),
			new Boolean(readonly));
		mReadOnly	= readonly;
	}

	/**
	 * Retrives the state of the document preview.
	 *
	 * @return <code>true</code> if the document preview is visible.
	 */
	public boolean isPreviewVisible()
	{
		return mPreviewVisible;
	}

	/**
	 * Sets the state of the document preview.
	 *
	 * @param visible if <code>true</code> the document preview is visible.
	 */
	public void setPreviewVisible(boolean visible)
	{
		if (mPreviewVisible != visible) {
			if (isDocumentLoaded() == true) {
				OfficeCommand command = new OfficeCommand(SID_TOGGLEPREVIEW);
				command.appendParameter("Preview", new Boolean(visible));
				command.execute(this);
			}
			firePropertyChange("PreviewVisible", new Boolean(mPreviewVisible),
				new Boolean(visible));
			mPreviewVisible	= visible;
		}
	}

	/**
	 * Retrives the visibility of the menu bar.
	 *
	 * @return <code>true</code> if the menu bar is visable.
	 */
	public boolean isMenuBarVisible()
	{
		return mMenuBarVisible;
	}

	/**
	 * Sets the visibility of the menu bar.
	 *
	 * @param visible The visibility flag.
	 */
	public void setMenuBarVisible(boolean visible)
	{
		if (mMenuBarVisible != visible) {
			if (isDocumentLoaded() == true) {
				OfficeCommand command = new OfficeCommand(SID_TOGGLEMENUBAR);
				command.appendParameter("MenuBar", new Boolean(visible));
				command.execute(this);
			}
			firePropertyChange("MenuBarVisible", new Boolean(mMenuBarVisible),
				new Boolean(visible));
			mMenuBarVisible	= visible;
		}
	}

	/**
	 * Retrives the visibility of the object bar.
	 *
	 * @return <code>true</code> if the object bar is visable.
	 */
	public boolean isObjectBarVisible()
	{
		return mObjectBarVisible;
	}

	/**
	 * Sets the visibility of the object bar.
	 *
	 * @param visible The visibility flag.
	 */
	public void setObjectBarVisible(boolean visible)
	{
		if (mObjectBarVisible != visible) {
			if (isDocumentLoaded() == true) {
				OfficeCommand command = new OfficeCommand(SID_TOGGLEOBJECTBAR);
				command.appendParameter("ObjectBarVisible", new Boolean(visible));
				command.execute(this);
			}
			firePropertyChange("ObjectBarVisible", new Boolean(mObjectBarVisible),
				new Boolean(visible));
			mObjectBarVisible	= visible;
		}
	}

	/**
	 * Retrives the visibility of the tool bar.
	 *
	 * @return <code>true</code> if the tool bar is visable.
	 */
	public boolean isToolBarVisible()
	{
		return mToolBarVisible;
	}

	/**
	 * Sets the visibility of the tool bar.
	 *
	 * @param visible The visibility flag.
	 */
	public void setToolBarVisible(boolean visible)
	{
		if (mToolBarVisible != visible) {
			if (isDocumentLoaded() == true) {
				OfficeCommand command = new OfficeCommand(SID_TOGGLETOOLBAR);
				command.appendParameter("ToolBarVisible", new Boolean(visible));
				command.execute(this);
			}
			firePropertyChange("ToolBarVisible", new Boolean(mToolBarVisible),
				new Boolean(visible));
			mToolBarVisible	= visible;
		}
	}

	/**
	 * Loads a document referenced by a URL.
	 *
	 * @param url The document's URL string. 
	 * @exception java.io.IOException if the document loading process has 
	 *	failed.
	 */
	public synchronized void load(String url)
		throws java.io.IOException
	{
		super.load(url);
		setMenuBarVisible(false);
	}

	/**
	 * Loads the document from the given InputStream.
	 *
	 * @param in The InputStream from which to load the document
	 * @see #save
	 */
	public void load(InputStream in)
		throws java.io.IOException
	{
		// BUG: Office 627: type detection needs to have the extension
		load(in, "tmp");
	}

	/**
	 * loads the document from the given stream.
	 * @see #save
	 */
	private void load(InputStream in, String sExtension)
		throws java.io.IOException
	{
		File tmpFile = java.io.File.createTempFile("officebean", sExtension);

		try {
			String tmpFileName = "file:///" + tmpFile.getAbsolutePath();

			byte[] buffer = new byte[1024];
			OutputStream o = new FileOutputStream(tmpFile);

			int len = 0;
			while ((len = in.read(buffer)) > 0)
				o.write(buffer, 0, len);
			o.close();

			load(tmpFileName);
		}
		catch (java.lang.Exception e) {
			e.printStackTrace(System.out);
		}
		tmpFile.delete();
	}

	/**
	* saves the document to the given stream.
	* @see #loadFromStream
	*/
	public void save(OutputStream o)
		throws java.io.IOException
	{
		if (mFrame == null)
			throw new java.io.IOException("no document loaded");

		XModel xModel = mFrame.getController().getModel();
		XStorable xStorable =
			(XStorable)UnoRuntime.queryInterface(XStorable.class, xModel);

		File tmpFile = File.createTempFile("officebean", "tmp");

		try {
			String tmpFileName = "file:///" + tmpFile.getAbsolutePath();
			xStorable.storeToURL(tmpFileName, new PropertyValue[0]);

			byte[] buffer = new byte[1024];
			InputStream in = new FileInputStream(tmpFile);

			int len = 0;
			while ((len = in.read(buffer)) > 0)
				o.write(buffer, 0, len);
			in.close();
		}
		catch (com.sun.star.io.IOException e) {
			throw new java.io.IOException(e.getMessage());
		}
		tmpFile.delete();
	}

	/**
	 * Sets a document referenced by a URL.
	 *
	 * @param url The document's URL string. 
	 */
	public void setDocumentURL(String url)
	{
		try {
			load(url);
		} catch (java.io.IOException ioe) {
			mDocumentURL	= null;
		}
	}

	/**
	 * Sends an office slot command to the document.
	 *
	 * @param id The office slot command identifier.
	 * @param args The array of the command arguments.
	 * @param asyn if <code>true</code> the office slot command will be 
	 *	executed asynchronously.
	 */
	public void sendSlotCommand(short id, PropertyValue args[], boolean asyn)
	{
		OfficeCommand	command	= new OfficeCommand(id, args);
		if (asyn == true)
			queue(command);
		else
			command.execute(this);
	}

	/**
	 * Retrives a property change listener.
	 *
	 * @return The property change listener.
	 */
	public PropertyChangeListener getPropertyChangeListener()
	{
		if (mPropertyChangeListener == null) {
			mPropertyChangeListener	= new DefaultPropertyChangeListener();
			addPropertyChangeListener(mPropertyChangeListener);
		}
		return mPropertyChangeListener;
	}

	/**
	 * Sets the new property chanche listener.
	 *
	 * @param listener The new property chanche listener.
	 */
	public void setPropertyChangeListener(PropertyChangeListener listener)
	{
		if (mPropertyChangeListener == listener)
			return;
		if (mPropertyChangeListener != null)
			removePropertyChangeListener(mPropertyChangeListener);
		mPropertyChangeListener	= listener;
		addPropertyChangeListener(mPropertyChangeListener);
	}

	/**
	 * Determines is the property chanche listener available.
	 *
	 * @return <code>true</code> if the property chanche listener is available.
	 */
	public boolean isPropertyChangeListenerNull()
	{
		return (mPropertyChangeListener == null);
	}

	/**
	 * Adds a frame action listener.
	 *
	 * @param listener The frame action listener.
	 */
	public void addFrameActionListener(XFrameActionListener listener)
	{
		mFrame.addEventListener(listener);
	}

	/**
	 * Removes a frame action listener.
	 *
	 * @param listener The frame action listener.
	 */
	public void removeFrameActionListener(XFrameActionListener listener)
	{
		mFrame.removeFrameActionListener(listener);
	}

	/**
	 * Closes the connection to the office.
	 */
	public void dispose()
	{
		closeConnection();
	}

	/**
	 * A stub implementation of the property change listener.
	 */
	private class DefaultPropertyChangeListener
		implements PropertyChangeListener
	{
		public void propertyChange(PropertyChangeEvent evt)
		{
		}
	}
}
