PRJ=..
PRJNAME=apiwww
TARGET=odk

common_build=

# ------------------------------------------------------------------
.INCLUDE: settings.mk
# ------------------------------------------------------------------

PRODUCT_NAME=odk$(UPD)

DOCZIPFILE=$(BIN)$/$(PRODUCT_NAME)_doc.zip
DOCTARGZFILE=$(BIN)$/$(PRODUCT_NAME)_doc.tar.gz

DESTDIRDOC=$(OUT)$/misc$/$(PRODUCT_NAME)
DESTDIRWWWDOC=$(DESTDIRDOC)$/docs
DESTCOMMONDOC=$(DESTDIRWWWDOC)$/common
DESTDIRIDEINTEGRATIONDOC=$(DESTCOMMONDOC)$/man$/IDEintegration
DESTDIRXMLSPEC=$(DESTCOMMONDOC)$/spec$/xml_format
DESTDIRBASICDOC=$(DESTDIRWWWDOC)$/basic
COMMONDIRDOC=$(PRJ)$/common
BASICDIRDOC=$(PRJ)$/basic



UDKZIPPATH=$(SOLARBINDIR)
UDKNAME=udk$(UDK_MAJOR).$(UDK_MINOR).$(UDK_MICRO)
UDKDOCZIP=$(UDKNAME)_doc.tar.gz
UDKDOCTAR=$(UDKNAME)_doc.tar
UDKDOCCOMPLETE=$(UDKZIPPATH)$/$(UDKDOCZIP)
 
IDLOUT=$(SOLARIDLDIR)

CONVERTSCRIPT=$(SOLARENV)$/bin$/convertlinks.pl
MY_AUTODOC=$(SOLARBINDIR)$/autodoc

.IF "$(GUI)"=="WNT"
#--------------------
# WNT ONLY
#--------------------
MY_COPY=copy /u
MY_COPY_RECURSIVE=copy /us 
MY_DELETE_RECURSIVE=del /sy

RM_CVS_DIRS=$(FIND) $(DESTDIRDOC) -name "CVS" -type d -exec rm -rf $(0,text {)$(0,text }) ;
.ELSE
# TODO : add further platforms
#--------------------
# UNX ONLY
#--------------------
MY_COPY=$(GNUCOPY) -u
MY_COPY_RECURSIVE=$(GNUCOPY) -urf
MY_DELETE_RECURSIVE=rm -rf

RM_CVS_DIRS=$(FIND) $(DESTDIRDOC) -name "CVS" -type d -exec rm -rf $(0,text {)$(0,text }) ;
.ENDIF

UDKCOPYFLAG = $(MISC)$/udk_copy.flag
DOCUGENIDLFLAG = $(MISC)$/docugen_idl_reference.flag
DOCUCOPYFLAG = $(MISC)$/docucopy_html_files.flag

DIRLIST= \
    $(DESTDIRCOMMONDOC) \
    $(DESTDIRBASICDOC) \
    $(DESTDIRBASICDOC)$/man \
    $(DESTDIRBASICDOC)$/man$/tutorial \
    $(DESTDIRIDEINTEGRATIONDOC) \
    $(DESTDIRXMLSPEC)

DOCUFILESLIST= \
    $(PRJ)$/common$/man$/IDEintegration$/APIHelp.gif \
    $(PRJ)$/common$/man$/IDEintegration$/JavaCodeCompletion.gif \
    $(PRJ)$/common$/man$/IDEintegration$/OfficeNetBeansIntegration.html \
    $(PRJ)$/common$/man$/IDEintegration$/AttachToVM.jpg \
    $(PRJ)$/basic$/man$/tutorial$/tutorial.pdf

#DOCUFILES= \
#	$(PRJ)$/faq.html \
#	$(PRJ)$/index.html

DESTDOCUFILES= \
    $(DESTDIRXMLSPEC)$/xml_specification_draft.pdf

DESTDOCUFILES+= \
    {$(subst,..,$(DESTDIRWWWDOC) $(DOCUFILESLIST))}
    
#.IF "$(BUILD_SOSL)"!=""
# for OO build

#DESTDOCUFILES+= \
#    {$(subst,..$/,$(DESTDIRWWWDOC)$/odk_ $(DOCUFILES))}
        
#.ENDIF
    

#--------------------------------------------------
# TARGETS
#--------------------------------------------------
all: \
    $(DOCZIPFILE) \
    $(DOCTARGZFILE)

$(MISC)$/deltree.txt : deltree.txt
	+-$(RM) $(BIN)$/$(PRODUCT_NAME)_doc.zip >& $(NULLDEV)
	+-$(RM) $(BIN)$/$(PRODUCT_NAME)_doc.tar.gz >& $(NULLDEV)
	+-$(MY_DELETE_RECURSIVE) $(DESTDIRDOC) >& $(NULLDEV)
	+@echo "" > $(MISC)$/deltree.txt

$(DIRLIST) : $(UDKCOPYFLAG)
	$(MKDIRHIER)	$@

$(UDKCOPYFLAG) : $(UDKDOCCOMPLETE) $(MISC)$/deltree.txt
	+-$(COPY) $(UDKDOCCOMPLETE) $(MISC)
	+-cd $(MISC) && gzip -dfq $(UDKDOCZIP) && tar xf $(UDKDOCTAR) && $(RM) $(UDKDOCTAR)
	+-$(RENAME) $(MISC)$/$(UDKNAME) $(MISC)$/$(PRODUCT_NAME)
	+@echo "docu copied" > $@

#$(DOCUGENIDLFLAG) : $(PRJ)$/ref-man.tar.gz $(UDKCOPYFLAG)
#	+-$(MY_DELETE_RECURSIVE) $(DESTDIRIDLAUTODOC)
#	+$(COPY) $(PRJ)$/ref-man.tar.gz $(DESTDIRWWWDOC)
# 	+cd $(DESTDIRWWWDOC) && gzip -df ref-man.tar.gz && tar xvf ref-man.tar && $(RM) ref-man.tar
#	+@echo "idl reference docu generated" > $@

$(DESTDIRXMLSPEC)$/xml_specification_draft.pdf : $(SOLARINCDIR)$/xml_specification_draft.pdf
	$(GNUCOPY) -p $(SOLARINCDIR)$/xml_specification_draft.pdf $(DESTDIRXMLSPEC)$/xml_specification_draft.pdf
    
$(DESTCOMMONDOC)$/% : $(COMMONDIRDOC)$/%
	$(GNUCOPY) -p  $(subst,$(DESTDIRWWWDOC),.. $@) $@

$(DESTDIRBASICDOC)$/% : $(BASICDIRDOC)$/%
	$(GNUCOPY) -p $(subst,$(DESTDIRWWWDOC),.. $@) $@
    
$(DOCUCOPYFLAG) : $(DIRLIST) $(DESTDOCUFILES)
.IF "$(BUILD_SOSL)"!=""
# for OO build
	+$(PERL) $(CONVERTSCRIPT) $(DESTDIRWWWDOC) odk_
.ENDIF    
	+@echo "documentation copied and tags converted" > $@

# ------------------------------------------------------------------------------------
#      ZIP IT
# ------------------------------------------------------------------------------------
#$(DOCZIPFILE) : $(DOCUCOPYFLAG) $(DOCUGENIDLFLAG)
$(DOCZIPFILE) : $(DOCUCOPYFLAG)
	+-$(RM) $(BIN)$/$(PRODUCT_NAME)_doc.zip
	+-cd $(DESTDIRDOC)$/.. && zip -9 -r ..$/bin$/$(PRODUCT_NAME)_doc.zip $(PRODUCT_NAME)
    
#$(DOCTARGZFILE) : $(DOCUCOPYFLAG) $(DOCUGENIDLFLAG)
$(DOCTARGZFILE) : $(DOCUCOPYFLAG)
	+-$(RM) $(BIN)$/$(PRODUCT_NAME)_doc.tar.gz
	+-cd $(DESTDIRDOC)$/.. && tar cvf - $(PRODUCT_NAME) | gzip -c > ..$/bin$/$(PRODUCT_NAME)_doc.tar.gz

