/*************************************************************************
 *
 *  $RCSfile: ipi_ce.hxx,v $
 *
 *  $Revision: 1.1.12.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/01/27 17:00:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_IDL_IPI_CE_HXX
#define ARY_IDL_IPI_CE_HXX


// USED SERVICES
    // BASE CLASSES
#include <ary/idl/ip_ce.hxx>
    // COMPONENTS
    // PARAMETERS


namespace ary
{
namespace idl
{

class Ce_Storage;


/** @resp
    Implements ::ary::idl::CePilot. Provides the access logic for all
    IDL code entities.

    @collab Gate_Inst
    @collab Ce_Storage
    @collab Type_Pilot

    @see CodeEntity
*/
class CePilot_Inst : public CePilot
{
  public:
    // LIFECYCLE
                        CePilot_Inst(
                            Ce_Storage &        io_rStorage );
    virtual             ~CePilot_Inst();

    // OPERATIONS

    // INQUIRY

    // ACCESS

  private:
    // Interface ::ary::idl::CePilot:
    virtual Module &    do_CheckIn_Module(
                            Ce_id               i_nParentId,
                            const String &      i_sName );
    virtual Service &   do_Store_Service(
                            Ce_id               i_nOwner,
                            const String &      i_sName );
    virtual Interface & do_Store_Interface(
                            Ce_id               i_nOwner,
                            const String &      i_sName,
                            Type_id             i_nBase );
    virtual Struct &    do_Store_Struct(
                            Ce_id               i_nOwner,
                            const String &      i_sName,
                            Type_id             i_nBase );
    virtual Exception & do_Store_Exception(
                            Ce_id               i_nOwner,
                            const String &      i_sName,
                            Type_id             i_nBase );
    virtual Enum &      do_Store_Enum(
                            Ce_id               i_nOwner,
                            const String &      i_sName );
    virtual Typedef &   do_Store_Typedef(
                            Ce_id               i_nOwner,
                            const String &      i_sName,
                            Type_id             i_nDefiningType );
    virtual ConstantsGroup &
                        do_Store_ConstantsGroup(
                            Ce_id               i_nOwner,
                            const String &      i_sName );
    virtual Singleton & do_Store_Singleton(
                            Ce_id               i_nOwner,
                            const String &      i_sName );

    virtual Constant &  do_Store_Constant(
                            Ce_id               i_nOwner,
                            const String &      i_sName,
                            Type_id             i_nType,
                            const String &      i_sValue );
    virtual Property &  do_Store_Property(
                            Ce_id               i_nOwner,
                            const String &      i_sName,
                            Type_id             i_nType,
                            Property::Stereotypes
                                                i_stereotypes );
    virtual Function &  do_Store_Function(
                            Ce_id               i_nOwner,
                            const String &      i_sName,
                            Type_id             i_nReturnType,
                            bool                i_bOneWay,
                            bool                i_bConst );
    virtual StructElement &
                        do_Store_StructMember(
                            Ce_id               i_nOwner,
                            const String &      i_sName,
                            Type_id             i_nType );
    virtual StructElement &
                        do_Store_ExceptionMember(
                            Ce_id               i_nOwner,
                            const String &      i_sName,
                            Type_id             i_nType );
    virtual EnumValue & do_Store_EnumValue(
                            Ce_id               i_nOwner,
                            const String &      i_sName,
                            const String &      i_sValue );
    virtual Attribute & do_Store_Attribute(
                            Ce_id               i_nOwner,
                            const String &      i_sName,
                            Type_id             i_nType,
                            bool                i_bReadOnly );

    virtual const Module &
                        inq_GlobalNamespace() const;
    virtual const CodeEntity &
                        inq_Find_Ce(
                            Ce_id               i_nId ) const;

    virtual const Module &
                        inq_Find_Module(
                            Ce_id               i_nId ) const;
    virtual const Module *
                        inq_Search_Module(
                            Ce_id               i_nId ) const;
    virtual const Function &
                        inq_Find_Function(
                            Ce_id               i_nId ) const;
    virtual const Property &
                        inq_Find_Property(
                            Ce_id               i_nId ) const;
    virtual const EnumValue &
                        inq_Find_EnumValue(
                            Ce_id               i_nId ) const;
    virtual const Constant &
                        inq_Find_Constant(
                            Ce_id               i_nId ) const;
    virtual const StructElement &
                        inq_Find_StructElement(
                            Ce_id               i_nId ) const;
    virtual void        inq_Get_Text(
                            StringVector &      o_module,
                            String &            o_ce,
                            String &            o_member,
                            const CodeEntity &  i_ce ) const;     
    // ACCESS
    virtual Module &    access_GlobalNamespace();
    virtual CodeEntity &
                        access_Find_Ce(
                            Ce_id               i_nId );

    // Locals
    Module &            lhf_Access_Module(
                            Ce_id               i_nId );
    void                lhf_Put2Storage_and_AssignId(
                            CodeEntity &        pass_io_rCe );
    void                lhf_Store_NewEntity(
                            DYN CodeEntity &    pass_io_rCe,
                            Module &            i_rOwner );
    void                get_ModuleText(
                            StringVector &      o_module,
                            const CodeEntity &  i_ce ) const;     

    const Ce_Storage &  my_Storage() const;
    Ce_Storage &        my_Storage();

    // DATA
    Ce_Storage *        pStorage;           /// @inv pStorage != 0;
    Module *            pGlobalNamespace;
};




// IMPLEMENTATION


}   // namespace idl
}   // namespace ary



#endif

