/*************************************************************************
 *
 *  $RCSfile: st_iterator.hxx,v $
 *
 *  $Revision: 1.1.12.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/01/27 17:01:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_STORE_ST_ITERATOR_HXX
#define ARY_STORE_ST_ITERATOR_HXX

// USED SERVICES
    // BASE CLASSES
    // COMPONENTS
    // PARAMETERS
#include <getncast.hxx>
#include "st_unit.hxx"


namespace ary
{
namespace store
{

template<class X> class RootBlock;

namespace internal
{

class IteratorNoFilter { public: enum E_ClassId {class_id = 0}; };
                   

template <class UNIT, class FILTER>                   
bool
CheckFilter( const UNIT &   i_rUnit,
             T2T<FILTER>    )
{
    return FILTER::class_id == 0
           OR i_rUnit.EntityClass() == FILTER::class_id;
}

                                                
/** @task   Base class for very simple one-pass iterators to use on 
            class ::ary::store::Root .
    @descr  
    Operators of this kind are to be used like this:
    
        ary::store::Root & 
            r = GetData();
        for ( ary::store::RootIterator & it = r.Begin();           
              it;       // which is the same as "bool(it)"
              ++it; )
        {
            doSomethingWith(*it);
        }
    
    @derive
    Derived classes have to provide the operator*() method.
    They may provide a constructor which calls
        IteratorBase<UNIT,FILTER>( block_iterator, block_iterator, in_block_iterator );
*/                                                
template <class UNIT, class FILTER = IteratorNoFilter>
class IteratorBase
{            
    // KORR
    // Clarify, how to use this - with != End() or with bool?

  public:
    typedef IteratorBase<UNIT,FILTER>       self;
    typedef UNIT                            unit_type;
    typedef RootBlock<UNIT>                 block_type;
    typedef block_type *                    block_iterator;
    typedef typename block_type::iterator   in_block_iterator;

    // OPERATORS
    bool                operator==(
                            const self &        i_rOther ) const
                            {   return itPosition == i_rOther.itPosition
                                AND itBlock == i_rOther.itBlock;
                            }

    void                operator++();           /// @precond itPosition != 0
                        operator bool() const   { return itPosition != 0 ? (*itPosition).EntityPtr() != 0 : false; }

    // OPERATIONS
    void                Set(
                            block_iterator      i_itBlock,
                            block_iterator      i_itBlocksEnd,
                            in_block_iterator   i_itPosition )
                            {   itBlock = i_itBlock;
                                itBlocksEnd = i_itBlocksEnd;
                                itPosition = i_itPosition;
                                Search_NextValidPosition();
                            }
    // INQUIRY
    const block_iterator
                        CurBlock() const        { return itBlock; }
    const block_iterator
                        EndBlock() const        { return itBlocksEnd; }
    in_block_iterator   CurPosition() const     { return itPosition; }

  protected:
    // LIFECYCLE
                        IteratorBase()          :   itBlock(0),
                                                    itBlocksEnd(0),
                                                    itPosition(0) {}
                        IteratorBase(
                            block_iterator      i_itBlock,
                            block_iterator      i_itBlocksEnd,
                            in_block_iterator   i_itPosition )
                            :   itBlock(i_itBlock),
                                itBlocksEnd(i_itBlocksEnd),
                                itPosition(i_itPosition)
                            { Search_NextValidPosition(); }
                        ~IteratorBase()         {}

    unit_type &         CurUnit() const         /// @precond bool(*this);
                                                { csv_assert(itPosition != 0);
                                                  return *itPosition; }
  private:
    void                Advance()               /// @precond itPosition != 0
                                                { if ( ++itPosition == (*itBlock).End() )
                                                    Advance_Block();
                                                }
    void                Advance_Block()         /// @precond itBlock != itBlocksEnd
                                                { if (++itBlock != itBlocksEnd)
                                                      itPosition = (*itBlock).Begin();
                                                  else
                                                      itPosition = 0;
                                                }
    /** @return false, if the iterator cannot stay on this position,
        because of filtering.
    */    
    bool                Check()                 { return itPosition != 0
                                                    ? CheckFilter(*itPosition, T2T<FILTER>() )
                                                    : true;
                                                }
    void                Search_NextValidPosition();

    // DATA
    block_iterator      itBlock;
    block_iterator      itBlocksEnd;
    in_block_iterator   itPosition;
};

template <class UNIT, class FILTER>
void
IteratorBase<UNIT,FILTER>::operator++()           /// @precond itPosition != 0
{
    csv_assert(itPosition != 0);
        
    do { 
        Advance(); 
    } while (NOT Check());
}


template <class UNIT, class FILTER>
void
IteratorBase<UNIT,FILTER>::Search_NextValidPosition()
{
    while ( NOT Check() )
    {
        Advance();
    }
}


}   // namespace internal

template <class UNIT>
class RootConstIterator : public internal::IteratorBase< UNIT, internal::IteratorNoFilter >
{
  public:
    // This must be repeated from the base class because of a bug in the 
    //   SunPro 5.2 C++ compiler.
    typedef UNIT                            unit_type;
    typedef RootBlock<UNIT>                 block_type;
    typedef block_type *                    block_iterator;
    typedef typename block_type::iterator   in_block_iterator;
    // END compiler bug

                        RootConstIterator()     {}
                        RootConstIterator(
                            block_iterator      i_itBlock,
                            block_iterator      i_itBlocksEnd,
                            in_block_iterator   i_itPosition )
                            :   internal::IteratorBase< UNIT, internal::IteratorNoFilter >(
                                    i_itBlock, i_itBlocksEnd, i_itPosition )
                            { }


    const unit_type &   operator*() const       /// @precond bool(*this);
                                                { return CurUnit(); }
};



template <class UNIT>
class RootIterator: public internal::IteratorBase< UNIT, internal::IteratorNoFilter >
{
  public:
    // This must be repeated from the base class because of a bug in the 
    //   SunPro 5.2 C++ compiler.
    typedef UNIT                            unit_type;
    typedef RootBlock<UNIT>                 block_type;
    typedef block_type *                    block_iterator;
    typedef typename block_type::iterator   in_block_iterator;
    // END compiler bug

                        RootIterator()      	{}
                        RootIterator(
                            block_iterator      i_itBlock,
                            block_iterator      i_itBlocksEnd,
                            in_block_iterator   i_itPosition )
                            :   internal::IteratorBase< UNIT, internal::IteratorNoFilter >(
                                    i_itBlock, i_itBlocksEnd, i_itPosition )
                            { }

    unit_type &         operator*() const       /// @precond bool(*this);
                                                { return CurUnit(); }
};


template <class UNIT, class FILTER>
class RootFilterConstIterator : public internal::IteratorBase< UNIT, FILTER >
{
  public:
    typedef RootFilterConstIterator<UNIT,FILTER>    self;

                        RootFilterConstIterator(
                            const RootConstIterator<UNIT> &
                                                i_rOther )
                            :    internal::IteratorBase< UNIT, FILTER >(
                                    i_rOther.CurBlock(),
                                    i_rOther.EndBlock(),
                                    i_rOther.CurPosition() ) {}

    const unit_type &   operator*() const       /// @precond bool(*this);
                                                { return CurUnit(); }
    self &              operator=(
                            const RootConstIterator<UNIT> &
                                                i_rOther )
                            { Set(  i_rOther.CurBlock(),
                                    i_rOther.EndBlock(),
                                    i_rOther.CurPosition() );
                              return *this;
                            }
};



template <class UNIT, class FILTER>
class RootFilterIterator : public internal::IteratorBase< UNIT, FILTER >
{
  public:
                        RootFilterIterator(
                            const RootIterator<UNIT> &
                                                i_rOther )
                            :    internal::IteratorBase< UNIT, FILTER >(
                                    i_rOther.CurBlock(),
                                    i_rOther.EndBlock(),
                                    i_rOther.CurPosition() ) {}


    unit_type &         operator*() const       /// @precond bool(*this);
                                                { return CurUnit(); }
    self &              operator=(
                            const RootIterator<UNIT> &
                                                i_rOther )
                            { Set(  i_rOther.CurBlock(),
                                    i_rOther.EndBlock(),
                                    i_rOther.CurPosition() );
                              return *this;
                            }
};



}   // namespace store
}   // namespace ary

#endif

