/*************************************************************************
 *
 *  $RCSfile: di_glbix.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <precomp.h>
#include "di_glbix.hxx"


// NOT FULLY DEFINED SERVICES
#include <algorithm>
#include <csi/l_uidl/service.hxx>
#include <csi/l_uidl/intrface.hxx>
#include <csi/l_uidl/struct.hxx>
#include <csi/l_uidl/except.hxx>
#include <csi/l_uidl/enum.hxx>
#include <csi/l_uidl/typedef.hxx>
#include <csi/l_uidl/constant.hxx>
#include <csi/l_uidl/enumvalu.hxx>
#include <csi/l_uidl/attrib.hxx>
#include <ary_i/uidl/cenamesp.hxx>
#include <ary_i/uidl/gate.hxx>
#include <display/corframe.hxx>
#include "api_file.hxx"
#include <ctype.h>


#ifdef UNX
#define stricmp strcasecmp
#endif


namespace display
{
namespace dsapi
{

udmstri G_sDummy;
uintt   G_nDummy;


GlobalIndex_Docu::GlobalIndex_Docu()
	:	aText(2000)
{
	for ( int i = 0; i < 26; ++i )
	{
		aData[i].reserve(200);
	}  // end for
}


struct S_LessStr
{
  bool	operator()( const udmstri & s1,
					const udmstri & s2 )
					{ return stricmp( s1, s2 ) < 0; } 
};


const char *	sTypeNames[GlobalIndex_Docu::t_MAX ] =
					{ "service ", "interface ", "struct ", "exception ", "enum ",
					  "typedef ", "constants group ", "property ", "method ", "field ",
					  "value ", "constant "
					};

GlobalIndex_Docu::~GlobalIndex_Docu()
{
}

const char C_cSplit = '#';


void
GlobalIndex_Docu::WriteOut(	Html_MultiPiece & o_rOut,
							char			  i_cLetter )
{
	Entry & rLetter = aData[i_cLetter-'a'];
	static S_LessStr aLess;
	std::sort( rLetter.begin(), rLetter.end(), aLess );

    o_rOut.AddData( TextWH("<DL>\n") );

	for ( Entry::iterator iter = rLetter.begin();
		  iter != rLetter.end();
		  ++iter )
	{
		aText.seekp(0);
		aText << "<DT><A HREF=\"../";
		int nSplit = strchr((*iter).c_str(),C_cSplit) - (*iter).c_str();

		StreamLock slPath(200);
        slPath() << ((*iter).c_str() + nSplit + 1);
		int nTypePos = slPath().length() - 1;
		int nType = slPath().c_str()[nTypePos] - 'A';
		slPath().pop_back(1);
		slPath().replace_all("::","/");

        StreamLock slIter(200);
        slIter() << (*iter);
		slIter().pop_back( slIter().length() - (nTypePos+nSplit+1) );
		slIter().replace_all(C_cSplit,'\0');
        *iter = slIter().c_str();

		if (nType < 7)
		{
			aText << slPath().c_str() << (*iter) << ".html\">"
				  << "<B>" << (*iter) << "</B></A> - \n"
				  << sTypeNames[nType]
                  << ".<A NAME=\"\">" << (*iter) << "</A>"
//                << " in " << ( (*iter) + nSplit + 1 )
                  << "\n<DD>&nbsp\n";
		}
		else
		{
			aText << slPath().c_str() << ".html#" << (*iter) << "\">"
				  << "<B>" << (*iter) << "</B></A> - \n"
				  << sTypeNames[nType]
                  << ".<A NAME=\"\">" << (*iter) << "</A>"
//                << " in " << ( (*iter) + nSplit + 1 )
                  << "\n<DD>&nbsp\n";
		}
		o_rOut.AddData( TextWH(aText.c_str()) );
	} 	// end for

    o_rOut.AddData( TextWH("</DL>\n") );
}

void
GlobalIndex_Docu::Add_Service( const udmstri & i_sName )
{
	StoreString( i_sName, t_service );
}

void
GlobalIndex_Docu::Add_Interface( const udmstri & i_sName )
{
	StoreString( i_sName, t_interface );
}

void
GlobalIndex_Docu::Add_Struct( const udmstri & i_sName )
{
	StoreString( i_sName, t_struct );
}

void
GlobalIndex_Docu::Add_Exception( const udmstri & i_sName )
{
	StoreString( i_sName, t_exception );
}

void
GlobalIndex_Docu::Add_Function( const udmstri & i_sName )
{
	StoreString( i_sName, t_function, true );
}

void
GlobalIndex_Docu::Add_StructElement( const udmstri & i_sName )
{
	StoreString( i_sName, t_structelement, true );
}

void
GlobalIndex_Docu::Add_Property( const udmstri & i_sName )
{
	StoreString( i_sName, t_property, true );
}

void
GlobalIndex_Docu::Add_Enum( const udmstri & i_sName )
{
	StoreString( i_sName, t_enum );
}

void
GlobalIndex_Docu::Add_Typedef( const udmstri & i_sName )
{
	StoreString( i_sName, t_typedef );
}

void
GlobalIndex_Docu::Add_ConstantsGroup( const udmstri & i_sName )
{
	StoreString( i_sName, t_constantsgroup );
}

void
GlobalIndex_Docu::Add_Constant( const udmstri & i_sName )
{
	StoreString( i_sName, t_constant, true );
}

void
GlobalIndex_Docu::Add_EnumValue( const udmstri & i_sName )
{
	StoreString( i_sName, t_enumvalue, true );
}

void
GlobalIndex_Docu::StoreString( const udmstri &		i_sName,
							   E_Types				i_eType,
							   bool					i_bUseOwner )
{
	aText.seekp(0);
	aText << i_sName << C_cSplit;
	aText << sCurModule << "::";
	if (i_bUseOwner)
	{
		aText << sCurOwner;
	}

	aText << char('A'+char(i_eType));

	int nBegin = tolower(aText.c_str()[0]);
	if (nBegin >= 'a' AND nBegin <= 'z')
		aData[nBegin-'a'].push_back(aText.c_str());
}


}   // namespace dsapi
}   // namespace display


