/*************************************************************************
 *
 *  $RCSfile: di_syntx.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <precomp.h>
#include "di_syntx.hxx"


// NOT FULLY DEFINED SERVICES
#include <csi/l_uidl/service.hxx>
#include <csi/l_uidl/intrface.hxx>
#include <csi/l_uidl/struct.hxx>
#include <csi/l_uidl/function.hxx>
#include <csi/l_uidl/struelem.hxx>
#include <csi/l_uidl/attrib.hxx>
#include <csi/l_uidl/except.hxx>
#include <csi/l_uidl/enum.hxx>
#include <csi/l_uidl/enumvalu.hxx>
#include <csi/l_uidl/typedef.hxx>
#include <csi/l_uidl/constant.hxx>
#include <ary_i/codeinf2.hxx>




namespace display
{
namespace dsapi
{


SyntaxDocu::~SyntaxDocu()
{

}

void
SyntaxDocu::Display_Service( const Service & 		 i_rData,
							 const CodeInformation * i_rDocu )
{
	CheckDeprecated(i_rDocu);
	DisplaySyntax( &TextOH("service "),
				   &TextOH(i_rData.Name()),
				   0
				 );
}

void
SyntaxDocu::Display_Interface( const Interface & 		i_rData,
							   const CodeInformation * 	i_rDocu )
{
	CheckDeprecated(i_rDocu);
	DisplaySyntax( &TextOH("interface "),
				   &TextOH(i_rData.Name()),
				   FullNameTypeLink( i_rData.Base().Id() )
				 );
}

void
SyntaxDocu::Display_Struct( const Struct &			i_rData,
							const CodeInformation * i_rDocu )
{
	CheckDeprecated(i_rDocu);
	DisplaySyntax( &TextOH("struct "),
				   &TextOH(i_rData.Name()),
				   FullNameTypeLink( i_rData.Base().Id() )
				 );
}

void
SyntaxDocu::Display_Exception( const Exception &	   i_rData,
							   const CodeInformation * i_rDocu )
{
	CheckDeprecated(i_rDocu);
	DisplaySyntax( &TextOH("exception "),
				   &TextOH(i_rData.Name()),
				   FullNameTypeLink( i_rData.BaseException().Id() )
				 );
}

void
SyntaxDocu::Display_Function( const Function &			i_rData,
							  const CodeInformation *	i_rDocu )
{
	CheckDeprecated(i_rDocu);
	DYN Html_DefList * dpDefList = new Html_DefList;
	dpDefList->AddTerm( *new Html_AnyTag( TextOH("Syntax"),"H4") );

	DYN Html_DefList * dpFunc = new Html_DefList;
	DYN Html_MultiPiece * dpName = new Html_MultiPiece;
	DYN Html_MultiPiece * dpParam = new Html_MultiPiece;

	if (i_rData.IsConst())
		dpName->AddData( TextWH("const ") );
	if (i_rData.IsOneway())
		dpName->AddData( TextWH("oneway ") );
	dpName->AddData( *FullNameTypeLink(i_rData.ReturnType().Id()) );
	dpName->AddData( TextWH("  ") );
	dpName->AddData( *new Html_AnyTag( TextOH(i_rData.Name()),"B") );

	// Parameters:
	if (i_rData.Parameters().size() > 0)
	{
		dpName->AddData( TextWH("( ") );
		dpFunc->AddTerm(*dpName);
		for ( Function::ParameterList::const_iterator
					iter = i_rData.Parameters().begin();
			  iter != i_rData.Parameters().end();
			  ++iter )
		{
			if (iter != i_rData.Parameters().begin())
			{
				dpParam->AddData( TextWH(", ") );
				dpFunc->AddDefinition(*dpParam);
				dpParam = new Html_MultiPiece;
			}
			dpParam->AddData( *FullNameTypeLink( (*iter).Type().Id() ) );
			dpParam->AddData( TextWH(" ") );
			dpParam->AddData( TextOH( (*iter).Name()) );
		}
		if (i_rData.Exceptions().size() == 0)
		{
			dpParam->AddData( TextWH(" );") );
			dpFunc->AddDefinition(*dpParam);
			dpParam = 0;
		}
		else
		{
			dpParam->AddData( TextWH(" )") );
			dpFunc->AddDefinition(*dpParam);
			dpParam = new Html_MultiPiece;
		}
	}
	else
	{
		dpName->AddData( TextWH("();") );
		dpFunc->AddTerm(*dpName);
		if (i_rData.Exceptions().size() == 0)
			delete dpParam;
	}  // endif

	// Exceptions:
	if (i_rData.Exceptions().size() > 0)
	{
		dpParam->AddData( TextWH(" raises ( ") );

		for ( Function::ExceptionList::const_iterator
					iter = i_rData.Exceptions().begin();
			  iter != i_rData.Exceptions().end();
			  ++iter )
		{
			if (iter != i_rData.Exceptions().begin())
				dpParam->AddData( TextWH(", ") );
			dpParam->AddData( *FullNameTypeLink( (*iter).Id() ) );
		}
		dpParam->AddData( TextWH(" );") );
		dpFunc->AddDefinition(*dpParam);
		dpParam = 0;
	}

	dpDefList->AddDefinition( *dpFunc );
	Destination().AddData( *dpDefList );
}

void
SyntaxDocu::Display_StructElement( const StructElement & 	i_rData,
								   const CodeInformation * 	i_rDocu  )
{
	CheckDeprecated(i_rDocu);
	DisplaySyntax( FullNameTypeLink(i_rData.Type().Id()),
				   &TextOH(i_rData.Name()) );
}

void
SyntaxDocu::Display_Attribute( const Attribute & 	     i_rData,
							   const CodeInformation * 	 i_rDocu  )
{
	CheckDeprecated(i_rDocu);
	DisplaySyntax( FullNameTypeLink(i_rData.Type().Id()),
				   &TextOH(i_rData.Name()),
				   0,
				   i_rData.IsReadonly() );
}

void
SyntaxDocu::Display_Enum( const Enum &				i_rData,
						  const CodeInformation *   i_rDocu )
{
	CheckDeprecated(i_rDocu);
	DisplaySyntax( &TextOH("enum "),
				   &TextOH(i_rData.Name()) );
}

void
SyntaxDocu::Display_Typedef( const Typedef &			i_rData,
							 const CodeInformation *	i_rDocu )
{
	CheckDeprecated(i_rDocu);
	DYN Html_DefList * dpDefList = new Html_DefList;
	dpDefList->AddTerm( *new Html_AnyTag( TextOH("Syntax"),"H4") );

	DYN Html_MultiPiece * dpText = new Html_MultiPiece;
	dpText->AddData( TextWH("typedef "));
	csv_assert(i_rData.DefiningType().Id() != 0);
	dpText->AddData( *FullNameTypeLink(i_rData.DefiningType().Id()) );
	dpText->AddData( TextOH(" ") );
	dpText->AddData( TextOH(i_rData.Name()) );
	dpText->AddData( TextOH(";") );

	dpDefList->AddDefinition( *new Html_AnyTag(*dpText,"PRE") );
	Destination().AddData( *dpDefList );
}

void
SyntaxDocu::Display_ConstantsGroup( const ConstantsGroup &  i_rData,
									const CodeInformation * i_rDocu )
{
	CheckDeprecated(i_rDocu);
	DisplaySyntax( &TextOH("constants group "),
				   &TextOH(i_rData.Name()) );
}

void
SyntaxDocu::Display_Constant( const Constant & 			i_rData,
							  const CodeInformation *   i_rDocu )
{
	CheckDeprecated(i_rDocu);
	DYN Html_DefList * dpDefList = new Html_DefList;
	dpDefList->AddTerm( *new Html_AnyTag( TextOH("Syntax"),"H4") );

	DYN Html_MultiPiece * dpText = new Html_MultiPiece;
	dpText->AddData( TextWH("const "));
	csv_assert(i_rData.Type().Id() != 0);
	dpText->AddData( *FullNameTypeLink(i_rData.Type().Id()) );
	dpText->AddData( TextOH(" ") );
	dpText->AddData( TextOH(i_rData.Name()) );
	dpText->AddData( TextOH(" ") );
	dpText->AddData( TextOH(i_rData.Value()) );

	dpDefList->AddDefinition( *new Html_AnyTag(*dpText,"PRE") );
	Destination().AddData( *dpDefList );
}

void
SyntaxDocu::Display_EnumValue( const EnumValue &		i_rData,
							   const CodeInformation * 	i_rDocu  )
{
	CheckDeprecated(i_rDocu);
	DYN Html_DefList * dpDefList = new Html_DefList;
	dpDefList->AddTerm( *new Html_AnyTag( TextOH("Syntax"),"H4") );

	DYN Html_MultiPiece * dpText = new Html_MultiPiece;
	dpText->AddData( TextOH(i_rData.Name()) );
	if ( i_rData.Value().length() > 0 )
	{
		dpText->AddData( TextOH(" ") );
		dpText->AddData( TextOH(i_rData.Value()) );
	}
	else
		dpText->AddData( TextOH(",") );

	dpDefList->AddDefinition( *new Html_AnyTag(*dpText,"PRE") );
	Destination().AddData( *dpDefList );
}

void
SyntaxDocu::DisplaySyntax( DYN HtmlPiece *	i_sType,
						   DYN HtmlPiece *	i_sName,
						   DYN HtmlPiece *	let_dpBase,
						   bool				i_bReadonly )
{
	DYN Html_DefList * dpDefList = new Html_DefList;
	dpDefList->AddTerm( *new Html_AnyTag( TextOH("Syntax"),"H4") );

	DYN Html_MultiPiece * dpText = new Html_MultiPiece;
	if (i_bReadonly)
		dpText->AddData( TextOH("[readonly] ") );
	dpText->AddData( *i_sType );
	dpText->AddData( *i_sName );
	if (let_dpBase != 0)
	{
		dpText->AddData( TextOH(" : ") );
		dpText->AddData( *let_dpBase );
	}
	dpText->AddData( TextOH(";") );

	dpDefList->AddDefinition( *new Html_AnyTag(*dpText,"PRE") );
	Destination().AddData( *dpDefList );
}

void
SyntaxDocu::CheckDeprecated( const CodeInformation * i_pDocu )
{
	if (i_pDocu == 0)
		return;
	if (i_pDocu->IsDeprecated())
	{
		Destination().AddData( TextWH(" [ DEPRECATED ]") );
	}
}

#if 0   // obsolete
void
SyntaxDocu::CheckOptional( const CodeInformation * i_pDocu )
{
	if (i_pDocu == 0)
		return;
	if (i_pDocu->IsOptional())
	{
		Destination().AddData( TextWH(" [ OPTIONAL ]") );
	}
}
#endif // 0


}   // namespace dsapi
}   // namespace display

