/*************************************************************************
 *
 *  $RCSfile: di_whole.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ADC_DISPLAY_DI_WHOLE_HXX
#define ADC_DISPLAY_DI_WHOLE_HXX



// USED SERVICES
	// BASE CLASSES
#include "didl_def.hxx"
#include "dht_impl.hxx"
	// COMPONENTS
	// PARAMETERS
#include <csi/l_uidl/service.hxx>


class CorporateFrame;

namespace display
{
namespace dsapi
{


class UnoApiDocuFile;
class GlobalIndex_Docu;

struct S_ActiveModule
{
	udmstri		sName;           // Name
	StreamStr	sRelativePath;
	udmstri		sDirectory;
	uintt		nSubLevel;       // Levels below docu root directory

				S_ActiveModule( udmstri sn, udmstri sp, udmstri sd, uintt nl )
					:	sName(sn), sRelativePath(50), sDirectory(sd), nSubLevel(nl) { sRelativePath << sp; }
};

class WholeDisplay : public DefaultedDisplay,
					 public HtmlDisplay_Impl
{
  public:
						WholeDisplay(
							const udmstri &		i_sOutputDir,
							const CorporateFrame &
												i_rFrame );
	virtual				~WholeDisplay();

	virtual void		WriteGlobalIndices();

	virtual void		InitModule(
							const char *		i_sModule,
							const char *		i_sPath,
							uintt				i_nDepth );

	virtual void	  	Display_Module(
							const ary::uidl::CeNamespace &
												i_rData,
							const CodeInformation *
												i_rDocu );
	virtual void	  	Display_Service(
							const Service &		i_rData,
							const CodeInformation *
												i_rDocu );
	virtual void	  	Display_Interface(
							const Interface & 	i_rData,
							const CodeInformation *
												i_rDocu );
	virtual void	  	Display_Struct(
							const Struct &		i_rData,
							const CodeInformation *
												i_rDocu );
	virtual void	  	Display_Exception(
							const Exception &	i_rData,
							const CodeInformation *
												i_rDocu );
	virtual void	  	Display_Enum(
							const Enum &		i_rData,
							const CodeInformation *
												i_rDocu );
	virtual void	  	Display_Typedef(
							const Typedef &		i_rData,
							const CodeInformation *
												i_rDocu );
	virtual void	  	Display_ConstantsGroup(
							const ConstantsGroup &
												i_rData,
							const CodeInformation *
												i_rDocu );
  private:
	typedef StringVector NameList;

	Html_MultiPiece *	Show_DetailsHeader(
							const char *		i_sTitle );
	void				Show_IndexOfAType(
							const char * 				i_sTitle,
							NameList &	                i_rNames,
							const ary::uidl::CeNamespace &
														i_rModule );
	void				InitNewFile(
							const udmstri &		i_sFileName );
	void				FinishFile();
	void				StartGlobalIndexFile(
                        	char				i_cLetter );

	void				GetExtern_ExportsDocu(
                        	csi::uidl::Service::CommentedLinkList::iterator
                                                i_it );

	// DATA
	udmstri				sOutputDir;
    udmstri				sPackageList;
	Dyn<UnoApiDocuFile>	pMyFile;
	const CorporateFrame *
						pFrame;
	Dyn<S_ActiveModule> pActiveModule;
	DYN GlobalIndex_Docu *
						dpGlobalIndex;
};


}   // namespace dsapi
}   // namespace display


#endif

