/*************************************************************************
 *
 *  $RCSfile: oodbarea.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef OODB_OODBAREA_HXX
#define OODB_OODBAREA_HXX

// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
// #include <template\dicty.hxx>
// #include <template\listinbl.hxx>
#include <cosv\cosvfile.hxx>
#include <template\bin_list.hxx>
#include <oodb\oodbimpl.hxx>
	// PARAMETERS
#include <oodb\odbtypes.hxx>
class DiskLocation;




struct S_AreaOnCallData;

class OodbArea
{
  public:
	// LIFECYCLE
	virtual				~OodbArea() {}

	virtual void		RemoveAllFiles(
							const DiskLocation&	i_rDirectory ) = 0;

	// OPERATIONS
	virtual void		PutOnCall(
							const DiskLocation&	i_rDirectory ) = 0;
	virtual void	 	ReleaseOnCall() = 0;

	virtual OodbLocalId	GetNewId() = 0;

	virtual bool	   	Start_AddObject(
							OodbLocalId         i_nObject ) = 0;
	virtual bool	   	Finish_AddObject(
							OodbLocalId         i_nObject ) = 0;
	virtual bool	   	Start_UpdateObject(
							OodbLocalId 		i_nObject ) = 0;
	virtual bool	   	Finish_UpdateObject(
							OodbLocalId 		i_nObject ) = 0;
	virtual bool	   	DeleteObject(
							OodbLocalId			i_nObject ) = 0;
	virtual bool	   	OpenObject(
							OodbLocalId			i_nObject ) = 0;
	virtual bool	   	CloseObject() = 0;

	// INQUIRY
	virtual bool		DoesExist_LocalId(
							OodbLocalId			i_nObject ) = 0;
	virtual bool		IsOnCall() const = 0;
	virtual const String &
						Name() const = 0;
	virtual OodbAreaNr	Nr() const = 0;
	virtual CosvFile *	DataFile() const = 0;

	intt				key() const;       		/// @return nNr
};



class SimpleArea : public OodbArea
{
  public:
	// LIFECYCLE
						SimpleArea(
							const String &		i_sName,
							intt				i_nNr );
	virtual				~SimpleArea();
	virtual void	   	RemoveAllFiles(
							const DiskLocation&	i_rDirectory );

	// OPERATIONS
	virtual void	   	PutOnCall(
							const DiskLocation&	i_rDirectory );
	virtual void	   	ReleaseOnCall();

	virtual OodbLocalId	GetNewId();

	virtual bool	   	Start_AddObject(
							OodbLocalId         i_nObject );
	virtual bool	   	Finish_AddObject(
							OodbLocalId         i_nObject );
	virtual bool	   	Start_UpdateObject(
							OodbLocalId 		i_nObject );
	virtual bool	   	Finish_UpdateObject(
							OodbLocalId 		i_nObject );
	virtual bool	   	DeleteObject(
							OodbLocalId			i_nObject );
	virtual bool	   	OpenObject(
							OodbLocalId			i_nObject );
	virtual bool	   	CloseObject();

	// INQUIRY
	virtual bool		DoesExist_LocalId(
							OodbLocalId			i_nObject );
	virtual bool		IsOnCall() const;
	virtual const String &
						Name() const;
	virtual OodbAreaNr	Nr() const;
	virtual CosvFile *	DataFile() const;

  private:
	bool				Internal_CheckLocalId(
							OodbLocalId			i_nObject );

	String				sName;
	OodbAreaNr			nNr;
	DYN S_AreaOnCallData *
						pOnCallData;
	intt				nUseMeasure;
};


class Area_ofFileObjects : public OodbArea
{
  public:
						Area_ofFileObjects(
							const DiskLocation &
												i_rDirectory);
						~Area_ofFileObjects();

	virtual void		RemoveAllFiles(
							const DiskLocation &
												i_rDirectory);

	// OPERATIONS
	virtual void		PutOnCall(
							const DiskLocation &
												i_rDirectory );
	virtual void	 	ReleaseOnCall();

	virtual OodbLocalId	GetNewId();

	virtual bool	   	Start_AddObject(
							OodbLocalId         i_nObject );
	virtual bool	   	Finish_AddObject(
							OodbLocalId         i_nObject );
	virtual bool	   	Start_UpdateObject(
							OodbLocalId 		i_nObject );
	virtual bool	   	Finish_UpdateObject(
							OodbLocalId 		i_nObject );
	virtual bool	   	DeleteObject(
							OodbLocalId			i_nObject );
	virtual bool	   	OpenObject(
							OodbLocalId			i_nObject );
	virtual bool	   	CloseObject();

	// INQUIRY
	virtual bool		DoesExist_LocalId(
							OodbLocalId			i_nObject );
	virtual bool		IsOnCall() const;
	virtual const String &
						Name() const;
	virtual OodbAreaNr	Nr() const;
	virtual CosvFile *	DataFile() const;

  private:
	bool    			AssignLocalId2File(
							OodbLocalId			i_nId,
							bool                i_bMustExist );
	void    			MakeFileLocation(
							DiskLocation &		o_rLoc,
							OodbLocalId			i_nId );

	CosvFile			aDataFile;
	FreeNumbers	   		aFreeIds;
	DiskLocation		aDirectory;
	OodbLocalId			nActiveId;
};



struct S_AreaOnCallData
{
						S_AreaOnCallData(
							const DiskLocation& i_rDirectory,
							intt		        i_nAreaNr );
						~S_AreaOnCallData();

	ListInBlocks<S_ObjectPosition>
						aIndex;
	CosvFile			aDataFile;
	FreeNumbers	   		aFreeIds;

  private:
	bool				LoadIndex();
	bool				SaveIndex();
};



inline intt
OodbArea::key() const
	{ return Nr(); }





#endif

