/*************************************************************************
 *
 *  $RCSfile: serilize.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef OODB_SERILIZE_HXX
#define OODB_SERILIZE_HXX

// USED SERVICES
	// BASE CLASSES
#include <cosv/x_any.hxx>
	// COMPONENTS
	// PARAMETERS
#include <template/iterator.hxx>
#include <template/coll_t.hxx>
#include <template/dyn.hxx>
#include <oodb/srialdev.hxx>
#include <oodb/srialdev.hxx>


class Reflected;
class DiskLocation;

/*					How To Serialize
					----------------

	Any object can be serialized and deserialized just by
	calling

	void Serialize(SerialDevice &, const OBJ &);

	and

	void Deserialize(SerialDevice &, OBJ &);

	These functions are implemented for the primitive types,
	for derivates of class Reflected and derivates of
	class Collection. For any other types the above two functions
	need to be implemented. 


	If OBJ is a polymorphic pointer type, the functions

	intt SerializationId_ofPtrType(SerialDevice &, const XX *);

	and

	void CreateSerializedPtr(XX * &, intt);

	must be implemented for "XX", which must be the type to which
	"OBJ" is a pointer to.
*/


// Reflected classes
void				Serialize(
						SerialDevice &		o_rDest,
						const Reflected &   x );
void				Deserialize(
						SerialDevice &		io_rSrc,
						Reflected &         o_x );

// Collections
template <class ELEM>
void				Serialize(
						SerialDevice &		o_rDest,
						const Collection<ELEM> &
											x );
template <class ELEM>
void				Deserialize(
						SerialDevice &		io_rSrc,
						Collection<ELEM> &	o_x );


// Pointers
template <class OBJ>
void				Serialize(
						SerialDevice &		o_rDest,
						const Dyn<OBJ> &	x );
template <class OBJ>
void				Deserialize(
						SerialDevice &		io_rSrc,
						Dyn<OBJ>  &			o_x );


// Primitive Types
void				Serialize(
						SerialDevice &		o_rDest,
						const char &        x );
void				Serialize(
						SerialDevice &		o_rDest,
						const signed char & x);
void				Serialize(
						SerialDevice &		o_rDest,
						const unsigned char &
											x);
void				Serialize(
						SerialDevice &		o_rDest,
						const INT16 &       x);
void				Serialize(
						SerialDevice &		o_rDest,
						const UINT16 &      x);
void				Serialize(
						SerialDevice &		o_rDest,
						const INT32 &       x);
void				Serialize(
						SerialDevice &		o_rDest,
						const UINT32 &      x);
void				Serialize(
						SerialDevice &		o_rDest,
						const REAL32 &      x);
void				Serialize(
						SerialDevice &		o_rDest,
						const REAL64 &      x);
void				Serialize(
						SerialDevice &		o_rDest,
						const String &      x);
#ifndef _NO_BOOL_TYPE_
void				Serialize(
						SerialDevice &		o_rDest,
						const bool &        x);
#endif


void				Deserialize(
						SerialDevice &		io_rSrc,
						char &        x );
void				Deserialize(
						SerialDevice &		io_rSrc,
						signed char & x);
void				Deserialize(
						SerialDevice &		io_rSrc,
						unsigned char &
											x);
void				Deserialize(
						SerialDevice &		io_rSrc,
						INT16 &       x);
void				Deserialize(
						SerialDevice &		io_rSrc,
						UINT16 &      x);
void				Deserialize(
						SerialDevice &		io_rSrc,
						INT32 &       x);
void				Deserialize(
						SerialDevice &		io_rSrc,
						UINT32 &      x);
void				Deserialize(
						SerialDevice &		io_rSrc,
						REAL32 &      x);
void				Deserialize(
						SerialDevice &		io_rSrc,
						REAL64 &      x);
void				Deserialize(
						SerialDevice &		io_rSrc,
						String &      x);
#ifndef _NO_BOOL_TYPE_
void				Deserialize(
						SerialDevice &		io_rSrc,
						bool &        x);
#endif


// Other common types
void				Serialize(
						SerialDevice &		o_rDest,
						const DiskLocation& x );
void				Deserialize(
						SerialDevice &		io_rSrc,
						DiskLocation &      x );




// Help functions for virtual types

// As a default returns 1.  type_id
template <class XX>
intt				SerializationId_ofPtrType(
						const Dyn<XX> &		i_p );


// As a default returns an object of type XX on the heap.
template <class XX>
void		  		CreateSerializedPtr(
						Dyn<XX> &			o_dpx,
						intt				i_nPtrTypeId);



// Exception definition
class Serialize_Exception : public Any_Exception
{
  public:
	enum E_Error
	{
		unknown = 0,
		cant_read_collection,
		cant_create_dynamicvar,
		MAX_ERROR
	};
						Serialize_Exception(
							E_Error				i_eError)
							:	eError(0 < i_eError && i_eError < MAX_ERROR ? i_eError : unknown)
							{ sInfo = sErrorTexts_[eError]; }
  private:
	E_Error				eError;
	static String		sErrorTexts_[MAX_ERROR];
};



// Implementation of templates

template <class ELEM>
void
Serialize( SerialDevice &		    o_rDest,
		   const Collection<ELEM> &	x )
{
	o_rDest.Put(x.Size());
	for ( CIterator<ELEM> aIter = x.Begin();
		  aIter;
		  ++aIter )
	{
		Serialize(o_rDest,*aIter);
	}   // end for
}

template <class ELEM>
void
Deserialize( SerialDevice &		io_rSrc,
			 Collection<ELEM> &	o_x )
{
	intt nSize = 0;
	io_rSrc.Get(nSize);


	Growable<ELEM> * pGrow = o_x.AsGrowable();
	if (pGrow != 0)
	{
		ELEM aElement;
		pGrow->Empty();
		for (int i = 0; i < nSize; i++)
		{
			// Sequence of lines is important, because so
			//   also dynamic pointers as ELEM are handled
			// 	 correct!
			ELEM & rAim = pGrow->Add(aElement);
			Deserialize(io_rSrc,rAim);
		}  // end for
	}
	else
	{
		Settable<ELEM> * pSett = o_x.AsSettable();
		if (pSett == 0)
			throw Serialize_Exception(Serialize_Exception::cant_read_collection);
		pSett->SetSize(nSize);

		for ( Iterator<ELEM> aIter = o_x.Begin();
			  aIter;
			  ++aIter )
		{
			Deserialize(io_rSrc,*aIter);
		}	// end for
	}	// endif (pGrow != 0) else
}


template <class OBJ>
void
Serialize( SerialDevice &  		o_rDest,
		   const Dyn<OBJ> &   	x )
{
	intt nPtrType = (x ? SerializationId_ofPtrType(x) : 0);
	o_rDest.Put(nPtrType);

	if (x)
		Serialize(o_rDest,*x);
}

template <class OBJ>
void
Deserialize( SerialDevice &	io_rSrc,
			 Dyn<OBJ> &     o_x )
{
	intt  nPtr = 0;
	io_rSrc.Get(nPtr);

	if (o_x)
		o_x = 0;

	if (nPtr != 0)
	{
		CreateSerializedPtr(o_x,nPtr);
		if (o_x == 0)
			throw Serialize_Exception(Serialize_Exception::cant_create_dynamicvar);
		Deserialize(io_rSrc,*o_x);
	}
	else
	{
		o_x = 0;
	}
}


#endif

