/*************************************************************************
 *
 *  $RCSfile: srialdev.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef OODB_SRIALDEV_HXX
#define OODB_SRIALDEV_HXX


// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS

/**	@task
**/
ifc_class SerialDevice
{
  public:
	// LIFEYCLE
	virtual				~SerialDevice();

	// OPERATORS

	// OPERATIONS
	void				PutElementId(
							UINT8			i_nElementId);
	void				PutSchemeId(
							intt			i_nSchemeId);
	UINT8				GetElementId();
	intt				GetSchemeId();

	void				Put(
							UINT8 				i_nElementId,
							const char &        x );
	void				Put(
							UINT8 				i_nElementId,
							const signed char & x);
	void				Put(
							UINT8 				i_nElementId,
							const unsigned char &
												x);
	void				Put(
							UINT8 				i_nElementId,
							const INT16 &       x);
	void				Put(
							UINT8 				i_nElementId,
							const UINT16 &      x);
	void				Put(
							UINT8 				i_nElementId,
							const INT32 &       x);
	void				Put(
							UINT8 				i_nElementId,
							const UINT32 &      x);
	void				Put(
							UINT8 				i_nElementId,
							const REAL32 &      x);
	void				Put(
							UINT8 				i_nElementId,
							const REAL64 &      x);
	void				Put(
							UINT8 				i_nElementId,
							const String &      x);
#ifndef _CSV_NO_BOOL_TYPE_
	void				Put(
							UINT8 				i_nElementId,
							const bool &        x);
#endif
	void				PutRawData(
							UINT8 				i_nElementId,
							const void *      	i_pData,
							UINT32				i_nSize);

	void				Put(
							const char &        x );
	void				Put(
							const signed char & x);
	void				Put(
							const unsigned char &
												x);
	void				Put(
							const INT16 &       x);
	void				Put(
							const UINT16 &      x);
	void				Put(
							const INT32 &       x);
	void				Put(
							const UINT32 &      x);
	void				Put(
							const REAL32 &      x);
	void				Put(
							const REAL64 &      x);
	void				Put(
							const String &      x);
#ifndef _CSV_NO_BOOL_TYPE_
	void				Put(
							const bool &        x);
#endif
	void				PutRawData(
							const void *      	i_pData,
							UINT32				i_nSize);

	void				Get(
							char &              x);
	void				Get(
							signed char &       x);
	void				Get(
							unsigned char &     x);
	void				Get(
							INT16 &             x);
	void				Get(
							UINT16 &            x);
	void				Get(
							INT32 &             x);
	void				Get(
							UINT32 &            x);
	void				Get(
							REAL32 &            x);
	void				Get(
							REAL64 &            x);
	void				Get(
							String &            x);
#ifndef _CSV_NO_BOOL_TYPE_
	void				Get(
							bool &              x);
#endif
	void				GetRawData(
							void *      		o_pData,
							UINT32 &			o_rSize);

	// INQUIRY
	virtual bool	 	EndOfData() const = 0;

  protected:
	virtual void	  	Write(
							const void *		i_pData,
							UINT32				i_nSize ) = 0;
	virtual void	  	Read(
							void *				o_pData,
							UINT32				i_nSize ) = 0;
};


// Implementierung
inline void
SerialDevice::PutElementId(UINT8 i_nElementId)
	{ Write(&i_nElementId,1); }
inline void
SerialDevice::PutSchemeId(intt i_nSchemeId)
	{ Write(&i_nSchemeId,4);}
inline void
SerialDevice::Put(UINT8 i_nElem, const char & x)
	{ Write(&i_nElem,1); Write(&x,1); }
inline void
SerialDevice::Put(UINT8 i_nElem, const signed char & x)
	{ Write(&i_nElem,1); Write(&x,1); }
inline void
SerialDevice::Put(UINT8 i_nElem, const unsigned char & x)
	{ Write(&i_nElem,1); Write(&x,1); }
inline void
SerialDevice::Put(UINT8 i_nElem, const INT16 & x)
	{ Write(&i_nElem,1); Write(&x,2); }
inline void
SerialDevice::Put(UINT8 i_nElem, const UINT16 & x)
	{ Write(&i_nElem,1); Write(&x,2); }
inline void
SerialDevice::Put(UINT8 i_nElem, const INT32 & x)
	{ Write(&i_nElem,1); Write(&x,4); }
inline void
SerialDevice::Put(UINT8 i_nElem, const UINT32 & x)
	{ Write(&i_nElem,1); Write(&x,4); }
inline void
SerialDevice::Put(UINT8 i_nElem, const REAL32 & x)
	{ Write(&i_nElem,1); Write(&x,4); }
inline void
SerialDevice::Put(UINT8 i_nElem, const REAL64 & x)
	{ Write(&i_nElem,1); Write(&x,8); }
#ifndef _CSV_NO_BOOL_TYPE_
inline void
SerialDevice::Put(UINT8 i_nElem, const bool & x)
	{ UINT8 persx = UINT8(x ? 1 : 0); Write(&i_nElem,1); Write(&persx,1; }
#endif
inline void
SerialDevice::PutRawData( UINT8 	   i_nElem,
						  const void * i_pData,
						  UINT32	   i_nSize)
	{ Write(&i_nElem,1); Write(&i_nSize,4); Write(i_pData,i_nSize); }


inline void
SerialDevice::Put(const char & x)
	{ Write(&x,1); }
inline void
SerialDevice::Put(const signed char & x)
	{ Write(&x,1); }
inline void
SerialDevice::Put(const unsigned char & x)
	{ Write(&x,1); }
inline void
SerialDevice::Put(const INT16 & x)
	{ Write(&x,2); }
inline void
SerialDevice::Put(const UINT16 & x)
	{ Write(&x,2); }
inline void
SerialDevice::Put(const INT32 & x)
	{ Write(&x,4); }
inline void
SerialDevice::Put(const UINT32 & x)
	{ Write(&x,4); }
inline void
SerialDevice::Put(const REAL32 & x)
	{ Write(&x,4); }
inline void
SerialDevice::Put(const REAL64 & x)
	{ Write(&x,8); }
#ifndef _CSV_NO_BOOL_TYPE_
inline void
SerialDevice::Put(const bool & x)
	{ UINT8 persx = UINT8(x ? 1 : 0); Write(&persx,1; }
#endif
inline void
SerialDevice::PutRawData( const void * i_pData,
						  UINT32	   i_nSize)
	{ Write(&i_nSize,4); Write(i_pData,i_nSize); }



inline void
SerialDevice::Get(char & x)				{ Read(&x,1); }
inline void
SerialDevice::Get(signed char & x)		{ Read(&x,1); }
inline void
SerialDevice::Get(unsigned char & x)	{ Read(&x,1); }
inline void
SerialDevice::Get(INT16 & x)		    { Read(&x,2); }
inline void
SerialDevice::Get(UINT16 & x)	        { Read(&x,2); }
inline void
SerialDevice::Get(INT32 & x)		    { Read(&x,4); }
inline void
SerialDevice::Get(UINT32 & x)	        { Read(&x,4); }
inline void
SerialDevice::Get(REAL32 & x)	        { Read(&x,4); }
inline void
SerialDevice::Get(REAL64 & x)	        { Read(&x,8); }
#ifndef _CSV_NO_BOOL_TYPE_
inline void
SerialDevice::Get(bool & x)		        { UINT8 persx = 0; Read(&persx,1); x = persx ? true : false; }
#endif
inline void
SerialDevice::GetRawData( void * 	o_pData,
						  UINT32 & 	o_rSize )
	{ Read(&o_rSize,4); Read(o_pData,o_rSize); }


#endif


