#*************************************************************************
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.14 $
#
#   last change: $Author: kr $ $Date: 2001/05/21 11:25:04 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

PRJ=..$/..

PRJNAME=bridges
TARGET=java_uno
ENABLE_EXCEPTIONS=TRUE
USE_DEFFILE=TRUE
NO_BSYMBOLIC=TRUE

# --- Settings -----------------------------------------------------

.INCLUDE :  settings.mk

# ------------------------------------------------------------------

.IF "$(COM)$(OS)" == "GCCMACOSX"
CFLAGS += -Duno_initEnvironment=$(TARGET)uno_initEnvironment \
	  -Duno_ext_getMapping=$(TARGET)uno_ext_getMapping
.ENDIF

INTERFACES=$(MISC)$/interfaces.rdb

CPPUMAKERFLAGS += -C
UNOUCRDEP=$(SOLARBINDIR)$/udkapi.rdb $(INTERFACES)
UNOUCRRDB=$(SOLARBINDIR)$/udkapi.rdb $(INTERFACES)

TARGETJARFILE=..$/lib$/java_uno.jar
#JAVACLASSFILES=$(CLASSDIR)$/$(PACKAGE)$/JavaMapper.class
# output directory (one dir for each project)
UNOUCROUT=$(OUT)$/inc

# adding to inludepath
INCPRE+=$(UNOUCROUT)

UNOTYPES= \
	com.sun.star.bridge.XBridge					\
	com.sun.star.bridge.XBridgeFactory			\
	com.sun.star.bridge.XInstanceProvider		\
	com.sun.star.connection.XConnection			\
	com.sun.star.corba.giop.MessageHeader_1_1	\
	com.sun.star.lang.XInitialization			\
	com.sun.star.lang.XMultiServiceFactory		\
	com.sun.star.lang.XServiceInfo				\
	com.sun.star.lang.XSingleServiceFactory		\
	com.sun.star.lang.XTypeProvider				\
	com.sun.star.loader.XImplementationLoader	\
	com.sun.star.registry.XRegistryKey			\
	com.sun.star.java.XJavaMapper				\
	com.sun.star.java.XJavaThreadRegister_11	\
	com.sun.star.java.XJavaVM					\
	com.sun.star.uno.TypeClass					\
	com.sun.star.uno.XAggregation				\
	com.sun.star.uno.XWeak

SLOFILES= \
	$(SLO)$/java_uno_mapping.obj 		\
	$(SLO)$/exports.obj 				\
	$(SLO)$/java_uno_environment.obj	\
	$(SLO)$/connectionWrapper.obj 		\
	$(SLO)$/java.obj 					\
	$(SLO)$/nativeThreadPool.obj


SHL1TARGET= $(TARGET)

SHL1STDLIBS=\
		$(SALLIB)\
		$(CPPULIB)\
		$(RMCXTLIB)


SHL1LIBS=\
			$(SLB)$/$(TARGET).lib 


# --- Targets ------------------------------------------------------

.IF "$(depend)" == ""
ALL : $(CLASSDIR)$/$(TARGETJARFILE) ALLTAR 
.ELSE
ALL: ALLDEP
.ENDIF

.INCLUDE :	target.mk



JARFILES=sandbox.jar ridl.jar jurt.jar

NEWCLASS:=$(foreach,i,$(JARFILES) $(null,$(shell $(FIND) $(JARDIR) -name $i) $(SOLARBINDIR)$/$i $(shell $(FIND) $(JARDIR) -name $i)))

.IF "$(GUI)"=="UNX"
MYCLASSPATH=$(CLASSPATH):$(NEWCLASS:s/ /:/)
.ELSE
MYCLASSPATH=$(CLASSPATH);$(NEWCLASS:s/ /;/)
.ENDIF


JAVAFILES= JavaMapper.java

GENJAVACLASSFILES= \
	$(CLASSDIR)$/com$/sun$/star$/java$/XJavaMapper.class


GENJAVAFILES = {$(subst,.class,.java $(subst,$/class, $(GENJAVACLASSFILES)))}
TYPES={$(subst,.class, $(subst,$/,.  $(subst,$(CLASSDIR)$/,-T  $(GENJAVACLASSFILES))))}



$(GENJAVAFILES): $(INTERFACES)
	javamaker -BUCR -O$(OUT) $(TYPES) $(UNOUCRRDB)


$(GENJAVACLASSFILES): $(GENJAVAFILES)
	$(JAVAC) $(JAVACPS) $(MYCLASSPATH) -d $(CLASSDIR) $(JAVAFLAGS) $<

$(CLASSDIR)$/$(TARGETJARFILE): $(JAVAFILES) $(GENJAVACLASSFILES)
	$(JAVAC) $(JAVACPS) $(MYCLASSPATH) -d $(CLASSDIR) $(JAVAFLAGS) $(JAVAFILES)
	+cd $(CLASSDIR) && jar -cvf $(TARGETJARFILE) com$/sun$/star$/comp$/bridge$/JavaMapper.class com$/sun$/star$/java$/XJavaMapper.class

$(SLOFILES) : $(INTERFACES)

$(INTERFACES) : interfaces.idl 
	idlc $(UNOIDLINC) -O$(OUT)$/ucr$/$(IDLPACKAGE) interfaces.idl 
	regmerge $(INTERFACES) /UCR $(OUT)$/ucr$/$(IDLPACKAGE)$/interfaces.urd




$(MISC)$/$(SHL1TARGET).def: 
#makefile.mk
    @echo ------------------------------
    @echo Making: $@
    @echo LIBRARY     $(SHL1TARGET)														>$@
    @echo EXPORTS																		>>$@
    @echo uno_initEnvironment															>>$@
    @echo uno_ext_getMapping															>>$@
    @echo Java_com_sun_star_comp_bridge_JavaMapper_castIntToObject						>>$@
    @echo Java_com_sun_star_comp_bridge_JavaMapper_castObjectToInt						>>$@
    @echo Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_ngetThreadId	>>$@
    @echo Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_ncreate   		>>$@
    @echo Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_nattach		>>$@
    @echo Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_ndetach		>>$@
    @echo Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_nenter			>>$@
    @echo Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_nputJob		>>$@
    @echo Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_ndispose		>>$@
    @echo Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_ndestroy		>>$@
