/*************************************************************************
 *
 *  $RCSfile: nativeThreadPool.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: dbo $ $Date: 2001/10/26 07:22:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <string.h>

#include <osl/diagnose.h>

#include <rtl/byteseq.hxx>

#include <uno/threadpool.h>

#include <com/sun/star/java/XJavaThreadRegister_11.hpp>

#include "nativeThreadPool.hxx"

using namespace ::rtl;
using namespace ::com::sun::star::java;
using namespace ::com::sun::star::uno;


namespace java {
//--------------------------------------------------------------------------
// This is a nasty hack to grant the javaloader_callback-routine access to
// the XJavaThreadRegister_11-instance.
// Note : This works only as long as there is only ONE VM PER PROCESS !
// Note : This is only a weak reference
//-------------------------------------------------------------------------
	static JavaVMContext * __pVMContext = NULL;
	static jclass _jcJob;
	static jmethodID _jmJob_execute;
	static jmethodID _jmJob_getOperation;

	extern "C"
	{
		static void SAL_CALL executeJob(void * pJob)
		{
			sal_Bool attached = sal_False;
	
			if(!__pVMContext->isThreadAttached()) {
				attached = sal_True;
				__pVMContext->registerThread();
			}

			JNIEnv * pEnv;
			__pVMContext->_pJavaVM->AttachCurrentThread((void **)&pEnv, (void *)NULL);


			jobject joJob = (jobject)pJob;

			jobject joResult = pEnv->CallObjectMethod(joJob, _jmJob_execute);                                if(pEnv->ExceptionOccurred()) return;
	
			pEnv->DeleteGlobalRef(joJob);

			if(attached) {
				__pVMContext->revokeThread();
  				__pVMContext->_pJavaVM->DetachCurrentThread();
			}
		}


		/*
		 * Class:     com_sun_star_lib_uno_environments_remote_NativeThreadPool
		 * Method:    retrieve
		 * Signature: ()[B
		 */
		JNIEXPORT jbyteArray JNICALL Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_ngetThreadId(JNIEnv *pEnv, jclass)
		{
			ByteSequence seq;
			{
				sal_Sequence *pSequence = 0;
				uno_getIdOfCurrentThread( &pSequence );
				uno_releaseIdFromCurrentThread();

				seq = pSequence;
				rtl_byte_sequence_release( pSequence );
			}

			jbyteArray array = pEnv->NewByteArray( seq.getLength() );
			if( pEnv->ExceptionOccurred( ))
			{
				return 0;
			}

			jbyte *pMem = pEnv->GetByteArrayElements( array , 0 );
			if( pEnv->ExceptionOccurred( ))
			{
				return 0;
			}
			memcpy( pMem , seq.getConstArray() , seq.getLength() );

			pEnv->ReleaseByteArrayElements( array, pMem , 0 );
			if( pEnv->ExceptionOccurred( ))
			{
				return 0;
			}


			return array;
		}


	
		/*
		 * Class:     com_sun_star_lib_uno_environments_remote_NativeThreadPool
		 * Method:    create
		 * Signature: ()L
		 */
		JNIEXPORT jlong JNICALL Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_ncreate(JNIEnv * pEnv, jclass)
		{
			uno_ThreadPool threadPool = uno_threadpool_create();

			return (jlong)threadPool;
		}

		/*
		 * Class:     com_sun_star_lib_uno_environments_remote_NativeThreadPool
		 * Method:    attach
		 * Signature: (L)V
		 */
		JNIEXPORT void JNICALL Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_nattach(JNIEnv * pEnv, jclass, jlong jlHandle)
		{
			uno_threadpool_attach((uno_ThreadPool)jlHandle);
		}

		/*
		 * Class:     com_sun_star_lib_uno_environments_remote_NativeThreadPool
		 * Method:    detach
		 * Signature: (L)V
		 */
		JNIEXPORT void JNICALL Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_ndetach(JNIEnv, jclass,  jlong jlHandle)
		{
			uno_threadpool_detach((uno_ThreadPool)jlHandle);
		}

		/*
		 * Class:     com_sun_star_lib_uno_environments_remote_NativeThreadPool
		 * Method:    enter
		 * Signature: (L)Ljava/lang/Object;
		 */
		JNIEXPORT jobject JNICALL Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_nenter(JNIEnv * pEnv, jclass, jlong jlHandle, jbooleanArray jzaDisposed)
		{
			jobject joJob;

			sal_Bool detach = sal_False;
			if(!__pVMContext->isThreadAttached()) {
				detach = sal_True;
				__pVMContext->registerThread();
			}

			uno_threadpool_enter((uno_ThreadPool)jlHandle, (void **)&joJob);

			jobject joResult = 0;

			if(joJob) {
				joResult = pEnv->CallObjectMethod(joJob, _jmJob_execute);

				pEnv->DeleteGlobalRef(joJob);
			}
			else {
				jboolean * bools = pEnv->GetBooleanArrayElements(jzaDisposed, NULL);
				bools[0] = JNI_TRUE;
				pEnv->ReleaseBooleanArrayElements(jzaDisposed, bools, 0);
			}
				
			if(detach)
				__pVMContext->revokeThread();

			return joResult;
		}

		/*
		 * Class:     com_sun_star_lib_uno_environments_remote_NativeThreadPool
		 * Method:    putJob
		 * Signature: (L[BLcom/sun/star/lib/uno/environments/remote/Job;Z)V
		 */
		JNIEXPORT void JNICALL Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_nputJob(JNIEnv * pEnv, jclass, 
																									  jlong jlHandle,
																									  jbyteArray jbaThreadId,
																									  jobject joJob,
																									  jboolean   jzOneWay)
		{
			jstring jsOperation = (jstring)pEnv->CallObjectMethod(joJob, _jmJob_getOperation);               if(pEnv->ExceptionOccurred()) return;

			sal_Int32 nLength = pEnv->GetArrayLength(jbaThreadId);                                          if(pEnv->ExceptionOccurred()) return;
			jbyte * jbytes = pEnv->GetByteArrayElements(jbaThreadId, 0);                                    if(pEnv->ExceptionOccurred()) return;

			ByteSequence threadId((sal_Int8 *)jbytes, nLength);


			pEnv->ReleaseByteArrayElements(jbaThreadId, jbytes, JNI_ABORT);

			uno_threadpool_putJob((uno_ThreadPool)jlHandle, threadId.getHandle(), pEnv->NewGlobalRef(joJob), jsOperation ? executeJob : NULL, jsOperation ? jzOneWay : sal_False );
		}

		/*
		 * Class:     com_sun_star_lib_uno_environments_remote_NativeThreadPool
		 * Method:    dispose
		 * Signature: (L)V
		 */
		JNIEXPORT void JNICALL Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_ndispose(JNIEnv, jclass, jlong jlHandle)
		{
			uno_threadpool_dispose((uno_ThreadPool)jlHandle);
		}

		/*
		 * Class:     com_sun_star_lib_uno_environments_remote_NativeThreadPool
		 * Method:    destroy
		 * Signature: (L)V
		 */
		JNIEXPORT void JNICALL Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_ndestroy(JNIEnv *, jclass, jlong jlHandle)
		{
			uno_threadpool_destroy((uno_ThreadPool)jlHandle);
		}

	}

	void test_java_exception(JNIEnv * pJNIEnv) throw(RuntimeException);
	
	//--------------------------
	// Init the java threadpool
	//--------------------------
	void SAL_CALL java_uno_mapping_initNativeThreadPool(JNIEnv *pEnv, JavaVMContext * pVMContext) throw(RuntimeException) {
		RuntimeException javaException;

		try {
			// now instantiate a NativeThreadPoolWrapper
			jclass jcNativeThreadPoolFactory = pEnv->FindClass("com/sun/star/lib/uno/environments/remote/NativeThreadPoolFactory");
			if(pEnv->ExceptionOccurred()) throw javaException;

			jmethodID jmNativeThreadPoolFactory_ctor = pEnv->GetMethodID(jcNativeThreadPoolFactory, "<init>", "()V");
			if(pEnv->ExceptionOccurred()) throw javaException;

			jobject joNativeThreadPoolFactory = pEnv->NewObject(jcNativeThreadPoolFactory, jmNativeThreadPoolFactory_ctor);
			if(pEnv->ExceptionOccurred()) throw javaException;

			// get the Threadpool-class   
			jclass jcThreadPoolFactory = pEnv->FindClass("com/sun/star/lib/uno/environments/remote/ThreadPoolFactory");
			if(pEnv->ExceptionOccurred()) throw javaException;


			jmethodID jmThreadPoolFactory_setThreadPoolFactory = pEnv->GetStaticMethodID(jcThreadPoolFactory,
																						 "setThreadPoolFactory",
																						 "(Lcom/sun/star/lib/uno/environments/remote/IThreadPoolFactory;)V");
			if(pEnv->ExceptionOccurred()) throw javaException;


			pEnv->CallStaticVoidMethod(jcThreadPoolFactory, jmThreadPoolFactory_setThreadPoolFactory, joNativeThreadPoolFactory);
			if(pEnv->ExceptionOccurred()) throw javaException;

			// hold it weak
			__pVMContext = pVMContext;
	
			_jcJob = (jclass)pEnv->NewGlobalRef(pEnv->FindClass("com/sun/star/lib/uno/environments/remote/Job"));                 
			if(pEnv->ExceptionOccurred()) throw javaException;

			_jmJob_execute = pEnv->GetMethodID(_jcJob, "execute", "()Ljava/lang/Object;");          
			if(pEnv->ExceptionOccurred()) throw javaException;

			_jmJob_getOperation = pEnv->GetMethodID(_jcJob, "getOperation", "()Ljava/lang/String;");
			if(pEnv->ExceptionOccurred()) throw javaException;
 
		}
		catch(RuntimeException & runtimeException) {
			test_java_exception(pEnv);

			throw;
		}
	}
}	

