/*************************************************************************
 *
 *  $RCSfile: writer.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: jbu $ $Date: 2001/03/16 08:40:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <assert.h>
#include <stdio.h>

#include <osl/mutex.hxx>
#include <osl/conditn.h>

#include <bridges/remote/connection.h>
#include <bridges/remote/remote.hxx>

#include <com/sun/star/uno/Sequence.hxx>

#include <bridges/remote/counter.hxx>

#include "iothreads.hxx"
#include "conversion.h"

#ifdef DEBUG
static MyCounter thisCounter( "DEBUG : WriterThread" );
#endif

namespace bridges_remote {

OWriterThread::OWriterThread( remote_Connection *pConnection ) :
	m_pConnection( pConnection ),
	m_bAbort( sal_False )
{
	m_oslCondition = osl_createCondition();
	osl_resetCondition( m_oslCondition );
	m_pConnection->acquire( m_pConnection );
	
#ifdef DEBUG
	thisCounter.acquire();
#endif	
}

OWriterThread::~OWriterThread()
{
	osl_destroyCondition( m_oslCondition );
	m_pConnection->release( m_pConnection );
#ifdef DEBUG
	thisCounter.release();
#endif	
}


void OWriterThread::enqueue( const ::com::sun::star::uno::Sequence< sal_Int8 > &seq )
{
  	::osl::MutexGuard guard( m_mutex );
  	m_lst.push_back( seq );
  	osl_setCondition( m_oslCondition );
}


void OWriterThread::abort()
{
    {
       ::osl::MutexGuard guard( m_mutex );
 	   m_bAbort = sal_True;
	   osl_setCondition( m_oslCondition );
	}
	join();
}


void OWriterThread::run()
{
	while( sal_True )
	{
		// Wait for some work to do
		osl_waitCondition( m_oslCondition , 0 );
		
		::std::list < ::com::sun::star::uno::Sequence< sal_Int8 > > lst;
		
		// now send all data packages
		while( sal_True )
		{
			// get the list, so that other threads may add further requests ...
			{
				::osl::MutexGuard guard( m_mutex );
				lst.swap( m_lst );
				
				if( ! lst.size() )
				{
					if( m_bAbort )
					{
						m_pConnection->flush( m_pConnection );
						return;
					}
					// all packages have been sent,
					// go on waiting !
					osl_resetCondition( m_oslCondition );
					break;
				}
			}
			
			while( lst.size() )
			{
				::com::sun::star::uno::Sequence< sal_Int8 > seq = lst.front();
				lst.pop_front( );

				const sal_Int32 nLength = seq.getLength();

				sal_Int32 nWritten = m_pConnection->write(
					m_pConnection ,
					seq.getConstArray(),
					nLength );
				
				if( nLength != nWritten )
				{
					m_pConnection->close( m_pConnection );
					break;
				}
			}
		}
		m_pConnection->flush( m_pConnection );
	}

}


}
