/*************************************************************************
 *
 *  $RCSfile: cntppset.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/**************************************************************************
								TODO
 **************************************************************************

 *************************************************************************/

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _SFXITEMITER_HXX
#include <svtools/itemiter.hxx>
#endif

#include "cntppset.hxx"

#ifndef _CNTPOOL_HXX
#include "cntpool.hxx"
#endif
#ifndef _CNTSTG_HXX
#include "cntstg.hxx"
#endif
#ifndef _CNTSTGND_HXX /* STG_PROPS_EXTENSION */
#include "cntstgnd.hxx"
#endif
#ifndef _CHAOS_STORITEM_HXX
#include "storitem.hxx"
#endif
#ifndef _CONTENT_HXX
#include "content.hxx"
#endif

using namespace rtl;
using namespace com::sun::star::beans;
using namespace com::sun::star::uno;

using namespace chaos;

#ifdef _CHAOS_STORITEM_REF
SV_IMPL_REF( CntStoreItemSet );
#endif

//=========================================================================
//=========================================================================
//=========================================================================
//
// CntPersistentPropertySet Implementation.
//
//=========================================================================
//=========================================================================
//=========================================================================

// static
Sequence< PropertyInfo > CntPersistentPropertySet::query(
							const OUString& rURL, const OUString& rKey )
{
	if ( !rURL.getLength() || !rKey.getLength() )
		return Sequence< PropertyInfo >( 0 );

	// Check URL, at least it must point to a file.
	if ( INetURLObject::CompareProtocolScheme( rURL ) != INET_PROT_FILE )
		return Sequence< PropertyInfo >( 0 );

	// Create and initialize storage file.
	CntRootStorage aStorage;
	ErrCode nError = aStorage.initialize( NULL, rURL );
	if ( nError != ERRCODE_NONE )
		return Sequence< PropertyInfo >( 0 );

	String aKey( rKey );
	aKey.AppendAscii( RTL_CONSTASCII_STRINGPARAM( STG_PROPS_EXTENSION ) );

	SfxItemPool* pPool = CntItemPool::Acquire();

   	CntStoreItemSetRef xItemSet( aStorage.openItemSet(
									aKey, *pPool, STREAM_STD_READ, NULL ) );
	if ( xItemSet.Is() )
	{
		// Convert items contained in CntStoreItemSet into a sequence
		// of PropertyValue's.
		sal_uInt16 nCount = xItemSet->Count();
		if ( nCount )
		{
			Sequence< PropertyInfo > aSeq( nCount );
			PropertyInfo* pValues = aSeq.getArray();

			SfxItemIter aIter( *xItemSet );
			sal_uInt32 nArrPos = 0;

			const CntItemMap* pMap = CntItemPool::GetItemMap();

			const SfxPoolItem* pItem = aIter.FirstItem();
			while ( pItem )
			{
				USHORT nWhich = pItem->Which();
				const CntItemMapEntry* pEntry = pMap->Which2Prop( nWhich );
				if ( pEntry && pEntry->IsProperty() )
				{
					Any aValue;
					if ( pItem->QueryValue( aValue ) )
					{
						PropertyInfo& rProp = pValues[ nArrPos ];

						rProp.Name
							= UniString::CreateFromAscii( pEntry->pName );

						rProp.Handle 	 = pEntry->nWhich;

						ChaosContent::translatePropertyValue(
							rProp.Name, aValue, TRANSLATE_TO_EXTERNAL );

						rProp.Value  	 = aValue;
						rProp.State  	 = PropertyState_DIRECT_VALUE;
						rProp.Attributes = pEntry->nAttributes;

						nArrPos++;
					}
				}

				pItem = aIter.NextItem();
			}

			aSeq.realloc( nArrPos );

			xItemSet.Clear();
			CntItemPool::Release();
			return aSeq;
		}

		xItemSet.Clear();
	}

	CntItemPool::Release();
	return Sequence< PropertyInfo >( 0 );
}

