/*************************************************************************
 *
 *  $RCSfile: content.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 12:35:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Kai Sommerfeld ( kso@sun.com )
 *
 *
 ************************************************************************/

#ifndef _CONTENT_HXX
#define _CONTENT_HXX

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYCONTAINER_HPP_
#include <com/sun/star/beans/XPropertyContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTCREATOR_HPP_
#include <com/sun/star/ucb/XContentCreator.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDINFO_HPP_
#include <com/sun/star/ucb/XCommandInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTIESCHANGENOTIFIER_HPP_
#include <com/sun/star/beans/XPropertiesChangeNotifier.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDPROCESSOR_HPP_
#include <com/sun/star/ucb/XCommandProcessor.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENT_HPP_
#include <com/sun/star/ucb/XContent.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HPP_
#include <com/sun/star/beans/XPropertySetInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSETINFOCHANGENOTIFIER_HPP_
#include <com/sun/star/beans/XPropertySetInfoChangeNotifier.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDINFOCHANGENOTIFIER_HPP_
#include <com/sun/star/ucb/XCommandInfoChangeNotifier.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCHILD_HPP_
#include <com/sun/star/container/XChild.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _SFXLSTNER_HXX
#include <svtools/lstner.hxx>
#endif

#ifndef _CNTAPI_HXX // for CntAnchorRef member
#include "cntapi.hxx"
#endif

#ifndef _UCBHELPER_MACROS_HXX
#include <ucbhelper/macros.hxx>
#endif

namespace cppu {
	class OInterfaceContainerHelper;
}
namespace com { namespace sun { namespace star { namespace ucb {
	class XPersistentPropertySet;
} } } }

class SfxUShortRanges;

namespace chaos {

class ChaosPropertySetInfo;
class ChaosCommandInfo;
class ChaosContentProvider;
class Tasks_Impl;
class PropertyChangeListeners_Impl;

enum TranslationDirection
{
	TRANSLATE_TO_EXTERNAL = 0,
	TRANSLATE_TO_INTERNAL
};

#define CONTENT_SERVICE_NAME 	"com.sun.star.ucb.Content"

//=========================================================================

class ChaosContent :
				public cppu::OWeakObject,
				public com::sun::star::lang::XTypeProvider,
				public com::sun::star::lang::XServiceInfo,
				public com::sun::star::lang::XComponent,
				public com::sun::star::ucb::XContent,
				public com::sun::star::ucb::XContentCreator,
				public com::sun::star::ucb::XCommandProcessor,
				public com::sun::star::beans::XPropertiesChangeNotifier,
				public com::sun::star::beans::XPropertyContainer,
				public com::sun::star::beans::XPropertySetInfoChangeNotifier,
				public com::sun::star::ucb::XCommandInfoChangeNotifier,
				public com::sun::star::container::XChild,
				public SfxListener
{
	friend class ChaosTaskBase;
	friend class ChaosPropertyTask;

	com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory >
									 m_xSMgr;
	com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >
									 m_xIdentifier;
	CntAnchorRef 		  			 m_xAnchor;
	vos::OMutex						 m_aMutex;
	ChaosContent*					 m_pParent;
	ChaosPropertySetInfo* 			 m_pPropSetInfo;
	ChaosCommandInfo*	  			 m_pCommandsInfo;
	ChaosContentProvider*	  		 m_pProvider;
	Tasks_Impl*						 m_pTasks;
	cppu::OInterfaceContainerHelper* m_pDisposeEventListeners;
	cppu::OInterfaceContainerHelper* m_pContentEventListeners;
	cppu::OInterfaceContainerHelper* m_pPropSetChangeListeners;
	cppu::OInterfaceContainerHelper* m_pCommandChangeListeners;
	PropertyChangeListeners_Impl*    m_pPropertyChangeListeners;
	sal_uInt32						 m_nCommandId;
    sal_Bool                         m_bHasViewData;

private:
	void notifyContentEvent(
			const com::sun::star::uno::Reference< com::sun::star::uno::XInterface >& rSource,
			const long nAction,
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContent >& rContent,
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >& rId );
	void notifyContentEvent(
			const long nAction,
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContent >& rContent,
			const com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >& rId )
	{ notifyContentEvent( (cppu::OWeakObject*)this, nAction, rContent, rId ); }
	void notifyPropertiesChange(
			const com::sun::star::uno::Sequence< com::sun::star::beans::PropertyChangeEvent >& evt ) const;
	void notifyPropertyChange(
			const com::sun::star::beans::PropertyChangeEvent& evt ) const;
	void notifyPropertySetInfoChange(
			const com::sun::star::beans::PropertySetInfoChangeEvent& evt ) const;
	void notifyCommandInfoChange(
			const com::sun::star::ucb::CommandInfoChangeEvent& evt ) const;
	void exchange();
	com::sun::star::uno::Reference< com::sun::star::ucb::XPersistentPropertySet >
	getDynamicPropertySet( sal_Bool bCreate );

    com::sun::star::uno::Reference< com::sun::star::beans::XPropertySetInfo >
	getPropertySetInfo();
    com::sun::star::uno::Reference< com::sun::star::ucb::XCommandInfo >
	getCommandInfo();

public:
	ChaosContent(
			const com::sun::star::uno::Reference<
				com::sun::star::lang::XMultiServiceFactory >& rxSMgr,
			ChaosContentProvider* pProvider,
			const com::sun::star::uno::Reference<
				com::sun::star::ucb::XContentIdentifier >& Identifier,
			ChaosContent* pParent = NULL,
			CntAnchor* pAnchor = NULL );
	virtual ~ChaosContent();

	// XInterface
	XINTERFACE_DECL()

	// XTypeProvider
	XTYPEPROVIDER_DECL()

    // XServiceInfo
	XSERVICEINFO_NOFACTORY_DECL()

	// XComponent
    virtual void SAL_CALL dispose()
		throw( com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL addEventListener( const com::sun::star::uno::Reference< com::sun::star::lang::XEventListener >& Listener )
		throw( com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL removeEventListener( const com::sun::star::uno::Reference< com::sun::star::lang::XEventListener >& Listener )
		throw( com::sun::star::uno::RuntimeException );

	// XContent
    virtual com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier > SAL_CALL
	getIdentifier()
		throw( com::sun::star::uno::RuntimeException );
    virtual rtl::OUString SAL_CALL
	getContentType()
		throw( com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL
	addContentEventListener( const com::sun::star::uno::Reference< com::sun::star::ucb::XContentEventListener >& Listener )
		throw( com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL
	removeContentEventListener( const com::sun::star::uno::Reference< com::sun::star::ucb::XContentEventListener >& Listener )
		throw( com::sun::star::uno::RuntimeException );

	// XContentCreator
    virtual com::sun::star::uno::Sequence< com::sun::star::ucb::ContentInfo > SAL_CALL
	queryCreatableContentsInfo()
		throw( com::sun::star::uno::RuntimeException );
    virtual com::sun::star::uno::Reference< com::sun::star::ucb::XContent > SAL_CALL
	createNewContent( const com::sun::star::ucb::ContentInfo& Info )
		throw( com::sun::star::uno::RuntimeException );

	// XCommandProcessor
    virtual sal_Int32 SAL_CALL
	createCommandIdentifier()
		throw( com::sun::star::uno::RuntimeException );
    virtual com::sun::star::uno::Any SAL_CALL
	execute( const com::sun::star::ucb::Command& aCommand,
			 sal_Int32 CommandId,
			 const com::sun::star::uno::Reference< com::sun::star::ucb::XCommandEnvironment >& Environment )
    	throw( com::sun::star::uno::Exception,
			   com::sun::star::ucb::CommandAbortedException,
			   com::sun::star::uno::RuntimeException );

    virtual void SAL_CALL
	abort( sal_Int32 CommandId )
		throw( com::sun::star::uno::RuntimeException );

	// XPropertiesChangeNotifier
    virtual void SAL_CALL
	addPropertiesChangeListener( const com::sun::star::uno::Sequence< rtl::OUString >& PropertyNames,
								 const com::sun::star::uno::Reference< com::sun::star::beans::XPropertiesChangeListener >& Listener )
		throw( com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL
	removePropertiesChangeListener( const com::sun::star::uno::Sequence< rtl::OUString >& PropertyNames,
									const com::sun::star::uno::Reference< com::sun::star::beans::XPropertiesChangeListener >& Listener )
		throw( com::sun::star::uno::RuntimeException );

	// XCommandInfoChangeNotifier
    virtual void SAL_CALL
	addCommandInfoChangeListener( const com::sun::star::uno::Reference< com::sun::star::ucb::XCommandInfoChangeListener >& Listener )
		throw( com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL
	removeCommandInfoChangeListener( const com::sun::star::uno::Reference< ::com::sun::star::ucb::XCommandInfoChangeListener >& Listener )
		throw( com::sun::star::uno::RuntimeException );

	// XPropertyContainer
	virtual void SAL_CALL
	addProperty( const rtl::OUString& Name,
				 sal_Int16 Attributes,
				 const com::sun::star::uno::Any& DefaultValue )
		throw( com::sun::star::beans::PropertyExistException,
			   com::sun::star::beans::IllegalTypeException,
			   com::sun::star::lang::IllegalArgumentException,
			   com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL
	removeProperty( const rtl::OUString& Name )
		throw( com::sun::star::beans::UnknownPropertyException,
			   com::sun::star::beans::NotRemoveableException,
			   com::sun::star::uno::RuntimeException );

	// XPropertySetInfoChangeNotifier
    virtual void SAL_CALL
	addPropertySetInfoChangeListener( const com::sun::star::uno::Reference< com::sun::star::beans::XPropertySetInfoChangeListener >& Listener )
		throw( com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL
	removePropertySetInfoChangeListener( const com::sun::star::uno::Reference< com::sun::star::beans::XPropertySetInfoChangeListener >& Listener )
		throw( com::sun::star::uno::RuntimeException );

	// XChild
    virtual com::sun::star::uno::Reference< com::sun::star::uno::XInterface > SAL_CALL
	getParent()
		throw( com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL
	setParent( const com::sun::star::uno::Reference<
						com::sun::star::uno::XInterface >& Parent )
		throw( com::sun::star::lang::NoSupportException,
			   com::sun::star::uno::RuntimeException );

	// SfxListener
	virtual void Notify( SfxBroadcaster& rBC, const SfxHint& rHint );

	// Non-Interface methods.
	CntAnchor* getAnchor() const { return m_xAnchor; }
	ChaosContentProvider* getProvider() const { return m_pProvider; }
	sal_Bool isHandleValid( sal_uInt16 nHandle ) const;
	static sal_Int32 queryChaosPropertyHandle( const rtl::OUString& rName );
	static sal_Bool translatePropertyValue( const rtl::OUString& rName,
										  	com::sun::star::uno::Any& rValue,
											TranslationDirection eDirection );
};

//=========================================================================

#define	CNT_ITEMMAP() CNT_POOL()->GetItemMap()
#define REAL_RANGES() SfxItemSet::GetParent()->GetRanges()

}

#endif /* !_CONTENT_HXX */
