/*************************************************************************
 *
 *  $RCSfile: dynrset.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2000/10/16 15:03:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DYNRSET_HXX
#define _DYNRSET_HXX

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XDYNAMICRESULTSET_HPP_
#include <com/sun/star/ucb/XDynamicResultSet.hpp>
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _VOS_REF_HXX_ 
#include <vos/ref.hxx>
#endif

#ifndef _UCBHELPER_MACROS_HXX
#include <ucbhelper/macros.hxx>
#endif

namespace com { namespace sun { namespace star { namespace ucb {
	struct Command;
	class XCommandEnvironment;
} } } }

namespace cppu {
	class OInterfaceContainerHelper;
}

namespace chaos {

class ResultSet;

#define DYNAMICRESULTSET_SERVICE_NAME "com.sun.star.ucb.DynamicContentResultSet"

//=========================================================================

class ChaosContent;

class DynamicResultSet :
				public cppu::OWeakObject,
				public com::sun::star::lang::XTypeProvider,
				public com::sun::star::lang::XServiceInfo,
				public com::sun::star::ucb::XDynamicResultSet
{
	com::sun::star::uno::Reference<
		com::sun::star::lang::XMultiServiceFactory >	 m_xSMgr;
	com::sun::star::uno::Reference<
		com::sun::star::ucb::XDynamicResultSetListener > m_xListener;
	vos::ORef< chaos::ResultSet >	 m_xResultSet;
	vos::OMutex						 m_aMutex;
	cppu::OInterfaceContainerHelper* m_pDisposeEventListeners;
	sal_Bool						 m_bStatic : 1;

public:
	DynamicResultSet(
			const com::sun::star::uno::Reference<
				com::sun::star::lang::XMultiServiceFactory >& rxSMgr,
			ChaosContent* pOwner,
			const com::sun::star::ucb::Command& rCommand,
			const com::sun::star::uno::Reference<
				com::sun::star::ucb::XCommandEnvironment >& Environment );
	virtual ~DynamicResultSet();

	// XInterface
	XINTERFACE_DECL()

	// XTypeProvider
	XTYPEPROVIDER_DECL()

    // XServiceInfo
	XSERVICEINFO_NOFACTORY_DECL()

	// XComponent ( base class of XDynamicResultSet )
    virtual void SAL_CALL
	dispose()
		throw( com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL
	addEventListener( const com::sun::star::uno::Reference<
							com::sun::star::lang::XEventListener >& Listener )
		throw( com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL
	removeEventListener( const com::sun::star::uno::Reference<
							com::sun::star::lang::XEventListener >& Listener )
		throw( com::sun::star::uno::RuntimeException );

	// XDynamicResultSet
    virtual com::sun::star::uno::Reference<
				com::sun::star::sdbc::XResultSet > SAL_CALL
	getStaticResultSet()
		throw( com::sun::star::ucb::ListenerAlreadySetException,
		com::sun::star::uno::RuntimeException );
    virtual void SAL_CALL
	setListener( const com::sun::star::uno::Reference<
					com::sun::star::ucb::XDynamicResultSetListener >& Listener )
		throw( com::sun::star::ucb::ListenerAlreadySetException,
			   com::sun::star::uno::RuntimeException );
	virtual void SAL_CALL
	connectToCache( const com::sun::star::uno::Reference<
						com::sun::star::ucb::XDynamicResultSet > & xCache )
		throw( com::sun::star::ucb::ListenerAlreadySetException,
			   com::sun::star::ucb::AlreadyInitializedException,
			   com::sun::star::ucb::ServiceNotFoundException,
			   com::sun::star::uno::RuntimeException );
    virtual sal_Int16 SAL_CALL
	getCapabilities()
		throw( com::sun::star::uno::RuntimeException );
};

}

#endif /* !_DYNRSET_HXX */
