/*************************************************************************
 *
 *  $RCSfile: ehdli.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: mhu $ $Date: 2001/09/12 11:10:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_EHDLI_HXX
#define CHAOS_EHDLI_HXX

#ifndef _COM_SUN_STAR_TASK_XINTERACTIONREQUEST_HPP_
#include <com/sun/star/task/XInteractionRequest.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_XINTERACTIONCONTINUATION_HPP_
#include <com/sun/star/task/XInteractionContinuation.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_INTERACTIONCLASSIFICATION_HPP_
#include <com/sun/star/task/InteractionClassification.hpp>
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _CNTBASE_HXX
#include <cntbase.hxx>
#endif

namespace chaos {

class InteractionContinuation_Impl;

//============================================================================
class InteractionRequest_Impl:
	public cppu::OWeakObject,
	public com::sun::star::task::XInteractionRequest
{
	const CntErrorData * m_pData;
	vos::ORef<InteractionContinuation_Impl> m_xSelection;
	sal_Bool m_bResource;
	com::sun::star::task::InteractionClassification m_eResourceClassification;
	com::sun::star::uno::Sequence<rtl::OUString> m_aResourceArguments;
	sal_uInt16 m_nResourceButtons;

	void getResource();

public:
	inline InteractionRequest_Impl(const CntErrorData * pTheData);

    virtual com::sun::star::uno::Any SAL_CALL queryInterface(const com::sun::star::uno::Type & rType)
		throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL acquire() throw() { OWeakObject::acquire(); }

    virtual void SAL_CALL release() throw() { OWeakObject::release(); }

	virtual com::sun::star::uno::Any SAL_CALL getRequest()
		throw (com::sun::star::uno::RuntimeException);

	virtual
	com::sun::star::uno::Sequence<com::sun::star::uno::Reference
	                        <com::sun::star::task::XInteractionContinuation> >
	SAL_CALL getContinuations()
		throw (com::sun::star::uno::RuntimeException);

	inline void setSelection(const vos::ORef<InteractionContinuation_Impl> &
							  rTheSelection);

	inline vos::ORef<InteractionContinuation_Impl> getSelection() const;

	void * getErrorExtraData() { return m_pData ? m_pData->_pData : 0; }
};

//============================================================================
class InteractionContinuation_Impl:
	public cppu::OWeakObject
{
	vos::ORef<InteractionRequest_Impl> m_xRequest;

protected:
	void recordSelection() { m_xRequest->setSelection(this); }

	void * getErrorExtraData() { return m_xRequest->getErrorExtraData(); }

public:
	InteractionContinuation_Impl(const vos::ORef<InteractionRequest_Impl> &
								  rTheRequest):
		m_xRequest(rTheRequest) {}

	virtual sal_uInt16 getButton() const = 0;
};

//============================================================================
// The following inline methods need to see the complete declaration of
// InteractionContinuation_Impl:

inline InteractionRequest_Impl::InteractionRequest_Impl(const CntErrorData *
														 pTheData):
	m_pData(pTheData), m_bResource(sal_False)
{}

inline void InteractionRequest_Impl::setSelection
             (const vos::ORef<InteractionContinuation_Impl> & rTheSelection)
{
	m_xSelection = rTheSelection;
}

inline vos::ORef<InteractionContinuation_Impl>
InteractionRequest_Impl::getSelection() const
{
	return m_xSelection;
}

}

#endif // CHAOS_EHDLI_HXX

