/*************************************************************************
 *
 *  $RCSfile: cntsys.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _FSYS_HXX //autogen
#include <tools/fsys.hxx>
#endif
#ifndef _TOOLS_RESMGR_HXX
#include <tools/resmgr.hxx>
#endif
#ifndef _TOOLS_INTN_HXX
#include <tools/intn.hxx>
#endif
#ifndef _SFXCANCEL_HXX //autogen
#include <svtools/cancel.hxx>
#endif
#ifndef _INETTYPE_HXX //autogen
#include <svtools/inettype.hxx>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef _SVTOOLS_CTYPEITM_HXX //autogen
#include <svtools/ctypeitm.hxx>
#endif
#ifndef _UNOTOOLS_INTLWRAPPER_HXX
#include <unotools/intlwrapper.hxx>
#endif

#include <cntsys.hxx>

#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CNTDATA_HXX
#include <cntdata.hxx>
#endif
#ifndef _CNTPOOL_HXX
#include <cntpool.hxx>
#endif
#ifndef _CNTVNODE_HXX
#include <cntvnode.hxx>
#endif
#ifndef _CNTJOB_HXX
#include <cntjob.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif
#ifndef _CNTANCHR_HXX
#include <cntanchr.hxx>
#endif
#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif

using namespace chaos;

//============================================================================
//
// CntSystem Implementation.
//
//============================================================================

// static member!
CntSystem* CntSystem::_pSystem = NULL;

//----------------------------------------------------------------------------
CntSystem::CntSystem()
{
	// Get and hold CHAOS RootNode Manager.
	CntRootNodeMgr* pRNM = CntRootNodeMgr::GetOrCreate();
	pRNM->AddRef();
	StartListening( *pRNM );
}

//----------------------------------------------------------------------------
// virtual
CntSystem::~CntSystem()
{
	CntRootNodeMgr* pRNM = CNT_RNM();

	DBG_ASSERT( pRNM, "RNM destroyed before CntSystem object!" );

	EndListening( *pRNM );
	pRNM->ReleaseRef();

	_pSystem = NULL;
}

//----------------------------------------------------------------------------
// static
const SfxPoolItem* CntSystem::Put( const SfxPoolItem& rProp )
{
	DBG_ASSERT( CNT_RNM(), "RNM destroyed before CntSystem object!" );
	return CNT_RNM()->Put( rProp, rProp.Which() );
}

//----------------------------------------------------------------------------
// static
const SfxPoolItem& CntSystem::Get( USHORT nWhich, BOOL bSrchInParent )
{
	DBG_ASSERT( CNT_RNM(), "RNM destroyed before CntSystem object!" );
	return CNT_RNM()->CntInterface::Get( nWhich, bSrchInParent );
}

//----------------------------------------------------------------------------
// virtual
void CntSystem::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	ACQUIRE_SOLAR_MUTEX();
	Broadcast( rHint );
}

//----------------------------------------------------------------------------
// static
CntSystem* CntSystem::GetMgr( BOOL bCreate )
{
	if ( !_pSystem && bCreate )
	{
		// Create System object.
		_pSystem = new CntSystem;
	}

	return _pSystem;
}

//----------------------------------------------------------------------------
// static
BOOL CntSystem::Initialize()
{
	if ( !_pSystem )
	{
		if ( !CntRootNodeMgr::GetIniManager() )
		{
			DBG_ERROR( "CntSystem::Initialize() - No INI-Manager!" );
			return FALSE;
		}

		if ( !CntRootNodeMgr::GetCancelManager() )
		{
			DBG_ERROR( "CntSystem::Initialize() - No Cancel-Manager!" );
			return FALSE;
		}

		if ( !CntRootNodeMgr::GetResManager() )
		{
			DBG_ERROR( "CntSystem::Initialize() - No Resource-Manager!" );
			return FALSE;
		}

		// Get and hold CHAOS item pool.
		CntItemPool* pItemPool = CntItemPool::Acquire();

		// Create the System object.
		CNT_SYS();
	}

	// Hold the System object.
	_pSystem->AddRef();

	return TRUE;
}

//----------------------------------------------------------------------------
// static
BOOL CntSystem::Deinitialize()
{
	if ( !_pSystem )
	{
		// Not initialized. This is not an error.
		return TRUE;
	}

	// Release System object. If the last reference goes, the
	// static(!) member _pSystem will be set to NULL in the dtor
	// of the System object.
	_pSystem->ReleaseRef();

	if ( _pSystem )
	{
		// Others still hold the system. This is not an error, because
		// the refcount of the system object will be increased on every
		// call to CntSystem::Initialize(...).
		return TRUE;
	}

	// System Cleanup: If the Rootnode manager exists after the CntSystem
	// object was destroyed there must be any nodes alive. Deinitialize()
	// must be called to release these nodes.
	CntRootNodeMgr* pRNM = CNT_RNM();
	if ( pRNM )
		pRNM->Deinitialize();

	pRNM = CNT_RNM();
	if ( pRNM )
	{
#ifdef DBG_UTIL
		SvFileStream aDump(	UniString::CreateFromAscii(
								RTL_CONSTASCII_STRINGPARAM( "c:\\chaos.err" ) ),
							STREAM_STD_WRITE );
		pRNM->Dump( aDump );

		DBG_ERROR( "CntSystem::Deinitialize() - RootnodeMgr not destroyed!" );
#endif
		return FALSE;
	}
	else
	{
		// Release CHAOS item pool.
		CntItemPool::Release();
	}

    return TRUE;
}

//----------------------------------------------------------------------------
// static
SfxItemPool* CntSystem::GetItemPool()
{
	// Get and hold CHAOS item pool.
	return CntItemPool::Acquire();
}

//----------------------------------------------------------------------------
// static
USHORT CntSystem::ReleaseItemPool()
{
	// Release CHAOS item pool.
	return CntItemPool::Release();
}

//----------------------------------------------------------------------------
// static
SimpleResMgr* CntSystem::GetResManager()
{
	return CntRootNodeMgr::GetResManager();
}

//----------------------------------------------------------------------------
// static
void CntSystem::SetCancelManager( SfxCancelManager* pCancelMgr )
{
	CntRootNodeMgr::SetCancelManager( pCancelMgr );
}

//----------------------------------------------------------------------------
// static
void CntSystem::Flush()
{
	CntRootNodeMgr* pRNM = CNT_RNM();
	if ( pRNM )
		pRNM->Flush();
}

//----------------------------------------------------------------------------
// static
CntTypesList* CntSystem::GetViewTypes()
{
	if ( !_pSystem )
	{
		DBG_ERROR( "CntSystem::GetViewTypes - CHAOS not initialized!" );
		return NULL;
	}

	// Get WID_CREATE_NEW item from RNM - It contains all info we need.

	const CntItemListItem& rListItem = (const CntItemListItem&)
								CNT_RNM()->SfxItemSet::Get( WID_CREATE_NEW );

	USHORT nCount = rListItem.Count();
	if ( !nCount )
		return NULL;

	CntTypesList* pList = new CntTypesList;

	for( USHORT n = 0; n < nCount; ++n )
	{
		const CntItemListItem& rCurr =
						(const CntItemListItem&)(rListItem)[ n ];

		INetContentType* pType = new INetContentType( (INetContentType)
				ITEM_VALUE( CntUInt16Item, *rCurr.Get( WID_FACTORY_NO ) ) );
		pList->Insert( pType, LIST_APPEND );
	}

	return pList;
}

//----------------------------------------------------------------------------
// static
const String CntSystem::ViewExists_Impl( const String& rDirURL,
	                                     INetContentType eType,
									     BOOL bDeep )
{
	BOOL bLower = FALSE;

	String aDirURL( rDirURL );
	if ( aDirURL.Len() )
	{
		DirEntry aDir( aDirURL, FSYS_STYLE_URL );
		if ( !aDir.IsCaseSensitive() )
		{
			bLower = TRUE;
			aDirURL.ToLowerAscii();
		}
	}

	CntRootNodeMgr* pRNM = CNT_RNM();
	ULONG n = 0;

	//////////////////////////////////////////////////////////////////////
	// First, try to find a view root URL matching the given type and
	// directory in RNM's view list.
	//////////////////////////////////////////////////////////////////////

	String aContentType( INetContentTypes::GetContentType( eType ) );

	const CntViewList* pViewList = pRNM->GetViewList();
	ULONG nCount = pViewList->Count();
	for ( n = 0; n < nCount; ++n )
	{
		CntViewEntry* pEntry = pViewList->GetObject( n );
		if ( pEntry->aContentType != aContentType )
			continue;

		// Content Type matches...

		const String aURL( pEntry->aViewURL );

		if ( !aDirURL.Len() )
			return aURL;

		xub_StrLen nPos = aURL.Match( aDirURL );
		if ( nPos != aDirURL.Len() )
			continue;

		// View URL starts with aDirURL.

		if ( !bDeep && ( aURL.Search( '/', nPos ) != STRING_NOTFOUND ) )
			continue;

		if ( CntViewBase::ViewFileExists( aURL ) )
		{
			// View file exists - Gotcha.
			return aURL;
		}
	}

	//////////////////////////////////////////////////////////////////////
	// Second, try to find an instanciated view root node matching the
	// given type and directory.
	//////////////////////////////////////////////////////////////////////

	nCount = pRNM->SubNodeCount();
	for ( n = 0; n < nCount; ++n )
	{
		CntNode* pChild = pRNM->GetSubNode( n );
		const String& rURL = OWN_URL( pChild );

		if ( rURL.Len() < aDirURL.Len() )
			continue;

		if ( CntViewBase::IsRootViewURL( rURL ) )
		{
			if ( aDirURL.Len() )
			{
				xub_StrLen nPos = rURL.Match( aDirURL );
				if ( nPos != aDirURL.Len() )
					continue;

				// pChild's URL starts with aDirURL.

				if ( !bDeep && ( rURL.Search( '/', nPos ) != STRING_NOTFOUND ) )
					continue;

				// pChild's URL points to a file for view root node in aDirURL.
			}

			CntNode* pMostRef = pChild->GetMostReferedNode();
			const CntContentTypeItem& rTypeItem = (const CntContentTypeItem&)
						( pMostRef->Get( WID_CONTENT_TYPE ) );
			if ( rTypeItem.GetEnumValue() == eType )
			{
				// Gotcha.
				return rURL;
			}
		}
	}

	if ( !aDirURL.Len() )
		return String();

	//////////////////////////////////////////////////////////////////////
	// Third, try to find file for a view root node in the given
	// directory, matching the given type.
	//////////////////////////////////////////////////////////////////////

	const CntViewTypesList* pTypes = pRNM->GetViewTypesList();
	nCount = pTypes->Count();
	for ( USHORT k = 0; k < nCount; ++k )
	{
		const String& rWild = *pTypes->GetObject( k );
		xub_StrLen nPos = rWild.Search( '*' );

		DBG_ASSERT( nPos != STRING_NOTFOUND,
					"CntSystem::ViewExists_Impl - Invalid URL wildcard!" );

		String aWild( aDirURL );
		aWild += rWild.Copy( nPos );

		DirEntry aDirEntry( aWild, FSYS_STYLE_URL );
		Dir      aDirectory( aDirEntry,
					   		 FSYS_KIND_FILE, FSYS_SORT_NONE, FSYS_SORT_END );
		USHORT   nEntries = aDirectory.Count();

		for ( USHORT m = 0; m < nEntries; ++m )
		{
			DirEntry& aCurr = aDirectory[ m ];

			String aURL( aDirURL );
			String aName( aCurr.GetName() );

			if ( bLower )
				aName.ToLowerAscii();

			aURL += aName;

			CntNodeRef xNode = pRNM->Query( aURL );
			if ( xNode.Is() )
			{
				CntNode* pMostRef = xNode->GetMostReferedNode();
				const CntContentTypeItem& rTypeItem =
									(const CntContentTypeItem&)
										( pMostRef->Get( WID_CONTENT_TYPE ) );
				if ( rTypeItem.GetEnumValue() == eType )
				{
					aURL = OWN_URL( xNode );
					return aURL;
				}
			}
		}
	}

	return String();
}

//----------------------------------------------------------------------------
// static
BOOL CntSystem::ViewExists( const String& rDirURL,
							INetContentType eType,
						    BOOL bDeep /* = FALSE */ )
{
	if ( !_pSystem )
	{
		DBG_ERROR( "CntSystem::ViewExists: CHAOS not initialized!" );
		return FALSE;
	}

	String aDirURL( rDirURL );
	if ( aDirURL.Len() )
	{
		if ( aDirURL.GetChar( aDirURL.Len() - 1 ) != '/' )
			aDirURL += '/';
	}

	const String aURL( ViewExists_Impl( aDirURL, eType, bDeep ) );
	if ( aURL.Len() )
		return TRUE;

	return FALSE;
}

//----------------------------------------------------------------------------
// static
const String CntSystem::CreateView_Impl( const String& rDirURL,
	                                     INetContentType eType )
{
	CntAnchorRef xAnchor( new CntAnchor( NULL, rDirURL ) );
	if ( !xAnchor->GetError() )
	{
		// Get WID_CREATE_NEW item corresponding to eType.

		const CntItemListItem* pItem = NULL;
		const CntItemListItem& rListItem =
					(const CntItemListItem&)xAnchor->Get( WID_CREATE_NEW );

		USHORT nCount = rListItem.Count();
		for( USHORT n = 0; n < nCount; ++n )
		{
			const CntItemListItem& rCurr =
							(const CntItemListItem&)(rListItem)[ n ];

			INetContentType eCurrType = (INetContentType)
				ITEM_VALUE( CntUInt16Item, *rCurr.Get( WID_FACTORY_NO ) );

			if ( eCurrType == eType )
			{
				// Gotcha!
				pItem = &rCurr;
				break;
			}

			pItem = NULL;
		}

		DBG_ASSERT( pItem, "CntSystem::CreateView - unable to get factory." );

		if ( pItem )
		{
			const CntAnchorItem* pResult =
						(const CntAnchorItem*)xAnchor->Put( *pItem );
			if ( pResult )
			{
				CntAnchorRef xNewView( pResult->GetValue() );

				// Set default title.
				String aTitle(
						ITEMSET_VALUE( xNewView, CntStringItem, WID_TITLE ) );

				if ( !aTitle.Len() )
					aTitle = INetContentTypes::GetPresentation
					          (eType,
							   CntRootNodeMgr::GetIniManager()->
                                getIntlWrapper().getLanguage());

				if ( aTitle.Len() )
					xNewView->Put( CntStringItem( WID_TITLE, aTitle ) );

				// Make new View persistent.
				xNewView->Put( SfxVoidItem( WID_INSERT ) );

				// delete the CntAnchorItem ( there is no DeleteOnIdle() anymore )
				delete ( CntAnchorItem*) pResult;

				return xNewView->GetViewURL( TRUE );
			}
		}
	}

	return String();
}

//----------------------------------------------------------------------------
// static
const String CntSystem::GetView( const String& rDirURL,
	                             INetContentType eType,
								 BOOL bCreate )
{
	if ( !_pSystem )
	{
		DBG_ERROR( "CntSystem::GetView: CHAOS not initialized!" );
		return String();
	}

	if ( !rDirURL.Len() )
	{
		DBG_ERROR( "CntSystem::GetView: Empty directory URL given!" );
		return String();
	}

	String aDirURL( rDirURL );
	if ( aDirURL.GetChar( aDirURL.Len() - 1 ) != '/' )
		aDirURL += '/';

	const String aURL( ViewExists_Impl( aDirURL, eType, FALSE ) );
	if ( aURL.Len() )
		return aURL;

	if ( !bCreate )
		return String();

	// Create view...
	return CreateView_Impl( aDirURL, eType );
}

//----------------------------------------------------------------------------
// static
const String CntSystem::GetView( BOOL& rbCreated,
								 const String& rDirURL,
	                             INetContentType eType )
{
	rbCreated = FALSE;

	if ( !_pSystem )
	{
		DBG_ERROR( "CntSystem::GetView: CHAOS not initialized!" );
		return String();
	}

	if ( !rDirURL.Len() )
	{
		DBG_ERROR( "CntSystem::GetView: Empty directory URL given!" );
		return String();
	}

	String aDirURL( rDirURL );
	if ( aDirURL.GetChar( aDirURL.Len() - 1 ) != '/' )
		aDirURL += '/';

	const String aURL( ViewExists_Impl( aDirURL, eType, FALSE ) );
	if ( aURL.Len() )
		return aURL;

	// Create view...
	const String aNewURL( CreateView_Impl( aDirURL, eType ) );

	if ( aNewURL.Len() )
		rbCreated = TRUE;

	return aNewURL;
}

//----------------------------------------------------------------------------
// static
CntViewList* CntSystem::GetViews( const String& rDirURL,
								  INetContentType eType,
								  BOOL bDeep /* = TRUE */ )
{
	if ( !_pSystem )
	{
		DBG_ERROR( "CntSystem::GetViews - CHAOS not initialized!" );
		return NULL;
	}

	const CntViewList* pViews = CNT_RNM()->GetViewList();
	if ( !pViews || !pViews->Count() )
		return NULL;

	// Case 1: All views of any types in any directory wanted.
	if ( ( rDirURL.Len() == 0 ) && ( eType == (INetContentType)-1 ) )
		return new CntViewList( *pViews );

	ULONG nCount = pViews->Count();
	CntViewList* pViewList = new CntViewList;

	String aType;
	if ( eType != (INetContentType)-1 )
		aType = INetContentTypes::GetContentType( eType );

	// Case 2: All views of given type in any directory wanted.
	if ( rDirURL.Len() == 0 )
	{
		for ( ULONG n = 0; n < nCount; ++n )
		{
			CntViewEntry* pEntry = pViews->GetObject( n );
			if ( pEntry->aContentType == aType )
				pViewList->Insert( pEntry, LIST_APPEND );
		}
	}
	else
	{
		// Directory URL given...

		String aDirURL( rDirURL );
		if ( aDirURL.GetChar( aDirURL.Len() - 1 ) != '/' )
			aDirURL += '/';

		DirEntry aDir( aDirURL, FSYS_STYLE_URL );
		if ( !aDir.IsCaseSensitive() )
			aDirURL.ToLowerAscii();

		// Case 3: All views of any types in given directory wanted.
		if ( eType == (INetContentType)-1 )
		{
			for ( ULONG n = 0; n < nCount; ++n )
			{
				CntViewEntry* pEntry = pViews->GetObject( n );

				if ( pEntry->aViewURL.Len() < aDirURL.Len() )
					continue;

				xub_StrLen nPos = pEntry->aViewURL.Match( aDirURL );
				if ( nPos != aDirURL.Len() )
					continue;

				// Entry-URL starts with aDirURL.

				if ( !bDeep &&
				 	pEntry->aViewURL.Search( '/', nPos ) != STRING_NOTFOUND )
					continue;

				// Entry-URL points to a file in aDirURL.
				pViewList->Insert( pEntry, LIST_APPEND );
			}
		}
		else
		{
			// Case 4: All views of given type in given directory wanted.
			for ( ULONG n = 0; n < nCount; ++n )
			{
				CntViewEntry* pEntry = pViews->GetObject( n );

				if ( pEntry->aContentType != aType )
					continue;

				if ( pEntry->aViewURL.Len() < aDirURL.Len() )
					continue;

				xub_StrLen nPos = pEntry->aViewURL.Match( aDirURL );
				if ( nPos != aDirURL.Len() )
					continue;

				// Entry-URL starts with aDirURL.

				if ( !bDeep &&
			 		pEntry->aViewURL.Search( '/', nPos ) != STRING_NOTFOUND )
					continue;

				// Entry-URL points to a file in aDirURL.
				pViewList->Insert( pEntry, LIST_APPEND );
			}
		}
	}

	if ( !pViewList->Count() )
	{
		delete pViewList;
		return NULL;
	}

	return pViewList;
}

//----------------------------------------------------------------------------
// static
CntViewList* CntSystem::GetViews( const String& rDirURL,
	                              const String& rServiceURL,
								  BOOL bDeep /* = TRUE */ )
{
	if ( !_pSystem )
	{
		DBG_ERROR( "CntSystem::GetViews - CHAOS not initialized!" );
		return NULL;
	}

	String aServiceURL( rServiceURL );
	if ( !NormalizeURL( aServiceURL ) )
		return NULL;

	CntNodeRef xNode( CNT_RNM()->Query( aServiceURL ) );
	if ( !xNode.Is() )
		return NULL;

	xNode = xNode->GetMostReferedNode()->GetRootNode();

	const CntContentTypeItem& rTypeItem =
				(const CntContentTypeItem&)xNode->Get( WID_CONTENT_TYPE );
  	INetContentType eType = rTypeItem.GetEnumValue();

	// First, get all known views of given type...
	CntViewList* pViews = GetViews( rDirURL, eType, bDeep );
	if ( pViews )
	{
		aServiceURL = OWN_URL( xNode );

		// ... then filter out all views pointing to other objects than
		// that given with rServiceURL.

		for ( ULONG n = 1; n <= pViews->Count(); ++n )
		{
			CntViewEntry* pEntry = pViews->GetObject( n - 1 );

			CntNodeRef xView( CNT_RNM()->Query( pEntry->aViewURL ) );
			if ( xView.Is() )
			{
				const String& rServiceURL =
								OWN_URL( xView->GetMostReferedNode() );
				if ( rServiceURL != aServiceURL )
				{
					// Remove invalid entry from list.
					pViews->Remove( pEntry );

					--n;
				}
			}
		}

		if ( !pViews->Count() )
		{
			delete pViews;
			pViews = NULL;
		}
	}

	return pViews;
}

//----------------------------------------------------------------------------
// static
BOOL CntSystem::IsInitialStartup()
{
	if ( !_pSystem )
	{
		DBG_ERROR( "CntSystem::IsInitialStartup - CHAOS not initialized!" );
		return FALSE; // Ganz boeser Fall - aber nicht GPF'en!
	}

	CntStorageNode* pStorage = (CntStorageNode *)CNT_RNM()->GetStorage();
	if ( !pStorage )
		return FALSE; // Ganz boeser Fall - aber auch nicht GPF'en!

	UniString aStreamName( UniString::CreateFromAscii(
					RTL_CONSTASCII_STRINGPARAM( CNT_COMPONENT_LIST ) ) );
	LanguageType eLanguage = CntRootNodeMgr::GetIniManager()->
                              getIntlWrapper().getLanguage();
	aStreamName += UniString::CreateFromAscii(
									ResMgr::GetLang( eLanguage, 0 ) );
	SvStream* pStream = pStorage->openStream( aStreamName, STREAM_STD_READ );
	if ( !pStream )
		return TRUE;

	BOOL  bRet     = TRUE;
	ULONG nVersion = 0;
	ULONG nCount   = 0;

	*pStream >> nVersion;
	*pStream >> nCount;

	// Da die Datenbank zu einem sehr fruehen Zeitpunkt angelegt wird
	// muss der Count groesser als Eins sein, damit wir ein FALSE
	// zurueckliefern

	if ( nCount > 1 )
		bRet = FALSE;

	delete pStream;
	return bRet;
}

//----------------------------------------------------------------------------
// static
const CntExplorerList* CntSystem::GetExplorers()
{
	if ( !_pSystem )
	{
		DBG_ERROR( "CntSystem::GetExplorers - CHAOS not initialized!" );
		return NULL;
	}

	return CNT_RNM()->GetExplorers();
}

//----------------------------------------------------------------------------
// static
void CntSystem::AddExplorer( const String& rDirURL )
{
	if ( !_pSystem )
	{
		DBG_ERROR( "CntSystem::AddExplorer - CHAOS not initialized!" );
		return;
	}

	CNT_RNM()->AddExplorer( rDirURL );
}

//----------------------------------------------------------------------------
// static
void CntSystem::RemoveExplorer( const String& rDirURL )
{
	if ( !_pSystem )
	{
		DBG_ERROR( "CntSystem::RemoveExplorer - CHAOS not initialized!" );
		return;
	}

	CNT_RNM()->RemoveExplorer( rDirURL );
}

//----------------------------------------------------------------------------
// static
void CntSystem::Dump( SvStream &rStream, USHORT nLevel )
{
	CntRootNodeMgr* pRNM = CNT_RNM();
	if ( pRNM )
		pRNM->Dump( rStream, nLevel );
}

