/*************************************************************************
 *
 *  $RCSfile: srchmtch.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: mhu $ $Date: 2001/09/12 11:10:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_SRCHMTCH_HXX
#define CHAOS_SRCHMTCH_HXX

#include <vector>

#ifndef _COM_SUN_STAR_UCB_XPROPERTYMATCHERFACTORY_HPP_
#include <com/sun/star/ucb/XPropertyMatcherFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XPROPERTYMATCHER_HPP_
#include <com/sun/star/ucb/XPropertyMatcher.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _UCBHELPER_MACROS_HXX
#include <ucbhelper/macros.hxx>
#endif

namespace com { namespace sun { namespace star { namespace ucb {
	struct SearchCriterium;
} } } }
struct SearchTerm_Impl;

//============================================================================
#define PROPERTYMATCHER_FACTORY_SERVICE_NAME \
							"com.sun.star.ucb.PropertyMatcherFactory"

//============================================================================
class PropertyMatcherFactory :
				public cppu::OWeakObject,
				public com::sun::star::lang::XTypeProvider,
				public com::sun::star::lang::XServiceInfo,
			   	public com::sun::star::ucb::XPropertyMatcherFactory
{
public:
	PropertyMatcherFactory(
		const com::sun::star::uno::Reference<
			com::sun::star::lang::XMultiServiceFactory >& rXSMgr );
	virtual ~PropertyMatcherFactory();

	// XInterface
	XINTERFACE_DECL()

	// XTypeProvider
	XTYPEPROVIDER_DECL()

    // XServiceInfo
	XSERVICEINFO_DECL()

	// XPropertyMatcherFactory
	virtual com::sun::star::uno::Reference<
		com::sun::star::ucb::XPropertyMatcher > SAL_CALL
	createPropertyMatcher( const com::sun::star::uno::Sequence<
				  			com::sun::star::ucb::SearchCriterium > & Criteria)
		throw ( com::sun::star::uno::RuntimeException );

private:
	com::sun::star::uno::Reference<
		com::sun::star::lang::XMultiServiceFactory > m_xSMgr;
};

//============================================================================
class PropertyMatcher:
	public cppu::OWeakObject,
	public com::sun::star::ucb::XPropertyMatcher
{
	std::vector< std::vector< SearchTerm_Impl > > m_aCriteria;

public:
	PropertyMatcher(const com::sun::star::uno::Sequence<
						            com::sun::star::ucb::SearchCriterium > &
						      rTheCriteria);

    virtual com::sun::star::uno::Any SAL_CALL
	queryInterface(const com::sun::star::uno::Type & rType)
		throw(com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL acquire() throw()
	{ OWeakObject::acquire(); }

    virtual void SAL_CALL release() throw()
	{ OWeakObject::release(); }

	virtual sal_Bool SAL_CALL
	matches(const com::sun::star::uno::Reference<
			          com::sun::star::ucb::XCommandProcessor > &
			    rProperties,
			const com::sun::star::uno::Reference<
			          com::sun::star::ucb::XCommandEnvironment > &
			    rEnvironment)
		throw (com::sun::star::uno::RuntimeException);
};

#endif // CHAOS_SRCHMTCH_HXX

