/*************************************************************************
 *
 *  $RCSfile: xdatacnt.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: mhu $ $Date: 2001/06/06 16:43:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _RTL_MEMORY_H_
#include <rtl/memory.h>
#endif
#ifndef _VOS_MUTEX_HXX_ //autogen
#include <vos/mutex.hxx>
#endif
#ifndef _CHAOS_SEQISTRM_HXX
#include "seqistrm.hxx"
#endif
#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif
#ifndef _FSYS_HXX //autogen
#include <tools/fsys.hxx>
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#include <xdatacnt.hxx>

using namespace chaos;

using namespace com::sun::star::io;
using namespace com::sun::star::ucb;
using namespace com::sun::star::container;
using namespace com::sun::star::lang;
using namespace com::sun::star::uno;

//============================================================================

DECLARE_LIST( CntUnoDataContainerList, XDataContainer* )

//============================================================================
//
// class CntUnoDataContainer_Impl.
//
//============================================================================

class CntUnoDataContainer_Impl
{
private:
	rtl::OUString	 			m_aDataURL;
	rtl::OUString	 			m_aContentType;
    rtl::OUString               m_aName;
	Sequence< sal_Int8 >* 		m_pData;
	Reference< XInputStream >	m_xStream;
	CntUnoDataContainerList		m_aChildList;
	vos::OMutex					m_aMutex;

public:
	CntUnoDataContainer_Impl();
	~CntUnoDataContainer_Impl();

    sal_Int32  getCount() const { return m_aChildList.Count(); }
    Any getByIndex( sal_Int32 Index )
		throw( IndexOutOfBoundsException );
	void insertByIndex( sal_Int32 Index,
						const Reference< XDataContainer >& rChild )
		throw( IndexOutOfBoundsException );
    void removeByIndex( sal_Int32 Index )
		throw( IndexOutOfBoundsException );
	void replaceByIndex( sal_Int32 Index,
						 const Reference< XDataContainer >& rNew )
		throw( IndexOutOfBoundsException );
    const rtl::OUString& getContentType() const { return m_aContentType; }
    void setContentType( const rtl::OUString& ContentType )
	{ m_aContentType = ContentType; }

    Sequence< sal_Int8 > getData();
    void setData( const Sequence< sal_Int8 >& Data );

    const rtl::OUString& getDataURL();
    void setDataURL( const rtl::OUString& DataURL );

	Reference< XInputStream > getInputStream();
	void setInputStream( const Reference< XInputStream >& xStream );

    const rtl::OUString& getName() const { return m_aName; }
    void setName( const rtl::OUString& Name ) { m_aName = Name; }
};

//============================================================================
//
// CntUnoDataContainer_Impl Implementation.
//
//============================================================================

CntUnoDataContainer_Impl::CntUnoDataContainer_Impl()
: m_pData( NULL )
{
}

//----------------------------------------------------------------------------
CntUnoDataContainer_Impl::~CntUnoDataContainer_Impl()
{
	ULONG nCount = m_aChildList.Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		// Release reference to object.
		m_aChildList.GetObject( n )->release();
	}

	delete m_pData;
}

//----------------------------------------------------------------------------
Sequence< sal_Int8 > CntUnoDataContainer_Impl::getData()
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_pData )
	{
		if ( m_xStream.is() )
		{
			try
            {
				m_pData = new Sequence< sal_Int8 >( 65536 );

				sal_Int32 nPos = 0;
            	Sequence< sal_Int8 > aBuffer;

                sal_Int32 nRead = m_xStream->readSomeBytes( aBuffer, 65536 );
                while ( nRead > 0 )
                {
					if ( m_pData->getLength() < ( nPos + nRead ) )
						m_pData->realloc( nPos + nRead );

					aBuffer.realloc( nRead );
					rtl_copyMemory( (void*)( m_pData->getArray() + nPos ),
					                (const void*)aBuffer.getConstArray(),
									nRead );
					nPos += nRead;

					aBuffer.realloc( 0 );
	                nRead = m_xStream->readSomeBytes( aBuffer, 65536 );
                }

				m_pData->realloc( nPos );
            }
            catch ( NotConnectedException const & ) {}
            catch ( BufferSizeExceededException const & ) {}
            catch ( IOException const & ) {}
		}
		else
			return Sequence< sal_Int8 >( 0 );
	}
	return Sequence< sal_Int8 >( *m_pData );
}

//----------------------------------------------------------------------------
void CntUnoDataContainer_Impl::setData( const Sequence< sal_Int8 >& Data )
{
	vos::OGuard aGuard( m_aMutex );

	m_aDataURL = rtl::OUString();
	m_xStream = 0;

	delete m_pData;
	m_pData = new Sequence< sal_Int8 >( Data );
}

//----------------------------------------------------------------------------
const rtl::OUString& CntUnoDataContainer_Impl::getDataURL()
{
	vos::OGuard aGuard( m_aMutex );

	if ( m_aDataURL.getLength() )
	{
		DirEntry aDirEntry( m_aDataURL,	FSYS_STYLE_URL );
		if ( !aDirEntry.Exists() )
		{
			DBG_ERROR( "CntUnoDataContainer_Impl::getDataURL() - "
					   "file not exists!" );
			m_aDataURL = rtl::OUString();
		}
	}
	return m_aDataURL;
}

//----------------------------------------------------------------------------
void CntUnoDataContainer_Impl::setDataURL( const rtl::OUString& DataURL )
{
	vos::OGuard aGuard( m_aMutex );

	if ( INetURLObject::CompareProtocolScheme( DataURL ) != INET_PROT_FILE )
	{
		DBG_ERROR( "CntUnoDataContainer_Impl::setDataURL - "
				   "Invalid protocol!" );
		return;
	}

	delete m_pData;
	m_pData = NULL;
	m_xStream = 0;

	m_aDataURL = DataURL;
}

//----------------------------------------------------------------------------
Reference< XInputStream > CntUnoDataContainer_Impl::getInputStream()
{
	vos::OGuard aGuard( m_aMutex );

	if ( !m_xStream.is() && m_pData )
		m_xStream = new SequenceInputStream( *m_pData );

	return m_xStream;
}

//----------------------------------------------------------------------------
void CntUnoDataContainer_Impl::setInputStream(
								const Reference< XInputStream >& xStream )
{
	vos::OGuard aGuard( m_aMutex );

	m_aDataURL = rtl::OUString();
	delete m_pData;
	m_pData = 0;

	m_xStream = xStream;

	Reference< XSeekable > xSeekable( xStream, UNO_QUERY );
	if ( !xSeekable.is() )
	{
		// Hold data as byte sequence.
		getData();
		m_xStream = 0;
	}
}

//----------------------------------------------------------------------------
Any CntUnoDataContainer_Impl::getByIndex( sal_Int32 Index )
	throw( IndexOutOfBoundsException )
{
	vos::OGuard aGuard( m_aMutex );

	Any aAny;

	if ( ( Index < 0 ) ||
	     ( sal_uInt32( Index + 1 ) > m_aChildList.Count() ) )
	{
		DBG_ERROR( "CntUnoDataContainer_Impl::getByIndex - "
		           "Invalid index!" );
		throw IndexOutOfBoundsException();
	}

	Reference< XDataContainer > xContainer( m_aChildList.GetObject( Index ) );
	aAny <<= xContainer;
	return aAny;
}

//----------------------------------------------------------------------------
void CntUnoDataContainer_Impl::insertByIndex(
				sal_Int32 Index, const Reference< XDataContainer >& rChild )
	throw( IndexOutOfBoundsException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( Index < 0 )
	{
		DBG_ERROR( "CntUnoDataContainer_Impl::insertByIndex - "
		           "Invalid index!" );
		throw IndexOutOfBoundsException();
	}

	if ( sal_uInt32( Index + 1 ) > m_aChildList.Count() )
	{
		// Index out of range -> Append child to list.
		Index = LIST_APPEND;
	}

	// Hold child and insert it into child list.
	rChild->acquire();
	m_aChildList.Insert( rChild.get(), Index );
}

//----------------------------------------------------------------------------
void CntUnoDataContainer_Impl::removeByIndex( INT32 Index )
	throw( IndexOutOfBoundsException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( ( Index < 0 ) ||
	     ( sal_uInt32( Index + 1 ) > m_aChildList.Count() ) )
	{
		DBG_ERROR( "CntUnoDataContainer_Impl::removeByIndex - "
		           "Invalid index!" );
		throw IndexOutOfBoundsException();
	}

	XDataContainer* pChild = m_aChildList.GetObject( Index );
	m_aChildList.Remove( pChild );

	// Release reference to object.
	pChild->release();
}

//----------------------------------------------------------------------------
void CntUnoDataContainer_Impl::replaceByIndex(
					sal_Int32 Index, const Reference< XDataContainer >& rNew )
	throw( IndexOutOfBoundsException )
{
	vos::OGuard aGuard( m_aMutex );

	if ( ( Index < 0 ) ||
	     ( sal_uInt32( Index + 1 ) > m_aChildList.Count() ) )
	{
		DBG_ERROR( "CntUnoDataContainer_Impl::replaceByIndex - "
		           "Invalid index!" );
		throw IndexOutOfBoundsException();
	}

	removeByIndex( Index );
	insertByIndex( Index, rNew );
}

//============================================================================
//
// CntUnoDataContainer Implementation.
//
//============================================================================

CntUnoDataContainer::CntUnoDataContainer(
						const Reference< XMultiServiceFactory >& rXSMgr )
: m_pImp( new CntUnoDataContainer_Impl )
{
}

//----------------------------------------------------------------------------
// virtual
CntUnoDataContainer::~CntUnoDataContainer()
{
	delete m_pImp;
}

//----------------------------------------------------------------------------
// XInterface methods.
//----------------------------------------------------------------------------

XINTERFACE_IMPL_9( CntUnoDataContainer,
				   XServiceInfo,
				   XTypeProvider,
				   XDataContainer,
				   XIndexContainer, 	/* base of  XDataContainer */
				   XIndexReplace,   	/* base of XIndexContainer */
				   XIndexAccess,    	/* base of XIndexReplace */
				   XElementAccess, 		/* base of XIndexAccess */
                   XActiveDataSink,
                   XNamed );

//----------------------------------------------------------------------------
// XTypeProvider methods.
//----------------------------------------------------------------------------

XTYPEPROVIDER_IMPL_5( CntUnoDataContainer,
				   	  XServiceInfo,
				   	  XTypeProvider,
					  XDataContainer,
                      XActiveDataSink,
                      XNamed );

//----------------------------------------------------------------------------
// XServiceInfo methods
//----------------------------------------------------------------------------

XSERVICEINFO_IMPL_1( CntUnoDataContainer,
					 rtl::OUString::createFromAscii(
							"com.sun.star.comp.chaos.CntUnoDataContainer" ),
					 rtl::OUString::createFromAscii(
							XDATACONTAINER_SERVICE_NAME  ) );

//----------------------------------------------------------------------------
// Service factory implementation.
//----------------------------------------------------------------------------

SINGLE_SERVICE_FACTORY_IMPL( CntUnoDataContainer );

//----------------------------------------------------------------------------
// XDataContainer methods.
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// virtual
rtl::OUString SAL_CALL CntUnoDataContainer::getContentType()
	throw( RuntimeException )
{
	return m_pImp->getContentType();
}

//----------------------------------------------------------------------------
// virtual
void SAL_CALL CntUnoDataContainer::setContentType( const rtl::OUString& aType )
	throw( RuntimeException )
{
	m_pImp->setContentType( aType );
}

//----------------------------------------------------------------------------
// virtual
Sequence< sal_Int8 > SAL_CALL CntUnoDataContainer::getData()
	throw( RuntimeException )
{
	return m_pImp->getData();
}

//----------------------------------------------------------------------------
// virtual
void SAL_CALL CntUnoDataContainer::setData(	const Sequence< sal_Int8 >& aData )
	throw( RuntimeException )
{
	m_pImp->setData( aData );
}

//----------------------------------------------------------------------------
// virtual
rtl::OUString SAL_CALL CntUnoDataContainer::getDataURL()
	throw( RuntimeException )
{
	return m_pImp->getDataURL();
}

//----------------------------------------------------------------------------
// virtual
void SAL_CALL CntUnoDataContainer::setDataURL( const rtl::OUString& aURL )
	throw( RuntimeException )
{
	m_pImp->setDataURL( aURL );
}

//----------------------------------------------------------------------------
// XIndexContainer methods.
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// virtual
void SAL_CALL CntUnoDataContainer::insertByIndex(
										sal_Int32 Index, const Any& Element )
	throw( IllegalArgumentException,
	   	   IndexOutOfBoundsException,
	   	   WrappedTargetException,
	   	   RuntimeException )
{
	Reference< XDataContainer > xContainer;
	if ( Element >>= xContainer )
	{
		m_pImp->insertByIndex( Index, xContainer );
		return;
	}

	DBG_ERROR( "CntUnoDataContainer::insertByIndex - Invalid type!" );
	throw IllegalArgumentException();
}

//----------------------------------------------------------------------------
// virtual
void SAL_CALL CntUnoDataContainer::removeByIndex( sal_Int32 Index )
	throw( IndexOutOfBoundsException,
		   WrappedTargetException,
		   RuntimeException )
{
	m_pImp->removeByIndex( Index );
}

//----------------------------------------------------------------------------
// XIndexReplace methods.
//----------------------------------------------------------------------------

// virtual
void SAL_CALL CntUnoDataContainer::replaceByIndex(
										sal_Int32 Index, const Any& Element )
	throw( IllegalArgumentException,
		   IndexOutOfBoundsException,
		   WrappedTargetException,
		   RuntimeException )
{
	Reference< XDataContainer > xContainer;
	if ( Element >>= xContainer )
	{
		m_pImp->replaceByIndex( Index, xContainer );
		return;
	}

	DBG_ERROR( "CntUnoDataContainer::replaceByIndex - Invalid type!" );
	throw IllegalArgumentException();
}

//----------------------------------------------------------------------------
// XIndexAccess methods.
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// virtual
sal_Int32 SAL_CALL CntUnoDataContainer::getCount()
	throw( RuntimeException )
{
	return m_pImp->getCount();
}

//----------------------------------------------------------------------------
// virtual
Any SAL_CALL CntUnoDataContainer::getByIndex( sal_Int32 Index )
	throw( IndexOutOfBoundsException,
		   WrappedTargetException,
		   RuntimeException )
{
	return m_pImp->getByIndex( Index );
}

//----------------------------------------------------------------------------
// XElementAccess methods.
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
//virtual
Type SAL_CALL CntUnoDataContainer::getElementType()
	throw( RuntimeException )
{
	return getCppuType( ( Reference< XDataContainer >* ) 0 );
}

//----------------------------------------------------------------------------
// virtual
sal_Bool SAL_CALL CntUnoDataContainer::hasElements()
	throw( RuntimeException )
{
	return ( m_pImp->getCount() > 0 );
}

//----------------------------------------------------------------------------
// XActiveDataSink methods.
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
//virtual
void SAL_CALL CntUnoDataContainer::setInputStream(
								const Reference< XInputStream >& aStream )
	throw( RuntimeException )
{
	m_pImp->setInputStream( aStream );
}

//----------------------------------------------------------------------------
//virtual
Reference< XInputStream > SAL_CALL CntUnoDataContainer::getInputStream()
	throw( RuntimeException )
{
	return m_pImp->getInputStream();
}

//----------------------------------------------------------------------------
// XNamed methods.
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
//virtual
rtl::OUString SAL_CALL CntUnoDataContainer::getName()
	throw( RuntimeException )
{
    return m_pImp->getName();
}

//----------------------------------------------------------------------------
//virtual
void SAL_CALL CntUnoDataContainer::setName( const rtl::OUString& aName )
	throw( RuntimeException )
{
    m_pImp->setName( aName );
}

