/*************************************************************************
 *
 *  $RCSfile: imapacnt.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/01/31 15:32:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <limits>

#ifndef _INET_CONFIG_HXX
#include <inet/inetcfg.hxx>
#endif
#ifndef _INETCOREMAIL_HXX
#include <inet/inetmail.hxx>
#endif
#ifndef _INET_WRAPPER_HXX
#include <inet/wrapper.hxx>
#endif
#ifndef _CNTWIDS_HRC
#include <svtools/cntwids.hrc>
#endif
#ifndef _SVTOOLS_CTYPEITM_HXX
#include <svtools/ctypeitm.hxx>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef TOOLS_INETMIME_HXX
#include <tools/inetmime.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _CNTCMITM_HXX
#include <cntcmitm.hxx>
#endif
#ifndef _CNTMSGNODE_HXX
#include <cntmsgnd.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CNTXREF_HXX
#include <cntxref.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _CHAOS_EXPORT_HXX
#include <export.hxx>
#endif
#ifndef CHAOS_FLSTITEM_HXX
#include <flstitem.hxx>
#endif
#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif
#ifndef _CHAOS_IMAP_HXX
#include <imap.hxx>
#endif
#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif
#ifndef _LAYITEM_HXX
#include <layitem.hxx>
#endif
#ifndef _RCPNITEM_HXX
#include <rcpnitem.hxx>
#endif
#ifndef _SILITEM_HXX
#include <silitem.hxx>
#endif
#ifndef _SORTITEM_HXX
#include <sortitem.hxx>
#endif
#ifndef _CHAOS_STORITEM_HXX
#include <storitem.hxx>
#endif
#ifndef _THRDITEM_HXX
#include <thrditem.hxx>
#endif
#ifndef _ULSTITEM_HXX
#include <ulstitem.hxx>
#endif

#ifndef CHAOS_IMAPACNT_HXX
#include <imapacnt.hxx>
#endif
#ifndef CHAOS_IMAPACTT_HXX
#include <imapactt.hxx>
#endif
#ifndef CHAOS_IMAPMBOX_HXX
#include <imapmbox.hxx>
#endif
#ifndef CHAOS_IMAPMBXT_HXX
#include <imapmbxt.hxx>
#endif
#ifndef CHAOS_IMAPMESG_HXX
#include <imapmesg.hxx>
#endif
#ifndef CHAOS_IMAPMSGT_HXX
#include <imapmsgt.hxx>
#endif
#ifndef CHAOS_IMAPSTOR_HXX
#include <imapstor.hxx>
#endif
#ifndef CHAOS_IMAPTASK_HXX
#include <imaptask.hxx>
#endif
#ifndef CHAOS_IMAPURL_HXX
#include <imapurl.hxx>
#endif

namespace unnamed_chaos_imapacnt {} using namespace unnamed_chaos_imapacnt;
	// unnamed namespaces don't work well yet...

using namespace chaos;

SV_IMPL_REF(CntStoreItemSet)

//============================================================================
namespace unnamed_chaos_imapacnt {

USHORT const aCntIMAPAcntNodeRanges[]
	= { WID_TITLE, WID_TITLE,
		WID_DEFAULT, WID_MESSAGEVIEW_MODE,
		WID_SORTING, WID_SORTING,
		WID_FILTERED, WID_IMAP_SSCRBD_MBOX_COUNT,
			// i.e., ..., WID_SUBSCRNEWSGROUPCOUNT
		WID_IMAP_MESG_COUNT, WID_IMAP_MESG_COUNT,
			// i.e., WID_TOTALCONTENTCOUNT, WID_TOTALCONTENTCOUNT
		WID_IMAP_READ_MESG_COUNT, WID_IMAP_READ_MESG_COUNT,
			// i.e., WID_SEENCONTENTCOUNT, WID_SEENCONTENTCOUNT
		WID_PREPARE_MOVE, WID_SERVERNAME,
		WID_SERVERBASE, WID_SERVERBASE,
		WID_NEWS_GROUPLIST, WID_MESSAGE_STOREMODE,
		WID_SERVER_RANGES, WID_REOPEN,
		WID_MSG_COLUMN_WIDTHS, WID_SEND_FROM_DEFAULT,
		WID_SEND_VIM_POPATH, WID_SEND_VIM_POPATH,
		WID_SEARCH, WID_SEARCH,
		WID_IMAP_MARKED_MESG_COUNT, WID_IMAP_MBOX_COUNT,
			// i.e., WID_MARKED_DOCUMENT_COUNT, WID_FOLDER_COUNT
		WID_EXPORT, WID_EXPORT,
		WID_VIEW_START, WID_VIEW_END,
		WID_FLAG_UPDATE_ON_OPEN, WID_FLAG_UPDATE_ON_OPEN,
		WID_VIEW2_START, WID_VIEW2_END,
		WID_FOLDER_START2, WID_FOLDER_END2,
		WID_VIEW3_START, WID_VIEW3_END,
		WID_SEND_FORMATS, WID_SEND_COPY_TARGET, 0 };

//============================================================================
USHORT const aCntIMAPAcntDirSetRanges[]
	= { WID_IMAP_SSCRBD_MBOX_COUNT, WID_IMAP_SSCRBD_MBOX_COUNT,
			// i.e., WID_SUBSCRNEWSGROUPCOUNT, WID_SUBSCRNEWSGROUPCOUNT
		WID_IMAP_MBOX_COUNT, WID_IMAP_MBOX_COUNT, 0 };
			// i.e., WID_FOLDER_COUNT, WID_FOLDER_COUNT

}

//============================================================================
//
//  CntIMAPAcntNode
//
//============================================================================

CNT_NODE_SUBCLASS_IMPL(CntIMAPAcntNode)
{
	CntRootNodeMgr::InsertFactory(
		new CntNodeFactory(String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(
			                                           CNT_IMAP_URL_PREFIX
													       "*")),
						   '/', TYPE(CntIMAPAcntNode),
						   CONTENT_TYPE_X_CNT_IMAPBOX,
						   CNT_CREATION_FLAG_PROPERTIES
						   	| CNT_CREATION_FLAG_KIND_FOLDER,
						   HID_CHAOS_NEW_IMAP_BOX));
	InsertFactory(new CntNodeFactory(String(), String(), TYPE(CntMessageNode),
									 CONTENT_TYPE_X_CNT_MESSAGE,
									 CNT_CREATION_FLAG_MESSAGEDOC
									     | CNT_CREATION_FLAG_SENDMESSAGE
										 | CNT_CREATION_FLAG_KIND_DOCUMENT,
									 HID_CHAOS_NEW_IMAP_MSG));
	InsertFactory(new CntNodeFactory(String::CreateFromAscii(
		                                 RTL_CONSTASCII_STRINGPARAM("/*")),
									 String::CreateFromAscii(
										 RTL_CONSTASCII_STRINGPARAM("/;")),
									 TYPE(CntIMAPMboxNode),
									 CONTENT_TYPE_X_CNT_IMAPFOLDER,
									 CNT_CREATION_FLAG_TITLE
									 	| CNT_CREATION_FLAG_KIND_FOLDER,
									 HID_CHAOS_NEW_IMAP_FLD));
}

//============================================================================
CntIMAPAcntNode::CntIMAPAcntNode():
	CntIMAPFldrNode(aCntIMAPAcntNodeRanges, new CntIMAPAcnt(*this))
{
	CntDefaults * pDefaults = GetDefaults();
	if (!pDefaults)
	{
		pDefaults = new CntDefaults(*this, aCntIMAPAcntNodeRanges);

		pDefaults->Put(CntUInt32Item(WID_IMAP_SSCRBD_MBOX_COUNT, 0));

		pDefaults->Put(CntContentTypeItem(WID_CONTENT_TYPE,
										  CONTENT_TYPE_X_CNT_IMAPBOX));

		pDefaults->Put(CntBoolItem(WID_FLAG_IS_FOLDER, true));
		pDefaults->Put(CntBoolItem(WID_FLAG_HAS_FOLDER, true));
		pDefaults->Put(CntBoolItem(WID_FLAG_HAS_MESSAGES, false));

		pDefaults->Put(CntUShortListItem(WID_RENAME, WID_TITLE, 0));

		pDefaults->Put(CntFolderViewModeItem(WID_FOLDERVIEW_MODE,
											 CNT_VIEW_SUBSCRIBED_FOLDERS));

		CntViewColumnsListItem
		 aColumns(WID_VIEW_COLS_BEAMER,
				  WID_FROM, DEF_WIDTH_FROM,
				  WID_TITLE, DEF_WIDTH_TITLE_MAIL,
				  WID_DATE_CREATED, DEF_WIDTH_DATE_CREATED,
				  WID_DOCUMENT_SIZE, DEF_WIDTH_DOCUMENT_SIZE,
				  WID_IS_MARKED, DEF_WIDTH_IS_MARKED,
				  WID_IS_READ, DEF_WIDTH_IS_READ, 0);
		pDefaults->Put(aColumns);
		aColumns.SetWhich(WID_VIEW_COLS_FILEDLG);
		pDefaults->Put(aColumns);
		aColumns.SetWhich(WID_VIEW_COLS_FLDWIN);
		pDefaults->Put(aColumns);

		CntSortingItem aSorting(WID_SORTING);
		aSorting.Append(CntSortingInfo(WID_DATE_CREATED, false));
		aSorting.Append(CntSortingInfo(WID_TITLE, true));
		aSorting.Append(CntSortingInfo(WID_FROM, true));
		aSorting.Append(CntSortingInfo(WID_DOCUMENT_SIZE, true));
		aSorting.Append(CntSortingInfo(WID_IS_MARKED, true));
		aSorting.Append(CntSortingInfo(WID_IS_READ, false));
		pDefaults->Put(aSorting);
		aSorting.SetWhich(WID_VIEW_SORT_BEAMER);
		pDefaults->Put(aSorting);
		aSorting.SetWhich(WID_VIEW_SORT_FILEDLG);
		pDefaults->Put(aSorting);
		aSorting.SetWhich(WID_VIEW_SORT_FLDWIN_DETAILS);
		pDefaults->Put(aSorting);
		aSorting.SetWhich(WID_VIEW_SORT_FLDWIN_ICON);
		pDefaults->Put(aSorting);

		CntThreadingItem aThreading(WID_THREADING);
		aThreading.Append(CntThreadingInfo(CNT_THREADING_BY_PARENTCHAIN,
										   WID_FLAG_IS_MESSAGE,
										   WID_IN_REPLY_TO, WID_MESSAGE_ID,
										   '<', WID_TITLE));
		aThreading.Append(CntThreadingInfo(CNT_THREADING_BY_PARENTCHAIN,
										   WID_FLAG_IS_MESSAGE,
										   WID_REFERENCES, WID_MESSAGE_ID,
										   '<', WID_TITLE));
		aThreading.Append(CntThreadingInfo(CNT_THREADING_BY_PROPVALUE,
										   WID_FLAG_IS_MESSAGE, WID_TITLE,
										   WID_TITLE));
		pDefaults->Put(aThreading);

		pDefaults->Put(CntLayoutItem(WID_VIEW_LAYOUT_FLDWIN,
									 LAYOUT_MAILNEWS));

		pDefaults->Put(CntIdentifierListItem(WID_PROPERTYLIST,
										 CNT_TABPAGE_GENERAL,
										 CNT_TABPAGE_RECV_IMAP,
										 CNT_TABPAGE_MAIL_NEWS_SEND,
										 CNT_TABPAGE_RULES,
										 CNT_TABPAGE_SUBSCRIBE,
										 CNT_TABPAGE_VIEW_PROPERTIES,
										 CNT_TABPAGE_HEADER,
										 CNT_TABPAGE_CONTENT_PROPERTIES,
										 CNT_TABPAGE_BACKGROUND,
										 CNT_TABPAGE_FONT, 0));

		pDefaults->Put(CntBoolItem(WID_OUTTRAY_WANTED, true));
	}
	CntInterface::SetParent(pDefaults);
}

//============================================================================
TYPEINIT1_AUTOFACTORY(CntIMAPAcntNode, CntIMAPFldrNode)

//============================================================================
// virtual
FASTBOOL CntIMAPAcntNode::IsItemFlag(USHORT nWhich, USHORT nFlag) const
{
	if (nFlag == CNT_ITEM_SYNCHRON)
		switch (nWhich)
		{
			case WID_SERVERBASE:
			case WID_SERVERNAME:
			case WID_USERNAME:
				return false;
		}
	return CntIMAPFldrNode::IsItemFlag(nWhich, nFlag);
}

//============================================================================
// virtual
void CntIMAPAcntNode::GetOwnURL(String & rURL)
{
	// Skip the "imap://" prefix and cut after the first following "/" (but
	// leave a dummy URL of "imap://" unchanged):
	xub_StrLen nPos = 0;
	if (rURL.EqualsAscii(CNT_IMAP_URL_PREFIX, 0,
						 RTL_CONSTASCII_LENGTH(CNT_IMAP_URL_PREFIX)))
		if (rURL.Len() == RTL_CONSTASCII_LENGTH(CNT_IMAP_URL_PREFIX))
			nPos = RTL_CONSTASCII_LENGTH(CNT_IMAP_URL_PREFIX);
		else
		{
			nPos = rURL.Search('/',
							   RTL_CONSTASCII_LENGTH(CNT_IMAP_URL_PREFIX));
			if (nPos == STRING_NOTFOUND)
				nPos = 0;
			else
				++nPos;
		}
	rURL.Erase(nPos);
}

//============================================================================
// virtual
void CntIMAPAcntNode::SetConnMode(CntConnMode eConnMode)
{
	bool bGoOffline;
	{
		vos::OGuard aGuard(getMutex());
		bGoOffline = getAcnt().isOnline()
			         && eConnMode != CNT_CONN_MODE_ONLINE;
		getAcnt().setOnline(eConnMode == CNT_CONN_MODE_ONLINE);
	}

	if (bGoOffline)
		InsertJob(new CntNodeJob(0, this, this,
								 CntConnModeItem(WID_CONNECTION_MODE,
												 CNT_CONN_MODE_OFFLINE)));
}

//============================================================================
// virtual
SfxPoolItem const * CntIMAPAcntNode::JobArrived(CntNodeJob * pJob)
{
	CntNodeJob * pParentJob = pJob->GetParent();
	if (pParentJob)
	{
		bool bForwardSubJob = false;
		{
			vos::OGuard aGuard(getMutex());
			CntNodeJobQueue * pQueue = GetJobQueue();
			if (pQueue && pQueue->Count() != 0)
			{
				CntNodeJobList * pList = pQueue->GetObject(0);
				if (pList && pList->Count() != 0
					&& pList->GetObject(0) == pParentJob)
				{
					CntIMAPTask * pParentTask
						= static_cast< CntIMAPTask * >(pParentJob->
													       GetRequestData());
					if (pParentTask && pParentTask->isForwardTask())
					{
						getAcnt().addForwardSubJob(*pJob);
						bForwardSubJob = true;
					}
				}
			}
		}

		if (bForwardSubJob)
		{
			pJob->Started();
			return ExecuteJob(pJob);
		}
	}
	return CntIMAPFldrNode::JobArrived(pJob);
}

//============================================================================
// virtual
BOOL CntIMAPAcntNode::JobFinished(CntNodeJob * pJob)
{
	CntNodeJob * pParentJob = pJob->GetParent();
	if (pParentJob)
	{
		CntIMAPTask * pParentTask
			= static_cast< CntIMAPTask * >(pParentJob->GetRequestData());
		if (pParentTask && pParentTask->isForwardTask())
		{
			vos::OGuard aGuard(getMutex());
			if (getAcnt().removeForwardSubJob(*pJob))
				return true;
		}
	}

	bool bFinished = CntIMAPFldrNode::JobFinished(pJob) != false;
	if (!(IsDead() || getAcnt().isOpen()))
	{
		bool bQueuedJobs = false;
		{
			vos::OGuard aGuard(getMutex());
			CntNodeJobQueue * pQueue = GetJobQueue();
			if (pQueue && pQueue->Count())
			{
				CntNodeJobList * pList = pQueue->GetObject(0);
				if (pList && pList->Count())
					bQueuedJobs = true;
			}
		}

		if (!bQueuedJobs)
		{
			bool bGoOffline;
			switch (pJob->GetRequest()->Which())
			{
				case WID_CONNECTION_MODE:
					bGoOffline = ITEM_VALUE(CntConnModeItem,
											*pJob->GetRequest())
						             == CNT_CONN_MODE_ONLINE;
					break;

				case WID_CLOSE:
					bGoOffline = false;
					break;

				default:
					bGoOffline = true;
					break;
			}
			if (bGoOffline)
				InsertJob(new CntNodeJob(0, this, this,
										 CntConnModeItem(
											 WID_CONNECTION_MODE,
											 CNT_CONN_MODE_OFFLINE)));
		}
	}
	return bFinished;
}

//============================================================================
// virtual
SfxPoolItem const * CntIMAPAcntNode::InsertJob(CntNodeJob * pJob)
{
	getAcnt().initialize(*pJob);

	DBG_ASSERT(pJob->GetSubject()->GetRootNode() == this,
			   "CntIMAPAcntNode::InsertJob(): Invalid subject");

	if (pJob->GetRequest()->Which() == WID_CREATE_NEW)
		return getAcnt().createNewNode(*pJob);

	return CntIMAPFldrNode::InsertJob(pJob);
}

//============================================================================
// virtual
SfxPoolItem const * CntIMAPAcntNode::ExecuteJob(CntNodeJob * pJob)
{
	if (pJob->GetRequestData())
		return static_cast< CntIMAPTask * >(pJob->GetRequestData())->run();

	if (pJob->GetSubject() == this)
	{
		getAcnt().initialize(*pJob);
		switch (pJob->GetRequest()->Which())
		{
			case WID_USERNAME:
				getAcnt().
					changeUserIDOrHostPort(*pJob,
										   &ITEM_VALUE(CntStringItem,
													   *pJob->GetRequest()),
										   0);
				pJob->Done();
				return 0;

			case WID_SERVERNAME:
				getAcnt().
					changeUserIDOrHostPort(*pJob, 0,
										   &ITEM_VALUE(CntStringItem,
													   *pJob->GetRequest()));
				pJob->Done();
				return 0;

			case WID_SERVERBASE:
				getAcnt().changeBase(*pJob,
									 ITEM_VALUE(CntStringItem,
												*pJob->GetRequest()));
				pJob->Done();
				return 0;

			case WID_PUTDATA:
				getAcnt().changeData(*pJob);
				return pJob->IsDone() || pJob->IsCanceled() ?
					       0 : CntIMAPFldrNode::ExecuteJob(pJob);

			case WID_OPEN:
				getAcnt().incrementOpenCount();
			case WID_SEARCH:
			case WID_UPDATE:
			case WID_SYNCHRONIZE:
			{
				CntNodeJob * pParentJob = pJob->GetParent();
				if (pParentJob)
				{
					CntIMAPTask * pParentTask
						= static_cast< CntIMAPTask * >(pParentJob->
													       GetRequestData());
					if (pParentTask && pParentTask->isForwardTask())
						return (new CntIMAPAcntOpenTask(*pJob, getAcnt(),
														true))->
							       run();
				}
				if (getAcnt().hasBase())
					return (new CntIMAPBaseOpenTask(*pJob, getAcnt()))->run();
				else
					return (new CntIMAPAcntOpenTask(*pJob, getAcnt()))->run();
			}

			case WID_NEWS_GROUPLIST:
				if (static_cast< CntFolderListItem const * >(
					            pJob->GetRequest())->
					        getCommand()
					    == CntFolderListItem::SET)
				if (getAcnt().hasBase())
					return
						(new CntIMAPBaseForwardTask(*pJob, getAcnt()))->run();
				else
					return (new CntIMAPAcntSetMboxsTask(*pJob, getAcnt()))->
						       run();
				else
					if (getAcnt().hasBase())
						return (new CntIMAPBaseGetMboxsTask(*pJob,
															getAcnt()))->
							       run();
					else
						return (new CntIMAPAcntGetMboxsTask(*pJob,
															getAcnt()))->
							       run();

			case WID_IMPORT:
				return (new CntIMAPAcntImportTask(*pJob, getAcnt()))->run();

			case WID_EXPORT:
				return (new CntIMAPAcntExportTask(*pJob, getAcnt()))->run();

			case WID_IS_READ:
			case WID_IS_MARKED:
				if (getAcnt().hasBase())
					return
						(new CntIMAPBaseForwardTask(*pJob, getAcnt()))->run();
				else
				{
					pJob->Cancel();
					return 0;
				}

			case WID_CONNECTION_MODE:
				if (ITEM_VALUE(CntConnModeItem, *pJob->GetRequest())
					    != CNT_CONN_MODE_ONLINE)
					return
						(new CntIMAPAcntCloseTask(*pJob, getAcnt()))->run();
				else
				{
					pJob->Done();
					return 0;
				}

			case WID_CLOSE:
				if (getAcnt().decrementOpenCount(*pJob->GetRequest()))
					return
						(new CntIMAPAcntCloseTask(*pJob, getAcnt()))->run();
				else
				{
					pJob->Done();
					return 0;
				}

			default:
				return CntIMAPFldrNode::ExecuteJob(pJob);
		}
	}
	else if (CntIMAPMboxNode * pMboxNode = PTR_CAST(CntIMAPMboxNode,
													pJob->GetSubject()))
		switch (pJob->GetRequest()->Which())
		{
			case WID_TITLE:
				return (new CntIMAPMboxRenameTask(*pJob,
												  pMboxNode->getMbox()))->
					       run();

			case WID_OPEN:
			case WID_SEARCH:
			case WID_UPDATE:
			case WID_SYNCHRONIZE:
				return (new CntIMAPMboxOpenTask(*pJob,
												pMboxNode->getMbox()))->
					       run();

			case WID_NEWS_GROUPLIST:
				if (static_cast< CntFolderListItem const * >(
					            pJob->GetRequest())->
					        getCommand()
					    == CntFolderListItem::SET)
					return (new CntIMAPMboxSetSubMboxsTask(*pJob,
														   pMboxNode->
														       getMbox()))->
						       run();
				else
					return (new CntIMAPMboxGetSubMboxsTask(*pJob,
														   pMboxNode->
														       getMbox()))->
						       run();

			case WID_INSERT:
				return (new CntIMAPMboxCreateTask(*pJob,
												  pMboxNode->getMbox()))->
					       run();

			case WID_TRANSFER:
				return (new CntIMAPMboxTransferTask(*pJob,
													pMboxNode->getMbox()))->
					       run();

			case WID_DELETE:
				return (new CntIMAPMboxDeleteTask(*pJob,
												  pMboxNode->getMbox()))->
					       run();

			case WID_UNDELETE:
				return (new CntIMAPMboxUnDeleteTask(*pJob,
													pMboxNode->getMbox()))->
					       run();

			case WID_IS_READ:
			case WID_IS_MARKED:
				return (new CntIMAPMboxFlagMesgsTask(*pJob,
													 pMboxNode->getMbox()))->
					       run();

			case WID_FLAG_SUBSCRIBED:
				return (new CntIMAPMboxSubscribeTask(*pJob,
													 pMboxNode->getMbox()))->
					       run();

			default:
				return pMboxNode->CntIMAPFldrNode::ExecuteJob(pJob);
		}
	else
	{
		DBG_ASSERT(pJob->GetSubject()->ISA(CntIMAPMesgNode),
				   "CntIMAPAcntNode::ExecuteJob(): Bad subject");
		CntIMAPMesgNode * pMesgNode
			= static_cast< CntIMAPMesgNode * >(pJob->GetSubject());
		switch (pJob->GetRequest()->Which())
		{
			case WID_OPEN:
				return (new CntIMAPMesgOpenTask(*pJob, *pMesgNode))->run();

			case WID_EXPORT:
				return (new CntIMAPMesgExportTask(*pJob, *pMesgNode))->run();

			case WID_DELETE:
				return (new CntIMAPMesgDeleteTask(*pJob, *pMesgNode))->run();

			case WID_UNDELETE:
				return (new CntIMAPMesgUnDeleteTask(*pJob, *pMesgNode))->
					       run();

			case WID_IS_READ:
			case WID_IS_MARKED:
				return (new CntIMAPMesgFlagTask(*pJob, *pMesgNode))->run();

			default:
				return static_cast< CntIMAPMboxNode * >(
					           pMesgNode->GetParent())->
					       CntIMAPFldrNode::ExecuteJob(pJob);
		}
	}
}

//============================================================================
// static
bool CntIMAPAcntNode::makeCanonicURL(String const & rURL,
									 String & rCanonicURL)
{
	return CntIMAPURL::makeCanonicURL(rURL, rCanonicURL);
}

//============================================================================
//
//  CntIMAPAcnt
//
//============================================================================

void CntIMAPAcnt::setBase(CntNodeJob & rJob, String const & rBase)
{
	m_bHasBase = rBase.Len() != 0;
	if (hasBase())
	{
		m_bAddBaseInbox = !rBase.EqualsAscii(INET_IMAP_CANONIC_INBOX_NAME);
		m_bCopyBaseData = true;
		CntNodeRef xBaseMboxNode = instantiateBaseMboxNode(rJob);
		if (xBaseMboxNode.Is())
			notifyMboxConstruction(static_cast< CntIMAPMboxNode * >(
				                           &xBaseMboxNode)->
								       getMbox());
	}
	else
	{
		getNode().ClearItem(WID_PROPERTYLIST);
		getNode().ClearItem(WID_CREATE_NEW);
		getNode().ClearItem(WID_FLAG_HAS_MESSAGES);
		getNode().ClearItem(WID_FLAG_HAS_FOLDER);
		getNode().DisableItem(WID_IS_READ);
		getNode().DisableItem(WID_IS_MARKED);
		getNode().ClearItem(WID_IMAP_MESG_COUNT);
		getNode().DisableItem(WID_IMAP_READ_MESG_COUNT);
		getNode().DisableItem(WID_IMAP_MARKED_MESG_COUNT);

		CntNodeRef xAcntDirNode = getDirNode(rJob);
		getNode().Put(xAcntDirNode.Is() ?
					      xAcntDirNode->Get(WID_MESSAGE_STOREMODE) :
					      getNode().Get(WID_MESSAGE_STOREMODE));

		if (xAcntDirNode.Is())
		{
			CntStoreItemSetRef xAcntDirSet
				= static_cast< CntStorageNode * >(&xAcntDirNode)->
				      openItemSet(aCntIMAPAcntDirSetRanges,
								  String::CreateFromAscii(
									  RTL_CONSTASCII_STRINGPARAM(
										  CNT_IMAP_ACNT_SET_ID)),
								  STREAM_STD_READ);
			if (xAcntDirSet.Is())
			{
				SfxPoolItem const * pItem;
				if (xAcntDirSet->GetItemState(WID_IMAP_MBOX_COUNT, false,
											  &pItem)
					    == SFX_ITEM_SET)
					getNode().Put(*pItem);
				if (xAcntDirSet->GetItemState(WID_IMAP_SSCRBD_MBOX_COUNT,
											  false, &pItem)
					    == SFX_ITEM_SET)
					getNode().Put(*pItem);
			}
		}
	}
}

//============================================================================
void CntIMAPAcnt::setBaseProperty(USHORT nWhich, SfxPoolItem const * pItem)
{
	DBG_ASSERT(m_pBaseMbox, "CntIMAPAcnt::setBaseProperty(): Null base");

	if (!pItem
		&& m_pBaseMbox->getNode().GetItemState(nWhich, false, &pItem)
		       != SFX_ITEM_SET)
		pItem = 0;

	SfxPoolItem * pModifiedItem = 0;
	switch (nWhich)
	{
		case WID_PROPERTYLIST:
		{
			bool bInferiors
				= !pItem
				  || static_cast< CntUShortListItem const * >(pItem)->
				         Contains(CNT_TABPAGE_SUBSCRIBE);
			if (m_bAddBaseInbox || bInferiors)
				getNode().ClearItem(WID_PROPERTYLIST);
			else
				getNode().
					Put(CntIdentifierListItem(WID_PROPERTYLIST,
											  CNT_TABPAGE_GENERAL,
											  CNT_TABPAGE_RECV_IMAP,
											  CNT_TABPAGE_MAIL_NEWS_SEND,
											  CNT_TABPAGE_RULES,
											  CNT_TABPAGE_VIEW_PROPERTIES,
											  CNT_TABPAGE_HEADER,
											  CNT_TABPAGE_CONTENT_PROPERTIES,
											  CNT_TABPAGE_BACKGROUND,
											  CNT_TABPAGE_FONT, 0));
			if (bInferiors)
				getNode().ClearItem(WID_CREATE_NEW);
			else
				getNode().
					Put(getMboxNoInferiorsFactoryList(*getNode().
													       GetDefaults()));
			return;
		}

		case WID_FLAG_HAS_MESSAGES:
			if (!pItem || ITEM_VALUE(CntBoolItem, *pItem))
			{
				getNode().ClearItem(WID_IS_READ);
				getNode().ClearItem(WID_IS_MARKED);
				getNode().Put(CntBoolItem(WID_FLAG_HAS_MESSAGES, true));
			}
			else
			{
				getNode().DisableItem(WID_IS_READ);
				getNode().DisableItem(WID_IS_MARKED);
				getNode().Put(CntBoolItem(WID_FLAG_HAS_MESSAGES, false));
			}
			return;

		case WID_FLAG_HAS_FOLDER:
			if (m_bAddBaseInbox)
				pModifiedItem = new CntBoolItem(WID_FLAG_HAS_FOLDER, true);
			break;

		case WID_IMAP_MBOX_COUNT:
			if (m_bAddBaseInbox && pItem)
				pModifiedItem = new CntUInt32Item(WID_IMAP_MBOX_COUNT,
												  ITEM_VALUE(CntUInt32Item,
															 *pItem)
												      + 1);
			break;
	}

	if (pModifiedItem)
	{
		getNode().Put(*pModifiedItem);
		delete pModifiedItem;
	}
	else if (pItem)
		getNode().Put(*pItem);
	else
		getNode().ClearItem(nWhich);
}

//============================================================================
IMPL_LINK(CntIMAPAcnt, unilateralClientCallback, INetIMAPResponse const *,
		  pResponse)
{
	DBG_ASSERT(pResponse,
			   "CntIMAPAcnt::unilateralClientCallback(): Null response");

	switch (pResponse->getType())
	{
		case INetIMAPResponse::TYPE_CLOSED:
		case INetIMAPResponse::TYPE_FLAGS:
		case INetIMAPResponse::TYPE_LIST:
		case INetIMAPResponse::TYPE_MAILBOX:
		case INetIMAPResponse::TYPE_SEARCH:
		case INetIMAPResponse::TYPE_STATUS:
		case INetIMAPResponse::TYPE_EXISTS:
		case INetIMAPResponse::TYPE_RECENT:
		case INetIMAPResponse::TYPE_EXPUNGE:
		case INetIMAPResponse::TYPE_FETCH:
		case INetIMAPResponse::TYPE_CAPABILITY:
		case INetIMAPResponse::TYPE_NAMESPACE:
			break;

		case INetIMAPResponse::TYPE_INVALID:
		case INetIMAPResponse::TYPE_CONTINUE_CODE:
			CntIMAPTask::handleErrorNoTask(
				*new TwoStringErrorInfo(
					     ERRCODE_CHAOS_IMAP_BAD_RESPONSE,
						 ITEMSET_VALUE(&getNode(), CntStringItem,
									   WID_SERVERNAME),
						 static_cast< INetIMAPTextResponse const * >(
							     pResponse)->
						     getText(),
						 ERRCODE_BUTTON_OK | ERRCODE_MSG_ERROR));
			break;

		case INetIMAPResponse::TYPE_STATE:
		{
			INetIMAPStateResponse const & rStateResponse
				= *static_cast< INetIMAPStateResponse const * >(pResponse);

			// Ignore non-alert responses, because some servers are suspected
			// to sometimes send some junk response before closing the
			// connection due to a time out:
			if (rStateResponse.getCode() == INetIMAPCodeResponse::CODE_ALERT)
				CntIMAPTask::handleErrorNoTask(
					*new TwoStringErrorInfo(ERRCODE_CHAOS_IMAP_SERVER_MSG,
											ITEMSET_VALUE(&getNode(),
														  CntStringItem,
														  WID_SERVERNAME),
											rStateResponse.getText(),
											ERRCODE_BUTTON_OK
											    | ERRCODE_MSG_ERROR));
			break;
		}

		default:
			DBG_ERROR(
				"CntIMAPAcnt::unilateralClientCallback(): Invalid response");
			break;
	}

	return 0;
}

//============================================================================
TYPEINIT2(CntIMAPAcnt, CntIMAPFldr, SfxListener)

//============================================================================
CntIMAPAcnt::CntIMAPAcnt(CntIMAPAcntNode & rAcntNode):
	CntIMAPFldr(rAcntNode),
	m_bHasUserIDAndAuthType(false),
	m_bHasBase(false),
	m_pBaseMbox(0),
	m_bAddBaseInbox(false),
	m_bCopyBaseData(false),
	m_pMailer(0),
	m_bClientLocked(false),
	m_bOnline(false),
	m_pMboxNoInferiorsFactoryList(0),
	m_nOpenCount(0)
{}

//============================================================================
// virtual
CntIMAPAcnt::~CntIMAPAcnt()
{
	delete m_pMailer;
	delete m_pMboxNoInferiorsFactoryList;
}

//============================================================================
CntIMAPAcntNode const & CntIMAPAcnt::getNode() const
{
	return *static_cast< CntIMAPAcntNode const * >(&CntIMAPFldr::getNode());
}

//============================================================================
CntIMAPAcntNode & CntIMAPAcnt::getNode()
{
	return *static_cast< CntIMAPAcntNode * >(&CntIMAPFldr::getNode());
}

//============================================================================
void CntIMAPAcnt::initialize(CntNodeJob & rJob)
{
	if (isInitialized())
		return;
	else
	{
		vos::OGuard aGuard(getMutex());
		if (isInitialized())
			return;
		setInitialized();
	}

	if (getNode().IsDummy())
	{
		getNode().Put(CntStringItem(WID_SERVERNAME,
									CntRootNodeMgr::Get()->GetIniManager()->
									    getEntry(CNT_KEY_INET_POPSERVER)));
		m_bHasBase = false;
	}
	else
	{
		INetURLObject aURL(OWN_URL(&getNode()));
		m_bHasUserIDAndAuthType = aURL.HasUserData();
		getNode().
			Put(CntStringItem(WID_USERNAME,
							  aURL.GetUser(
								       INetURLObject::DECODE_WITH_CHARSET)));
		getNode().
			Put(CntStringItem(WID_SERVERNAME,
							  aURL.GetHostPort(
								       INetURLObject::DECODE_WITH_CHARSET)));

		CntNodeRef xAcntDirNode(getDirNode(rJob));
		if (xAcntDirNode.Is())
		{
			static_cast< CntStorageNode * >(&xAcntDirNode)->
				attrib(String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(
					                               CNT_IMAP_ACNT_SET_ID)),
					   0,
					   CNTDIRENTRY_ATTRIB_CREATE | CNTDIRENTRY_ATTRIB_HIDDEN);

			SfxPoolItem const * pItem;
			if (xAcntDirNode->GetItemState(WID_PASSWORD, false, &pItem)
				    == SFX_ITEM_SET)
				getNode().Put(*pItem);
			if (xAcntDirNode->GetItemState(WID_SERVERBASE, false, &pItem)
				    == SFX_ITEM_SET)
				getNode().Put(*pItem);
		}

		setBase(rJob,
				ITEMSET_VALUE(&getNode(), CntStringItem, WID_SERVERBASE));
	}
}

//============================================================================
void CntIMAPAcnt::changeData(CntNodeJob & rJob)
{
	CntItemListItem const & rList
		= *static_cast< CntItemListItem const * >(rJob.GetRequest());

	bool bUserIDPresent = false;
	String aUserID;
	bool bHostPortPresent = false;
	String aHostPort;
	USHORT nBaseCount = 0;
	USHORT nMboxListCount = 0;
	{for (USHORT i = 0; i < rList.Count();)
	{
		SfxPoolItem const & rItem = rList[i];
		bool bRemove = false;
		switch (rItem.Which())
		{
			case WID_USERNAME:
				bUserIDPresent = true;
				aUserID = ITEM_VALUE(CntStringItem, rItem);
				bRemove = true;
				break;

			case WID_SERVERNAME:
				bHostPortPresent = true;
				aHostPort = ITEM_VALUE(CntStringItem, rItem);
				bRemove = true;
				break;

			case WID_SERVERBASE:
				++nBaseCount;
				break;

			case WID_NEWS_GROUPLIST:
				++nMboxListCount;
				break;
		}
		if (bRemove)
			const_cast< CntItemListItem & >(rList).Remove(i);
		else
			++i;
	}}

	if (bUserIDPresent || bHostPortPresent)
	{
		changeUserIDOrHostPort(rJob, bUserIDPresent ? &aUserID : 0,
							   bHostPortPresent ? &aHostPort : 0);
		if (rJob.IsDone() || rJob.IsCanceled())
			return;
	}

	{for (USHORT i = 0; nBaseCount;)
	{
		SfxPoolItem const & rItem = rList[i];
		if (rItem.Which() == WID_SERVERBASE)
		{
			changeBase(rJob, ITEM_VALUE(CntStringItem, rItem));
			if (rJob.IsDone() || rJob.IsCanceled())
				return;
			const_cast< CntItemListItem & >(rList).Remove(i);
			--nBaseCount;
		}
		else
			++i;
	}}

	for (USHORT i = 0; nMboxListCount;)
	{
		SfxPoolItem const & rItem = rList[i];
		if (rItem.Which() == WID_NEWS_GROUPLIST)
		{
			getNode().InsertJob(new CntNodeJob(&rJob, rJob.GetClient(),
											   &getNode(), rItem));
			const_cast< CntItemListItem & >(rList).Remove(i);
			--nMboxListCount;
		}
		else
			++i;
	}
}

//============================================================================
void CntIMAPAcnt::changeUserIDOrHostPort(CntNodeJob & rJob,
										 String const * pUserID,
										 String const * pHostPort) const
{
	bool bHasNewUserID = false;
	String aNewUserID;
	if (pUserID)
	{
		bHasNewUserID = true;
		aNewUserID = *pUserID;
	}
	else if (getNode().IsDummy() || m_bHasUserIDAndAuthType)
	{
		bHasNewUserID = true;
		aNewUserID = ITEMSET_VALUE(&getNode(), CntStringItem, WID_USERNAME);
	}

	String aNewHostPort;
	bool bCheckHostPort;
	if (pHostPort)
	{
		aNewHostPort = *pHostPort;
		bCheckHostPort = true;
	}
	else
	{
		aNewHostPort = ITEMSET_VALUE(&getNode(), CntStringItem,
									 WID_SERVERNAME);
		bCheckHostPort = getNode().IsDummy() != false;
	}
	if (bCheckHostPort)
	{
		ErrCode nError = CntIMAPURL::makeCanonicHostPort(aNewHostPort,
														 aNewHostPort);
		if (nError != ERRCODE_NONE)
		{
			rJob.SetError(nError);
			rJob.Cancel();
			return;
		}
	}

	CntNodeRef xNewAcntNode
		= CntRootNodeMgr::Get()->
		      Query(CntIMAPURL::createAcntURL(bHasNewUserID, aNewUserID,
											  String(), aNewHostPort));
	if (!xNewAcntNode.Is())
	{
		rJob.SetError(ERRCODE_IO_GENERAL);
		rJob.Cancel();
		return;
	}

	if (static_cast< CntIMAPAcntNode * >(&xNewAcntNode) != &getNode())
	{
		static_cast< CntIMAPAcntNode * >(&xNewAcntNode)->
			getAcnt().initialize(rJob);

		rJob.Result(xNewAcntNode, CNT_ACTION_EXCHANGED);
		rJob.Done();
	}
}

//============================================================================
void CntIMAPAcnt::changeBase(CntNodeJob & rJob, String const & rBase)
{
	// changeBase() and createNewNode() must synchronize:
	vos::OGuard aGuard(getMutex());

	String aCanonicBaseMboxPath;
	CntIMAPURL::makeCanonicMboxPath(rBase, aCanonicBaseMboxPath);
	if (aCanonicBaseMboxPath != ITEMSET_VALUE(&getNode(), CntStringItem,
											  WID_SERVERBASE))
	{
		if (m_pBaseMbox)
		{
			EndListening(m_pBaseMbox->getNode());
			m_pBaseMbox = 0;
		}

		getNode().Put(CntStringItem(WID_SERVERBASE, aCanonicBaseMboxPath));
		CntNodeRef xAcntDirNode = getDirNode(rJob);
		if (xAcntDirNode.Is())
			xAcntDirNode->Put(CntStringItem(WID_SERVERBASE,
											aCanonicBaseMboxPath));

		setBase(rJob, aCanonicBaseMboxPath);
	}
}

//============================================================================
inet::INetCoreMailer * CntIMAPAcnt::getINetMailer()
{
	if (!m_pMailer)
	{
		inet::INetWrapper * pWrapper;
		if (CntRootNodeMgr::Get()->getINetWrapper(pWrapper))
			pWrapper->newINetCoreMailer(m_pMailer);
	}
	return m_pMailer;
}

//============================================================================
ErrCode CntIMAPAcnt::getHostAndPort(String & rHost, sal_uInt16 & rPort) const
{
	String
		aHostPort(ITEMSET_VALUE(&getNode(), CntStringItem, WID_SERVERNAME));
	xub_StrLen nPortSeparatorPos = aHostPort.Search(':');
	if (nPortSeparatorPos == STRING_NOTFOUND)
	{
		rHost = aHostPort;
		rPort = inet::eINET_IMAP_PORT;
		return ERRCODE_NONE;
	}
	else
	{
		sal_uInt32 nThePort = 0;
		for (xub_StrLen i = nPortSeparatorPos + 1; i < aHostPort.Len(); ++i)
		{
			int nValue = INetMIME::getWeight(aHostPort.GetChar(i));
			DBG_ASSERT(nValue >= 0,
					   "CntIMAPAcnt::getHostAndPort(): Invalid port");

			nThePort = 10 * nThePort + nValue;
			if (nThePort >= 100000)
				break;
		}
		if (nThePort < 65536)
		{
			rHost = aHostPort.Copy(0, nPortSeparatorPos);
			rPort = sal_uInt16(nThePort);
			return ERRCODE_NONE;
		}
		else
			return ERRCODE_CHAOS_SERVER_PORT_SYNTAX;
	}
}

//============================================================================
void CntIMAPAcnt::getUserIDAndPassword(bool & rHasUserIDAndAuthType,
									   String & rUserID, String & rPassword)
	const
{
	rHasUserIDAndAuthType = m_bHasUserIDAndAuthType;
	if (m_bHasUserIDAndAuthType)
		rUserID = ITEMSET_VALUE(&getNode(), CntStringItem, WID_USERNAME);
	rPassword = ITEMSET_VALUE(&getNode(), CntStringItem, WID_PASSWORD);
}

//============================================================================
String CntIMAPAcnt::getBaseFldrURL() const
{
	if (hasBase())
		return
		 CntIMAPURL::createMboxURL(OWN_URL(&getNode()),
								   ITEMSET_VALUE(&getNode(), CntStringItem,
												 WID_SERVERBASE));
	else
		return OWN_URL(&getNode());
}

//============================================================================
CntNodeRef CntIMAPAcnt::instantiateBaseMboxNode(CntNodeJob & rJob)
{
	DBG_ASSERT(hasBase(), "CntIMAPAcnt::instantiateBaseMboxNode(): None");

	if (m_pBaseMbox)
		return &m_pBaseMbox->getNode();

	CntNodeRef xBaseMboxNode(getNode().Query(getBaseFldrURL()));
	if (!xBaseMboxNode.Is())
		return 0;

	static_cast< CntIMAPMboxNode * >(&xBaseMboxNode)->
		getMbox().initialize(rJob);
	return xBaseMboxNode;
}

//============================================================================
void CntIMAPAcnt::storeProperty(SfxPoolItem const & rItem, CntNodeJob & rJob)
{
	DBG_ASSERT(rItem.Which() == WID_IMAP_MBOX_COUNT
			   || rItem.Which() == WID_IMAP_SSCRBD_MBOX_COUNT,
			   "CntIMAPAcnt::storeProperty(): Invalid item");

	if (!hasBase())
		getNode().Put(rItem);

	CntNodeRef xAcntDirNode(getDirNode(rJob));
	if (xAcntDirNode.Is())
	{
		CntStoreItemSetRef xAcntDirSet
			= static_cast< CntStorageNode * >(&xAcntDirNode)->
			      openItemSet(aCntIMAPAcntDirSetRanges,
							  String::CreateFromAscii(
								  RTL_CONSTASCII_STRINGPARAM(
									  CNT_IMAP_ACNT_SET_ID)),
							  STREAM_STD_WRITE | STREAM_NOCREATE);
		if (xAcntDirSet.Is())
			xAcntDirSet->Put(rItem);
	}
}

//============================================================================
// virtual
CntStorageNode * CntIMAPAcnt::getDirNode(CntNodeJob & rJob)
{
	// CntIMAPAcnt::changeUserIDOrHostPort() calls CntIMAPAcnt::getDirNode()
	// (which in turn calls this fn) with a job that is not "compatible" with
	// the involved CntIMAPAcntNode, so be careful here:
	if (rJob.GetSubject()->GetRootNode() == &getNode())
		return rJob.GetCacheNode();
	else
	{
		String aAcntDirURL(String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(
			                                           STG_PROTOCOL_CACHE)));
		aAcntDirURL += OWN_URL(&getNode());
		return static_cast< CntStorageNode * >(CntRootNodeMgr::Get()->
											       Query(aAcntDirURL));
	}
}

//============================================================================
// virtual
void CntIMAPAcnt::changeMboxCounts(CntNodeJob & rJob,
								   CountChange eMboxCountChange,
								   CountChange eSubscribedMboxCountChange)
{
	if (eMboxCountChange == COUNT_STAY
		&& eSubscribedMboxCountChange == COUNT_STAY)
		return;

	CntNodeRef xAcntDirNode = getDirNode(rJob);
	CntStoreItemSetRef xAcntDirSet;
	if (xAcntDirNode.Is())
		xAcntDirSet = static_cast< CntStorageNode * >(&xAcntDirNode)->
			              openItemSet(aCntIMAPAcntDirSetRanges,
									  String::CreateFromAscii(
										  RTL_CONSTASCII_STRINGPARAM(
											  CNT_IMAP_ACNT_SET_ID)),
									  STREAM_STD_READWRITE | STREAM_NOCREATE);

	sal_uInt32 nMboxCount;
	if (eMboxCountChange != COUNT_STAY)
		nMboxCount = !hasBase() ?
			             ITEMSET_VALUE(&getNode(), CntUInt32Item,
									   WID_IMAP_MBOX_COUNT) :
		             xAcntDirSet.Is() ?
			             ITEMSET_VALUE(xAcntDirSet, CntUInt32Item,
									   WID_IMAP_MBOX_COUNT) :
		                 0;
	sal_uInt32 nSubscribedMboxCount;
	if (eSubscribedMboxCountChange != COUNT_STAY)
		if (!hasBase())
			nSubscribedMboxCount = ITEMSET_VALUE(&getNode(), CntUInt32Item,
												 WID_IMAP_SSCRBD_MBOX_COUNT);
		else
		{
			SfxPoolItem const * pCount;
			if (xAcntDirSet.Is()
				&& xAcntDirSet->GetItemState(WID_IMAP_SSCRBD_MBOX_COUNT,
											 false, &pCount)
				    == SFX_ITEM_SET)
				nSubscribedMboxCount = ITEM_VALUE(CntUInt32Item, *pCount);
			else
				nSubscribedMboxCount = 0;
		}

	bool bMboxCountChanged;
	switch (eMboxCountChange)
	{
		case COUNT_DEC:
			bMboxCountChanged = nMboxCount != 0;
			if (bMboxCountChanged)
				--nMboxCount;
			break;

		case COUNT_STAY:
			bMboxCountChanged = false;
			break;

		case COUNT_INC:
			bMboxCountChanged = true;
			++nMboxCount;
	}
	bool bSubscribedMboxCountChanged;
	switch (eSubscribedMboxCountChange)
	{
		case COUNT_DEC:
			bSubscribedMboxCountChanged = nSubscribedMboxCount != 0;
			if (bSubscribedMboxCountChanged)
				--nSubscribedMboxCount;
			break;

		case COUNT_STAY:
			bSubscribedMboxCountChanged = false;
			break;

		case COUNT_INC:
			bSubscribedMboxCountChanged = true;
			++nSubscribedMboxCount;
	}

	if (bMboxCountChanged)
	{
		if (!hasBase())
			getNode().Put(CntUInt32Item(WID_IMAP_MBOX_COUNT, nMboxCount));
		if (xAcntDirSet.Is())
			xAcntDirSet->Put(CntUInt32Item(WID_IMAP_MBOX_COUNT, nMboxCount));
	}
	if (bSubscribedMboxCountChanged)
	{
		if (!hasBase())
			getNode().Put(CntUInt32Item(WID_IMAP_SSCRBD_MBOX_COUNT,
										nSubscribedMboxCount));
		if (xAcntDirSet.Is())
			xAcntDirSet->Put(CntUInt32Item(WID_IMAP_SSCRBD_MBOX_COUNT,
										   nSubscribedMboxCount));
	}
}

//============================================================================
bool CntIMAPAcnt::initializeClient(bool bToClose)
{
	if (m_xClient.Is() && m_xClient->hasClosedConnection())
		m_xClient = 0;
	if (!m_xClient.Is() && !bToClose)
	{
		inet::INetWrapper * pWrapper;
		if (CntRootNodeMgr::Get()->getINetWrapper(pWrapper))
			pWrapper->newINetIMAPClient(m_xClient);
	}
	return m_xClient.Is() != false;
}

//============================================================================
bool CntIMAPAcnt::checkNextJob(CntNode const & rSubject, USHORT nWhich)
{
	vos::OGuard aGuard(getNode().getMutex());
	CntNodeJobQueue const * pQueue = getNode().GetJobQueue();
	if (pQueue && pQueue->Count() != 0)
	{
		CntNodeJobList const * pList = pQueue->GetObject(0);
		if (pList && pList->Count() >= 2)
		{
			CntNodeJob const * pJob = pList->GetObject(1);
			if (pJob && pJob->GetSubject() == &rSubject
				&& pJob->GetRequest()->Which() == nWhich)
				return true;
		}
	}
	return false;
}

//============================================================================
CntNodeItem const * CntIMAPAcnt::createNewNode(CntNodeJob & rJob)
{
	CntItemListItem const * pProperties
		= PTR_CAST(CntItemListItem, rJob.GetRequest());
	if (!pProperties)
		return 0;

	SfxPoolItem const * pItem = pProperties->Get(WID_FACTORY_NO);
	CntUInt16Item const * pFactoryID = PTR_CAST(CntUInt16Item, pItem);
	if (!pFactoryID)
		return 0;

	// changeBase() and createNewNode() must synchronize:
	vos::OGuard aGuard(getMutex());

	if (hasBase() && rJob.GetSubject() == &getNode())
	{
		CntNodeRef xBaseMboxNode = instantiateBaseMboxNode(rJob);
		if (!xBaseMboxNode.Is())
			return 0;
		rJob.SetSubject(xBaseMboxNode);
	}

	CntNodeItem const * pNodeItem = 0;

	switch (ITEM_VALUE(CntUInt16Item, *pFactoryID))
	{
		case CONTENT_TYPE_X_CNT_IMAPFOLDER:
			{for (USHORT i = pProperties->Count(); i != 0;)
			{
				SfxPoolItem const & rProperty = (*pProperties)[--i];
				if (rProperty.Which() == WID_TITLE)
				{
					if (CntStringItem const * pTitle
						    = PTR_CAST(CntStringItem, &rProperty))
						const_cast< CntItemListItem * >(pProperties)->
							Append(new CntStringItem(
								           WID_OWN_URL,
										   CntIMAPURL::createSubMboxURL(
											   OWN_URL(rJob.GetSubject()),
											   CntIMAPUTF7::translateToUTF7(
												   ITEM_VALUE(CntStringItem,
															  *pTitle)))));
					const_cast< CntItemListItem * >(pProperties)->Remove(i);
				}
			}}

			pItem = rJob.GetSubject()->CntNode::ExecuteJob(&rJob);
			pNodeItem = PTR_CAST(CntNodeItem, pItem);
			break;

		case CONTENT_TYPE_X_CNT_MESSAGE:
		{
			pItem = rJob.GetSubject()->CntNode::ExecuteJob(&rJob);
			pNodeItem = PTR_CAST(CntNodeItem, pItem);
			if (!pNodeItem)
				break;

			CntNode * pMesgNode = ITEM_VALUE(CntNodeItem, *pNodeItem);
			if (!pMesgNode)
				break;

			CntAnchor * pAnchor = PTR_CAST(CntAnchor, rJob.GetClient());
			if (!pAnchor)
				break;

			CntAnchorRef xRootAnchor
				= new CntAnchor(0, pAnchor->GetRootViewURL());

			// If private messages use the settings from the IMAP account
			// (instead of the settings from the out box), preset the 'from'
			// and 'reply-to' fields with the settings for the selected
			// protocol:
			if (!ITEMSET_VALUE(xRootAnchor, CntBoolItem,
							   WID_SEND_PRIVATE_OUTBOXPROPS))
			{
				CntOutMsgProtocolType nProtocol
					= CntOutMsgProtocolType(ITEMSET_VALUE(
						                        xRootAnchor, CntUInt16Item,
												WID_SEND_PRIVATE_PROT_ID));
				String const * pInfo
					= static_cast< CntSendInfoListItem const * >(
						      &xRootAnchor->Get(WID_SEND_FROM_DEFAULT))->
				          findEntry(nProtocol);
				if (pInfo)
					pMesgNode->Put(CntNameItem(WID_FROM, *pInfo));
				pInfo
					= static_cast< CntSendInfoListItem const * >(
						      &xRootAnchor->Get(WID_SEND_REPLY_TO_DEFAULT))->
					      findEntry(nProtocol);
				if (pInfo)
					pMesgNode->Put(CntStringItem(WID_REPLY_TO, *pInfo));
			}

			pMesgNode->Put(xRootAnchor->Get(WID_SEND_PUBLIC_PROT_ID));
			pMesgNode->Put(xRootAnchor->Get(WID_SEND_PRIVATE_PROT_ID));
			pMesgNode->Put(xRootAnchor->Get(WID_SEND_PUBLIC_OUTBOXPROPS));
			pMesgNode->Put(xRootAnchor->Get(WID_SEND_PRIVATE_OUTBOXPROPS));
			pMesgNode->Put(xRootAnchor->Get(WID_SEND_SERVERNAME));
			pMesgNode->Put(xRootAnchor->Get(WID_SEND_USERNAME));
			pMesgNode->Put(xRootAnchor->Get(WID_SEND_PASSWORD));
			pMesgNode->Put(xRootAnchor->Get(WID_SEND_REPLY_TO_DEFAULT));
			pMesgNode->Put(xRootAnchor->Get(WID_SEND_FROM_DEFAULT));
			pMesgNode->Put(xRootAnchor->Get(WID_SEND_VIM_POPATH));
			pMesgNode->Put(xRootAnchor->Get(WID_SEND_FORMATS));
			pMesgNode->Put(xRootAnchor->Get(WID_SEND_COPY_TARGET));
			break;
		}

		default:
			pItem = rJob.GetSubject()->CntNode::ExecuteJob(&rJob);
			pNodeItem = PTR_CAST(CntNodeItem, pItem);
			break;
	}

	return pNodeItem;
}

//============================================================================
ErrCode CntIMAPAcnt::exportMesg(CntNodeJob & rJob, CntExport & rExport,
								CntIMAPMesgNode & rMesgNode)
{
	rMesgNode.getBody(rJob);

	SfxItemSet aExportSet(*getNode().GetPool());
	aExportSet.Put(rMesgNode);
	aExportSet.Put(CntContentTypeItem(WID_CONTENT_TYPE,
									  CONTENT_TYPE_X_CNT_MESSAGE));

	String aMboxURL;
	sal_uInt32 nUIDValidity;
	sal_uInt32 nMesgUID;
	CntIMAPURL::decomposeMesgURL(OWN_URL(&rMesgNode), aMboxURL, nUIDValidity,
								 nMesgUID);
	if (!nUIDValidity)
	{
		String aMboxPath(aMboxURL,
						 aMboxURL.Search('/',
										 RTL_CONSTASCII_LENGTH(
											 CNT_IMAP_URL_PREFIX))
						     + 1,
						 STRING_LEN);
		CntItemListItem aXref(WID_NEWS_XREFLIST);
		aXref.Append(new CntCrossReferenceItem(WID_NEWS_XREF, aMboxPath,
											   nMesgUID));
		aExportSet.Put(aXref);
	}

	return rExport.writeMessage(aExportSet, 0);
}

//============================================================================
void CntIMAPAcnt::notifyMboxConstruction(CntIMAPMbox & rMbox)
{
	if (hasBase() && !m_pBaseMbox
		&& getBaseFldrURL() == OWN_URL(&rMbox.getNode()))
	{
		m_pBaseMbox = &rMbox;
		if (m_bCopyBaseData)
		{
			// Order is important:
			setBaseProperty(WID_IS_READ);
			setBaseProperty(WID_IS_MARKED);
			setBaseProperty(WID_PROPERTYLIST);
			setBaseProperty(WID_FLAG_HAS_MESSAGES);
			setBaseProperty(WID_FLAG_HAS_FOLDER);
			setBaseProperty(WID_IMAP_MBOX_COUNT);
			setBaseProperty(WID_IMAP_SSCRBD_MBOX_COUNT);
			setBaseProperty(WID_IMAP_MESG_COUNT);
			setBaseProperty(WID_IMAP_READ_MESG_COUNT);
			setBaseProperty(WID_IMAP_MARKED_MESG_COUNT);
			setBaseProperty(WID_DELETE_ON_SERVER);
			setBaseProperty(WID_MESSAGE_STOREMODE);

			m_bCopyBaseData = false;
		}
		StartListening(m_pBaseMbox->getNode());
	}
}

//============================================================================
void CntIMAPAcnt::notifyMboxDestruction(CntIMAPMbox & rMbox)
{
	if (&rMbox == m_pBaseMbox)
	{
		EndListening(m_pBaseMbox->getNode());
		m_pBaseMbox = 0;
	}
}

//============================================================================
// virtual
void CntIMAPAcnt::Notify(SfxBroadcaster & rBroadcaster, SfxHint const & rHint)
{
	if (m_pBaseMbox && &rBroadcaster == &m_pBaseMbox->getNode())
		if (rHint.ISA(SfxItemChangedHint))
		{
			SfxPoolItem const & rItem
				= static_cast< SfxItemChangedHint const * >(&rHint)->
				      GetNewItem();
			switch (rItem.Which())
			{
				case WID_PROPERTYLIST:
				case WID_FLAG_HAS_MESSAGES:
				case WID_FLAG_HAS_FOLDER:
				case WID_IS_READ:
				case WID_IS_MARKED:
				case WID_IMAP_MBOX_COUNT:
				case WID_IMAP_SSCRBD_MBOX_COUNT:
				case WID_IMAP_MESG_COUNT:
				case WID_IMAP_READ_MESG_COUNT:
				case WID_IMAP_MARKED_MESG_COUNT:
				case WID_DELETE_ON_SERVER:
				case WID_MESSAGE_STOREMODE:
					setBaseProperty(rItem.Which(), &rItem);
					break;
			}
		}
		else if (rHint.ISA(CntNodeHint)
				 && static_cast< CntNodeHint const * >(&rHint)->GetAction()
				        == CNT_ACTION_INSERTED)
			getNode().Broadcast(rHint);
}

//============================================================================
CntItemListItem const &
CntIMAPAcnt::getMboxNoInferiorsFactoryList(SfxItemSet const & rDefaults)
{
	if (!m_pMboxNoInferiorsFactoryList)
	{
		m_pMboxNoInferiorsFactoryList = new CntItemListItem(WID_CREATE_NEW);
		CntItemListItem const & rFactoryList
			= static_cast< CntItemListItem const & >(
				    rDefaults.Get(WID_CREATE_NEW));
		for (USHORT i = 0; i < rFactoryList.Count(); ++i)
		{
			CntItemListItem const & rFactory
				= static_cast< CntItemListItem const & >(rFactoryList[i]);
			if (ITEM_VALUE(CntUInt16Item, *rFactory.Get(WID_FACTORY_NO))
				    != CONTENT_TYPE_X_CNT_IMAPFOLDER)
				m_pMboxNoInferiorsFactoryList->Append(rFactory.Clone());
		}
	}
	return *m_pMboxNoInferiorsFactoryList;
}

//============================================================================
void CntIMAPAcnt::incrementOpenCount()
{
	if (m_nOpenCount < std::numeric_limits< sal_uInt32 >::max())
		++m_nOpenCount;
}

//============================================================================
bool CntIMAPAcnt::decrementOpenCount(SfxPoolItem const & rRequest)
{
	if (m_nOpenCount == std::numeric_limits< sal_uInt32 >::max())
		return false;
	sal_Int32 nCount = rRequest.ISA(CntInt32Item) ? ITEM_VALUE(CntInt32Item,
															   rRequest) :
		                                            1;
	if (nCount <= 0)
		return false;
	if (nCount >= m_nOpenCount)
		m_nOpenCount = 0;
	else
		m_nOpenCount -= nCount;
	return m_nOpenCount == 0;
}

